/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.playback.filecommands.builtin;

import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.playback.PlaybackControllerClient;
import com.minecrafttas.tasmod.playback.filecommands.PlaybackFileCommand;
import com.minecrafttas.tasmod.util.LoggerMarkers;
import java.nio.file.Path;

public class OptionsFileCommandExtension
extends PlaybackFileCommand.PlaybackFileCommandExtension {
    private boolean shouldRenderHud = true;

    public OptionsFileCommandExtension() {
        this("hud");
    }

    public OptionsFileCommandExtension(String tempDirName) {
        super(tempDirName);
        this.enabled = true;
    }

    public OptionsFileCommandExtension(Path tempDir) {
        super(tempDir);
        this.enabled = true;
    }

    @Override
    public String getExtensionName() {
        return "tasmod_options@v1";
    }

    @Override
    public String[] getFileCommandNames() {
        return new String[]{"hud"};
    }

    @Override
    public void onPlayback(long tick, PlaybackControllerClient.InputContainer inputContainer) {
        if (this.inlineFileCommandStorage.size() <= tick) {
            return;
        }
        PlaybackFileCommand.SortedFileCommandContainer containerInTick = (PlaybackFileCommand.SortedFileCommandContainer)this.inlineFileCommandStorage.get(tick);
        if (containerInTick == null) {
            return;
        }
        PlaybackFileCommand.FileCommandsInTickList line = (PlaybackFileCommand.FileCommandsInTickList)containerInTick.get("hud");
        if (line == null) {
            return;
        }
        for (PlaybackFileCommand command : line) {
            if (command == null) continue;
            String[] args = command.getArgs();
            if (args.length == 1) {
                switch (args[0]) {
                    case "true": {
                        this.shouldRenderHud = true;
                        break;
                    }
                    case "false": {
                        this.shouldRenderHud = false;
                        break;
                    }
                    default: {
                        TASmod.LOGGER.warn(LoggerMarkers.Playback, "FileCommand hud has the wrong argument in tick {}: {} (Must be true or false)", (Object)tick, (Object)args[0]);
                        break;
                    }
                }
                continue;
            }
            TASmod.LOGGER.warn(LoggerMarkers.Playback, "FileCommand hud has the wrong number of arguments in tick {}: {}", (Object)tick, (Object)args.length);
        }
    }

    @Override
    public void onClear() {
        super.onClear();
        this.shouldRenderHud = true;
    }

    public boolean shouldRenderHud() {
        return this.shouldRenderHud;
    }
}

