/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.playback.metadata;

import com.minecrafttas.mctcommon.registry.Registerable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PlaybackMetadata {
    private String extensionName;
    private LinkedHashMap<String, String> data;
    private static String SEPERATOR = ":";

    public PlaybackMetadata(PlaybackMetadataExtension extension) {
        this(extension.getExtensionName());
    }

    public PlaybackMetadata(String extensionName) {
        this.extensionName = extensionName;
        this.data = new LinkedHashMap();
    }

    public PlaybackMetadata(String extensionName, LinkedHashMap<String, String> data) {
        this.extensionName = extensionName;
        this.data = data;
    }

    public void setValue(String key, String value) {
        this.data.put(key, value);
    }

    public void setValue(Object key, String value) {
        this.setValue(key.toString(), value);
    }

    public String getValue(String key) {
        return this.data.get(key);
    }

    public String getValue(Object key) {
        return this.getValue(key.toString());
    }

    public String toString() {
        String out = "";
        for (String key : this.data.keySet()) {
            String value = this.getValue(key);
            out = out + String.format("%s%s%s\n", key, SEPERATOR, value);
        }
        return out;
    }

    public List<String> toStringList() {
        ArrayList<String> out = new ArrayList<String>();
        Iterator<String> iterator = this.data.keySet().iterator();
        while (iterator.hasNext()) {
            String keyObj;
            String key = keyObj = iterator.next();
            String value = this.getValue(key);
            out.add(String.format("%s%s%s\n", key, SEPERATOR, value));
        }
        return out;
    }

    public String getExtensionName() {
        return this.extensionName;
    }

    public LinkedHashMap<String, String> getData() {
        return this.data;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PlaybackMetadata) {
            PlaybackMetadata other = (PlaybackMetadata)obj;
            return other.data.equals(this.data) && other.extensionName.equals(this.extensionName);
        }
        return super.equals(obj);
    }

    public static PlaybackMetadata fromStringList(String extensionName, List<String> list) {
        PlaybackMetadata out = new PlaybackMetadata(extensionName);
        Pattern pattern = Pattern.compile("(\\w+)\\" + SEPERATOR + "(.+)");
        for (String data : list) {
            Matcher matcher = pattern.matcher(data);
            if (!matcher.find()) continue;
            String key = matcher.group(1);
            String value = matcher.group(2);
            out.setValue(key, value);
        }
        return out;
    }

    public static PlaybackMetadata fromHashMap(String extensionName, LinkedHashMap<String, String> data) {
        return new PlaybackMetadata(extensionName, new LinkedHashMap<String, String>(data));
    }

    public static abstract class PlaybackMetadataExtension
    implements Registerable {
        public void onCreate() {
        }

        public abstract PlaybackMetadata onStore();

        public abstract void onLoad(PlaybackMetadata var1);

        public abstract void onClear();
    }
}

