/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.playback.metadata;

import com.minecrafttas.mctcommon.registry.AbstractRegistry;
import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.events.EventPlaybackClient;
import com.minecrafttas.tasmod.playback.metadata.PlaybackMetadata;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class PlaybackMetadataRegistry
extends AbstractRegistry<PlaybackMetadata.PlaybackMetadataExtension>
implements EventPlaybackClient.EventRecordClear {
    public PlaybackMetadataRegistry() {
        super("METADATA_REGISTRY", new LinkedHashMap());
    }

    public static void handleOnCreate() {
    }

    public List<PlaybackMetadata> handleOnStore() {
        ArrayList<PlaybackMetadata> metadataList = new ArrayList<PlaybackMetadata>();
        for (PlaybackMetadata.PlaybackMetadataExtension extension : this.REGISTRY.values()) {
            metadataList.add(extension.onStore());
        }
        return metadataList;
    }

    public void handleOnLoad(List<PlaybackMetadata> meta) {
        if (meta.isEmpty()) {
            return;
        }
        for (PlaybackMetadata metadata : meta) {
            if (this.REGISTRY.containsKey(metadata.getExtensionName())) {
                PlaybackMetadata.PlaybackMetadataExtension extension = (PlaybackMetadata.PlaybackMetadataExtension)this.REGISTRY.get(metadata.getExtensionName());
                extension.onLoad(metadata);
                continue;
            }
            TASmod.LOGGER.warn("The metadata extension {} was not found while loading the TASfile. Things might not be correctly loaded!", (Object)metadata.getExtensionName());
        }
    }

    @Override
    public void onRecordingClear() {
        this.REGISTRY.forEach((key, extension) -> extension.onClear());
    }
}

