/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.playback.metadata.builtin;

import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.events.EventPlaybackClient;
import com.minecrafttas.tasmod.playback.PlaybackControllerClient;
import com.minecrafttas.tasmod.playback.metadata.PlaybackMetadata;
import com.minecrafttas.tasmod.playback.tasfile.exception.PlaybackLoadException;
import com.minecrafttas.tasmod.util.LoggerMarkers;
import net.minecraft.class_1442;
import net.minecraft.class_1600;
import net.minecraft.class_1982;
import net.minecraft.class_1989;

public class CreditsMetadataExtension
extends PlaybackMetadata.PlaybackMetadataExtension
implements EventPlaybackClient.EventPlaybackJoinedWorld,
EventPlaybackClient.EventControllerStateChange {
    protected String title = "Insert TAS category here";
    protected String authors = "Insert author here";
    protected String playtime = "00:00.0";
    protected int rerecords = 0;
    protected boolean creditsPrinted = false;

    @Override
    public String getExtensionName() {
        return "Credits";
    }

    @Override
    public void onCreate() {
    }

    @Override
    public PlaybackMetadata onStore() {
        PlaybackMetadata metadata = new PlaybackMetadata(this);
        metadata.setValue((Object)CreditFields.Title, this.title);
        metadata.setValue((Object)CreditFields.Author, this.authors);
        metadata.setValue((Object)CreditFields.PlayTime, this.playtime);
        metadata.setValue((Object)CreditFields.Rerecords, Integer.toString(this.rerecords));
        return metadata;
    }

    @Override
    public void onLoad(PlaybackMetadata metadata) {
        this.title = this.getOrDefault(metadata.getValue((Object)CreditFields.Title), this.title);
        this.authors = this.getOrDefault(metadata.getValue((Object)CreditFields.Author), this.authors);
        this.playtime = this.getOrDefault(metadata.getValue((Object)CreditFields.PlayTime), this.playtime);
        try {
            this.rerecords = Integer.parseInt(this.getOrDefault(metadata.getValue((Object)CreditFields.Rerecords), Integer.toString(this.rerecords)));
        }
        catch (NumberFormatException e) {
            this.rerecords = 0;
            throw new PlaybackLoadException(e);
        }
    }

    protected String getOrDefault(String value, String defaultVal) {
        return value != null ? value : defaultVal;
    }

    @Override
    public void onClear() {
        this.title = "Insert TAS category here";
        this.authors = "Insert author here";
        this.playtime = "00:00.0";
        this.rerecords = 0;
        this.creditsPrinted = false;
    }

    @Override
    public void onPlaybackJoinedWorld(PlaybackControllerClient.TASstate state) {
        TASmod.LOGGER.trace(LoggerMarkers.Playback, "Printing credits");
        if (state == PlaybackControllerClient.TASstate.PLAYBACK && !this.creditsPrinted) {
            this.creditsPrinted = true;
            this.printMessage(this.title, class_1442.field_5489);
            this.printMessage("", null);
            this.printMessage("by " + this.authors, class_1442.field_5494);
            this.printMessage("", null);
            this.printMessage("in " + this.playtime, null);
            this.printMessage("", null);
            this.printMessage("Rerecords: " + this.rerecords, null);
        }
    }

    protected void printMessage(String msg, class_1442 format) {
        String formatString = "";
        if (format != null) {
            formatString = format.toString();
        }
        class_1600.method_2965().field_3820.method_983().method_6690((class_1982)new class_1989(formatString + msg));
    }

    @Override
    public void onControllerStateChange(PlaybackControllerClient.TASstate newstate, PlaybackControllerClient.TASstate oldstate) {
        if (newstate == PlaybackControllerClient.TASstate.PLAYBACK) {
            this.creditsPrinted = false;
        }
    }

    public static enum CreditFields {
        Title("Title"),
        Author("Author"),
        PlayTime("Playing Time"),
        Rerecords("Rerecords");

        private final String name;

        private CreditFields(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

