/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.playback.metadata.builtin;

import com.minecrafttas.mctcommon.networking.exception.PacketNotImplementedException;
import com.minecrafttas.mctcommon.networking.exception.WrongSideException;
import com.minecrafttas.mctcommon.networking.interfaces.PacketID;
import com.minecrafttas.mctcommon.networking.interfaces.ServerPacketHandler;
import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.TASmodClient;
import com.minecrafttas.tasmod.events.EventPlaybackClient;
import com.minecrafttas.tasmod.networking.TASmodBufferBuilder;
import com.minecrafttas.tasmod.playback.PlaybackControllerClient;
import com.minecrafttas.tasmod.playback.metadata.PlaybackMetadata;
import com.minecrafttas.tasmod.playback.tasfile.exception.PlaybackLoadException;
import com.minecrafttas.tasmod.registries.TASmodPackets;
import com.minecrafttas.tasmod.util.LoggerMarkers;
import java.nio.ByteBuffer;
import net.minecraft.class_1600;
import net.minecraft.class_518;
import net.minecraft.class_798;

public class StartpositionMetadataExtension
extends PlaybackMetadata.PlaybackMetadataExtension
implements EventPlaybackClient.EventControllerStateChange,
ServerPacketHandler {
    protected StartPosition startPosition = null;

    @Override
    public String getExtensionName() {
        return "Start Position";
    }

    @Override
    public void onCreate() {
    }

    @Override
    public PlaybackMetadata onStore() {
        PlaybackMetadata metadata = new PlaybackMetadata(this);
        StartPosition startPositionToStore = new StartPosition(0.0, 0.0, 0.0, 0.0f, 0.0f);
        if (this.startPosition != null) {
            startPositionToStore = this.startPosition;
        }
        metadata.setValue((Object)StartPositionFields.X, Double.toString(startPositionToStore.x));
        metadata.setValue((Object)StartPositionFields.Y, Double.toString(startPositionToStore.y));
        metadata.setValue((Object)StartPositionFields.Z, Double.toString(startPositionToStore.z));
        metadata.setValue((Object)StartPositionFields.Pitch, Float.toString(startPositionToStore.pitch));
        metadata.setValue((Object)StartPositionFields.Yaw, Float.toString(startPositionToStore.yaw));
        return metadata;
    }

    @Override
    public void onLoad(PlaybackMetadata metadata) {
        double x = this.getDouble((Object)StartPositionFields.X, metadata);
        double y = this.getDouble((Object)StartPositionFields.Y, metadata);
        double z = this.getDouble((Object)StartPositionFields.Z, metadata);
        float pitch = this.getFloat((Object)StartPositionFields.Pitch, metadata);
        float yaw = this.getFloat((Object)StartPositionFields.Yaw, metadata);
        this.startPosition = new StartPosition(x, y, z, pitch, yaw);
    }

    private double getDouble(Object key, PlaybackMetadata metadata) {
        return this.getDouble(key.toString(), metadata);
    }

    private double getDouble(String key, PlaybackMetadata metadata) {
        String out = metadata.getValue(key);
        if (out != null) {
            try {
                return Double.parseDouble(out);
            }
            catch (NumberFormatException e) {
                throw new PlaybackLoadException(e);
            }
        }
        throw new PlaybackLoadException(String.format("Missing key %s in Start Position metadata", key));
    }

    private float getFloat(Object key, PlaybackMetadata metadata) {
        return this.getFloat(key.toString(), metadata);
    }

    private float getFloat(String key, PlaybackMetadata metadata) {
        String out = metadata.getValue(key);
        if (out != null) {
            try {
                return Float.parseFloat(out);
            }
            catch (NumberFormatException e) {
                throw new PlaybackLoadException(e);
            }
        }
        throw new PlaybackLoadException(String.format("Missing key %s in Start Position metadata", key));
    }

    @Override
    public void onClear() {
        this.startPosition = null;
    }

    @Override
    public void onControllerStateChange(PlaybackControllerClient.TASstate newstate, PlaybackControllerClient.TASstate oldstate) {
        class_1600 mc = class_1600.method_2965();
        if (mc.field_10310 != null) {
            if (oldstate == PlaybackControllerClient.TASstate.NONE && newstate == PlaybackControllerClient.TASstate.RECORDING && this.startPosition == null) {
                this.updateStartPosition();
            } else if (oldstate == PlaybackControllerClient.TASstate.NONE && newstate == PlaybackControllerClient.TASstate.PLAYBACK && this.startPosition != null) {
                TASmod.LOGGER.debug(LoggerMarkers.Playback, "Teleporting the player to the start location");
                TASmodBufferBuilder packetBuilder = new TASmodBufferBuilder(TASmodPackets.PLAYBACK_TELEPORT);
                packetBuilder.writeDouble(this.startPosition.x).writeDouble(this.startPosition.y).writeDouble(this.startPosition.z).writeFloat(this.startPosition.pitch).writeFloat(this.startPosition.yaw);
                try {
                    TASmodClient.client.send(packetBuilder);
                }
                catch (Exception e) {
                    TASmod.LOGGER.error("Unable to teleport player to start location", (Throwable)e);
                }
            }
        }
    }

    public void updateStartPosition() {
        TASmod.LOGGER.debug(LoggerMarkers.Playback, "Setting start location");
        class_1600 mc = class_1600.method_2965();
        class_518 player = mc.field_10310;
        if (player != null) {
            this.startPosition = new StartPosition(player.field_3252, player.field_3253, player.field_3254, player.field_3193, player.field_3258);
        } else {
            TASmod.LOGGER.warn("Start position not set, the player was null! This will create problems when storing inputs!");
        }
    }

    @Override
    public PacketID[] getAcceptedPacketIDs() {
        return new PacketID[]{TASmodPackets.PLAYBACK_TELEPORT};
    }

    @Override
    public void onServerPacket(PacketID id, ByteBuffer buf, String username) throws PacketNotImplementedException, WrongSideException, Exception {
        TASmodPackets packet = (TASmodPackets)id;
        if (packet == TASmodPackets.PLAYBACK_TELEPORT) {
            double x = TASmodBufferBuilder.readDouble(buf);
            double y = TASmodBufferBuilder.readDouble(buf);
            double z = TASmodBufferBuilder.readDouble(buf);
            float angleYaw = TASmodBufferBuilder.readFloat(buf);
            float anglePitch = TASmodBufferBuilder.readFloat(buf);
            class_798 player = TASmod.getServerInstance().method_3004().method_2010(username);
            player.method_2162().method_6635(() -> {
                player.field_3193 = anglePitch;
                player.field_3258 = angleYaw;
                player.method_2577(x, y, z);
            });
        }
    }

    public static class StartPosition {
        public final double x;
        public final double y;
        public final double z;
        public final float pitch;
        public final float yaw;

        public StartPosition(double x, double y, double z, float pitch, float yaw) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.pitch = pitch;
            this.yaw = yaw;
        }

        public String toString() {
            return String.format("%e,%e,%e,%e,%e", this.x, this.y, this.z, Float.valueOf(this.pitch), Float.valueOf(this.yaw));
        }
    }

    public static enum StartPositionFields {
        X("x"),
        Y("y"),
        Z("z"),
        Pitch("pitch"),
        Yaw("yaw");

        private final String name;

        private StartPositionFields(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

