/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.playback.tasfile;

import com.dselent.bigarraylist.BigArrayList;
import com.minecrafttas.tasmod.playback.PlaybackControllerClient;
import com.minecrafttas.tasmod.playback.tasfile.exception.PlaybackLoadException;
import com.minecrafttas.tasmod.playback.tasfile.exception.PlaybackSaveException;
import com.minecrafttas.tasmod.playback.tasfile.flavor.SerialiserFlavorBase;
import com.minecrafttas.tasmod.registries.TASmodAPIRegistry;
import com.minecrafttas.tasmod.util.FileThread;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class PlaybackSerialiser {
    private static String defaultFlavor = "beta1";

    public static void saveToFile(Path file, PlaybackControllerClient controller, String flavorName) throws PlaybackSaveException {
        PlaybackSerialiser.saveToFile(file, controller, flavorName, -1L);
    }

    public static void saveToFile(Path file, PlaybackControllerClient controller, String flavorName, long stopIndex) throws PlaybackSaveException {
        if (controller == null) {
            throw new PlaybackSaveException("Save to file failed. No controller specified");
        }
        PlaybackSerialiser.saveToFile(file, controller.getInputs(), flavorName, stopIndex);
    }

    public static void saveToFile(Path file, BigArrayList<PlaybackControllerClient.InputContainer> container, String flavorName) throws PlaybackSaveException {
        PlaybackSerialiser.saveToFile(file, container, flavorName, -1L);
    }

    public static void saveToFile(Path path, BigArrayList<PlaybackControllerClient.InputContainer> container, String flavorName, long stopIndex) throws PlaybackSaveException {
        FileThread writerThread;
        if (path == null) {
            throw new PlaybackSaveException("Save to file failed. No file specified");
        }
        if (container == null) {
            throw new PlaybackSaveException("Save to file failed. No inputcontainer list specified");
        }
        if (flavorName == null || flavorName.isEmpty()) {
            if (defaultFlavor == null || defaultFlavor.isEmpty()) {
                throw new PlaybackSaveException("No default flavor specified... Please specify a flavor name first");
            }
            flavorName = defaultFlavor;
        }
        try {
            writerThread = new FileThread(path, false);
        }
        catch (IOException e) {
            throw new PlaybackSaveException(e, "Trying to save the file %s, but the file can't be created", path.getFileName().toString());
        }
        writerThread.start();
        SerialiserFlavorBase flavor = TASmodAPIRegistry.SERIALISER_FLAVOR.getFlavor(flavorName);
        if (flavor == null) {
            throw new PlaybackSaveException("Flavor %s doesn't exist", flavorName);
        }
        defaultFlavor = flavorName;
        List<String> header = flavor.serialiseHeader();
        for (String line : header) {
            writerThread.addLine(line);
        }
        BigArrayList<String> tickLines = flavor.serialise(container, stopIndex);
        for (String tickLine : tickLines) {
            writerThread.addLine(tickLine);
        }
        writerThread.close();
    }

    public static BigArrayList<PlaybackControllerClient.InputContainer> loadFromFile(Path file) throws PlaybackLoadException, IOException {
        return PlaybackSerialiser.loadFromFile(file, true);
    }

    public static BigArrayList<PlaybackControllerClient.InputContainer> loadFromFile(Path file, boolean processExtensions) throws PlaybackLoadException, IOException {
        if (file == null) {
            throw new PlaybackLoadException("Load from file failed. No file specified");
        }
        if (!Files.exists(file, new LinkOption[0])) {
            throw new PlaybackLoadException("Trying to load %s but the file doesn't exist", file.getFileName().toString());
        }
        SerialiserFlavorBase flavor = PlaybackSerialiser.readFlavor(file);
        flavor.setProcessExtensions(processExtensions);
        return PlaybackSerialiser.loadFromFile(file, flavor);
    }

    public static BigArrayList<PlaybackControllerClient.InputContainer> loadFromFile(Path file, String flavorName) throws PlaybackLoadException, IOException {
        return PlaybackSerialiser.loadFromFile(file, flavorName, true);
    }

    public static BigArrayList<PlaybackControllerClient.InputContainer> loadFromFile(Path file, String flavorName, boolean processExtensions) throws PlaybackLoadException, IOException {
        if (flavorName == null || flavorName.isEmpty()) {
            return PlaybackSerialiser.loadFromFile(file);
        }
        SerialiserFlavorBase flavor = TASmodAPIRegistry.SERIALISER_FLAVOR.getFlavor(flavorName);
        if (flavor == null) {
            throw new PlaybackLoadException("Flavor name %s doesn't exist.", flavorName);
        }
        SerialiserFlavorBase flavorInFile = PlaybackSerialiser.readFlavor(file);
        if (!flavor.equals(flavorInFile)) {
            throw new PlaybackLoadException("Detected flavor %s in the TASfile, which does not match the specified flavor: %s", flavorInFile.getExtensionName(), flavor.getExtensionName());
        }
        flavor.setProcessExtensions(processExtensions);
        return PlaybackSerialiser.loadFromFile(file, flavor);
    }

    public static BigArrayList<PlaybackControllerClient.InputContainer> loadFromFile(Path file, SerialiserFlavorBase flavor) throws PlaybackLoadException, IOException {
        if (file == null) {
            throw new PlaybackLoadException("Load from file failed. No file specified");
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file.toFile()));
        }
        catch (FileNotFoundException e) {
            throw new PlaybackLoadException("Trying to load %s, but the file doesn't exist", file.getFileName().toString());
        }
        BigArrayList<String> lines = new BigArrayList<String>();
        String line = null;
        while ((line = reader.readLine()) != null) {
            lines.add(line);
        }
        reader.close();
        List<String> headerLines = flavor.extractHeader(lines);
        flavor.deserialiseHeader(headerLines);
        BigArrayList<PlaybackControllerClient.InputContainer> deserialisedContainers = flavor.deserialise(lines, headerLines.size());
        return deserialisedContainers;
    }

    public static SerialiserFlavorBase searchForFlavor(List<String> lines, List<SerialiserFlavorBase> flavorList) {
        for (SerialiserFlavorBase flavor : flavorList) {
            if (!flavor.checkFlavorName(lines)) continue;
            return flavor.clone();
        }
        throw new PlaybackLoadException("Couldn't find a flavorname in the file. TASfile is missing a flavor-extension or the file is broken");
    }

    public static SerialiserFlavorBase readFlavor(Path file) throws PlaybackLoadException, IOException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file.toFile()));
        }
        catch (FileNotFoundException e) {
            throw new PlaybackLoadException("Trying to load %s but the file doesn't exist", file.getFileName().toString());
        }
        ArrayList<String> lines = new ArrayList<String>();
        String line = null;
        for (int i = 0; i < 100; ++i) {
            line = reader.readLine();
            if (line == null) continue;
            lines.add(line);
        }
        reader.close();
        SerialiserFlavorBase flavor = null;
        flavor = PlaybackSerialiser.searchForFlavor(lines, TASmodAPIRegistry.SERIALISER_FLAVOR.getFlavors());
        return flavor;
    }
}

