/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.playback.tasfile.flavor;

import com.dselent.bigarraylist.BigArrayList;
import com.minecrafttas.mctcommon.registry.Registerable;
import com.minecrafttas.tasmod.playback.PlaybackControllerClient;
import com.minecrafttas.tasmod.playback.filecommands.PlaybackFileCommand;
import com.minecrafttas.tasmod.playback.metadata.PlaybackMetadata;
import com.minecrafttas.tasmod.playback.tasfile.exception.PlaybackLoadException;
import com.minecrafttas.tasmod.registries.TASmodAPIRegistry;
import com.minecrafttas.tasmod.virtual.Subtickable;
import com.minecrafttas.tasmod.virtual.VirtualCameraAngle;
import com.minecrafttas.tasmod.virtual.VirtualKey;
import com.minecrafttas.tasmod.virtual.VirtualKeyboard;
import com.minecrafttas.tasmod.virtual.VirtualMouse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public abstract class SerialiserFlavorBase
implements Registerable {
    protected long currentLine = 1L;
    protected long currentTick = 0L;
    protected int currentSubtick = 0;
    protected PlaybackControllerClient.InputContainer previousInputContainer = null;
    protected boolean processExtensions = true;
    protected int yawRotations = 0;

    protected String headerStart() {
        return SerialiserFlavorBase.createCenteredHeading("TASfile", '#', 50);
    }

    protected String headerEnd() {
        return SerialiserFlavorBase.createPaddedString('#', 50);
    }

    public List<String> serialiseHeader() {
        ArrayList<String> out = new ArrayList<String>();
        out.add(this.headerStart());
        this.serialiseFlavorName(out);
        this.serialiseEnabledFileCommandNames(out);
        this.serialiseMetadata(out);
        out.add(this.headerEnd());
        return out;
    }

    protected void serialiseFlavorName(List<String> out) {
        out.add("Flavor: " + this.getExtensionName());
    }

    protected void serialiseEnabledFileCommandNames(List<String> out) {
        ArrayList stringlist = new ArrayList();
        List<PlaybackFileCommand.PlaybackFileCommandExtension> extensionList = TASmodAPIRegistry.PLAYBACK_FILE_COMMAND.getEnabled();
        if (this.processExtensions) {
            extensionList.forEach(extension -> stringlist.add(extension.getExtensionName()));
        }
        out.add("FileCommand-Extensions: " + String.join((CharSequence)", ", stringlist));
        out.add("");
    }

    protected void serialiseMetadata(List<String> out) {
        if (!this.processExtensions) {
            return;
        }
        List<PlaybackMetadata> metadataList = TASmodAPIRegistry.PLAYBACK_METADATA.handleOnStore();
        for (PlaybackMetadata metadata : metadataList) {
            this.serialiseMetadataName(out, metadata.getExtensionName());
            this.serialiseMetadataValues(out, metadata.getData());
            out.add("");
        }
    }

    protected void serialiseMetadataName(List<String> out, String name) {
        out.add(SerialiserFlavorBase.createCenteredHeading(name, '-', 50));
    }

    protected void serialiseMetadataValues(List<String> out, LinkedHashMap<String, String> data) {
        data.forEach((key, value) -> out.add(String.format("%s:%s", key, value)));
    }

    public BigArrayList<String> serialise(BigArrayList<PlaybackControllerClient.InputContainer> inputs, long toTick) {
        BigArrayList<String> out = new BigArrayList<String>();
        int i = 0;
        while ((long)i < inputs.size() && toTick != (long)i) {
            this.currentTick = i;
            PlaybackControllerClient.InputContainer container = inputs.get(i).clone();
            this.serialiseContainer(out, container);
            this.previousInputContainer = container;
            ++i;
        }
        return out;
    }

    protected void serialiseContainer(BigArrayList<String> out, PlaybackControllerClient.InputContainer container) {
        this.currentLine = out.size() - 1L;
        List<String> serialisedKeyboard = this.serialiseKeyboard(container.getKeyboard());
        List<String> serialisedMouse = this.serialiseMouse(container.getMouse());
        List<String> serialisedCameraAngle = this.serialiseCameraAngle(container.getCameraAngle());
        this.pruneListEndEmpty(serialisedCameraAngle);
        PlaybackFileCommand.UnsortedFileCommandContainer fileCommandsInline = TASmodAPIRegistry.PLAYBACK_FILE_COMMAND.handleOnSerialiseInline(this.currentTick, container);
        PlaybackFileCommand.UnsortedFileCommandContainer fileCommandsEndline = TASmodAPIRegistry.PLAYBACK_FILE_COMMAND.handleOnSerialiseEndline(this.currentTick, container);
        PlaybackControllerClient.CommentContainer comments = container.getComments();
        List<String> serialisedInlineComments = this.serialiseInlineComments(comments.getInlineComments(), fileCommandsInline);
        List<String> serialisedEndlineComments = this.serialiseEndlineComments(comments.getEndlineComments(), fileCommandsEndline);
        this.mergeInputs(out, serialisedKeyboard, serialisedMouse, serialisedCameraAngle, serialisedInlineComments, serialisedEndlineComments);
    }

    protected List<String> serialiseKeyboard(VirtualKeyboard keyboard) {
        ArrayList<String> out = new ArrayList<String>();
        ArrayList subticks = new ArrayList(keyboard.getAll());
        for (VirtualKeyboard subtick : subticks) {
            out.add(this.serialiseKeyboardSubtick(subtick));
        }
        return out;
    }

    protected String serialiseKeyboardSubtick(VirtualKeyboard keyboardSubtick) {
        return String.format("%s;%s", String.join((CharSequence)",", keyboardSubtick.getCurrentPresses()), this.charListToString(keyboardSubtick.getCharList()));
    }

    protected String charListToString(List<Character> charList) {
        String charString = "";
        if (!charList.isEmpty()) {
            charString = charList.stream().map(Object::toString).collect(Collectors.joining());
            charString = StringUtils.replace((String)charString, (String)"\r", (String)"\\n");
            charString = StringUtils.replace((String)charString, (String)"\n", (String)"\\n");
        }
        return charString;
    }

    protected List<String> serialiseMouse(VirtualMouse mouse) {
        ArrayList<String> out = new ArrayList<String>();
        ArrayList subticks = new ArrayList(mouse.getAll());
        for (VirtualMouse subtick : subticks) {
            out.add(this.serialiseMouseSubtick(subtick));
        }
        return out;
    }

    protected String serialiseMouseSubtick(VirtualMouse mouseSubtick) {
        return String.format("%s;%s,%s,%s", String.join((CharSequence)",", mouseSubtick.getCurrentPresses()), mouseSubtick.getScrollWheel(), mouseSubtick.getCursorX(), mouseSubtick.getCursorY());
    }

    protected List<String> serialiseCameraAngle(VirtualCameraAngle cameraAngle) {
        VirtualCameraAngle previousCamera = null;
        ArrayList<String> out = new ArrayList<String>();
        for (VirtualCameraAngle subtick : cameraAngle.getAll()) {
            if (!subtick.equals(previousCamera)) {
                out.add(this.serialiseCameraAngleSubtick(subtick));
            }
            previousCamera = subtick;
        }
        return out;
    }

    protected String serialiseCameraAngleSubtick(VirtualCameraAngle cameraAngleSubtick) {
        return String.format("%s;%s", this.clampYaw(cameraAngleSubtick.getYaw()), cameraAngleSubtick.getPitch());
    }

    protected List<String> serialiseInlineComments(List<String> inlineComments, PlaybackFileCommand.UnsortedFileCommandContainer fileCommandsInline) {
        ArrayList<String> out = new ArrayList<String>();
        LinkedList<PlaybackFileCommand.FileCommandsInCommentList> fileCommandQueue = null;
        if (fileCommandsInline != null) {
            fileCommandQueue = new LinkedList<PlaybackFileCommand.FileCommandsInCommentList>(fileCommandsInline);
        }
        if (inlineComments != null) {
            LinkedList<String> commentQueue = new LinkedList<String>(inlineComments);
            while (!commentQueue.isEmpty()) {
                String comment = (String)commentQueue.poll();
                String command = null;
                if (fileCommandQueue != null) {
                    command = this.serialiseFileCommandsInline((PlaybackFileCommand.FileCommandsInCommentList)fileCommandQueue.poll());
                }
                if (comment == null && command == null) {
                    out.add("");
                    continue;
                }
                out.add(this.serialiseInlineComment(this.joinNotEmpty(" ", command, comment)));
            }
        }
        if (fileCommandQueue != null) {
            while (!fileCommandQueue.isEmpty()) {
                String command = this.serialiseFileCommandsInline((PlaybackFileCommand.FileCommandsInCommentList)fileCommandQueue.poll());
                if (command != null) {
                    out.add(this.serialiseInlineComment(command));
                    continue;
                }
                out.add("");
            }
        }
        return out;
    }

    protected String serialiseInlineComment(String comment) {
        return String.format("// %s", comment);
    }

    protected List<String> serialiseEndlineComments(List<String> endlineComments, PlaybackFileCommand.UnsortedFileCommandContainer fileCommandsEndline) {
        ArrayList<String> out = new ArrayList<String>();
        LinkedList<PlaybackFileCommand.FileCommandsInCommentList> fileCommandQueue = null;
        if (fileCommandsEndline != null) {
            fileCommandQueue = new LinkedList<PlaybackFileCommand.FileCommandsInCommentList>(fileCommandsEndline);
        }
        if (endlineComments != null) {
            LinkedList<String> commentQueue = new LinkedList<String>(endlineComments);
            while (!commentQueue.isEmpty()) {
                String comment = (String)commentQueue.poll();
                String command = null;
                if (fileCommandQueue != null) {
                    command = this.serialiseFileCommandsEndline((PlaybackFileCommand.FileCommandsInCommentList)fileCommandQueue.poll());
                }
                if (comment == null && command == null) {
                    out.add("");
                    continue;
                }
                out.add(this.serialiseEndlineComment(this.joinNotEmpty(" ", command, comment)));
            }
        }
        if (fileCommandQueue != null) {
            while (!fileCommandQueue.isEmpty()) {
                String command = this.serialiseFileCommandsEndline((PlaybackFileCommand.FileCommandsInCommentList)fileCommandQueue.poll());
                if (command != null) {
                    out.add(this.serialiseEndlineComment(command));
                    continue;
                }
                out.add("");
            }
        }
        return out;
    }

    protected String serialiseEndlineComment(String comment) {
        return String.format("// %s", comment);
    }

    protected String serialiseFileCommandsInline(PlaybackFileCommand.FileCommandsInCommentList fileCommands) {
        if (fileCommands == null) {
            return null;
        }
        ArrayList<String> serialisedCommands = new ArrayList<String>();
        for (PlaybackFileCommand command : fileCommands) {
            serialisedCommands.add(this.serialiseFileCommand(command));
        }
        return this.joinNotEmpty(" ", serialisedCommands);
    }

    protected String serialiseFileCommandsEndline(PlaybackFileCommand.FileCommandsInCommentList fileCommands) {
        return this.serialiseFileCommandsInline(fileCommands);
    }

    protected String serialiseFileCommand(PlaybackFileCommand fileCommand) {
        if (!this.processExtensions || fileCommand == null) {
            return "";
        }
        return String.format("$%s(%s);", fileCommand.getName(), String.join((CharSequence)", ", fileCommand.getArgs()));
    }

    protected void mergeInputs(BigArrayList<String> out, List<String> serialisedKeyboard, List<String> serialisedMouse, List<String> serialisedCameraAngle, List<String> serialisedInlineComments, List<String> serialisedEndlineComments) {
        out.addAll(serialisedInlineComments);
        LinkedBlockingQueue<String> keyboardQueue = new LinkedBlockingQueue<String>(serialisedKeyboard);
        LinkedBlockingQueue<String> mouseQueue = new LinkedBlockingQueue<String>(serialisedMouse);
        LinkedBlockingQueue<String> cameraAngleQueue = new LinkedBlockingQueue<String>(serialisedCameraAngle);
        LinkedBlockingQueue<String> endlineCommentQueue = new LinkedBlockingQueue<String>(serialisedEndlineComments);
        String kb = this.getOrEmpty((String)keyboardQueue.poll());
        String ms = this.getOrEmpty((String)mouseQueue.poll());
        String ca = this.getOrEmpty((String)cameraAngleQueue.poll());
        String elc = this.getOrEmpty((String)endlineCommentQueue.poll());
        if (!elc.isEmpty()) {
            elc = "\t\t" + elc;
        }
        out.add(this.mergeInput(this.currentTick, kb, ms, ca, elc));
        this.currentSubtick = 0;
        while (!(keyboardQueue.isEmpty() && mouseQueue.isEmpty() && cameraAngleQueue.isEmpty())) {
            ++this.currentSubtick;
            kb = this.getOrEmpty((String)keyboardQueue.poll());
            ms = this.getOrEmpty((String)mouseQueue.poll());
            ca = this.getOrEmpty((String)cameraAngleQueue.poll());
            elc = this.getOrEmpty((String)endlineCommentQueue.poll());
            if (!elc.isEmpty()) {
                elc = "\t\t" + elc;
            }
            out.add(this.mergeSubtickInput(this.currentSubtick, kb, ms, ca, elc));
        }
        while (!endlineCommentQueue.isEmpty()) {
            elc = this.getOrEmpty((String)endlineCommentQueue.poll());
            out.add(String.format("\t|||;\t\t%s", elc));
        }
        this.currentSubtick = 0;
    }

    protected String mergeInput(long currentTick, String keyboard, String mouse, String cameraAngle, String endLineComment) {
        return String.format("%s|%s|%s|%s%s", currentTick, keyboard, mouse, cameraAngle, endLineComment);
    }

    protected String mergeSubtickInput(int currentSubtick, String keyboard, String mouse, String cameraAngle, String endLineComment) {
        return String.format("\t%s|%s|%s|%s%s", currentSubtick, keyboard, mouse, cameraAngle, endLineComment);
    }

    protected String getOrEmpty(String string) {
        return string == null ? "" : string;
    }

    protected String joinNotEmpty(String delimiter, Iterable<String> args) {
        String out = "";
        ArrayList copy = new ArrayList();
        args.forEach(arg -> {
            if (arg != null && !arg.isEmpty()) {
                copy.add(arg);
            }
        });
        out = String.join((CharSequence)delimiter, copy);
        return out;
    }

    protected String joinNotEmpty(String delimiter, String ... args) {
        return this.joinNotEmpty(delimiter, Arrays.asList(args));
    }

    public boolean checkFlavorName(List<String> headerLines) {
        for (String line : headerLines) {
            Matcher matcher = this.extract("^Flavor: " + this.getExtensionName(), line);
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }

    public List<String> extractHeader(BigArrayList<String> lines) {
        ArrayList<String> extracted = new ArrayList<String>();
        long maxExtract = 1000L;
        maxExtract = lines.size() < maxExtract ? lines.size() : maxExtract;
        for (long i = 0L; i < maxExtract; ++i) {
            String line = lines.get(i);
            extracted.add(line);
            if (!line.equals(this.headerEnd())) continue;
            return extracted;
        }
        throw new PlaybackLoadException("Cannot find the end of the header");
    }

    public void deserialiseHeader(List<String> headerLines) {
        this.deserialiseMetadata(headerLines);
        this.deserialiseEnabledFileCommandNames(headerLines);
    }

    protected void deserialiseMetadata(List<String> headerLines) {
        if (!this.processExtensions) {
            return;
        }
        ArrayList<PlaybackMetadata> out = new ArrayList<PlaybackMetadata>();
        String metadataName = null;
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        for (String headerLine : headerLines) {
            Matcher nameMatcher = this.extract("^-+ ([^-]+)", headerLine);
            Matcher valueMatcher = this.extract("^([^#].*?):\\s*(.+)", headerLine);
            if (nameMatcher.find()) {
                if (metadataName != null && !metadataName.equals(nameMatcher.group(1))) {
                    out.add(PlaybackMetadata.fromHashMap(metadataName, values));
                    values.clear();
                }
                metadataName = nameMatcher.group(1).trim();
                continue;
            }
            if (metadataName == null || !valueMatcher.find()) continue;
            values.put(valueMatcher.group(1).trim(), valueMatcher.group(2).trim());
        }
        if (metadataName != null) {
            out.add(PlaybackMetadata.fromHashMap(metadataName, values));
        }
        TASmodAPIRegistry.PLAYBACK_METADATA.handleOnLoad(out);
    }

    protected void deserialiseEnabledFileCommandNames(List<String> headerLines) {
        if (!this.processExtensions) {
            return;
        }
        for (String line : headerLines) {
            Matcher matcher = this.extract("FileCommand-Extensions: ?(.*)", line);
            if (!matcher.find()) continue;
            if (!this.processExtensions) {
                return;
            }
            String extensionStrings = matcher.group(1);
            String[] extensionNames = extensionStrings.split(", ?");
            TASmodAPIRegistry.PLAYBACK_FILE_COMMAND.setEnabled(extensionNames);
            return;
        }
        throw new PlaybackLoadException("FileCommand-Extensions value was not found in the header");
    }

    public BigArrayList<PlaybackControllerClient.InputContainer> deserialise(BigArrayList<String> lines, long startPos) {
        BigArrayList<PlaybackControllerClient.InputContainer> out = new BigArrayList<PlaybackControllerClient.InputContainer>();
        if (this.processExtensions) {
            TASmodAPIRegistry.PLAYBACK_FILE_COMMAND.onClear();
        }
        long i = startPos;
        while (i < lines.size()) {
            ArrayList<String> container = new ArrayList<String>();
            i = this.extractContainer(container, lines, i);
            this.currentLine = i++;
            this.deserialiseContainer(out, container);
            ++this.currentTick;
        }
        this.previousInputContainer = null;
        return out;
    }

    protected long extractContainer(List<String> extracted, BigArrayList<String> lines, long startPos) {
        ExtractPhases phase = ExtractPhases.NONE;
        String commentRegex = "^//";
        String tickRegex = "^\\d+\\|";
        String subtickRegex = "^\t\\d+\\|";
        long counter = 0L;
        for (long i = startPos; i < lines.size(); ++i) {
            String line = lines.get(i);
            switch (phase.ordinal()) {
                case 3: {
                    if (this.contains(subtickRegex, line)) {
                        throw new PlaybackLoadException(startPos + counter + 1L, this.currentTick, this.currentSubtick, "Error while trying to parse the file. This should not be a subtick at this position");
                    }
                    if (this.contains(commentRegex, line) || line.isEmpty()) {
                        phase = ExtractPhases.COMMENTS;
                        break;
                    }
                    if (!this.contains(tickRegex, line)) break;
                    phase = ExtractPhases.TICK;
                    break;
                }
                case 0: {
                    if (this.contains(subtickRegex, line)) {
                        throw new PlaybackLoadException(startPos + counter + 1L, this.currentTick, this.currentSubtick, "Error while trying to parse the file. This should not be a subtick at this position");
                    }
                    if (!this.contains(tickRegex, line)) break;
                    phase = ExtractPhases.TICK;
                    break;
                }
                case 1: {
                    if (this.contains(subtickRegex, line)) {
                        phase = ExtractPhases.SUBTICK;
                    }
                    if (!this.contains(commentRegex, line) && !this.contains(tickRegex, line) && !line.isEmpty()) break;
                    return startPos + counter - 1L;
                }
                case 2: {
                    if (!this.contains(commentRegex, line) && !this.contains(tickRegex, line) && !line.isEmpty()) break;
                    return startPos + counter - 1L;
                }
            }
            if (phase != ExtractPhases.NONE) {
                extracted.add(line);
            }
            ++counter;
        }
        return startPos + counter - 1L;
    }

    protected void deserialiseContainer(BigArrayList<PlaybackControllerClient.InputContainer> out, List<String> containerLines) {
        ArrayList<String> inlineComments = new ArrayList<String>();
        ArrayList<String> tickLines = new ArrayList<String>();
        this.splitContainer(containerLines, inlineComments, tickLines);
        PlaybackFileCommand.UnsortedFileCommandContainer inlineFileCommands = new PlaybackFileCommand.UnsortedFileCommandContainer();
        this.deserialiseMultipleInlineComments(inlineComments, inlineFileCommands);
        ArrayList<String> keyboardStrings = new ArrayList<String>();
        ArrayList<String> mouseStrings = new ArrayList<String>();
        ArrayList<String> cameraAngleStrings = new ArrayList<String>();
        ArrayList<String> endlineComments = new ArrayList<String>();
        PlaybackFileCommand.UnsortedFileCommandContainer endlineFileCommands = new PlaybackFileCommand.UnsortedFileCommandContainer();
        this.splitTickLines(tickLines, keyboardStrings, mouseStrings, cameraAngleStrings, endlineComments, endlineFileCommands);
        this.pruneListEndNull(endlineComments);
        VirtualKeyboard keyboard = this.deserialiseKeyboard(keyboardStrings);
        VirtualMouse mouse = this.deserialiseMouse(mouseStrings);
        VirtualCameraAngle cameraAngle = this.deserialiseCameraAngle(cameraAngleStrings);
        PlaybackControllerClient.CommentContainer comments = new PlaybackControllerClient.CommentContainer(inlineComments, endlineComments);
        PlaybackControllerClient.InputContainer deserialisedContainer = new PlaybackControllerClient.InputContainer(keyboard, mouse, cameraAngle, comments);
        if (this.processExtensions) {
            TASmodAPIRegistry.PLAYBACK_FILE_COMMAND.handleOnDeserialiseInline(this.currentTick, deserialisedContainer, inlineFileCommands);
            TASmodAPIRegistry.PLAYBACK_FILE_COMMAND.handleOnDeserialiseEndline(this.currentTick, deserialisedContainer, endlineFileCommands);
        }
        this.previousInputContainer = deserialisedContainer;
        out.add(deserialisedContainer);
    }

    protected String inlineComment() {
        return "^//";
    }

    protected void splitContainer(List<String> lines, List<String> inlineComments, List<String> ticks) {
        for (String line : lines) {
            if (this.contains(this.inlineComment(), line)) {
                inlineComments.add(line);
                continue;
            }
            ticks.add(line);
        }
    }

    protected void deserialiseMultipleInlineComments(List<String> inlineComments, PlaybackFileCommand.UnsortedFileCommandContainer inlineFileCommands) {
        for (int i = 0; i < inlineComments.size(); ++i) {
            PlaybackFileCommand.FileCommandsInCommentList deserialisedFileCommands = new PlaybackFileCommand.FileCommandsInCommentList();
            String comment = inlineComments.get(i);
            inlineComments.set(i, this.deserialiseInlineComment(comment, deserialisedFileCommands));
            if (deserialisedFileCommands.isEmpty()) {
                deserialisedFileCommands = null;
            }
            inlineFileCommands.add(deserialisedFileCommands);
        }
    }

    protected String deserialiseInlineComment(String comment, PlaybackFileCommand.FileCommandsInCommentList deserialisedFileCommands) {
        comment = this.deserialiseFileCommandsInline(comment, deserialisedFileCommands);
        if ((comment = this.extract("^// ?(.+)", comment, 1)) != null && (comment = comment.trim()).isEmpty()) {
            comment = null;
        }
        return comment;
    }

    protected String endlineComment() {
        return "(//.+)";
    }

    protected String deserialiseEndlineComment(String comment, PlaybackFileCommand.FileCommandsInCommentList deserialisedFileCommands) {
        comment = this.deserialiseFileCommandsEndline(comment, deserialisedFileCommands);
        if ((comment = this.extract("^// ?(.+)", comment, 1)) != null && (comment = comment.trim()).isEmpty()) {
            comment = null;
        }
        return comment;
    }

    protected String deserialiseFileCommandsInline(String comment, PlaybackFileCommand.FileCommandsInCommentList deserialisedFileCommands) {
        Matcher matcher = this.extract("\\$(.+?)\\((.*?)\\);", comment);
        while (matcher.find()) {
            String name = matcher.group(1);
            String[] args = matcher.group(2).split(", ?");
            if (this.processExtensions) {
                deserialisedFileCommands.add(new PlaybackFileCommand(name, args));
            }
            comment = matcher.replaceFirst("");
            matcher.reset(comment);
        }
        return comment;
    }

    protected String deserialiseFileCommandsEndline(String comment, PlaybackFileCommand.FileCommandsInCommentList deserialisedFileCommands) {
        Matcher matcher = this.extract("\\$(.+?)\\((.*?)\\);", comment);
        while (matcher.find()) {
            String name = matcher.group(1);
            String[] args = matcher.group(2).split(", ?");
            if (this.processExtensions) {
                deserialisedFileCommands.add(new PlaybackFileCommand(name, args));
            }
            comment = matcher.replaceFirst("");
            matcher.reset(comment);
        }
        return comment;
    }

    protected String splitTickLineRegex() {
        return "^\\t?\\d+\\|(.*?)\\|(.*?)\\|(\\S*)\\s?";
    }

    protected void splitTickLines(List<String> lines, List<String> serialisedKeyboard, List<String> serialisedMouse, List<String> serialisedCameraAngle, List<String> commentsAtEnd, PlaybackFileCommand.UnsortedFileCommandContainer endlineFileCommands) {
        String previousCamera = null;
        if (this.previousInputContainer != null) {
            VirtualCameraAngle camera = this.previousInputContainer.getCameraAngle();
            previousCamera = String.format("%s;%s", camera.getYaw(), camera.getPitch());
        }
        for (String line : lines) {
            Matcher tickMatcher = this.extract(this.splitTickLineRegex(), line);
            if (!tickMatcher.find()) continue;
            if (!tickMatcher.group(1).isEmpty()) {
                serialisedKeyboard.add(tickMatcher.group(1));
            }
            if (!tickMatcher.group(2).isEmpty()) {
                serialisedMouse.add(tickMatcher.group(2));
            }
            if (!tickMatcher.group(3).isEmpty()) {
                serialisedCameraAngle.add(tickMatcher.group(3));
                previousCamera = tickMatcher.group(3);
            } else if (previousCamera != null) {
                serialisedCameraAngle.add(previousCamera);
            }
            PlaybackFileCommand.FileCommandsInCommentList deserialisedFileCommands = new PlaybackFileCommand.FileCommandsInCommentList();
            String endlineComment = line.substring(tickMatcher.group(0).length());
            commentsAtEnd.add(this.deserialiseEndlineComment(endlineComment, deserialisedFileCommands));
            if (deserialisedFileCommands.isEmpty()) {
                deserialisedFileCommands = null;
            }
            endlineFileCommands.add(deserialisedFileCommands);
        }
    }

    protected VirtualKeyboard deserialiseKeyboard(List<String> keyboardStrings) {
        VirtualKeyboard out = new VirtualKeyboard();
        this.currentSubtick = 0;
        for (String line : keyboardStrings) {
            Matcher matcher = this.extract("(.*?);(.*)", line);
            if (!matcher.find()) {
                throw new PlaybackLoadException(this.currentLine, this.currentTick, this.currentSubtick, "Keyboard could not be read. Probably a missing semicolon: %s", line);
            }
            String[] keys = matcher.group(1).split(",");
            char[] chars = matcher.group(2).toCharArray();
            Set<Integer> keycodes = this.deserialiseVirtualKeyboardKey(keys);
            out.updateFromState(keycodes, chars);
            ++this.currentSubtick;
        }
        return out;
    }

    protected VirtualMouse deserialiseMouse(List<String> mouseStrings) {
        VirtualMouse out = new VirtualMouse();
        this.currentSubtick = 0;
        Integer previousCursorX = this.previousInputContainer == null ? null : Integer.valueOf(this.previousInputContainer.getMouse().getCursorX());
        Integer previousCursorY = this.previousInputContainer == null ? null : Integer.valueOf(this.previousInputContainer.getMouse().getCursorY());
        for (String line : mouseStrings) {
            Integer cursorY;
            Integer cursorX;
            int scrollwheel;
            Set<Integer> keycodes;
            Matcher matcher = this.extract("(.*?);(.+)", line);
            if (matcher.find()) {
                String[] buttons = matcher.group(1).split(",");
                String[] functions = matcher.group(2).split(",");
                keycodes = this.deserialiseVirtualMouseKey(buttons);
                if (functions.length != 3) {
                    throw new PlaybackLoadException(this.currentLine, this.currentTick, this.currentSubtick, "Mouse can't be read. Probably a missing comma: %s", line);
                }
                scrollwheel = this.parseInt("scrollwheel", functions[0]);
                cursorX = this.deserialiseRelativeInt("cursorX", functions[1], previousCursorX);
                cursorY = this.deserialiseRelativeInt("cursorY", functions[2], previousCursorY);
            } else {
                throw new PlaybackLoadException(this.currentLine, this.currentTick, this.currentSubtick, "Mouse is missing a semicolon");
            }
            out.updateFromState(keycodes, scrollwheel, cursorX, cursorY);
            previousCursorX = cursorX;
            previousCursorY = cursorY;
            ++this.currentSubtick;
        }
        return out;
    }

    protected VirtualCameraAngle deserialiseCameraAngle(List<String> cameraAngleStrings) {
        VirtualCameraAngle out = new VirtualCameraAngle(null, null, false);
        this.currentSubtick = 0;
        Float previousYaw = this.previousInputContainer == null ? null : this.previousInputContainer.getCameraAngle().getYaw();
        Float previousPitch = this.previousInputContainer == null ? null : this.previousInputContainer.getCameraAngle().getPitch();
        for (String line : cameraAngleStrings) {
            Float cameraPitch;
            Float cameraYaw;
            Matcher matcher = this.extract("(.+?);(.+)", line);
            if (matcher.find()) {
                String cameraYawString = matcher.group(1);
                String cameraPitchString = matcher.group(2);
                cameraYaw = null;
                cameraPitch = null;
                if (!"null".equals(cameraYawString)) {
                    cameraYaw = this.deserialiseRelativeFloat("camera yaw", cameraYawString, previousYaw);
                }
                if (!"null".equals(cameraPitchString)) {
                    cameraPitch = this.deserialiseRelativeFloat("camera pitch", cameraPitchString, previousPitch);
                }
            } else {
                throw new PlaybackLoadException(this.currentLine, this.currentTick, this.currentSubtick, "Camera is missing a semicolon");
            }
            cameraYaw = this.unclampYaw(cameraYaw, previousYaw);
            out.updateFromState(cameraPitch, cameraYaw);
            previousYaw = cameraYaw;
            previousPitch = cameraPitch;
            ++this.currentSubtick;
        }
        return out;
    }

    protected Set<Integer> deserialiseVirtualKeyboardKey(String[] keyString) {
        HashSet<Integer> out = new HashSet<Integer>();
        for (int i = 0; i < keyString.length; ++i) {
            String key = keyString[i];
            Integer keycode = this.deserialiseVirtualKey(key, vkey -> {
                if (vkey < 0) {
                    throw new PlaybackLoadException(this.currentLine, this.currentTick, this.currentSubtick, "Keyboard section contains a mouse key: %s", new Object[]{VirtualKey.get(vkey)});
                }
            });
            if (out.contains(keycode)) {
                throw new PlaybackLoadException(this.currentLine, this.currentTick, this.currentSubtick, "Keyboard has a duplicate key press");
            }
            if (keycode == null) continue;
            out.add(keycode);
        }
        return out;
    }

    protected Set<Integer> deserialiseVirtualMouseKey(String[] keyString) {
        HashSet<Integer> out = new HashSet<Integer>();
        for (int i = 0; i < keyString.length; ++i) {
            String key = keyString[i];
            Integer keycode = this.deserialiseVirtualKey(key, vkey -> {
                if (vkey >= 0) {
                    throw new PlaybackLoadException(this.currentLine, this.currentTick, this.currentSubtick, "Mouse section contains a keyboard key: %s", new Object[]{VirtualKey.get(vkey)});
                }
            });
            if (out.contains(keycode)) {
                throw new PlaybackLoadException(this.currentLine, this.currentTick, this.currentSubtick, "Mouse has a duplicate key press");
            }
            if (keycode == null) continue;
            out.add(keycode);
        }
        return out;
    }

    protected Integer deserialiseVirtualKey(String key, WrongKeyCheck keyValidator) {
        Integer vkey = null;
        if (key.isEmpty()) {
            return null;
        }
        vkey = this.isNumeric(key) ? Integer.valueOf(Integer.parseInt(key)) : VirtualKey.getKeycode(key);
        if (vkey == null) {
            throw new PlaybackLoadException(this.currentLine, this.currentTick, this.currentSubtick, "The keycode %s does not exist", key);
        }
        keyValidator.checkKey(vkey);
        return vkey;
    }

    protected int parseInt(String name, String intstring) {
        try {
            return Integer.parseInt(intstring);
        }
        catch (NumberFormatException e) {
            throw new PlaybackLoadException(this.currentLine, this.currentTick, this.currentSubtick, e, "The %s could not be processed. This should be a number: %s", name, intstring);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int deserialiseRelativeInt(String name, String intstring, Integer previous) {
        int out = 0;
        if (!intstring.startsWith("~")) return this.parseInt(name, intstring);
        intstring = intstring.replace("~", "");
        int relative = this.parseInt(name, intstring);
        if (previous == null) throw new PlaybackLoadException(this.currentLine, this.currentTick, this.currentSubtick, "Can't process relative value ~%s in %s. Previous value for comparing is not available", intstring, name);
        return previous + relative;
    }

    protected float parseFloat(String name, String floatstring) {
        try {
            return Float.parseFloat(floatstring);
        }
        catch (NumberFormatException e) {
            throw new PlaybackLoadException(this.currentLine, this.currentTick, this.currentSubtick, e, "The %s could not be processed. This should be a decimal number: %s", name, floatstring);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Float deserialiseRelativeFloat(String name, String floatstring, Float previous) {
        if (floatstring == null) {
            return null;
        }
        float out = 0.0f;
        if (floatstring.startsWith("~")) {
            floatstring = floatstring.replace("~", "");
            float relative = this.parseFloat(name, floatstring);
            if (previous == null) throw new PlaybackLoadException(this.currentLine, this.currentTick, this.currentSubtick, "Can't process relative value ~%s in %s. Previous value for comparing is not available", floatstring, name);
            out = previous.floatValue() + relative;
            return Float.valueOf(out);
        } else {
            out = this.parseFloat(name, floatstring);
        }
        return Float.valueOf(out);
    }

    protected Matcher extract(String regex, String haystack) {
        Pattern pattern = Pattern.compile(regex, 8);
        Matcher matcher = pattern.matcher(haystack);
        return matcher;
    }

    protected String extract(String regex, String haystack, int group) {
        Matcher matcher = this.extract(regex, haystack);
        if (matcher.find()) {
            return matcher.group(group);
        }
        return null;
    }

    protected boolean contains(String regex, String haystack) {
        return this.extract(regex, haystack).find();
    }

    protected boolean isNumeric(String string) {
        return Pattern.matches("-?\\d+", string);
    }

    protected boolean isFloat(String string) {
        return Pattern.matches("-?\\d+(?:\\.\\d+)?", string);
    }

    public static String createCenteredHeading(String text, char spacingChar, int headingWidth) {
        if (text == null || text.isEmpty()) {
            return SerialiserFlavorBase.createPaddedString(spacingChar, headingWidth);
        }
        text = " " + text + " ";
        int spacingWidth = headingWidth - text.length();
        String paddingPre = SerialiserFlavorBase.createPaddedString(spacingChar, spacingWidth % 2 == 1 ? spacingWidth / 2 + 1 : spacingWidth / 2);
        String paddingSuf = SerialiserFlavorBase.createPaddedString(spacingChar, spacingWidth / 2);
        return String.format("%s%s%s", paddingPre, text, paddingSuf);
    }

    private static String createPaddedString(char spacingChar, int width) {
        char[] spacingLine = new char[width];
        for (int i = 0; i < spacingLine.length; ++i) {
            spacingLine[i] = spacingChar;
        }
        return new String(spacingLine);
    }

    protected <T> void pruneListEndNull(List<T> list) {
        ArrayList<T> copy = new ArrayList<T>(list);
        for (int i = copy.size() - 1; i >= 0; --i) {
            Object element = copy.get(i);
            if (element != null) {
                return;
            }
            list.remove(list.size() - 1);
        }
    }

    protected void pruneListEndEmpty(List<String> list) {
        ArrayList<String> copy = new ArrayList<String>(list);
        for (int i = copy.size() - 1; i >= 0; --i) {
            String element = (String)copy.get(i);
            if (!element.isEmpty()) {
                return;
            }
            list.remove(list.size() - 1);
        }
    }

    protected <T extends Subtickable<T>> void pruneListEndEmptySubtickable(List<T> list) {
        ArrayList<T> copy = new ArrayList<T>(list);
        for (int i = copy.size() - 1; i >= 0; --i) {
            Subtickable element = (Subtickable)copy.get(i);
            if (!element.isEmpty()) {
                return;
            }
            list.remove(list.size() - 1);
        }
    }

    protected Float clampYaw(Float yaw) {
        if (yaw == null) {
            return yaw;
        }
        while (yaw.floatValue() >= 180.0f) {
            yaw = Float.valueOf(yaw.floatValue() - 360.0f);
        }
        while (yaw.floatValue() < -180.0f) {
            yaw = Float.valueOf(yaw.floatValue() + 360.0f);
        }
        return yaw;
    }

    protected Float unclampYaw(Float yaw, Float previous) {
        if (previous == null || yaw == null) {
            return yaw;
        }
        float clampedPrevious = this.clampYaw(previous).floatValue();
        if (clampedPrevious >= 0.0f && clampedPrevious - yaw.floatValue() > 180.0f) {
            ++this.yawRotations;
        }
        if (clampedPrevious < 0.0f && clampedPrevious - yaw.floatValue() < -180.0f) {
            --this.yawRotations;
        }
        return Float.valueOf(yaw.floatValue() + (float)(360 * this.yawRotations));
    }

    public void setProcessExtensions(boolean processExtensions) {
        this.processExtensions = processExtensions;
    }

    public long getCurrentTick() {
        return this.currentTick;
    }

    public Integer getCurrentSubtick() {
        return this.currentSubtick;
    }

    public String toString() {
        return this.getExtensionName();
    }

    public abstract SerialiserFlavorBase clone();

    public boolean equals(Object obj) {
        if (obj instanceof SerialiserFlavorBase) {
            SerialiserFlavorBase flavor = (SerialiserFlavorBase)obj;
            return this.getExtensionName().equals(flavor.getExtensionName());
        }
        return super.equals(obj);
    }

    protected static enum ExtractPhases {
        COMMENTS,
        TICK,
        SUBTICK,
        NONE;

    }

    @FunctionalInterface
    protected static interface WrongKeyCheck {
        public void checkKey(int var1) throws PlaybackLoadException;
    }
}

