/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.playback.tasfile.flavor.builtin;

import com.dselent.bigarraylist.BigArrayList;
import com.minecrafttas.tasmod.playback.PlaybackControllerClient;
import com.minecrafttas.tasmod.playback.filecommands.PlaybackFileCommand;
import com.minecrafttas.tasmod.playback.metadata.PlaybackMetadata;
import com.minecrafttas.tasmod.playback.metadata.builtin.CreditsMetadataExtension;
import com.minecrafttas.tasmod.playback.metadata.builtin.StartpositionMetadataExtension;
import com.minecrafttas.tasmod.playback.tasfile.exception.PlaybackLoadException;
import com.minecrafttas.tasmod.playback.tasfile.flavor.SerialiserFlavorBase;
import com.minecrafttas.tasmod.registries.TASmodAPIRegistry;
import com.minecrafttas.tasmod.virtual.VirtualCameraAngle;
import com.minecrafttas.tasmod.virtual.VirtualKey;
import com.minecrafttas.tasmod.virtual.VirtualKeyboard;
import com.minecrafttas.tasmod.virtual.VirtualMouse;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;

public class AlphaFlavor
extends SerialiserFlavorBase {
    @Override
    public String getExtensionName() {
        return "alpha";
    }

    @Override
    public SerialiserFlavorBase clone() {
        return new AlphaFlavor();
    }

    @Override
    protected String headerStart() {
        return "################################################# TASFile ###################################################\n";
    }

    @Override
    public List<String> serialiseHeader() {
        ArrayList<String> out = new ArrayList<String>();
        out.add(this.headerStart() + "#\t\t\t\t\t\t\t\t\t\t\t\tVersion:1\t\t\t\t\t\t\t\t\t\t\t\t\t#\n#\t\t\t\t\t\t\tThis file was generated using the Minecraft TASMod\t\t\t\t\t\t\t\t#\n#\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t#\n#\t\t\tAny errors while reading this file will be printed out in the console and the chat\t\t\t\t#\n#\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t#");
        this.serialiseMetadata(out);
        out.add(this.headerEnd());
        out.add("#Comments start with \"//\" at the start of the line, comments with # will not be saved");
        return out;
    }

    @Override
    protected String headerEnd() {
        return "#############################################################################################################";
    }

    @Override
    protected void serialiseMetadata(List<String> out) {
        if (!this.processExtensions) {
            return;
        }
        List<PlaybackMetadata> metadataList = TASmodAPIRegistry.PLAYBACK_METADATA.handleOnStore();
        PlaybackMetadata credits = null;
        PlaybackMetadata startPosition = null;
        for (PlaybackMetadata metadata : metadataList) {
            String name = metadata.getExtensionName();
            if (name.equals("Credits")) {
                credits = metadata;
                continue;
            }
            if (!name.equals("Start Position")) continue;
            startPosition = metadata;
        }
        out.add("#------------------------------------------------ Header ---------------------------------------------------#\n#Author:" + credits.getValue((Object)CreditsMetadataExtension.CreditFields.Author) + "\n#\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t#\n#Title:" + credits.getValue((Object)CreditsMetadataExtension.CreditFields.Title) + "\n#\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t#\n#Playing Time:" + credits.getValue((Object)CreditsMetadataExtension.CreditFields.PlayTime) + "\n#\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t#\n#Rerecords:" + credits.getValue((Object)CreditsMetadataExtension.CreditFields.Rerecords) + "\n#\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t#\n#----------------------------------------------- Settings --------------------------------------------------#\n#StartPosition:" + this.processStartPosition(startPosition) + "\n#\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t#\n#StartSeed:" + 0);
    }

    protected String processStartPosition(PlaybackMetadata startPosition) {
        LinkedHashMap<String, String> data = startPosition.getData();
        return String.join((CharSequence)",", data.values());
    }

    @Override
    public boolean checkFlavorName(List<String> headerLines) {
        for (String line : headerLines) {
            Matcher matcher = this.extract("^#.*Version:1", line);
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected List<String> serialiseKeyboard(VirtualKeyboard keyboard) {
        ArrayList<String> out = new ArrayList<String>();
        List<String> stringy = keyboard.getCurrentPresses();
        String keyString = "";
        if (!stringy.isEmpty()) {
            String seperator = ",";
            for (int i = 0; i < stringy.size(); ++i) {
                if (i == stringy.size() - 1) {
                    seperator = "";
                }
                if (stringy.get(i).equals("ZERO")) continue;
                keyString = keyString.concat(stringy.get(i) + seperator);
            }
        }
        List<Character> charList = keyboard.getCharList();
        String charString = "";
        if (!charList.isEmpty()) {
            for (int i = 0; i < charList.size(); ++i) {
                charString = charString.concat(Character.toString(charList.get(i).charValue()));
            }
            charString = charString.replace("\r", "\\n");
            charString = charString.replace("\n", "\\n");
        }
        out.add("Keyboard:" + keyString + ";" + charString);
        return out;
    }

    @Override
    protected List<String> serialiseMouse(VirtualMouse mouse) {
        ArrayList<String> out = new ArrayList<String>();
        List<String> stringy = mouse.getCurrentPresses();
        String keyString = "";
        if (!stringy.isEmpty()) {
            String seperator = ",";
            for (int i = 0; i < stringy.size(); ++i) {
                if (i == stringy.size() - 1) {
                    seperator = "";
                }
                if (stringy.get(i).equals("MOUSEMOVED")) continue;
                keyString = keyString.concat(stringy.get(i) + seperator);
            }
        }
        ArrayList path = new ArrayList(mouse.getAll());
        String pathString = "";
        if (!path.isEmpty()) {
            String seperator = "->";
            for (int i = 0; i < path.size(); ++i) {
                if (i == path.size() - 1) {
                    seperator = "";
                }
                VirtualMouse singlePath = (VirtualMouse)path.get(i);
                pathString = pathString.concat("[" + this.serialisePath(singlePath) + "]" + seperator);
            }
        }
        out.add("Mouse:" + keyString + ";" + pathString);
        return out;
    }

    protected String serialisePath(VirtualMouse path) {
        String keyString = "";
        ArrayList strings = new ArrayList();
        path.getPressedKeys().forEach(virtualkeys -> strings.add(VirtualKey.getName(virtualkeys)));
        if (!strings.isEmpty()) {
            String seperator = ",";
            for (int i = 0; i < strings.size(); ++i) {
                if (i == strings.size() - 1) {
                    seperator = "";
                }
                keyString = keyString.concat((String)strings.get(i) + seperator);
            }
        }
        if (keyString.isEmpty()) {
            return "MOUSEMOVED," + path.getScrollWheel() + "," + path.getCursorX() + "," + path.getCursorY();
        }
        return keyString + "," + path.getScrollWheel() + "," + path.getCursorX() + "," + path.getCursorY();
    }

    @Override
    protected List<String> serialiseCameraAngle(VirtualCameraAngle subticks) {
        ArrayList<String> out = new ArrayList<String>();
        float pitch = subticks.getPitch() == null ? 0.0f : subticks.getPitch().floatValue();
        float yaw = subticks.getYaw() == null ? 0.0f : subticks.getYaw().floatValue();
        out.add("Camera:" + pitch + ";" + yaw);
        return out;
    }

    @Override
    protected String serialiseFileCommandsInline(PlaybackFileCommand.FileCommandsInCommentList fileCommands) {
        if (fileCommands == null) {
            return null;
        }
        ArrayList<String> serialisedCommands = new ArrayList<String>();
        for (PlaybackFileCommand command : fileCommands) {
            if ("hud".equals(command.getName())) {
                serialisedCommands.add(String.format("$hud %s", command.getArgs()[0].equals("true") ? "on" : "off"));
            }
            if (!"label".equals(command.getName())) continue;
            serialisedCommands.add(String.format("$info %s", command.getArgs().length == 0 ? "off" : String.join((CharSequence)" ", command.getArgs())));
        }
        return String.join((CharSequence)" ", serialisedCommands);
    }

    @Override
    protected String serialiseFileCommandsEndline(PlaybackFileCommand.FileCommandsInCommentList fileCommands) {
        if (fileCommands == null) {
            return null;
        }
        ArrayList<String> serialisedCommands = new ArrayList<String>();
        for (PlaybackFileCommand command : fileCommands) {
            if (!"desyncMonitor".equals(command.getName())) continue;
            serialisedCommands.add(String.format("Monitoring:%s 0", String.join((CharSequence)" ", command.getArgs())));
        }
        return String.join((CharSequence)" ", serialisedCommands);
    }

    @Override
    protected String serialiseInlineComment(String comment) {
        return String.format("//%s", comment);
    }

    @Override
    protected String serialiseEndlineComment(String comment) {
        return String.format("//%s", comment);
    }

    @Override
    protected String mergeInput(long currentTick, String keyboard, String mouse, String cameraAngle, String endLineComment) {
        return String.format("%s|%s|%s|%s~&\t\t%s", currentTick, keyboard, mouse, cameraAngle, endLineComment);
    }

    @Override
    protected void deserialiseMetadata(List<String> headerLines) {
        String author = "Insert author here";
        String title = "Insert TAS category here";
        String playtime = "00:00.0";
        String rerecords = "0";
        String startLocation = "";
        for (String line : headerLines) {
            if (line.startsWith("#Author:")) {
                author = line.split(":")[1];
                continue;
            }
            if (line.startsWith("#Title:")) {
                title = line.split(":")[1];
                continue;
            }
            if (line.startsWith("#Playing Time:")) {
                playtime = line.split("Playing Time:")[1];
                continue;
            }
            if (line.startsWith("#Rerecords:")) {
                rerecords = line.split(":")[1];
                continue;
            }
            if (!line.startsWith("#StartPosition:")) continue;
            startLocation = line.replace("#StartPosition:", "");
        }
        PlaybackMetadata creditsMetada = new PlaybackMetadata("Credits");
        creditsMetada.setValue((Object)CreditsMetadataExtension.CreditFields.Author, author);
        creditsMetada.setValue((Object)CreditsMetadataExtension.CreditFields.Title, title);
        creditsMetada.setValue((Object)CreditsMetadataExtension.CreditFields.PlayTime, playtime);
        creditsMetada.setValue((Object)CreditsMetadataExtension.CreditFields.Rerecords, rerecords);
        PlaybackMetadata startPositionMetadata = new PlaybackMetadata("Start Position");
        String[] split = startLocation.split(",");
        startPositionMetadata.setValue((Object)StartpositionMetadataExtension.StartPositionFields.X, split[0]);
        startPositionMetadata.setValue((Object)StartpositionMetadataExtension.StartPositionFields.Y, split[1]);
        startPositionMetadata.setValue((Object)StartpositionMetadataExtension.StartPositionFields.Z, split[2]);
        startPositionMetadata.setValue((Object)StartpositionMetadataExtension.StartPositionFields.Pitch, split[3]);
        startPositionMetadata.setValue((Object)StartpositionMetadataExtension.StartPositionFields.Yaw, split[4]);
        ArrayList<PlaybackMetadata> metadataList = new ArrayList<PlaybackMetadata>();
        metadataList.add(creditsMetada);
        metadataList.add(startPositionMetadata);
        TASmodAPIRegistry.PLAYBACK_METADATA.handleOnLoad(metadataList);
    }

    @Override
    protected String splitTickLineRegex() {
        return "^\\d+\\|(.*?)\\|(.*?)\\|(\\S*)~&";
    }

    @Override
    protected String deserialiseFileCommandsInline(String comment, PlaybackFileCommand.FileCommandsInCommentList deserialisedFileCommands) {
        Matcher matcher = this.extract("\\$(.+?) (.+?)", comment);
        while (matcher.find()) {
            String name = matcher.group(1);
            String[] args = matcher.group(2).split(" ");
            if ("hud".equals(name)) {
                args[0] = "on".equals(args[0]) ? "true" : "false";
            } else if ("info".equals(name)) {
                name = "label";
                String string = args[0] = "off".equals(args[0]) ? "" : args[0];
            }
            if (this.processExtensions) {
                deserialisedFileCommands.add(new PlaybackFileCommand(name, args));
            }
            comment = matcher.replaceFirst("");
            matcher.reset(comment);
        }
        return comment;
    }

    @Override
    protected String deserialiseFileCommandsEndline(String comment, PlaybackFileCommand.FileCommandsInCommentList deserialisedFileCommands) {
        Matcher matcher = this.extract("Monitoring:(.+)", comment);
        while (matcher.find()) {
            String name = "desyncMonitor";
            String[] args = matcher.group(1).split(" ");
            String[] shortenedArgs = new String[6];
            for (int i = 0; i < 6; ++i) {
                shortenedArgs[i] = args[i];
            }
            if (this.processExtensions) {
                deserialisedFileCommands.add(new PlaybackFileCommand(name, shortenedArgs));
            }
            comment = matcher.replaceFirst("");
            matcher.reset(comment);
        }
        return comment;
    }

    @Override
    protected VirtualKeyboard deserialiseKeyboard(List<String> keyboardStrings) {
        VirtualKeyboard out = new VirtualKeyboard();
        this.currentSubtick = 0;
        for (String line : keyboardStrings) {
            Matcher matcher = this.extract("Keyboard:(.*?);(.*)", line);
            if (!matcher.find()) {
                throw new PlaybackLoadException(this.currentLine, this.currentTick, this.currentSubtick, "Keyboard could not be read. Probably a missing semicolon: %s", line);
            }
            String[] keys = matcher.group(1).split(",");
            char[] chars = matcher.group(2).toCharArray();
            Set<Integer> keycodes = this.deserialiseVirtualKeyboardKey(keys);
            out.updateFromState(keycodes, chars);
            ++this.currentSubtick;
        }
        return out;
    }

    @Override
    public BigArrayList<PlaybackControllerClient.InputContainer> deserialise(BigArrayList<String> lines, long startPos) {
        BigArrayList<PlaybackControllerClient.InputContainer> out = new BigArrayList<PlaybackControllerClient.InputContainer>();
        for (long i = startPos; i < lines.size(); ++i) {
            if (lines.get(i).startsWith("#")) continue;
            ArrayList<String> container = new ArrayList<String>();
            this.currentLine = i = this.extractContainer(container, lines, i);
            this.deserialiseContainer(out, container);
            ++this.currentTick;
        }
        this.previousInputContainer = null;
        return out;
    }

    @Override
    protected VirtualMouse deserialiseMouse(List<String> mouseStrings) {
        String section = mouseStrings.get(0);
        VirtualMouse mouse = new VirtualMouse();
        section = section.replace("Mouse:", "");
        String buttons = section.split(";")[0];
        String path = section.split(";")[1];
        if (!buttons.isEmpty()) {
            String[] splitButtons = buttons.split(",");
            Set<Integer> keycodes = this.deserialiseVirtualMouseKey(splitButtons);
            mouse.updateFromState(keycodes, 0, 0, 0);
        }
        this.readPath(path, mouse);
        return mouse;
    }

    protected void readPath(String section, VirtualMouse mouse) {
        String[] pathNodes;
        section = section.replace("[", "").replace("]", "");
        for (String pathNode : pathNodes = section.split("->")) {
            String[] split = pathNode.split(",");
            int length = split.length;
            int scrollWheel = 0;
            int cursorX = 0;
            int cursorY = 0;
            try {
                scrollWheel = Integer.parseInt(split[length - 3]);
                cursorX = Integer.parseInt(split[length - 2]);
                cursorY = Integer.parseInt(split[length - 1]);
            }
            catch (NumberFormatException e) {
                throw new PlaybackLoadException("'" + pathNode + "' couldn't be read in line " + this.currentLine + ": Something is not a number");
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new PlaybackLoadException("'" + pathNode + "' couldn't be read in line " + this.currentLine + ": Something is missing or is too much");
            }
            HashSet<Integer> keyList = new HashSet<Integer>();
            for (int i = 0; i < length - 3; ++i) {
                String key = split[i];
                Integer keyCode = VirtualKey.getKeycode(key);
                if (keyCode == null) {
                    throw new PlaybackLoadException(this.currentLine, this.currentTick, this.currentSubtick, "Could not find keycode");
                }
                keyList.add(keyCode);
            }
            mouse.updateFromState(keyList, scrollWheel, cursorX, cursorY);
        }
    }

    @Override
    protected VirtualCameraAngle deserialiseCameraAngle(List<String> cameraAngleStrings) {
        VirtualCameraAngle out = new VirtualCameraAngle();
        this.currentSubtick = 0;
        Float previousPitch = this.previousInputContainer == null ? null : this.previousInputContainer.getCameraAngle().getPitch();
        Float previousYaw = this.previousInputContainer == null ? null : this.previousInputContainer.getCameraAngle().getYaw();
        for (String line : cameraAngleStrings) {
            Float cameraPitch;
            Float cameraYaw;
            Matcher matcher = this.extract("Camera:(.+?);(.+)", line);
            if (matcher.find()) {
                String cameraYawString = matcher.group(2);
                String cameraPitchString = matcher.group(1);
                cameraYaw = null;
                cameraPitch = null;
                if (!"null".equals(cameraYawString)) {
                    cameraYaw = this.deserialiseRelativeFloat("camera yaw", cameraYawString, previousYaw);
                }
                if (!"null".equals(cameraPitchString)) {
                    cameraPitch = this.deserialiseRelativeFloat("camera pitch", cameraPitchString, previousPitch);
                }
            } else {
                throw new PlaybackLoadException(this.currentLine, this.currentTick, this.currentSubtick, "Camera is missing a semicolon");
            }
            out.updateFromState(cameraPitch, cameraYaw);
            ++this.currentSubtick;
        }
        return out;
    }

    @Override
    protected void deserialiseEnabledFileCommandNames(List<String> headerLines) {
        TASmodAPIRegistry.PLAYBACK_FILE_COMMAND.setEnabled("tasmod_label@v1", "tasmod_desyncMonitor@v1", "tasmod_options@v1");
    }
}

