/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.savestates;

import com.dselent.bigarraylist.BigArrayList;
import com.minecrafttas.mctcommon.events.EventListenerRegistry;
import com.minecrafttas.mctcommon.networking.Client;
import com.minecrafttas.mctcommon.networking.exception.PacketNotImplementedException;
import com.minecrafttas.mctcommon.networking.exception.WrongSideException;
import com.minecrafttas.mctcommon.networking.interfaces.ClientPacketHandler;
import com.minecrafttas.mctcommon.networking.interfaces.PacketID;
import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.TASmodClient;
import com.minecrafttas.tasmod.events.EventSavestate;
import com.minecrafttas.tasmod.networking.TASmodBufferBuilder;
import com.minecrafttas.tasmod.playback.PlaybackControllerClient;
import com.minecrafttas.tasmod.playback.tasfile.PlaybackSerialiser;
import com.minecrafttas.tasmod.registries.TASmodAPIRegistry;
import com.minecrafttas.tasmod.registries.TASmodPackets;
import com.minecrafttas.tasmod.savestates.exceptions.SavestateException;
import com.minecrafttas.tasmod.util.Ducks;
import com.minecrafttas.tasmod.util.LoggerMarkers;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1196;
import net.minecraft.class_1600;
import net.minecraft.class_1982;
import net.minecraft.class_1989;
import net.minecraft.class_476;
import net.minecraft.class_518;
import net.minecraft.class_837;
import net.minecraft.class_864;

public class SavestateHandlerClient
implements ClientPacketHandler,
EventSavestate.EventClientCompleteLoadstate,
EventSavestate.EventClientLoadPlayer {
    public static final Path clientSavestateDirectory = TASmodClient.tasfiledirectory.resolve("savestates");

    @Override
    public void onClientLoadPlayer(class_518 player) {
        TASmod.LOGGER.trace(LoggerMarkers.Savestate, "Keep player {} in loaded entity list", (Object)player.method_2518());
        class_1600.method_2965().field_3803.field_4542.remove(player);
    }

    @Override
    public void onClientLoadstateComplete() {
        class_518 player = class_1600.method_2965().field_10310;
        TASmod.LOGGER.trace(LoggerMarkers.Savestate, "Add player {} to loaded entity list", (Object)player.method_2518());
        int i = class_837.method_2345((double)(player.field_3252 / 16.0));
        int j = class_837.method_2345((double)(player.field_3254 / 16.0));
        class_1196 chunk = class_1600.method_2965().field_3803.method_3688(i, j);
        for (int k = 0; k < chunk.method_9162().length; ++k) {
            if (!chunk.method_9162()[k].contains((Object)player)) continue;
            return;
        }
        chunk.method_3887((class_864)player);
    }

    public static void savestate(String nameOfSavestate) throws SavestateException, IOException {
        PlaybackControllerClient container;
        TASmod.LOGGER.debug(LoggerMarkers.Savestate, "Saving client savestate {}", (Object)nameOfSavestate);
        if (nameOfSavestate.isEmpty()) {
            TASmod.LOGGER.error(LoggerMarkers.Savestate, "No recording savestate loaded since the name of savestate is empty");
            return;
        }
        Path targetfile = clientSavestateDirectory.resolve(nameOfSavestate + ".mctas").normalize();
        if (!targetfile.startsWith(clientSavestateDirectory)) {
            TASmod.LOGGER.error("Could not create client savestate: Savestate won't be saved in savestate folder {}", (Object)targetfile);
            return;
        }
        Path targetParentDir = targetfile.getParent();
        if (!Files.exists(targetParentDir, new LinkOption[0])) {
            Files.createDirectories(targetParentDir, new FileAttribute[0]);
        }
        if ((container = TASmodClient.controller).isRecording()) {
            PlaybackSerialiser.saveToFile(targetfile, container, "");
        } else if (container.isPlayingback()) {
            PlaybackSerialiser.saveToFile(targetfile, container, "", container.index());
        }
    }

    public static void loadstate(String nameOfSavestate) throws Exception {
        TASmod.LOGGER.debug(LoggerMarkers.Savestate, "Loading client savestate {}", (Object)nameOfSavestate);
        if (nameOfSavestate.isEmpty()) {
            TASmod.LOGGER.error(LoggerMarkers.Savestate, "No recording savestate loaded since the name of savestate is empty");
            return;
        }
        Path targetfile = clientSavestateDirectory.resolve(nameOfSavestate + ".mctas").normalize();
        if (!targetfile.startsWith(clientSavestateDirectory)) {
            TASmod.LOGGER.error("Could not load client savestate: Savestate won't be saved in savestate folder {}", (Object)targetfile);
            return;
        }
        PlaybackControllerClient controller = TASmodClient.controller;
        PlaybackControllerClient.TASstate state = controller.getState();
        if (state == PlaybackControllerClient.TASstate.NONE) {
            TASmodClient.tickSchedulerClient.add(() -> EventListenerRegistry.fireEvent(EventSavestate.EventClientCompleteLoadstate.class));
            return;
        }
        if (state == PlaybackControllerClient.TASstate.PAUSED) {
            state = controller.getStateAfterPause();
        }
        if (!Files.exists(targetfile, new LinkOption[0])) {
            controller.setTASStateClient(PlaybackControllerClient.TASstate.NONE, false);
            class_1600.method_2965().field_10310.method_5505((class_1982)new class_1989(ChatFormatting.YELLOW + "Inputs could not be loaded for this savestate,"));
            class_1600.method_2965().field_10310.method_5505((class_1982)new class_1989(ChatFormatting.YELLOW + "since the file doesn't exist. Stopping!"));
            TASmod.LOGGER.warn(LoggerMarkers.Savestate, "Inputs could not be loaded for this savestate, since the file doesn't exist.");
            return;
        }
        BigArrayList<PlaybackControllerClient.InputContainer> savestateContainerList = PlaybackSerialiser.loadFromFile(targetfile, state != PlaybackControllerClient.TASstate.PLAYBACK);
        if (state == PlaybackControllerClient.TASstate.RECORDING) {
            long index = savestateContainerList.size() - 1L;
            SavestateHandlerClient.preload(savestateContainerList, index);
            controller.setInputs(savestateContainerList, index);
            TASmodClient.virtual.clearNext();
        } else if (state == PlaybackControllerClient.TASstate.PLAYBACK) {
            if ((long)controller.size() >= savestateContainerList.size()) {
                long index = savestateContainerList.size();
                SavestateHandlerClient.preload(controller.getInputs(), index);
                controller.setIndex(index);
                TASmodClient.virtual.clearNext();
            } else {
                long index = savestateContainerList.size() - 1L;
                SavestateHandlerClient.preload(savestateContainerList, index);
                controller.setInputs(savestateContainerList, index);
            }
        }
        TASmodClient.tickSchedulerClient.add(() -> EventListenerRegistry.fireEvent(EventSavestate.EventClientCompleteLoadstate.class));
    }

    private static void preload(BigArrayList<PlaybackControllerClient.InputContainer> containerList, long index) {
        TASmod.LOGGER.trace(LoggerMarkers.Savestate, "Preloading container at index {}", (Object)index);
        PlaybackControllerClient.InputContainer containerToPreload = containerList.get(index);
        TASmodClient.virtual.preloadInput(containerToPreload.getKeyboard(), containerToPreload.getMouse(), containerToPreload.getCameraAngle());
        TASmodAPIRegistry.PLAYBACK_FILE_COMMAND.onPlaybackTick(index, containerToPreload);
    }

    @Environment(value=EnvType.CLIENT)
    public static void unloadAllClientChunks() {
        TASmod.LOGGER.trace(LoggerMarkers.Savestate, "Unloading All Client Chunks");
        class_1600 mc = class_1600.method_2965();
        class_476 chunkProvider = mc.field_3803.method_12239();
        ((Ducks.ChunkProviderDuck)chunkProvider).unloadAllChunks();
        mc.field_3804.method_1363();
        ((Ducks.WorldClientDuck)mc.field_3803).clearEntityList();
    }

    @Override
    public PacketID[] getAcceptedPacketIDs() {
        return new TASmodPackets[]{TASmodPackets.SAVESTATE_SAVE, TASmodPackets.SAVESTATE_LOAD};
    }

    @Override
    public void onClientPacket(PacketID id, ByteBuffer buf, String username) throws PacketNotImplementedException, WrongSideException, Exception {
        TASmodPackets packet = (TASmodPackets)id;
        class_1600 mc = class_1600.method_2965();
        switch (packet) {
            case SAVESTATE_SAVE: {
                String savestateName = TASmodBufferBuilder.readString(buf);
                mc.method_6635(() -> {
                    try {
                        SavestateHandlerClient.savestate(savestateName);
                    }
                    catch (SavestateException e) {
                        TASmod.LOGGER.error(e.getMessage());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
                break;
            }
            case SAVESTATE_LOAD: {
                String loadstateName = TASmodBufferBuilder.readString(buf);
                mc.method_6635(() -> {
                    try {
                        SavestateHandlerClient.loadstate(loadstateName);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
                break;
            }
            default: {
                throw new PacketNotImplementedException(packet, this.getClass(), Client.Side.CLIENT);
            }
        }
    }
}

