/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.savestates;

import com.minecrafttas.mctcommon.events.EventListenerRegistry;
import com.minecrafttas.mctcommon.networking.Client;
import com.minecrafttas.mctcommon.networking.exception.PacketNotImplementedException;
import com.minecrafttas.mctcommon.networking.exception.WrongSideException;
import com.minecrafttas.mctcommon.networking.interfaces.PacketID;
import com.minecrafttas.mctcommon.networking.interfaces.ServerPacketHandler;
import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.commands.CommandSavestate;
import com.minecrafttas.tasmod.events.EventSavestate;
import com.minecrafttas.tasmod.mixin.savestates.AccessorAnvilChunkLoader;
import com.minecrafttas.tasmod.mixin.savestates.AccessorChunkLoader;
import com.minecrafttas.tasmod.networking.TASmodBufferBuilder;
import com.minecrafttas.tasmod.registries.TASmodPackets;
import com.minecrafttas.tasmod.savestates.SavestateIndexer;
import com.minecrafttas.tasmod.savestates.exceptions.LoadstateException;
import com.minecrafttas.tasmod.savestates.exceptions.SavestateDeleteException;
import com.minecrafttas.tasmod.savestates.exceptions.SavestateException;
import com.minecrafttas.tasmod.savestates.handlers.SavestatePlayerHandlerServer;
import com.minecrafttas.tasmod.savestates.handlers.SavestateResourcePackHandler;
import com.minecrafttas.tasmod.savestates.handlers.SavestateTempHandler;
import com.minecrafttas.tasmod.savestates.handlers.SavestateWorldHandler;
import com.minecrafttas.tasmod.util.Component;
import com.minecrafttas.tasmod.util.LoggerMarkers;
import com.minecrafttas.tasmod.util.Scheduler;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1061;
import net.minecraft.class_1150;
import net.minecraft.class_1205;
import net.minecraft.class_1442;
import net.minecraft.class_322;
import net.minecraft.class_743;
import net.minecraft.class_795;
import net.minecraft.class_798;
import net.minecraft.class_864;
import net.minecraft.class_988;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.Logger;

public class SavestateHandlerServer
implements ServerPacketHandler {
    private final MinecraftServer server;
    private SavestateState state = SavestateState.NONE;
    private SavestateIndexer indexer;
    private final SavestatePlayerHandlerServer playerHandler;
    private final SavestateWorldHandler worldHandler;
    private final SavestateTempHandler tempSavestateHandler;
    private final Logger logger;

    public SavestateHandlerServer(MinecraftServer server, Logger logger) {
        this.server = server;
        this.logger = logger;
        this.playerHandler = new SavestatePlayerHandlerServer(server);
        this.worldHandler = new SavestateWorldHandler(server);
        this.tempSavestateHandler = new SavestateTempHandler(this, logger);
        this.createIndexer(server);
    }

    public void saveState(SavestateCallback cb, SavestateFlags ... flags) throws SavestateException {
        this.saveState(-1, null, cb, flags);
    }

    public void saveState(int index, SavestateCallback cb, SavestateFlags ... flags) throws SavestateException {
        this.saveState(index, null, cb, flags);
    }

    public void saveState(String name, SavestateCallback cb, SavestateFlags ... flags) throws SavestateException {
        this.saveState(-1, name, cb, flags);
    }

    public void saveState(int index, String name, SavestateCallback cb, SavestateFlags ... flags) throws SavestateException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(LoggerMarkers.Savestate, "SAVING a savestate with index {}. Flags: ", (Object)index, (Object)Arrays.stream(flags).map(Enum::toString).collect(Collectors.joining(",")));
        } else {
            this.logger.debug(LoggerMarkers.Savestate, "Creating new savestate");
        }
        if (this.state == SavestateState.SAVING) {
            throw new SavestateException("A savestating operation is already being carried out");
        }
        if (this.state == SavestateState.LOADING) {
            throw new SavestateException("A loadstate operation is being carried out");
        }
        try {
            TASmod.server.sendToAll(new TASmodBufferBuilder(TASmodPackets.SAVESTATE_LOADING_SCREEN).writeEnum(SavestateState.SAVING));
        }
        catch (Exception e) {
            this.logger.catching((Throwable)e);
        }
        this.state = SavestateState.SAVING;
        this.logger.trace("Create new savestate index via indexer");
        SavestateIndexer.SavestatePaths paths = this.indexer.createSavestate(index, name, !SavestateFlags.BLOCK_CHANGE_INDEX.isBlocked(flags));
        if (paths.getSavestate().index == 0 && !ArrayUtils.contains((Object[])flags, (Object)((Object)SavestateFlags.BLOCK_CLIENT_SAVESTATE))) {
            flags = (SavestateFlags[])ArrayUtils.add((Object[])flags, (Object)((Object)SavestateFlags.BLOCK_CLIENT_SAVESTATE));
        }
        this.savestateInner(paths, cb, flags);
    }

    public void saveStateTemp(SavestateCallback cb) {
        if (this.state == SavestateState.SAVING) {
            throw new SavestateException("A savestating operation is already being carried out");
        }
        if (this.state == SavestateState.LOADING) {
            throw new SavestateException("A loadstate operation is being carried out");
        }
        this.state = SavestateState.SAVING;
        SavestateIndexer.SavestatePaths paths = this.indexer.createTempSavestate();
        SavestateFlags[] flags = new SavestateFlags[]{SavestateFlags.BLOCK_CLIENT_SAVESTATE, SavestateFlags.BLOCK_PAUSE_TICKRATE};
        this.savestateInner(paths, cb, flags);
        paths.getSavestate().save();
    }

    private void savestateInner(SavestateIndexer.SavestatePaths paths, SavestateCallback cb, SavestateFlags ... flags) {
        TASmod.tickratechanger.pauseGame(true);
        this.server.method_3004().method_2011();
        this.server.method_3001(false);
        Path sourceFolder = paths.getSourceFolder();
        Path targetFolder = paths.getTargetFolder();
        Integer indexToSave = paths.getSavestate().index;
        this.logger.debug("Source: {}, Target: {}", (Object)sourceFolder, (Object)targetFolder);
        EventListenerRegistry.fireEvent(EventSavestate.EventServerSavestate.class, this.server, paths);
        if (Files.exists(targetFolder, new LinkOption[0])) {
            if (indexToSave != null) {
                this.logger.warn(LoggerMarkers.Savestate, "WARNING! Overwriting the savestate with the index {}", (Object)indexToSave);
            }
            SavestateHandlerServer.deleteFolder(targetFolder);
        }
        if (!SavestateFlags.BLOCK_CLIENT_SAVESTATE.isBlocked(flags)) {
            class_795[] folder = paths.getSavestate().folder;
            Path savestateDir = folder.getParent().getParent();
            Path relativeFolder = savestateDir.relativize((Path)folder);
            try {
                TASmod.server.sendToAll(new TASmodBufferBuilder(TASmodPackets.SAVESTATE_SAVE).writeString(relativeFolder.toString()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (class_795 world : this.server.field_3850) {
            class_1205 chunkloader = (class_1205)((AccessorChunkLoader)world.method_12782()).getChunkLoader();
            while (((AccessorAnvilChunkLoader)chunkloader).getChunksToSave().size() > 0) {
            }
        }
        SavestateHandlerServer.copyFolder(sourceFolder, targetFolder);
        if (SavestateFlags.BLOCK_PAUSE_TICKRATE.isBlocked(flags)) {
            TASmod.tickratechanger.pauseGame(false);
        } else {
            try {
                TASmod.server.sendToAll(new TASmodBufferBuilder(TASmodPackets.TICKRATE_0_WARN));
            }
            catch (Exception e) {
                this.logger.catching((Throwable)e);
            }
        }
        if (cb != null) {
            cb.invoke(paths);
        }
        this.state = SavestateState.NONE;
    }

    public void loadState(SavestateCallback cb, SavestateFlags ... flags) throws LoadstateException {
        this.loadState(-1, cb, flags);
    }

    public void loadState(int index, SavestateCallback cb, SavestateFlags ... flags) throws LoadstateException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(LoggerMarkers.Savestate, "LOADING a savestate with index {}, ", (Object)index, (Object)Arrays.stream(flags).map(Enum::toString).collect(Collectors.joining(",")));
        } else {
            this.logger.debug(LoggerMarkers.Savestate, "Loading a savestate");
        }
        if (this.state == SavestateState.SAVING) {
            throw new LoadstateException("A savestating operation is already being carried out");
        }
        if (this.state == SavestateState.LOADING) {
            throw new LoadstateException("A loadstate operation is being carried out");
        }
        this.state = SavestateState.LOADING;
        try {
            TASmod.server.sendToAll(new TASmodBufferBuilder(TASmodPackets.SAVESTATE_LOADING_SCREEN).writeEnum(SavestateState.LOADING));
        }
        catch (Exception e) {
            this.logger.catching((Throwable)e);
        }
        this.logger.trace(LoggerMarkers.Savestate, "Load savestate index via indexer");
        SavestateIndexer.SavestatePaths paths = this.indexer.loadSavestate(index, !SavestateFlags.BLOCK_CHANGE_INDEX.isBlocked(flags));
        this.logger.debug(LoggerMarkers.Savestate, "Source: {}, Target: {}", (Object)paths.getSourceFolder(), (Object)paths.getTargetFolder());
        if (paths.getSavestate().index == 0 && !ArrayUtils.contains((Object[])flags, (Object)((Object)SavestateFlags.BLOCK_CLIENT_SAVESTATE))) {
            flags = (SavestateFlags[])ArrayUtils.add((Object[])flags, (Object)((Object)SavestateFlags.BLOCK_CLIENT_SAVESTATE));
        }
        this.loadStateInner(paths, cb, flags);
    }

    public void loadStateTemp(SavestateCallback cb) {
        if (this.state == SavestateState.SAVING) {
            throw new LoadstateException("A savestating operation is already being carried out");
        }
        if (this.state == SavestateState.LOADING) {
            throw new LoadstateException("A loadstate operation is being carried out");
        }
        this.state = SavestateState.LOADING;
        SavestateIndexer.SavestatePaths paths = this.indexer.loadTempSavestate();
        if (paths == null) {
            return;
        }
        SavestateFlags[] flags = new SavestateFlags[]{SavestateFlags.BLOCK_CLIENT_SAVESTATE, SavestateFlags.BLOCK_PAUSE_TICKRATE};
        this.loadStateInner(paths, cb, flags);
        paths.getSavestate().save();
    }

    private void loadStateInner(SavestateIndexer.SavestatePaths paths, SavestateCallback cb, SavestateFlags ... flags) {
        TASmod.tickratechanger.pauseGame(true);
        String worldname = this.server.method_2028();
        Path sourcefolder = paths.getSourceFolder();
        Path targetfolder = paths.getTargetFolder();
        EventListenerRegistry.fireEvent(EventSavestate.EventServerLoadstate.class, this.server, paths);
        if (!SavestateFlags.BLOCK_CLIENT_SAVESTATE.isBlocked(flags)) {
            Path folder = paths.getSavestate().folder;
            Path savestateDir = folder.getParent().getParent();
            Path relativeFolder = savestateDir.relativize(folder);
            try {
                TASmod.server.sendToAll(new TASmodBufferBuilder(TASmodPackets.SAVESTATE_LOAD).writeString(relativeFolder.toString()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.worldHandler.disableLevelSaving();
        try {
            TASmod.server.sendToAll(new TASmodBufferBuilder(TASmodPackets.SAVESTATE_UNLOAD_CHUNKS));
        }
        catch (Exception e) {
            this.logger.catching((Throwable)e);
        }
        this.worldHandler.disconnectPlayersFromChunkMap();
        this.worldHandler.unloadAllServerChunks();
        this.worldHandler.flushSaveHandler();
        SavestateHandlerServer.deleteFolder(targetfolder);
        SavestateHandlerServer.copyFolder(sourcefolder, targetfolder);
        this.playerHandler.clearScoreboard();
        this.worldHandler.loadAllWorlds(worldname);
        this.playerHandler.loadAndSendMotionToPlayer();
        this.worldHandler.addPlayersToChunkMap();
        this.worldHandler.enableLevelSaving();
        SavestateResourcePackHandler.refreshServerResourcepack(this.server);
        this.worldHandler.addPlayersToServerChunks();
        this.worldHandler.sendChunksToClient();
        if (SavestateFlags.BLOCK_PAUSE_TICKRATE.isBlocked(flags)) {
            TASmod.tickratechanger.pauseGame(false);
        } else {
            try {
                TASmod.server.sendToAll(new TASmodBufferBuilder(TASmodPackets.TICKRATE_0_WARN));
            }
            catch (Exception e) {
                this.logger.catching((Throwable)e);
            }
        }
        if (cb != null) {
            cb.invoke(paths);
        }
        this.state = SavestateState.NONE;
        TASmod.tickSchedulerServer.add(() -> {
            EventListenerRegistry.fireEvent(EventSavestate.EventServerCompleteLoadstate.class);
            this.onLoadstateComplete();
        });
    }

    private void createIndexer(MinecraftServer server) {
        Path dataDirectory;
        this.logger.trace(LoggerMarkers.Savestate, "Creating savestate indexer");
        Path savesDirectory = dataDirectory = server.method_3040().toPath();
        if (!server.method_2983()) {
            savesDirectory = dataDirectory.resolve("saves");
        }
        Path savestateBaseDirectory = savesDirectory.resolve("savestates");
        String worldname = server.method_2028();
        this.logger.debug("Created savestate handler with saves: {}, savestates: {}, worldname: {}", (Object)savesDirectory, (Object)savestateBaseDirectory, (Object)worldname);
        this.indexer = new SavestateIndexer(this.logger, savesDirectory, savestateBaseDirectory, worldname);
    }

    public void deleteSavestate(int index, SavestateCallback cb) throws SavestateDeleteException {
        this.logger.warn(LoggerMarkers.Savestate, "Deleting savestate {}", (Object)index);
        SavestateIndexer.SavestatePaths paths = this.indexer.deleteSavestate(index);
        if (cb != null) {
            cb.invoke(paths);
        }
    }

    public void deleteSavestate(int from, int to, SavestateCallback cb, SavestateIndexer.ErrorRunnable err) throws SavestateDeleteException {
        this.logger.warn(LoggerMarkers.Savestate, "Deleting multiple savestates from {} to {}", (Object)from, (Object)to);
        if (this.state == SavestateState.SAVING) {
            err.run(new SavestateDeleteException("msg.tasmod.savestate.save.error"));
            return;
        }
        if (this.state == SavestateState.LOADING) {
            err.run(new SavestateDeleteException("msg.tasmod.savestate.load.error"));
            return;
        }
        SavestateIndexer.DeletionRunnable onDelete = paths -> {
            SavestateIndexer.deleteFolder(paths.getTargetFolder());
            if (cb != null) {
                cb.invoke(paths);
            }
        };
        this.indexer.deleteMultipleSavestates(from, to, onDelete, err);
    }

    public void rename(int index, String name) throws SavestateException {
        this.rename(index, name, null);
    }

    public void renameCurrent(String name) throws SavestateException {
        this.indexer.renameCurrent(name);
    }

    public void rename(int index, String name, SavestateCallback cb) throws SavestateException {
        SavestateIndexer.SavestatePaths paths = this.indexer.renameSavestate(index, name);
        if (cb != null) {
            cb.invoke(paths);
        }
    }

    public void reload() {
        this.indexer.reload();
    }

    public void onLoadstateComplete() {
        this.logger.trace(LoggerMarkers.Savestate, "Running loadstate complete event");
        class_743 playerList = this.server.method_3004();
        for (class_798 player : playerList.method_10783()) {
            class_322 nbttagcompound = playerList.method_5294(player);
            this.playerHandler.reattachEntityToPlayer(nbttagcompound, (class_1150)player.method_2162(), (class_864)player);
        }
    }

    @Override
    public PacketID[] getAcceptedPacketIDs() {
        return new TASmodPackets[]{TASmodPackets.SAVESTATE_SAVE, TASmodPackets.SAVESTATE_LOAD};
    }

    @Override
    public void onServerPacket(PacketID id, ByteBuffer buf, String username) throws PacketNotImplementedException, WrongSideException, Exception {
        TASmodPackets packet = (TASmodPackets)id;
        class_798 player = this.server.method_3004().method_2010(username);
        switch (packet) {
            case SAVESTATE_SAVE: {
                int index = TASmodBufferBuilder.readInt(buf);
                SavestateCallback cb = paths -> {
                    try {
                        TASmod.server.sendTo((class_988)player, new TASmodBufferBuilder(TASmodPackets.SAVESTATE_RENAME_SCREEN).writeInt(paths.getSavestate().index));
                    }
                    catch (Exception e) {
                        TASmod.LOGGER.catching((Throwable)e);
                    }
                };
                Scheduler.Task savestateTask = () -> {
                    try {
                        this.saveState(index, cb, new SavestateFlags[0]);
                    }
                    catch (SavestateException e) {
                        TASmod.getServerInstance().method_12833().method_3004().method_6061(Component.translatable(e.getMessage()).withStyle(class_1442.field_5495).build());
                        try {
                            TASmod.server.sendToAll(new TASmodBufferBuilder(TASmodPackets.TICKRATE_0_WARN));
                            TASmod.server.sendToAll(new TASmodBufferBuilder(TASmodPackets.CLEAR_SCREEN));
                        }
                        catch (Exception e1) {
                            this.logger.catching((Throwable)e);
                        }
                        TASmod.LOGGER.error("Failed to create a savestate");
                        TASmod.LOGGER.catching((Throwable)e);
                    }
                    catch (Exception e) {
                        Throwable cause = e.getCause();
                        if (cause == null) {
                            cause = e;
                        }
                        TASmod.getServerInstance().method_3004().method_6061(Component.translatable("msg.tasmod.savestate.failure", e.getMessage()).withStyle(class_1442.field_5495).build());
                        try {
                            TASmod.server.sendToAll(new TASmodBufferBuilder(TASmodPackets.TICKRATE_0_WARN));
                            TASmod.server.sendToAll(new TASmodBufferBuilder(TASmodPackets.CLEAR_SCREEN));
                        }
                        catch (Exception e1) {
                            this.logger.catching((Throwable)e);
                        }
                        TASmod.LOGGER.error("Failed to create a savestate");
                        TASmod.LOGGER.catching((Throwable)e);
                    }
                    finally {
                        this.resetState();
                    }
                };
                if (TASmod.tickratechanger.ticksPerSecond != 0.0f) {
                    TASmod.tickSchedulerServer.add(savestateTask);
                    break;
                }
                TASmod.gameLoopSchedulerServer.add(savestateTask);
                break;
            }
            case SAVESTATE_LOAD: {
                int indexing = TASmodBufferBuilder.readInt(buf);
                SavestateCallback cb2 = CommandSavestate.createChatMessageCallback((class_1061)player, "msg.tasmod.savestate.load.end");
                Scheduler.Task loadstateTask = () -> {
                    try {
                        this.loadState(indexing, cb2, new SavestateFlags[0]);
                    }
                    catch (LoadstateException e) {
                        TASmod.getServerInstance().method_12833().method_3004().method_6061(Component.translatable(e.getMessage()).withStyle(class_1442.field_5495).build());
                        try {
                            TASmod.server.sendToAll(new TASmodBufferBuilder(TASmodPackets.TICKRATE_0_WARN));
                            TASmod.server.sendToAll(new TASmodBufferBuilder(TASmodPackets.CLEAR_SCREEN));
                        }
                        catch (Exception e1) {
                            this.logger.catching((Throwable)e);
                        }
                        TASmod.LOGGER.error("Failed to create a savestate: " + e.getMessage());
                    }
                    catch (Exception e) {
                        Throwable cause = e.getCause();
                        if (cause == null) {
                            cause = e;
                        }
                        TASmod.getServerInstance().method_12833().method_3004().method_6061(Component.translatable("msg.tasmod.savestate.failure", e.getMessage()).withStyle(class_1442.field_5495).build());
                        try {
                            TASmod.server.sendToAll(new TASmodBufferBuilder(TASmodPackets.TICKRATE_0_WARN));
                            TASmod.server.sendToAll(new TASmodBufferBuilder(TASmodPackets.CLEAR_SCREEN));
                        }
                        catch (Exception e1) {
                            this.logger.catching((Throwable)e);
                        }
                        TASmod.LOGGER.throwing((Throwable)e);
                    }
                    finally {
                        this.resetState();
                    }
                };
                TASmod.gameLoopSchedulerServer.add(loadstateTask);
                break;
            }
            default: {
                throw new PacketNotImplementedException(packet, this.getClass(), Client.Side.SERVER);
            }
        }
    }

    public static void copyFolder(Path src, Path dest) {
        try {
            Files.walk(src, new FileVisitOption[0]).forEach(s -> {
                try {
                    Path d = dest.resolve(src.relativize((Path)s));
                    if (Files.isDirectory(s, new LinkOption[0])) {
                        if (!Files.exists(d, new LinkOption[0])) {
                            Files.createDirectory(d, new FileAttribute[0]);
                        }
                        return;
                    }
                    Files.copy(s, d, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void deleteFolder(Path toDelete) {
        try {
            Files.walk(toDelete, new FileVisitOption[0]).forEach(s -> {
                if (toDelete.equals(s)) {
                    return;
                }
                if (Files.isDirectory(s, new LinkOption[0])) {
                    SavestateHandlerServer.deleteFolder(s);
                } else {
                    try {
                        Files.delete(s);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
            Files.delete(toDelete);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<SavestateIndexer.Savestate> getSavestateInfo() {
        return this.getSavestateInfo(-1, 10);
    }

    public List<SavestateIndexer.Savestate> getSavestateInfo(int center, int amount) {
        return this.indexer.getSavestateList(center, amount);
    }

    public int size() {
        return this.indexer.size();
    }

    public int getCurrentIndex() {
        return this.indexer.getCurrentIndex();
    }

    public Path getCurrentSavestateDir() {
        return this.indexer.getCurrentSavestateDir();
    }

    public void resetState() {
        this.state = SavestateState.NONE;
    }

    public SavestateState getState() {
        return this.state;
    }

    public SavestatePlayerHandlerServer getPlayerHandler() {
        return this.playerHandler;
    }

    public SavestateTempHandler getSavestateTemporaryHandler() {
        return this.tempSavestateHandler;
    }

    public static enum SavestateState {
        SAVING,
        LOADING,
        NONE;

    }

    @FunctionalInterface
    public static interface SavestateCallback {
        public void invoke(SavestateIndexer.SavestatePaths var1);
    }

    public static enum SavestateFlags {
        BLOCK_CHANGE_INDEX,
        BLOCK_CLIENT_SAVESTATE,
        BLOCK_PAUSE_TICKRATE;


        public boolean isBlocked(SavestateFlags[] flagList) {
            return Arrays.stream(flagList).anyMatch(this::equals);
        }
    }
}

