/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.savestates;

import com.minecrafttas.mctcommon.file.AbstractDataFile;
import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.savestates.exceptions.LoadstateException;
import com.minecrafttas.tasmod.savestates.exceptions.SavestateDeleteException;
import com.minecrafttas.tasmod.savestates.exceptions.SavestateException;
import com.minecrafttas.tasmod.savestates.files.SavestateDataFile;
import com.minecrafttas.tasmod.savestates.files.SavestateTrackerFile;
import com.minecrafttas.tasmod.util.I18n;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class SavestateIndexer {
    private final Logger logger;
    private Path savesDir;
    private final Path savestateBaseDirectory;
    private final String worldname;
    private final Path currentSavestateDir;
    private final LinkedHashMap<Integer, Savestate> savestateList;
    private Savestate currentSavestate;
    public static final Path savestateDataDir = Paths.get("tas", new String[0]);
    private static final Path savestateFilePath = savestateDataDir.resolve("savestate.json");
    private final SavestateTrackerFile trackerfile;

    public SavestateIndexer(Logger logger, Path savesDir, Path savestateBaseDirectory, String worldname) {
        this.logger = logger;
        this.savestateBaseDirectory = savestateBaseDirectory;
        this.savesDir = savesDir;
        this.worldname = worldname;
        this.currentSavestateDir = savestateBaseDirectory.resolve(String.format("%s-Savestates", worldname));
        this.trackerfile = new SavestateTrackerFile(this.currentSavestateDir.resolve(String.format(worldname + "-info.txt", new Object[0])));
        this.savestateList = new LinkedHashMap();
        this.createSavestateDir();
        Path savestateDat = savesDir.resolve(worldname).resolve(savestateFilePath);
        if (Files.exists(savestateDat, new LinkOption[0])) {
            this.currentSavestate = new Savestate(savestateDat, null);
            this.currentSavestate.load();
        } else {
            this.currentSavestate = new Savestate(savestateDat, 0, null, null, null);
        }
        this.reload();
    }

    private void createSavestateDir() {
        try {
            Files.createDirectories(this.currentSavestateDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            this.logger.catching((Throwable)e);
        }
    }

    public SavestatePaths createSavestate(int index) {
        return this.createSavestate(index, null, true);
    }

    public SavestatePaths createSavestate(int index, String name, boolean changeIndex) {
        this.logger.trace("Creating a savestate in indexer");
        index = this.getNextIndex(index);
        if (name == null) {
            name = "Savestate #" + index;
        }
        int savedIndex = index;
        this.currentSavestate.index = index;
        this.currentSavestate.name = name;
        this.currentSavestate.date = new Date();
        this.currentSavestate.save();
        if (!changeIndex) {
            this.currentSavestate.index = savedIndex;
        }
        Path sourceDir = this.savesDir.resolve(this.worldname);
        Path targetDir = this.currentSavestateDir.resolve(this.worldname + "-Savestate" + index);
        Savestate newSavestate = this.currentSavestate.clone(targetDir.resolve(savestateFilePath), targetDir);
        this.trackerfile.increaseSavestateCount();
        this.savestateList.put(index, newSavestate);
        this.sortSavestateList();
        return SavestatePaths.of(newSavestate.clone(), sourceDir, targetDir);
    }

    public SavestatePaths loadSavestate(int index, boolean changeIndex) throws LoadstateException {
        Savestate savestateToLoad;
        this.logger.trace("Loading a savestate in indexer");
        if (index < 0 && this.savestateList.containsKey(index = this.currentSavestate.getIndex().intValue())) {
            index = this.findLatestIndex(index);
        }
        if ((savestateToLoad = this.savestateList.get(index)) == null) {
            String translationKey = this.savestateList.size() == 0 ? "msg.tasmod.savestate.error.none" : "msg.tasmod.savestate.error.noexist";
            throw new LoadstateException(translationKey, index);
        }
        int savedIndex = this.currentSavestate.index;
        this.currentSavestate = savestateToLoad.clone(this.savesDir.resolve(this.worldname).resolve(savestateFilePath), this.savesDir.resolve(this.worldname));
        Path sourceDir = savestateToLoad.getFolder();
        Path targetDir = this.savesDir.resolve(this.worldname);
        if (sourceDir != null && !Files.exists(sourceDir, new LinkOption[0])) {
            Path missingFile = this.savesDir.relativize(sourceDir);
            throw new LoadstateException("msg.tasmod.savestate.error.filenoexist", missingFile);
        }
        SavestatePaths out = SavestatePaths.of(savestateToLoad.clone(), sourceDir, targetDir);
        this.trackerfile.increaseLoadstateCount();
        if (!changeIndex) {
            this.currentSavestate.index = savedIndex;
        }
        return out;
    }

    public SavestatePaths renameSavestate(int index, String name) throws SavestateException {
        Savestate savestateToRename = this.savestateList.get(index);
        if (savestateToRename == null) {
            throw new SavestateException(I18n.format("msg.tasmod.savestate.error.noexist", index));
        }
        if (savestateToRename instanceof FailedSavestate) {
            throw new SavestateException(I18n.format("msg.tasmod.savestate.rename.error", new Object[0]));
        }
        if (name.isEmpty()) {
            name = "Savestate #" + index;
        }
        savestateToRename.name = name;
        savestateToRename.save();
        return SavestatePaths.of(savestateToRename, null, null);
    }

    public void renameCurrent(String name) {
        this.currentSavestate.name = name;
        this.currentSavestate.save();
    }

    public SavestatePaths deleteSavestate(int index) throws SavestateDeleteException {
        this.logger.trace("Deleting savestate {}", (Object)index);
        if (index == 0) {
            throw new SavestateDeleteException("msg.tasmod.savestate.delete.error.zero");
        }
        if (!this.savestateList.containsKey(index)) {
            throw new SavestateDeleteException(I18n.format("msg.tasmod.savestate.error.noexist", index));
        }
        Savestate toDelete = this.savestateList.get(index);
        Path targetDir = toDelete.getFolder();
        SavestatePaths out = SavestatePaths.of(toDelete, null, targetDir);
        this.savestateList.remove(index);
        if (!this.savestateList.containsKey(this.currentSavestate.index)) {
            this.currentSavestate.index = this.findLatestIndex(this.currentSavestate.index);
        }
        return out;
    }

    public void deleteMultipleSavestates(int from, int to, DeletionRunnable onDelete, ErrorRunnable onError) {
        if (from >= to) {
            onError.run(new SavestateDeleteException("Can't delete amounts that are negative or 0"));
            return;
        }
        for (int i = from; i <= to; ++i) {
            try {
                onDelete.run(this.deleteSavestate(i));
                continue;
            }
            catch (Exception e) {
                if (onError == null) continue;
                onError.run(e);
            }
        }
    }

    private void sortSavestateList() {
        LinkedHashMap copy = new LinkedHashMap();
        this.savestateList.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> copy.put((Integer)entry.getKey(), (Savestate)entry.getValue()));
        this.savestateList.clear();
        this.savestateList.putAll(copy);
    }

    public void reload() {
        this.logger.trace("Reloading savestate indexes");
        this.savestateList.clear();
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                Stream<Path> stream = null;
                try {
                    stream = Files.list(SavestateIndexer.this.currentSavestateDir);
                }
                catch (IOException e) {
                    SavestateIndexer.this.logger.catching((Throwable)e);
                    return;
                }
                Set<Path> pathSet = stream.filter(file -> Files.isDirectory(file, new LinkOption[0])).filter(file -> file.getFileName().toString().startsWith(SavestateIndexer.this.worldname)).collect(Collectors.toSet());
                stream.close();
                Pattern backupIndexPattern = Pattern.compile("-Savestate(\\d+)$");
                pathSet.forEach(path -> {
                    Path savestateDat = path.resolve(savestateFilePath);
                    Savestate savestate = null;
                    if (Files.exists(savestateDat, new LinkOption[0])) {
                        savestate = new Savestate(savestateDat, (Path)path);
                        savestate.load();
                    } else if (Files.exists(path.resolve("tasmod/savestateData.txt"), new LinkOption[0])) {
                        Path tasmodDir = path.resolve("tasmod");
                        Path tasDir = tasmodDir.getParent().resolve(savestateDataDir);
                        SavestateIndexer.copyFolder(tasmodDir, tasDir);
                        SavestateIndexer.deleteFolder(tasmodDir);
                        Path legacyPath = tasDir.resolve("savestateData.txt");
                        SavestateDataFile dataFile = new SavestateDataFile(legacyPath);
                        dataFile.load();
                        int index = Integer.parseInt(dataFile.get(SavestateDataFile.DataValues.INDEX));
                        try {
                            Files.delete(legacyPath);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        savestate = new Savestate(savestateDat, index, "Savestate #" + index, null, (Path)path);
                        savestate.save();
                    } else {
                        String filename = path.getFileName().toString();
                        Matcher matcher = backupIndexPattern.matcher(filename);
                        int backupIndex = -1;
                        if (matcher.find()) {
                            backupIndex = Integer.parseInt(matcher.group(1));
                        }
                        SavestateIndexer.this.logger.warn("Savestate {} does not contain a valid savestate.json, skipping", (Object)backupIndex);
                        SavestateException error = new SavestateException("Savestate.json data file not found in " + SavestateIndexer.this.savestateBaseDirectory.relativize(savestateDat));
                        savestate = new FailedSavestate((Path)path, backupIndex, null, null, error);
                    }
                    if (savestate.index != null) {
                        SavestateIndexer.this.savestateList.put(savestate.getIndex(), savestate.clone());
                    }
                });
                SavestateIndexer.this.sortSavestateList();
                try {
                    ((SavestateIndexer)SavestateIndexer.this).currentSavestate.index = SavestateIndexer.this.findLatestIndex(((SavestateIndexer)SavestateIndexer.this).currentSavestate.index);
                }
                catch (Exception e) {
                    SavestateIndexer.this.logger.catching((Throwable)e);
                }
            }
        }, "Savestate Reload");
        t.run();
    }

    public Set<Integer> getIndexList() {
        return this.savestateList.keySet();
    }

    public List<Savestate> getSavestateList() {
        return this.getSavestateList(this.currentSavestate.index);
    }

    public List<Savestate> getSavestateList(int center) {
        return this.getSavestateList(center, 10);
    }

    public List<Savestate> getSavestateList(int center, int amount) {
        LinkedList<Savestate> out = new LinkedList<Savestate>();
        if (center < 0) {
            this.savestateList.forEach((key, value) -> out.add((Savestate)value));
            return out;
        }
        LinkedHashMap<Integer, Savestate> copy = new LinkedHashMap<Integer, Savestate>(this.savestateList);
        int delta = amount / 2;
        for (int i = center - delta; i <= center + delta; ++i) {
            Savestate entry = copy.get(i);
            if (entry == null) continue;
            out.add(entry);
        }
        return out;
    }

    public int size() {
        return this.savestateList.size();
    }

    public int findLatestIndex(int start) {
        if (this.savestateList.containsKey(start)) {
            return start;
        }
        for (int i = start; i >= 0; --i) {
            if (!this.savestateList.containsKey(i) || this.savestateList.get(i) instanceof FailedSavestate) continue;
            return i;
        }
        return 0;
    }

    public Savestate getCurrentSavestate() {
        return this.currentSavestate;
    }

    public int getCurrentIndex() {
        return this.getCurrentSavestate().index;
    }

    public static void copyFolder(Path src, Path dest) {
        try {
            Files.walk(src, new FileVisitOption[0]).forEach(s -> {
                try {
                    Path d = dest.resolve(src.relativize((Path)s));
                    if (Files.isDirectory(s, new LinkOption[0])) {
                        if (!Files.exists(d, new LinkOption[0])) {
                            Files.createDirectory(d, new FileAttribute[0]);
                        }
                        return;
                    }
                    Files.copy(s, d, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void deleteFolder(Path toDelete) {
        try {
            Files.walk(toDelete, new FileVisitOption[0]).forEach(s -> {
                if (toDelete.equals(s)) {
                    return;
                }
                if (Files.isDirectory(s, new LinkOption[0])) {
                    SavestateIndexer.deleteFolder(s);
                } else {
                    try {
                        Files.delete(s);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
            Files.delete(toDelete);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Path getCurrentSavestateDir() {
        return this.currentSavestateDir;
    }

    public boolean exists(int index) {
        index = this.getNextIndex(index);
        return this.savestateList.containsKey(index);
    }

    public int getNextIndex(int index) {
        if (index < 0) {
            index = this.currentSavestate.getIndex() + 1;
        }
        return index;
    }

    public SavestatePaths createTempSavestate() {
        Path sourceDirectory = this.savesDir.resolve(this.worldname);
        Path targetDirectory = this.currentSavestateDir.resolve(this.worldname + "-SavestateTemp");
        Savestate tempSavestate = new Savestate(targetDirectory.resolve(savestateFilePath), null, "Temporary Savestate!", new Date(), targetDirectory);
        return SavestatePaths.of(tempSavestate, sourceDirectory, targetDirectory);
    }

    public SavestatePaths loadTempSavestate() {
        Path sourceDirectory = this.currentSavestateDir.resolve(this.worldname + "-SavestateTemp");
        if (!Files.exists(sourceDirectory, new LinkOption[0])) {
            return null;
        }
        Path targetDirectory = this.savesDir.resolve(this.worldname);
        return SavestatePaths.of(this.currentSavestate.clone(), sourceDirectory, targetDirectory);
    }

    public class Savestate
    extends AbstractDataFile {
        @Nullable
        protected Integer index;
        @Nullable
        protected String name;
        @Nullable
        protected Date date;
        protected Path folder;
        protected Logger logger;

        private Savestate(Path datFile, Path folder) {
            this(datFile, null, null, null, folder);
        }

        private Savestate(Path file, Integer index, String name, Date date, Path folder) {
            super(file, "Savestate", "Stores savestate related data");
            this.logger = TASmod.LOGGER;
            this.index = index;
            this.name = name;
            this.date = date;
            this.folder = folder;
        }

        private Savestate(Path file, Properties properties, Integer index, String name, Date date, Path folder) {
            this(file, index, name, date, folder);
            this.properties = properties;
        }

        public Integer getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public Date getDate() {
            return this.date;
        }

        public Path getFolder() {
            return this.folder;
        }

        @Override
        public void save() {
            if (this.index != null) {
                this.properties.setProperty(Options.INDEX.toString(), Integer.toString(this.index));
            }
            if (this.name != null) {
                this.properties.setProperty(Options.NAME.toString(), this.name);
            }
            if (this.date != null) {
                this.properties.setProperty(Options.DATE.toString(), Long.toString(ChronoUnit.SECONDS.between(Instant.EPOCH, this.date.toInstant())));
            }
            super.saveToJson();
        }

        @Override
        public void load() {
            super.loadFromJson();
            try {
                String loadedIndex = this.properties.getProperty(Options.INDEX.toString());
                if (loadedIndex != null) {
                    this.index = Integer.parseInt(loadedIndex);
                }
            }
            catch (Exception e) {
                this.logger.error("Can't parse '{}' in {}", (Object)Options.INDEX.toString(), (Object)SavestateIndexer.this.currentSavestateDir.resolve(savestateFilePath));
                this.logger.catching((Throwable)e);
            }
            this.name = this.properties.getProperty(Options.NAME.toString());
            try {
                String loadedDate = this.properties.getProperty(Options.DATE.toString());
                if (loadedDate != null) {
                    this.date = this.parseDate(loadedDate);
                }
            }
            catch (Exception e) {
                this.logger.error("Can't parse '{}' in {}", (Object)Options.DATE.toString(), (Object)SavestateIndexer.this.currentSavestateDir.resolve(savestateFilePath));
                this.logger.catching((Throwable)e);
            }
        }

        protected Savestate clone() {
            return new Savestate(this.file, this.properties, this.index, this.name, this.date, this.folder);
        }

        protected Savestate clone(Path newFile, Path newFolder) {
            return new Savestate(newFile, this.properties, this.index, this.name, this.date, newFolder);
        }

        private Date parseDate(String dateString) throws Exception {
            long unixTimestamp = Long.parseLong(dateString);
            return Date.from(Instant.ofEpochSecond(unixTimestamp));
        }
    }

    public static class SavestatePaths {
        private final Savestate savestate;
        private final Path sourceFolder;
        private final Path targetFolder;

        private SavestatePaths(Savestate savestate, Path sourceFolder, Path targetFolder) {
            this.savestate = savestate;
            this.sourceFolder = sourceFolder;
            this.targetFolder = targetFolder;
        }

        public Savestate getSavestate() {
            return this.savestate;
        }

        public Path getSourceFolder() {
            return this.sourceFolder;
        }

        public Path getTargetFolder() {
            return this.targetFolder;
        }

        public static SavestatePaths of(Savestate savestate, Path sourceFolder, Path targetFolder) {
            return new SavestatePaths(savestate, sourceFolder, targetFolder);
        }
    }

    public class FailedSavestate
    extends Savestate {
        private final Throwable t;

        public FailedSavestate(Path file, Throwable t) {
            this(file, null, null, null, t);
        }

        public FailedSavestate(Path file, Integer index, String name, Date date, Throwable t) {
            super(file, index, name, date, null);
            this.t = t;
        }

        public FailedSavestate(Path file, Properties properties, Integer index, String name, Date date, Throwable t) {
            super(file, index, name, date, null);
            this.t = t;
        }

        public Throwable getError() {
            return this.t;
        }

        @Override
        public void saveToJson() {
        }

        @Override
        public void save() {
        }

        @Override
        public void loadFromJson() {
        }

        @Override
        public void load() {
        }

        @Override
        protected FailedSavestate clone() {
            return new FailedSavestate(this.file, this.properties, this.index, this.name, this.date, this.t);
        }
    }

    @FunctionalInterface
    public static interface ErrorRunnable {
        public void run(Exception var1);
    }

    @FunctionalInterface
    public static interface DeletionRunnable {
        public void run(SavestatePaths var1);
    }

    private static enum Options {
        INDEX,
        NAME,
        DATE;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

