/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.savestates.files;

import com.minecrafttas.mctcommon.file.AbstractDataFile;
import com.minecrafttas.tasmod.TASmod;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class SavestateTrackerFile
extends AbstractDataFile {
    public SavestateTrackerFile(Path saveLocation) {
        super(saveLocation, "Savestate Tracker", "This file was generated by TASmod and diplays info about the usage of savestates");
        if (!Files.exists(saveLocation, new LinkOption[0])) {
            this.setSavestateCount(0);
            this.setLoadstateCount(0);
            this.save();
        } else {
            this.load();
        }
    }

    public int getSavestateCount() {
        this.load();
        return this.loadCount("Total Savestates");
    }

    private void setSavestateCount(int savestatecount) {
        this.setCount("Total Savestates", savestatecount);
    }

    public void increaseSavestateCount() {
        this.setSavestateCount(this.getSavestateCount() + 1);
        this.save();
    }

    public int getLoadstateCount() {
        this.load();
        return this.loadCount("Total Loadstates");
    }

    public void setLoadstateCount(int loadstatecount) {
        this.setCount("Total Loadstates", loadstatecount);
        this.save();
    }

    public void increaseLoadstateCount() {
        this.setLoadstateCount(this.getLoadstateCount() + 1);
    }

    private int loadCount(String key) {
        String value = this.properties.getProperty(key, "0");
        int count = 0;
        try {
            count = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            TASmod.LOGGER.error("The {} could not be read in {}. The value {} is not a number", (Object)key, (Object)this.name, (Object)e.getMessage());
        }
        return count;
    }

    private void setCount(String key, int count) {
        this.properties.setProperty(key, Integer.toString(count));
    }
}

