/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.savestates.handlers;

import com.minecrafttas.mctcommon.networking.Client;
import com.minecrafttas.mctcommon.networking.exception.PacketNotImplementedException;
import com.minecrafttas.mctcommon.networking.exception.WrongSideException;
import com.minecrafttas.mctcommon.networking.interfaces.ClientPacketHandler;
import com.minecrafttas.mctcommon.networking.interfaces.PacketID;
import com.minecrafttas.tasmod.TASmodClient;
import com.minecrafttas.tasmod.networking.TASmodBufferBuilder;
import com.minecrafttas.tasmod.registries.TASmodPackets;
import com.minecrafttas.tasmod.savestates.SavestateHandlerServer;
import com.minecrafttas.tasmod.savestates.gui.GuiSavestate;
import com.minecrafttas.tasmod.savestates.gui.GuiSavestateRename;
import com.minecrafttas.tasmod.util.Component;
import java.nio.ByteBuffer;
import net.minecraft.class_1442;
import net.minecraft.class_1600;
import net.minecraft.class_388;

public class SavestateGuiHandlerClient
implements ClientPacketHandler {
    @Override
    public PacketID[] getAcceptedPacketIDs() {
        return new PacketID[]{TASmodPackets.SAVESTATE_LOADING_SCREEN, TASmodPackets.SAVESTATE_RENAME_SCREEN};
    }

    @Override
    public void onClientPacket(PacketID id, ByteBuffer buf, String username) throws PacketNotImplementedException, WrongSideException, Exception {
        TASmodPackets packet = (TASmodPackets)id;
        class_1600 mc = class_1600.method_2965();
        switch (packet) {
            case SAVESTATE_LOADING_SCREEN: {
                SavestateHandlerServer.SavestateState state = TASmodBufferBuilder.readEnum(SavestateHandlerServer.SavestateState.class, buf);
                String msg = "";
                if (state == SavestateHandlerServer.SavestateState.SAVING) {
                    msg = "gui.tasmod.savestate.save.start";
                } else if (state == SavestateHandlerServer.SavestateState.LOADING) {
                    msg = "gui.tasmod.savestate.load.start";
                }
                mc.method_2928((class_388)new GuiSavestate(Component.translatable(msg).withStyle(class_1442.field_5497).build()));
                break;
            }
            case SAVESTATE_RENAME_SCREEN: {
                int index = TASmodBufferBuilder.readInt(buf);
                mc.method_2928(null);
                TASmodClient.tickSchedulerClient.add(() -> this.displayGuiRename(index));
                break;
            }
            default: {
                throw new PacketNotImplementedException(packet, Client.Side.CLIENT);
            }
        }
    }

    private void displayGuiRename(int index) {
        class_1600 mc = class_1600.method_2965();
        mc.method_2928((class_388)new GuiSavestateRename(Component.translatable("gui.tasmod.savestate.save.rename", Component.literal(Integer.toString(index)).withStyle(t -> t.method_7486(class_1442.field_5494))).withStyle(t -> t.method_7486(class_1442.field_5493)).build(), index));
    }
}

