/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.savestates.handlers;

import com.minecrafttas.mctcommon.events.EventListenerRegistry;
import com.minecrafttas.mctcommon.networking.exception.PacketNotImplementedException;
import com.minecrafttas.mctcommon.networking.exception.WrongSideException;
import com.minecrafttas.mctcommon.networking.interfaces.ClientPacketHandler;
import com.minecrafttas.mctcommon.networking.interfaces.PacketID;
import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.TASmodClient;
import com.minecrafttas.tasmod.events.EventSavestate;
import com.minecrafttas.tasmod.mixin.savestates.AccessorEntityLivingBase;
import com.minecrafttas.tasmod.networking.TASmodBufferBuilder;
import com.minecrafttas.tasmod.registries.TASmodPackets;
import com.minecrafttas.tasmod.util.Ducks;
import com.minecrafttas.tasmod.util.LoggerMarkers;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1157;
import net.minecraft.class_1600;
import net.minecraft.class_322;
import net.minecraft.class_518;

public class SavestatePlayerHandlerClient
implements ClientPacketHandler {
    public void loadPlayer(class_322 compound) {
        TASmod.LOGGER.trace(LoggerMarkers.Savestate, "Loading client player from NBT");
        class_1600 mc = class_1600.method_2965();
        class_518 player = mc.field_10310;
        ((AccessorEntityLivingBase)player).clearPotionEffects();
        double x = player.field_3255;
        double y = player.field_3256;
        double z = player.field_3257;
        float rx = player.field_16513;
        float ry = player.field_6781;
        float rz = player.field_6780;
        boolean sprinting = player.method_2514();
        float jumpVector = player.field_6760;
        player.method_2547(compound);
        player.field_3255 = x;
        player.field_3256 = y;
        player.field_3257 = z;
        player.field_16513 = rx;
        player.field_6781 = ry;
        player.field_6780 = rz;
        player.method_2529(sprinting);
        player.field_6760 = jumpVector;
        TASmod.LOGGER.trace(LoggerMarkers.Savestate, "Setting client gamemode");
        int gamemode = compound.method_824("playerGameType");
        class_1157 type = class_1157.method_3764((int)gamemode);
        mc.field_3800.method_1233(type);
        TASmodClient.virtual.CAMERA_ANGLE.setCamera(Float.valueOf(player.field_3193), Float.valueOf(player.field_3258));
        Ducks.SubtickDuck entityRenderer = (Ducks.SubtickDuck)class_1600.method_2965().field_3818;
        entityRenderer.runUpdate(0.0f);
        mc.field_3820.method_12167().method_12171();
        EventListenerRegistry.fireEvent(EventSavestate.EventClientLoadPlayer.class, player);
    }

    @Override
    public PacketID[] getAcceptedPacketIDs() {
        return new PacketID[]{TASmodPackets.SAVESTATE_PLAYER};
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void onClientPacket(PacketID id, ByteBuffer buf, String username) throws PacketNotImplementedException, WrongSideException, Exception {
        TASmodPackets packet = (TASmodPackets)id;
        switch (packet) {
            case SAVESTATE_PLAYER: {
                class_322 compound;
                try {
                    compound = TASmodBufferBuilder.readNBTTagCompound(buf);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    break;
                }
                class_1600.method_2965().method_6635(() -> this.loadPlayer(compound));
                break;
            }
        }
    }
}

