/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.savestates.handlers;

import com.minecrafttas.mctcommon.networking.ByteBufferBuilder;
import com.minecrafttas.mctcommon.networking.Client;
import com.minecrafttas.mctcommon.networking.exception.PacketNotImplementedException;
import com.minecrafttas.mctcommon.networking.exception.WrongSideException;
import com.minecrafttas.mctcommon.networking.interfaces.PacketID;
import com.minecrafttas.mctcommon.networking.interfaces.ServerPacketHandler;
import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.networking.TASmodBufferBuilder;
import com.minecrafttas.tasmod.registries.TASmodPackets;
import com.minecrafttas.tasmod.util.LoggerMarkers;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1150;
import net.minecraft.class_1205;
import net.minecraft.class_2036;
import net.minecraft.class_322;
import net.minecraft.class_700;
import net.minecraft.class_743;
import net.minecraft.class_795;
import net.minecraft.class_798;
import net.minecraft.class_864;
import net.minecraft.class_988;
import net.minecraft.server.MinecraftServer;

public class SavestatePlayerHandlerServer
implements ServerPacketHandler {
    private final MinecraftServer server;

    public SavestatePlayerHandlerServer(MinecraftServer server) {
        this.server = server;
    }

    public void reattachEntityToPlayer(class_322 nbttagcompound, class_1150 worldserver, class_864 playerIn) {
        if (nbttagcompound != null && nbttagcompound.method_7346("RootVehicle", 10)) {
            class_322 nbttagcompound1 = nbttagcompound.method_831("RootVehicle");
            class_864 entity1 = class_1205.method_11784((class_322)nbttagcompound1.method_831("Entity"), (class_1150)worldserver, (boolean)true);
            if (entity1 == null) {
                for (class_864 entity : worldserver.field_4541) {
                    if (!entity.method_6099().equals(nbttagcompound1.method_12586("Attach"))) continue;
                    entity1 = entity;
                }
            }
            if (entity1 != null) {
                UUID uuid = nbttagcompound1.method_12586("Attach");
                if (entity1.method_6099().equals(uuid)) {
                    playerIn.method_12975(entity1, true);
                } else {
                    for (class_864 entity : entity1.method_13001()) {
                        if (!entity.method_6099().equals(uuid)) continue;
                        playerIn.method_12975(entity, true);
                        break;
                    }
                }
                if (!playerIn.method_12980()) {
                    TASmod.LOGGER.warn("Couldn't reattach entity to player");
                    worldserver.method_3700(entity1);
                    for (class_864 entity2 : entity1.method_13001()) {
                        worldserver.method_3700(entity2);
                    }
                }
            }
        } else if (playerIn.method_12980()) {
            playerIn.method_13014();
        }
    }

    public void loadAndSendMotionToPlayer() {
        class_743 list = this.server.method_3004();
        List players = list.method_10783();
        for (class_798 player : players) {
            int dimensionFrom = player.field_5323;
            player.method_2504((class_1150)this.server.method_2991(dimensionFrom));
            class_322 nbttagcompound = this.server.method_3004().method_5294(player);
            if (nbttagcompound == null) continue;
            int dimensionTo = 0;
            if (nbttagcompound.method_820("Dimension")) {
                dimensionTo = nbttagcompound.method_824("Dimension");
            }
            if (dimensionTo != dimensionFrom) {
                this.changeDimensionDangerously(player, dimensionTo);
            } else {
                player.method_2162().field_4542.remove(player);
            }
            player.method_6119();
            player.method_2547(nbttagcompound);
            player.method_2504((class_1150)this.server.method_2991(player.field_5323));
            player.field_2825.method_2168((class_795)player.field_3248);
            TASmod.LOGGER.debug(LoggerMarkers.Savestate, "Sending motion to {}", (Object)player.method_2518());
            try {
                TASmod.server.sendTo((class_988)player, (ByteBufferBuilder)new TASmodBufferBuilder(TASmodPackets.SAVESTATE_PLAYER).writeNBTTagCompound(nbttagcompound));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void changeDimensionDangerously(class_798 player, int dimensionTo) {
        int dimensionFrom = player.field_5323;
        class_795 worldServerFrom = this.server.method_2991(dimensionFrom);
        player.field_2823.method_8166((class_700)new class_2036(dimensionTo, player.field_3248.method_8519(), player.field_3248.method_3588().method_236(), player.field_2825.method_2172()));
        worldServerFrom.method_3700((class_864)player);
        player.field_3204 = false;
    }

    public void clearScoreboard() {
        try {
            TASmod.server.sendToAll(new TASmodBufferBuilder(TASmodPackets.SAVESTATE_CLEAR_SCOREBOARD));
        }
        catch (Exception e) {
            TASmod.LOGGER.catching((Throwable)e);
        }
    }

    @Override
    public PacketID[] getAcceptedPacketIDs() {
        return new PacketID[]{TASmodPackets.SAVESTATE_PLAYER};
    }

    @Override
    public void onServerPacket(PacketID id, ByteBuffer buf, String username) throws PacketNotImplementedException, WrongSideException, Exception {
        TASmodPackets packet = (TASmodPackets)id;
        switch (packet) {
            case SAVESTATE_PLAYER: {
                throw new WrongSideException(packet, Client.Side.SERVER);
            }
        }
    }
}

