/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.savestates.handlers;

import com.minecrafttas.mctcommon.networking.ByteBufferBuilder;
import com.minecrafttas.mctcommon.networking.Client;
import com.minecrafttas.mctcommon.networking.exception.PacketNotImplementedException;
import com.minecrafttas.mctcommon.networking.exception.WrongSideException;
import com.minecrafttas.mctcommon.networking.interfaces.ClientPacketHandler;
import com.minecrafttas.mctcommon.networking.interfaces.PacketID;
import com.minecrafttas.mctcommon.networking.interfaces.ServerPacketHandler;
import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.TASmodClient;
import com.minecrafttas.tasmod.events.EventSavestate;
import com.minecrafttas.tasmod.networking.TASmodBufferBuilder;
import com.minecrafttas.tasmod.registries.TASmodPackets;
import com.minecrafttas.tasmod.savestates.SavestateIndexer;
import com.minecrafttas.tasmod.savestates.exceptions.SavestateException;
import com.minecrafttas.tasmod.savestates.gui.GuiResourcepackWarn;
import com.minecrafttas.tasmod.util.LoggerMarkers;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1600;
import net.minecraft.class_388;
import net.minecraft.server.MinecraftServer;

public class SavestateResourcePackHandler
implements EventSavestate.EventServerLoadstate,
ServerPacketHandler,
ClientPacketHandler {
    private CompletableFuture<String> serverRPFuture;
    public static CountDownLatch clientRPLatch;

    @Override
    public void onServerLoadstate(MinecraftServer server, SavestateIndexer.SavestatePaths paths) {
        if (server.method_2981().isEmpty() || server.method_2983()) {
            return;
        }
        String serverOwnerName = server.method_2974();
        try {
            TASmod.server.sendTo(serverOwnerName, (ByteBufferBuilder)new TASmodBufferBuilder(TASmodPackets.SAVESTATE_CLEAR_RESOURCEPACK));
        }
        catch (Exception e) {
            TASmod.LOGGER.catching((Throwable)e);
        }
        this.serverRPFuture = new CompletableFuture();
        String playername = null;
        try {
            playername = this.serverRPFuture.get(2L, TimeUnit.MINUTES);
        }
        catch (TimeoutException e) {
            throw new SavestateException(e, "Clearing resourcepacks %s timed out!", serverOwnerName);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new SavestateException(e, "Clearing resourcepacks %s", serverOwnerName);
        }
        server.method_10821("", "");
        TASmod.LOGGER.debug(LoggerMarkers.Savestate, "Cleared resourcepack for player {}", (Object)playername);
    }

    @Override
    public PacketID[] getAcceptedPacketIDs() {
        return new TASmodPackets[]{TASmodPackets.SAVESTATE_CLEAR_RESOURCEPACK};
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void onClientPacket(PacketID id, ByteBuffer buf, String username) throws PacketNotImplementedException, WrongSideException, Exception {
        TASmodPackets packetId = (TASmodPackets)id;
        class_1600 mc = class_1600.method_2965();
        switch (packetId) {
            case SAVESTATE_CLEAR_RESOURCEPACK: {
                TASmod.LOGGER.debug(LoggerMarkers.Savestate, "Clearing server resource pack");
                mc.method_2928((class_388)new GuiResourcepackWarn());
                clientRPLatch = new CountDownLatch(1);
                mc.method_5572().method_7040();
                try {
                    clientRPLatch.await(30L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                System.gc();
                try {
                    TASmodClient.client.send(new TASmodBufferBuilder(TASmodPackets.SAVESTATE_CLEAR_RESOURCEPACK));
                }
                catch (Exception e) {
                    TASmod.LOGGER.catching((Throwable)e);
                }
                break;
            }
            default: {
                throw new WrongSideException(packetId, Client.Side.CLIENT);
            }
        }
    }

    @Override
    public void onServerPacket(PacketID id, ByteBuffer buf, String username) throws PacketNotImplementedException, WrongSideException, Exception {
        TASmodPackets packetId = (TASmodPackets)id;
        switch (packetId) {
            case SAVESTATE_CLEAR_RESOURCEPACK: {
                this.serverRPFuture.complete(username);
                break;
            }
            default: {
                throw new WrongSideException(packetId, Client.Side.SERVER);
            }
        }
    }

    public static void refreshServerResourcepack(MinecraftServer server) {
        TASmod.LOGGER.debug(LoggerMarkers.Savestate, "Refreshing resourcepack");
        List players = server.method_3004().method_10783();
        players.forEach(player -> player.method_10761(server.method_2981(), server.method_10822()));
    }
}

