/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.savestates.handlers;

import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.events.EventPlaybackClient;
import com.minecrafttas.tasmod.events.EventPlaybackServer;
import com.minecrafttas.tasmod.networking.TASmodBufferBuilder;
import com.minecrafttas.tasmod.playback.PlaybackControllerClient;
import com.minecrafttas.tasmod.registries.TASmodPackets;
import com.minecrafttas.tasmod.savestates.SavestateHandlerServer;
import org.apache.logging.log4j.Logger;

public class SavestateTempHandler
implements EventPlaybackServer.EventControllerStateChange,
EventPlaybackClient.EventRecordClear {
    private final Logger logger;
    private final SavestateHandlerServer handler;
    private boolean createState = true;
    private boolean noSave = false;

    public SavestateTempHandler(SavestateHandlerServer handler, Logger logger) {
        this.logger = logger;
        this.handler = handler;
    }

    @Override
    public void onControllerStateChange(PlaybackControllerClient.TASstate newstate, PlaybackControllerClient.TASstate oldstate) {
        if (oldstate != PlaybackControllerClient.TASstate.NONE) {
            return;
        }
        if (this.noSave) {
            this.noSave = false;
            return;
        }
        if (newstate == PlaybackControllerClient.TASstate.RECORDING && this.createState) {
            this.logger.info("Creating temporary savestate");
            this.createState = false;
            this.handler.saveStateTemp(paths -> {
                try {
                    TASmod.server.sendToAll(new TASmodBufferBuilder(TASmodPackets.SAVESTATE_CLEAR_SCREEN));
                }
                catch (Exception e) {
                    this.logger.catching((Throwable)e);
                }
            });
        } else if (newstate == PlaybackControllerClient.TASstate.PLAYBACK) {
            this.logger.info("Loading temporary savestate");
            this.createState = false;
            this.handler.loadStateTemp(paths -> {
                try {
                    TASmod.server.sendToAll(new TASmodBufferBuilder(TASmodPackets.SAVESTATE_CLEAR_SCREEN));
                }
                catch (Exception e) {
                    this.logger.catching((Throwable)e);
                }
            });
        }
    }

    @Override
    public void onRecordingClear() {
        this.createState = true;
    }

    public void setNoSave(boolean noSave) {
        this.noSave = noSave;
    }
}

