/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.savestates.handlers;

import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.util.Ducks;
import com.minecrafttas.tasmod.util.LoggerMarkers;
import java.util.List;
import net.minecraft.class_100;
import net.minecraft.class_101;
import net.minecraft.class_1155;
import net.minecraft.class_1196;
import net.minecraft.class_1600;
import net.minecraft.class_789;
import net.minecraft.class_791;
import net.minecraft.class_792;
import net.minecraft.class_794;
import net.minecraft.class_795;
import net.minecraft.class_798;
import net.minecraft.class_837;
import net.minecraft.class_864;
import net.minecraft.class_98;
import net.minecraft.server.MinecraftServer;

public class SavestateWorldHandler {
    private final MinecraftServer server;

    public SavestateWorldHandler(MinecraftServer server) {
        this.server = server;
    }

    public void disableLevelSaving() {
        for (class_795 world : this.server.field_3850) {
            world.field_2822 = true;
        }
    }

    public void enableLevelSaving() {
        for (class_795 world : this.server.field_3850) {
            world.field_2822 = false;
        }
    }

    public void addPlayersToServerChunks() {
        this.server.method_3004().method_10783().forEach(player -> this.addPlayerToServerChunk((class_798)player));
    }

    public void addPlayerToServerChunk(class_798 player) {
        TASmod.LOGGER.trace(LoggerMarkers.Savestate, "Add player {} to server chunk", (Object)player.method_2518());
        int i = class_837.method_2345((double)(player.field_3252 / 16.0));
        int j = class_837.method_2345((double)(player.field_3254 / 16.0));
        class_795 world = player.method_2162();
        class_1196 chunk = world.method_3688(i, j);
        for (int k = 0; k < chunk.method_9162().length; ++k) {
            if (!chunk.method_9162()[k].contains((Object)player)) continue;
            return;
        }
        chunk.method_3887((class_864)player);
    }

    public void updateSessionLock() {
        class_795[] worlds;
        TASmod.LOGGER.trace(LoggerMarkers.Savestate, "Update the session lock");
        for (class_795 world : worlds = this.server.field_3850) {
            ((class_98)world.method_3587()).method_199();
        }
    }

    public void flushSaveHandler() {
        class_795[] worlds;
        TASmod.LOGGER.trace(LoggerMarkers.Savestate, "Flush the save handler");
        for (class_795 world : worlds = this.server.field_3850) {
            world.method_3587().method_239();
        }
    }

    public void addPlayersToChunkMap() {
        List players = this.server.method_3004().method_10783();
        class_795[] worlds = this.server.field_3850;
        block5: for (class_798 player : players) {
            TASmod.LOGGER.trace(LoggerMarkers.Savestate, "Add player {} to the chunk map", (Object)player.method_2518());
            switch (player.field_5323) {
                case -1: {
                    this.addPlayerToChunkMap(worlds[1], player);
                    continue block5;
                }
                case 0: {
                    this.addPlayerToChunkMap(worlds[0], player);
                    continue block5;
                }
                case 1: {
                    this.addPlayerToChunkMap(worlds[2], player);
                    continue block5;
                }
            }
            if (worlds.length <= player.field_5323) continue;
            this.addPlayerToChunkMap(worlds[player.field_5323 + 1], player);
        }
    }

    private void addPlayerToChunkMap(class_795 world, class_798 player) {
        int playerChunkPosX = (int)player.field_3252 >> 4;
        int playerChunkPosY = (int)player.field_3254 >> 4;
        class_792 playerChunkMap = world.method_2148();
        List<class_798> players = ((Ducks.PlayerChunkMapDuck)playerChunkMap).getPlayers();
        if (players.contains(player)) {
            TASmod.LOGGER.debug(LoggerMarkers.Savestate, "Not adding player {} to chunkmap, player already exists", (Object)player.method_2518());
        } else {
            playerChunkMap.method_2109(player);
        }
        world.method_12782().method_11766(playerChunkPosX, playerChunkPosY);
        world.method_3686((class_864)player);
    }

    public void disconnectPlayersFromChunkMap() {
        class_795[] worlds;
        List players = this.server.method_3004().method_10783();
        for (class_795 world : worlds = this.server.field_3850) {
            for (class_798 player : players) {
                TASmod.LOGGER.trace(LoggerMarkers.Savestate, "Disconnect player {} from the chunk map", (Object)player.method_2518());
                world.method_2148().method_2115(player);
            }
        }
    }

    public void unloadAllServerChunks() {
        class_795[] worlds;
        TASmod.LOGGER.trace(LoggerMarkers.Savestate, "Unloading all server chunks");
        for (class_795 world : worlds = this.server.field_3850) {
            class_794 chunkProvider = world.method_12782();
            ((Ducks.ChunkProviderDuck)chunkProvider).unloadAllChunks();
        }
    }

    public void sendChunksToClient() {
        class_795[] worlds;
        for (class_795 world : worlds = this.server.field_3850) {
            Ducks.PlayerChunkMapDuck chunkMap = (Ducks.PlayerChunkMapDuck)world.method_2148();
            chunkMap.forceTick();
        }
    }

    public void loadAllWorlds(String string) {
        this.server.method_3017(string);
        this.server.field_3850 = new class_795[3];
        this.server.field_3858 = new long[this.server.field_3850.length][100];
        class_101 iSaveHandler = this.server.method_2979().method_250(string, true);
        this.server.method_10813(this.server.method_2028(), iSaveHandler);
        class_100 worldInfo = iSaveHandler.method_245();
        if (worldInfo != null) {
            worldInfo.method_206(string);
        }
        for (int i = 0; i < this.server.field_3850.length; ++i) {
            int j = 0;
            if (i == 1) {
                j = -1;
            }
            if (i == 2) {
                j = 1;
            }
            this.server.field_3850[i] = i == 0 ? (class_795)new class_795(this.server, iSaveHandler, worldInfo, j, this.server.field_3849).method_8525() : (class_795)new class_789(this.server, iSaveHandler, j, this.server.field_3850[0], this.server.field_3849).method_8525();
            this.server.field_3850[i].method_3640((class_1155)new class_791(this.server, this.server.field_3850[i]));
        }
        this.server.method_3004().method_1993(this.server.field_3850);
        if (this.server.field_3850[0].method_3588().method_9339() == null) {
            this.server.method_8155(class_1600.method_2965().field_3823.field_7667);
        }
    }
}

