/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.savestates.storage;

import com.google.gson.JsonObject;
import com.minecrafttas.mctcommon.registry.AbstractRegistry;
import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.events.EventSavestate;
import com.minecrafttas.tasmod.savestates.SavestateIndexer;
import com.minecrafttas.tasmod.savestates.exceptions.LoadstateException;
import com.minecrafttas.tasmod.savestates.exceptions.SavestateException;
import com.minecrafttas.tasmod.savestates.storage.SavestateStorageExtensionBase;
import com.minecrafttas.tasmod.util.JsonUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import net.minecraft.server.MinecraftServer;

public class SavestateStorageExtensionRegistry
extends AbstractRegistry<SavestateStorageExtensionBase>
implements EventSavestate.EventServerSavestate,
EventSavestate.EventServerLoadstate {
    public SavestateStorageExtensionRegistry() {
        super("SAVESTATESTORAGE_REGISTRY", new LinkedHashMap());
    }

    @Override
    public void onServerSavestate(MinecraftServer server, SavestateIndexer.SavestatePaths paths) {
        Path storageDir = paths.getSourceFolder().resolve(SavestateIndexer.savestateDataDir);
        if (!Files.exists(storageDir, new LinkOption[0])) {
            try {
                Files.createDirectory(storageDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new SavestateException(e, "Can't create directory for savestate storage in savestate %s", paths.getSourceFolder().getFileName());
            }
        }
        for (SavestateStorageExtensionBase storage : this.REGISTRY.values()) {
            Path dataPath = storageDir.resolve(storage.fileName);
            JsonObject dataToSave = storage.onSavestate(server, new JsonObject());
            try {
                JsonUtils.saveJson(dataPath, dataToSave);
            }
            catch (IOException e) {
                throw new SavestateException(e, "Can't save %s from %s extension", storage.fileName, storage.getExtensionName());
            }
        }
    }

    @Override
    public void onServerLoadstate(MinecraftServer server, SavestateIndexer.SavestatePaths paths) {
        Path storageDir = paths.getTargetFolder().resolve(SavestateIndexer.savestateDataDir);
        if (!Files.exists(storageDir, new LinkOption[0])) {
            try {
                Files.createDirectory(storageDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new LoadstateException(e, "Can't create directory for savestate storage in savestate %s", paths.getTargetFolder().getFileName());
            }
        }
        for (SavestateStorageExtensionBase storage : this.REGISTRY.values()) {
            JsonObject loadedData;
            Path dataPath = storageDir.resolve(storage.fileName);
            if (!Files.exists(dataPath, new LinkOption[0])) {
                TASmod.LOGGER.warn("Could not load {} in {} extension", (Object)storage.fileName, (Object)storage.getExtensionName());
                return;
            }
            try {
                loadedData = JsonUtils.loadJson(dataPath);
            }
            catch (IOException e) {
                throw new LoadstateException(e, "Can't load %s in %s extension", storage.fileName, storage.getExtensionName());
            }
            storage.onLoadstate(server, loadedData);
        }
    }
}

