/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.savestates.storage.builtin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecrafttas.mctcommon.networking.ByteBufferBuilder;
import com.minecrafttas.mctcommon.networking.Client;
import com.minecrafttas.mctcommon.networking.exception.PacketNotImplementedException;
import com.minecrafttas.mctcommon.networking.exception.WrongSideException;
import com.minecrafttas.mctcommon.networking.interfaces.ClientPacketHandler;
import com.minecrafttas.mctcommon.networking.interfaces.PacketID;
import com.minecrafttas.mctcommon.networking.interfaces.ServerPacketHandler;
import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.TASmodClient;
import com.minecrafttas.tasmod.networking.TASmodBufferBuilder;
import com.minecrafttas.tasmod.registries.TASmodPackets;
import com.minecrafttas.tasmod.savestates.exceptions.SavestateException;
import com.minecrafttas.tasmod.savestates.storage.SavestateStorageExtensionBase;
import com.minecrafttas.tasmod.util.LoggerMarkers;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1600;
import net.minecraft.class_518;
import net.minecraft.class_743;
import net.minecraft.class_798;
import net.minecraft.class_988;
import net.minecraft.server.MinecraftServer;

public class ClientMotionStorage
extends SavestateStorageExtensionBase
implements ClientPacketHandler,
ServerPacketHandler {
    private final Map<class_798, CompletableFuture<MotionData>> futures = new HashMap<class_798, CompletableFuture<MotionData>>();

    public ClientMotionStorage() {
        super("clientMotion.json");
    }

    @Override
    public JsonObject onSavestate(MinecraftServer server, JsonObject dataToSave) {
        TASmod.LOGGER.trace(LoggerMarkers.Savestate, "Request motion from client");
        this.futures.clear();
        List playerList = server.method_3004().method_10783();
        playerList.forEach(player -> this.futures.put((class_798)player, new CompletableFuture()));
        try {
            TASmod.server.sendToAll(new TASmodBufferBuilder(TASmodPackets.SAVESTATE_REQUEST_MOTION));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.futures.forEach((player, future) -> {
            try {
                MotionData data = (MotionData)future.get(5L, TimeUnit.SECONDS);
                String uuid = player.method_6099().toString();
                if (player.method_2518().equals(server.method_2974())) {
                    uuid = "singleplayer";
                }
                dataToSave.add(uuid, this.json.toJsonTree((Object)data));
            }
            catch (TimeoutException e) {
                throw new SavestateException(e, "Writing client motion for %s timed out!", player.method_2518());
            }
            catch (InterruptedException | ExecutionException e) {
                throw new SavestateException(e, "Writing client motion for %s", player.method_2518());
            }
        });
        return dataToSave;
    }

    @Override
    public void onLoadstate(MinecraftServer server, JsonObject loadedData) {
        class_743 list = server.method_3004();
        for (Map.Entry motionDataJsonElement : loadedData.entrySet()) {
            class_798 player;
            String playerUUID = (String)motionDataJsonElement.getKey();
            MotionData motionData = (MotionData)this.json.fromJson((JsonElement)motionDataJsonElement.getValue(), MotionData.class);
            if (playerUUID.equals("singleplayer")) {
                String ownerName = server.method_2974();
                if (ownerName == null) continue;
                player = list.method_2010(ownerName);
            } else {
                player = list.method_10779(UUID.fromString(playerUUID));
            }
            if (player == null) continue;
            try {
                TASmod.server.sendTo((class_988)player, (ByteBufferBuilder)new TASmodBufferBuilder(TASmodPackets.SAVESTATE_SET_MOTION).writeMotionData(motionData));
            }
            catch (Exception e) {
                this.logger.catching((Throwable)e);
            }
        }
    }

    @Override
    public PacketID[] getAcceptedPacketIDs() {
        return new PacketID[]{TASmodPackets.SAVESTATE_REQUEST_MOTION, TASmodPackets.SAVESTATE_SET_MOTION};
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void onClientPacket(PacketID id, ByteBuffer buf, String username) throws PacketNotImplementedException, WrongSideException, Exception {
        TASmodPackets packet = (TASmodPackets)id;
        class_1600 mc = class_1600.method_2965();
        class_518 player = mc.field_10310;
        switch (packet) {
            case SAVESTATE_REQUEST_MOTION: {
                if (player == null) break;
                MotionData motionData = new MotionData(player.field_3255, player.field_3256, player.field_3257, player.field_16513, player.field_6781, player.field_6780, player.method_2514(), player.field_6760);
                TASmodClient.client.send(new TASmodBufferBuilder(TASmodPackets.SAVESTATE_REQUEST_MOTION).writeMotionData(motionData));
                break;
            }
            case SAVESTATE_SET_MOTION: {
                TASmod.LOGGER.trace(LoggerMarkers.Savestate, "Loading client motion");
                MotionData data = TASmodBufferBuilder.readMotionData(buf);
                player.field_3255 = data.motionX;
                player.field_3256 = data.motionY;
                player.field_3257 = data.motionZ;
                player.field_16513 = data.deltaX;
                player.field_6781 = data.deltaY;
                player.field_6780 = data.deltaZ;
                player.method_2529(data.sprinting);
                player.field_6760 = data.jumpMovementFactor;
                break;
            }
        }
    }

    @Override
    public void onServerPacket(PacketID id, ByteBuffer buf, String username) throws PacketNotImplementedException, WrongSideException, Exception {
        TASmodPackets packet = (TASmodPackets)id;
        class_798 player = TASmod.getServerInstance().method_3004().method_2010(username);
        switch (packet) {
            case SAVESTATE_REQUEST_MOTION: {
                MotionData data = TASmodBufferBuilder.readMotionData(buf);
                CompletableFuture<MotionData> future = this.futures.get(player);
                future.complete(data);
                break;
            }
            case SAVESTATE_SET_MOTION: {
                throw new WrongSideException(packet, Client.Side.SERVER);
            }
        }
    }

    @Override
    public String getExtensionName() {
        return "ClientMotionStorage";
    }

    public static class MotionData {
        private double motionX;
        private double motionY;
        private double motionZ;
        private float deltaX;
        private float deltaY;
        private float deltaZ;
        private boolean sprinting;
        private float jumpMovementFactor;

        public MotionData(double x, double y, double z, float rx, float ry, float rz, boolean sprinting, float jumpMovementVector) {
            this.motionX = x;
            this.motionY = y;
            this.motionZ = z;
            this.deltaX = rx;
            this.deltaY = ry;
            this.deltaZ = rz;
            this.sprinting = sprinting;
            this.jumpMovementFactor = jumpMovementVector;
        }

        public MotionData() {
            this(0.0, 0.0, 0.0, 0.0f, 0.0f, 0.0f, false, 0.0f);
        }

        public double getClientX() {
            return this.motionX;
        }

        public double getClientY() {
            return this.motionY;
        }

        public double getClientZ() {
            return this.motionZ;
        }

        public float getClientrX() {
            return this.deltaX;
        }

        public float getClientrY() {
            return this.deltaY;
        }

        public float getClientrZ() {
            return this.deltaZ;
        }

        public boolean isSprinting() {
            return this.sprinting;
        }

        public float getJumpMovementVector() {
            return this.jumpMovementFactor;
        }
    }
}

