/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.tickratechanger;

import com.minecrafttas.mctcommon.events.EventListenerRegistry;
import com.minecrafttas.mctcommon.networking.Client;
import com.minecrafttas.mctcommon.networking.exception.PacketNotImplementedException;
import com.minecrafttas.mctcommon.networking.exception.WrongSideException;
import com.minecrafttas.mctcommon.networking.interfaces.ClientPacketHandler;
import com.minecrafttas.mctcommon.networking.interfaces.PacketID;
import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.TASmodClient;
import com.minecrafttas.tasmod.events.EventTickratechanger;
import com.minecrafttas.tasmod.networking.TASmodBufferBuilder;
import com.minecrafttas.tasmod.registries.TASmodPackets;
import com.minecrafttas.tasmod.tickratechanger.TickrateChangerServer;
import com.minecrafttas.tasmod.util.LoggerMarkers;
import java.nio.ByteBuffer;
import net.minecraft.class_1600;

public class TickrateChangerClient
implements ClientPacketHandler {
    public float ticksPerSecond;
    public float tickrateSaved = 20.0f;
    public boolean advanceTick = false;
    public long millisecondsPerTick = 50L;
    private float[] rates = new float[]{0.1f, 0.2f, 0.5f, 1.0f, 2.0f, 5.0f, 10.0f, 20.0f, 40.0f, 100.0f};
    private short rateIndex = (short)7;

    public TickrateChangerClient() {
        this(20.0f);
    }

    public TickrateChangerClient(float initialTickrate) {
        this.ticksPerSecond = initialTickrate;
    }

    public void changeTickrate(float tickrate) {
        this.changeClientTickrate(tickrate);
        this.changeServerTickrate(tickrate);
    }

    public void changeClientTickrate(float tickrate) {
        this.changeClientTickrate(tickrate, true);
    }

    public void changeClientTickrate(float tickrate, boolean log) {
        if (tickrate < 0.0f) {
            return;
        }
        class_1600 mc = class_1600.method_2965();
        if (tickrate > 0.0f) {
            this.millisecondsPerTick = (long)(1000.0f / tickrate);
            mc.field_3778.field_15885 = this.millisecondsPerTick;
        } else if (tickrate == 0.0f) {
            if (this.ticksPerSecond != 0.0f) {
                this.tickrateSaved = this.ticksPerSecond;
            }
            mc.field_3778.field_15885 = Float.MAX_VALUE;
        }
        this.ticksPerSecond = tickrate;
        EventListenerRegistry.fireEvent(EventTickratechanger.EventClientTickrateChange.class, Float.valueOf(tickrate));
        if (log) {
            TickrateChangerClient.log("Setting the client tickrate to " + this.ticksPerSecond);
        }
    }

    public void changeServerTickrate(float tickrate) {
        if (tickrate < 0.0f) {
            return;
        }
        try {
            TASmodClient.client.send(new TASmodBufferBuilder(TASmodPackets.TICKRATE_CHANGE).writeFloat(tickrate));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void togglePause() {
        try {
            TASmodClient.client.send(new TASmodBufferBuilder(TASmodPackets.TICKRATE_ZERO).writeEnum(TickrateChangerServer.TickratePauseState.TOGGLE));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void togglePauseClient() {
        if (this.ticksPerSecond > 0.0f) {
            this.tickrateSaved = this.ticksPerSecond;
            this.pauseClientGame(true);
        } else if (this.ticksPerSecond == 0.0f) {
            this.pauseClientGame(false);
        }
    }

    public void pauseGame(boolean pause) {
        if (pause) {
            this.changeTickrate(0.0f);
        } else {
            this.advanceTick = false;
            this.changeTickrate(this.tickrateSaved);
        }
    }

    public void pauseClientGame(boolean pause) {
        if (pause) {
            this.changeClientTickrate(0.0f);
        } else {
            this.changeClientTickrate(this.tickrateSaved);
        }
    }

    public void advanceTick() {
        if (class_1600.method_2965().field_3803 != null) {
            this.advanceServerTick();
        } else {
            this.advanceClientTick();
        }
    }

    public void advanceServerTick() {
        try {
            TASmodClient.client.send(new TASmodBufferBuilder(TASmodPackets.TICKRATE_ADVANCE));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void advanceClientTick() {
        if (this.ticksPerSecond == 0.0f) {
            this.advanceTick = true;
            this.changeClientTickrate(this.tickrateSaved);
        }
    }

    public void increaseTickrate() {
        this.rateIndex = this.findClosestRateIndex(this.ticksPerSecond);
        this.rateIndex = (short)(this.rateIndex + 1);
        this.rateIndex = (short)TickrateChangerClient.clamp(this.rateIndex, 0, this.rates.length - 1);
        this.changeTickrate(this.rates[this.rateIndex]);
    }

    public void decreaseTickrate() {
        this.rateIndex = this.findClosestRateIndex(this.ticksPerSecond);
        this.rateIndex = (short)(this.rateIndex - 1);
        this.rateIndex = (short)TickrateChangerClient.clamp(this.rateIndex, 0, this.rates.length - 1);
        this.changeTickrate(this.rates[this.rateIndex]);
    }

    public void joinServer() {
        this.changeServerTickrate(this.ticksPerSecond);
    }

    private static void log(String msg) {
        TASmod.LOGGER.debug(LoggerMarkers.Tickrate, msg);
    }

    @Override
    public PacketID[] getAcceptedPacketIDs() {
        return new TASmodPackets[]{TASmodPackets.TICKRATE_CHANGE, TASmodPackets.TICKRATE_ADVANCE, TASmodPackets.TICKRATE_ZERO};
    }

    @Override
    public void onClientPacket(PacketID id, ByteBuffer buf, String username) throws PacketNotImplementedException, WrongSideException, Exception {
        TASmodPackets packet = (TASmodPackets)id;
        switch (packet) {
            case TICKRATE_CHANGE: {
                float tickrate = TASmodBufferBuilder.readFloat(buf);
                this.changeClientTickrate(tickrate);
                break;
            }
            case TICKRATE_ADVANCE: {
                this.advanceClientTick();
                break;
            }
            case TICKRATE_ZERO: {
                TickrateChangerServer.TickratePauseState state = TASmodBufferBuilder.readEnum(TickrateChangerServer.TickratePauseState.class, buf);
                switch (state) {
                    case PAUSE: {
                        this.pauseClientGame(true);
                        break;
                    }
                    case UNPAUSE: {
                        this.pauseClientGame(false);
                        break;
                    }
                    case TOGGLE: {
                        this.togglePauseClient();
                    }
                }
                break;
            }
            default: {
                throw new PacketNotImplementedException(packet, this.getClass(), Client.Side.CLIENT);
            }
        }
    }

    private short findClosestRateIndex(float tickrate) {
        for (int i = 0; i < this.rates.length; ++i) {
            int iMinus1 = i - 1;
            float min = 0.0f;
            if (iMinus1 >= 0) {
                min = this.rates[iMinus1];
            }
            float max = this.rates[i];
            if (!(tickrate >= min) || !(tickrate < max)) continue;
            if (min == 0.0f) {
                return (short)i;
            }
            float distanceToMin = tickrate - min;
            float distanceToMax = max - tickrate;
            if (distanceToMin < distanceToMax) {
                return (short)iMinus1;
            }
            if (distanceToMax < distanceToMin) {
                return (short)i;
            }
            return (short)iMinus1;
        }
        return (short)(this.rates.length - 1);
    }

    private static int clamp(long value, int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException(min + " > " + max);
        }
        return (int)Math.min((long)max, Math.max(value, (long)min));
    }
}

