/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.tickratechanger;

import com.minecrafttas.mctcommon.events.EventListenerRegistry;
import com.minecrafttas.mctcommon.events.EventServer;
import com.minecrafttas.mctcommon.networking.Client;
import com.minecrafttas.mctcommon.networking.exception.PacketNotImplementedException;
import com.minecrafttas.mctcommon.networking.exception.WrongSideException;
import com.minecrafttas.mctcommon.networking.interfaces.PacketID;
import com.minecrafttas.mctcommon.networking.interfaces.ServerPacketHandler;
import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.events.EventTickratechanger;
import com.minecrafttas.tasmod.networking.TASmodBufferBuilder;
import com.minecrafttas.tasmod.registries.TASmodPackets;
import com.minecrafttas.tasmod.util.LoggerMarkers;
import java.nio.ByteBuffer;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Logger;

public class TickrateChangerServer
implements EventServer.EventServerStop,
EventServer.EventClientCompleteAuthentication,
ServerPacketHandler {
    public float ticksPerSecond = 20.0f;
    public long millisecondsPerTick = 50L;
    public float tickrateSaved = 20.0f;
    public boolean advanceTick = false;
    public Logger logger;

    public TickrateChangerServer(Logger logger) {
        this.logger = logger;
    }

    public void changeTickrate(float tickrate) {
        this.changeClientTickrate(tickrate);
        this.changeServerTickrate(tickrate);
    }

    public void changeClientTickrate(float tickrate) {
        this.changeClientTickrate(tickrate, false);
    }

    public void changeClientTickrate(float tickrate, boolean log) {
        if (log) {
            this.log("Changing the tickrate " + tickrate + " to all clients");
        }
        try {
            TASmod.server.sendToAll(new TASmodBufferBuilder(TASmodPackets.TICKRATE_CHANGE).writeFloat(tickrate));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void changeServerTickrate(float tickrate) {
        this.changeServerTickrate(tickrate, true);
    }

    public void changeServerTickrate(float tickrate, boolean log) {
        if (tickrate > 0.0f) {
            this.millisecondsPerTick = (long)(1000.0f / tickrate);
        } else if (tickrate == 0.0f && this.ticksPerSecond != 0.0f) {
            this.tickrateSaved = this.ticksPerSecond;
        }
        this.ticksPerSecond = tickrate;
        EventListenerRegistry.fireEvent(EventTickratechanger.EventServerTickrateChange.class, Float.valueOf(tickrate));
        if (log) {
            this.log("Setting the server tickrate to " + this.ticksPerSecond);
        }
    }

    public void togglePause() {
        if (this.ticksPerSecond > 0.0f) {
            this.changeTickrate(0.0f);
        } else if (this.ticksPerSecond == 0.0f) {
            this.changeTickrate(this.tickrateSaved);
        }
    }

    public void pauseGame(boolean pause) {
        if (pause) {
            this.changeTickrate(0.0f);
        } else {
            this.advanceTick = false;
            this.changeTickrate(this.tickrateSaved);
        }
    }

    public void pauseServerGame(boolean pause) {
        if (pause) {
            this.changeServerTickrate(0.0f);
        } else {
            this.changeServerTickrate(this.tickrateSaved);
        }
    }

    public void advanceTick() {
        this.advanceServerTick();
        this.advanceClientTick();
    }

    private void advanceClientTick() {
        try {
            TASmod.server.sendToAll(new TASmodBufferBuilder(TASmodPackets.TICKRATE_ADVANCE));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void advanceServerTick() {
        if (this.ticksPerSecond == 0.0f) {
            this.advanceTick = true;
            this.changeServerTickrate(this.tickrateSaved);
        }
    }

    @Override
    public void onClientCompleteAuthentication(String username) {
        if (TASmod.getServerInstance() != null && TASmod.getServerInstance().method_2983()) {
            this.log("Sending the current tickrate (" + this.ticksPerSecond + ") to " + username);
            try {
                TASmod.server.sendTo(username, new TASmodBufferBuilder(TASmodPackets.TICKRATE_CHANGE).writeFloat(this.ticksPerSecond));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void log(String msg) {
        this.logger.debug(LoggerMarkers.Tickrate, msg);
    }

    @Override
    public void onServerStop(MinecraftServer server) {
        if (this.ticksPerSecond == 0.0f || this.advanceTick) {
            this.pauseGame(false);
        }
    }

    @Override
    public PacketID[] getAcceptedPacketIDs() {
        return new TASmodPackets[]{TASmodPackets.TICKRATE_CHANGE, TASmodPackets.TICKRATE_ADVANCE, TASmodPackets.TICKRATE_ZERO};
    }

    @Override
    public void onServerPacket(PacketID id, ByteBuffer buf, String username) throws PacketNotImplementedException, WrongSideException, Exception {
        TASmodPackets packet = (TASmodPackets)id;
        switch (packet) {
            case TICKRATE_CHANGE: {
                float tickrate = TASmodBufferBuilder.readFloat(buf);
                this.changeTickrate(tickrate);
                break;
            }
            case TICKRATE_ADVANCE: {
                this.advanceTick();
                break;
            }
            case TICKRATE_ZERO: {
                TickratePauseState state = TASmodBufferBuilder.readEnum(TickratePauseState.class, buf);
                switch (state.ordinal()) {
                    case 0: {
                        this.pauseGame(true);
                        break;
                    }
                    case 1: {
                        this.pauseGame(false);
                        break;
                    }
                    case 2: {
                        this.togglePause();
                    }
                }
                break;
            }
            default: {
                throw new PacketNotImplementedException(packet, this.getClass(), Client.Side.SERVER);
            }
        }
    }

    public static enum TickratePauseState {
        PAUSE,
        UNPAUSE,
        TOGGLE;

    }
}

