/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.ticksync;

import com.minecrafttas.mctcommon.events.EventServer;
import com.minecrafttas.mctcommon.networking.interfaces.PacketID;
import com.minecrafttas.mctcommon.networking.interfaces.ServerPacketHandler;
import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.events.EventServer;
import com.minecrafttas.tasmod.networking.TASmodBufferBuilder;
import com.minecrafttas.tasmod.registries.TASmodPackets;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.server.MinecraftServer;

public class TickSyncServer
implements ServerPacketHandler,
EventServer.EventServerTickPost,
EventServer.EventClientCompleteAuthentication {
    private static List<String> synchronizedList = Collections.synchronizedList(new ArrayList());
    private boolean enabled = true;

    @Override
    public PacketID[] getAcceptedPacketIDs() {
        return new TASmodPackets[]{TASmodPackets.TICKSYNC};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServerPacket(PacketID id, ByteBuffer buf, String username) {
        List<String> list = synchronizedList;
        synchronized (list) {
            if (!synchronizedList.contains(username)) {
                synchronizedList.add(username);
            }
        }
        if (TASmod.getServerInstance() == null) {
            this.sendToClients();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldTick() {
        List<String> list = synchronizedList;
        synchronized (list) {
            int acknowledged = synchronizedList.size();
            int totalConnections = TASmod.server.getClients().size();
            return acknowledged >= totalConnections;
            {
            }
        }
    }

    public static void clearList() {
        synchronizedList.clear();
    }

    @Override
    public void onServerTickPost(MinecraftServer server) {
        this.sendToClients();
    }

    @Override
    public void onClientCompleteAuthentication(String username) {
        this.sendToClients();
    }

    private void sendToClients() {
        try {
            TASmod.server.sendToAll(new TASmodBufferBuilder(TASmodPackets.TICKSYNC));
        }
        catch (Exception e) {
            TASmod.LOGGER.error("Unable to send packet to all clients:", (Throwable)e);
        }
        if (synchronizedList.size() > 0) {
            synchronizedList.clear();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

