/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.ConcurrentLinkedQueue;

public class FileThread
extends Thread {
    private final PrintWriter stream;
    private boolean end = false;
    private final ConcurrentLinkedQueue<String> output = new ConcurrentLinkedQueue();

    public FileThread(Path fileLocation, boolean append) throws IOException {
        super("TASmod FileWriter Thread");
        OutputStream outStream = Files.newOutputStream(fileLocation, StandardOpenOption.CREATE, append ? StandardOpenOption.APPEND : StandardOpenOption.TRUNCATE_EXISTING);
        this.stream = new PrintWriter((Writer)new OutputStreamWriter(outStream, StandardCharsets.UTF_8), true);
    }

    public void addLine(String line) {
        this.output.add(line + "\n");
    }

    @Override
    public void run() {
        while (!this.end) {
            this.writeOutput();
        }
        this.writeOutput();
        this.stream.flush();
        this.stream.close();
    }

    private void writeOutput() {
        String line;
        while ((line = this.output.poll()) != null) {
            this.stream.print(line);
        }
    }

    public void close() {
        this.end = true;
    }

    public void flush() {
        this.stream.flush();
    }
}

