/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class JsonUtils {
    public static Gson getJsonInstance() {
        return new GsonBuilder().setPrettyPrinting().create();
    }

    public static void saveJson(Path savePath, JsonObject data) throws IOException {
        JsonUtils.saveJson(savePath, data, JsonUtils.getJsonInstance());
    }

    public static void saveJson(Path savePath, JsonObject data, Gson jsonInstance) throws IOException {
        String out = jsonInstance.toJson((JsonElement)data);
        Files.write(savePath, out.getBytes(), new OpenOption[0]);
    }

    public static JsonObject loadJson(Path loadPath) throws IOException {
        return JsonUtils.loadJson(loadPath, JsonUtils.getJsonInstance());
    }

    public static JsonObject loadJson(Path loadPath, Gson jsonInstance) throws IOException {
        return (JsonObject)jsonInstance.fromJson(new String(Files.readAllBytes(loadPath)), JsonObject.class);
    }
}

