/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.util;

import com.minecrafttas.mctcommon.networking.ByteBufferBuilder;
import com.minecrafttas.mctcommon.networking.exception.PacketNotImplementedException;
import com.minecrafttas.mctcommon.networking.exception.WrongSideException;
import com.minecrafttas.mctcommon.networking.interfaces.ClientPacketHandler;
import com.minecrafttas.mctcommon.networking.interfaces.PacketID;
import com.minecrafttas.mctcommon.networking.interfaces.ServerPacketHandler;
import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.TASmodClient;
import com.minecrafttas.tasmod.networking.TASmodBufferBuilder;
import com.minecrafttas.tasmod.registries.TASmodAPIRegistry;
import com.minecrafttas.tasmod.registries.TASmodPackets;
import java.io.File;
import java.io.FileFilter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.minecraft.class_1600;

public class TabCompletionUtils
implements ServerPacketHandler,
ClientPacketHandler {
    private volatile CompletableFuture<List<String>> fileList = null;
    private volatile CompletableFuture<List<String>> flavorList = null;

    @Override
    public PacketID[] getAcceptedPacketIDs() {
        return new PacketID[]{TASmodPackets.COMMAND_TASFILELIST, TASmodPackets.COMMAND_FLAVORLIST};
    }

    @Override
    public void onServerPacket(PacketID id, ByteBuffer buf, String username) throws PacketNotImplementedException, WrongSideException, Exception {
        TASmodPackets packet = (TASmodPackets)id;
        switch (packet) {
            case COMMAND_TASFILELIST: {
                String filenames = TASmodBufferBuilder.readString(buf);
                this.fileList.complete(Arrays.asList(filenames.split("\\|")));
                break;
            }
            case COMMAND_FLAVORLIST: {
                String flavornames = TASmodBufferBuilder.readString(buf);
                this.flavorList.complete(Arrays.asList(flavornames.split("\\|")));
                break;
            }
        }
    }

    public List<String> getTASfileList(String playername) throws InterruptedException, ExecutionException, TimeoutException {
        this.fileList = new CompletableFuture();
        try {
            TASmod.server.sendTo(playername, (ByteBufferBuilder)new TASmodBufferBuilder(TASmodPackets.COMMAND_TASFILELIST));
        }
        catch (Exception e) {
            TASmod.LOGGER.catching((Throwable)e);
        }
        return this.fileList.get(2L, TimeUnit.SECONDS);
    }

    public List<String> getFlavorList(String playername) throws InterruptedException, ExecutionException, TimeoutException {
        this.flavorList = new CompletableFuture();
        try {
            TASmod.server.sendTo(playername, (ByteBufferBuilder)new TASmodBufferBuilder(TASmodPackets.COMMAND_FLAVORLIST));
        }
        catch (Exception e) {
            TASmod.LOGGER.catching((Throwable)e);
        }
        return this.flavorList.get(2L, TimeUnit.SECONDS);
    }

    @Override
    public void onClientPacket(PacketID id, ByteBuffer buf, String username) throws PacketNotImplementedException, WrongSideException, Exception {
        TASmodPackets packet = (TASmodPackets)id;
        switch (packet) {
            case COMMAND_TASFILELIST: {
                String filenames = String.join((CharSequence)"|", this.getFilenames());
                TASmodClient.client.send(new TASmodBufferBuilder(TASmodPackets.COMMAND_TASFILELIST).writeString(filenames));
                break;
            }
            case COMMAND_FLAVORLIST: {
                String flavornames = String.join((CharSequence)"|", TASmodAPIRegistry.SERIALISER_FLAVOR.getFlavorNames());
                TASmodClient.client.send(new TASmodBufferBuilder(TASmodPackets.COMMAND_FLAVORLIST).writeString(flavornames));
                break;
            }
        }
    }

    private List<String> getFilenames() {
        ArrayList<String> tab = new ArrayList<String>();
        File folder = new File(class_1600.method_2965().field_3762, "saves" + File.separator + "tasfiles");
        File[] listOfFiles = folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".mctas");
            }
        });
        for (int i = 0; i < listOfFiles.length; ++i) {
            tab.add(listOfFiles[i].getName().replaceFirst("\\.mctas$", ""));
        }
        return tab;
    }
}

