/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.virtual;

import com.minecrafttas.tasmod.virtual.Subtickable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_837;

public class VirtualCameraAngle
extends Subtickable<VirtualCameraAngle>
implements Serializable {
    private Float pitch;
    private Float yaw;

    public VirtualCameraAngle() {
        this(null, null, new ArrayList<VirtualCameraAngle>(), true);
    }

    public VirtualCameraAngle(Float pitch, Float yaw) {
        this(pitch, yaw, null);
    }

    public VirtualCameraAngle(Float pitch, Float yaw, boolean ignoreFirstUpdate) {
        this(pitch, yaw, new ArrayList<VirtualCameraAngle>(), ignoreFirstUpdate);
    }

    public VirtualCameraAngle(Float pitch, Float yaw, List<VirtualCameraAngle> subtickList) {
        this(pitch, yaw, subtickList, false);
    }

    public VirtualCameraAngle(Float pitch, Float yaw, List<VirtualCameraAngle> subtickList, boolean ignoreFirstUpdate) {
        super(subtickList, ignoreFirstUpdate);
        this.pitch = pitch;
        this.yaw = yaw;
    }

    public void updateFromEvent(float pitchDelta, float yawDelta) {
        this.updateFromEvent(pitchDelta, yawDelta, true);
    }

    public void updateFromEvent(float pitchDelta, float yawDelta, boolean updateSubtick) {
        if (this.pitch == null || this.yaw == null) {
            return;
        }
        this.createSubtick(updateSubtick);
        this.pitch = Float.valueOf(class_837.method_2336((float)(this.pitch.floatValue() + pitchDelta), (float)-90.0f, (float)90.0f));
        this.yaw = Float.valueOf(this.yaw.floatValue() + yawDelta);
    }

    public void updateFromState(Float pitch, Float yaw) {
        if (this.pitch != null && this.yaw != null) {
            this.createSubtick(true);
        }
        if (pitch != null) {
            pitch = Float.valueOf(class_837.method_2336((float)pitch.floatValue(), (float)-90.0f, (float)90.0f));
        }
        this.pitch = pitch;
        this.yaw = yaw;
    }

    public void createSubtick(boolean updateSubtick) {
        if (this.isParent() && !this.ignoreFirstUpdate() && updateSubtick) {
            this.addSubtick(this.shallowClone());
        }
    }

    public void set(float pitch, float yaw) {
        this.pitch = Float.valueOf(pitch);
        this.yaw = Float.valueOf(yaw);
    }

    public void getStates(List<VirtualCameraAngle> reference) {
        if (this.isParent()) {
            reference.addAll(this.subtickList);
            reference.add(this.shallowClone());
        }
    }

    public void moveFrom(VirtualCameraAngle camera) {
        if (camera == null) {
            return;
        }
        this.pitch = camera.pitch;
        this.yaw = camera.yaw;
        this.subtickList.clear();
        this.subtickList.addAll(camera.subtickList);
        camera.subtickList.clear();
    }

    public void deepCopyFrom(VirtualCameraAngle camera) {
        if (camera == null || !camera.isParent()) {
            return;
        }
        this.pitch = camera.pitch;
        this.yaw = camera.yaw;
        this.subtickList.clear();
        this.subtickList.addAll(camera.subtickList);
    }

    @Override
    public void clear() {
        this.pitch = null;
        this.yaw = null;
        super.clear();
    }

    public VirtualCameraAngle shallowClone() {
        return new VirtualCameraAngle(this.pitch, this.yaw);
    }

    public VirtualCameraAngle clone() {
        return new VirtualCameraAngle(this.pitch, this.yaw, new ArrayList<VirtualCameraAngle>(this.subtickList), this.isIgnoreFirstUpdate());
    }

    public boolean equals(Object obj) {
        if (obj instanceof VirtualCameraAngle) {
            VirtualCameraAngle angle = (VirtualCameraAngle)obj;
            if (this.pitch == null && angle.pitch != null) {
                return false;
            }
            if (this.yaw == null && angle.yaw != null) {
                return false;
            }
            if (this.pitch != null && !this.pitch.equals(angle.pitch)) {
                return false;
            }
            return this.yaw == null || this.yaw.equals(angle.yaw);
        }
        return super.equals(obj);
    }

    public String toString() {
        if (this.isParent()) {
            return this.getAll().stream().map(VirtualCameraAngle::toString2).collect(Collectors.joining("\n"));
        }
        return this.toString2();
    }

    public String toString2() {
        return String.format("%s;%s", this.yaw, this.pitch);
    }

    public Float getPitch() {
        return this.pitch;
    }

    public Float getYaw() {
        return this.yaw;
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.pitch != null && this.pitch.floatValue() != 0.0f || this.yaw != null && this.yaw.floatValue() != 0.0f);
    }
}

