/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.virtual;

import com.minecrafttas.mctcommon.events.EventListenerRegistry;
import com.minecrafttas.tasmod.events.EventVirtualInput;
import com.minecrafttas.tasmod.util.Ducks;
import com.minecrafttas.tasmod.util.LoggerMarkers;
import com.minecrafttas.tasmod.util.PointerNormalizer;
import com.minecrafttas.tasmod.virtual.SubtickGuiScreen;
import com.minecrafttas.tasmod.virtual.VirtualCameraAngle;
import com.minecrafttas.tasmod.virtual.VirtualInterpolationHandler;
import com.minecrafttas.tasmod.virtual.VirtualKey;
import com.minecrafttas.tasmod.virtual.VirtualKeyboard;
import com.minecrafttas.tasmod.virtual.VirtualMouse;
import com.minecrafttas.tasmod.virtual.event.VirtualKeyboardEvent;
import com.minecrafttas.tasmod.virtual.event.VirtualMouseEvent;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.class_1600;
import net.minecraft.class_388;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class VirtualInput {
    private final Logger LOGGER;
    public final VirtualKeyboardInput KEYBOARD;
    public final VirtualMouseInput MOUSE;
    public final VirtualCameraAngleInput CAMERA_ANGLE;
    public final VirtualInterpolationHandler interpolationHandler = new VirtualInterpolationHandler();
    private boolean useVanillaIsKeyDown;

    public VirtualInput(Logger logger) {
        this(logger, new VirtualKeyboard(), new VirtualMouse(), new VirtualCameraAngle());
    }

    public VirtualInput(Logger logger, VirtualKeyboard preloadedKeyboard, VirtualMouse preloadedMouse, VirtualCameraAngle preloadedCamera) {
        this.LOGGER = logger;
        this.KEYBOARD = new VirtualKeyboardInput(preloadedKeyboard);
        this.MOUSE = new VirtualMouseInput(preloadedMouse);
        this.CAMERA_ANGLE = new VirtualCameraAngleInput(preloadedCamera);
    }

    public void update(class_388 currentScreen) {
        while (Keyboard.next()) {
            if (this.updateSubtickGuiScreenKeyboard(currentScreen)) {
                return;
            }
            this.KEYBOARD.updateNextKeyboard(Keyboard.getEventKey(), Keyboard.getEventKeyState(), Keyboard.getEventCharacter(), Keyboard.areRepeatEventsEnabled());
        }
        while (Mouse.next()) {
            if (currentScreen == null) {
                this.MOUSE.updateNextMouse(Mouse.getEventButton() - 100, Mouse.getEventButtonState(), Mouse.getEventDWheel(), 0, 0);
                continue;
            }
            if (this.updateSubtickGuiScreenMouse(currentScreen)) {
                return;
            }
            Ducks.GuiScreenDuck screen = (Ducks.GuiScreenDuck)currentScreen;
            int eventX = screen.unscaleX(Mouse.getEventX());
            int eventY = screen.unscaleY(Mouse.getEventY());
            eventX = PointerNormalizer.getNormalizedX(eventX);
            eventY = PointerNormalizer.getNormalizedY(eventY);
            this.MOUSE.updateNextMouse(Mouse.getEventButton() - 100, Mouse.getEventButtonState(), Mouse.getEventDWheel(), eventX, eventY);
        }
    }

    private boolean updateSubtickGuiScreenKeyboard(class_388 currentScreen) {
        if (currentScreen instanceof SubtickGuiScreen) {
            SubtickGuiScreen screenSubtickable = (SubtickGuiScreen)currentScreen;
            if (Keyboard.getEventKeyState()) {
                screenSubtickable.method_1024(Keyboard.getEventCharacter(), Keyboard.getEventKey());
            }
            return true;
        }
        return false;
    }

    private boolean updateSubtickGuiScreenMouse(class_388 currentScreen) {
        if (currentScreen instanceof SubtickGuiScreen) {
            SubtickGuiScreen screenSubtickable = (SubtickGuiScreen)currentScreen;
            Ducks.GuiScreenDuck screenDuck = (Ducks.GuiScreenDuck)((Object)screenSubtickable);
            if (Mouse.getEventButtonState()) {
                screenSubtickable.method_1026(screenDuck.unscaleX(Mouse.getEventX()), screenDuck.unscaleY(Mouse.getEventY()), Mouse.getEventButton());
            }
            return true;
        }
        return false;
    }

    public void setUseVanillaIsKeyDown(boolean isVanilla) {
        this.useVanillaIsKeyDown = isVanilla;
    }

    public boolean isKeyDown(int keycode) {
        if (keycode >= 0) {
            if (!this.useVanillaIsKeyDown) {
                return this.KEYBOARD.isKeyDown(keycode);
            }
            return Keyboard.isKeyDown((int)keycode);
        }
        if (!this.useVanillaIsKeyDown) {
            return this.MOUSE.isKeyDown(keycode);
        }
        return Keyboard.isKeyDown((int)keycode);
    }

    public boolean willKeyBeDown(int keycode) {
        if (keycode >= 0) {
            return this.KEYBOARD.willKeyBeDown(keycode);
        }
        return this.MOUSE.willKeyBeDown(keycode);
    }

    public void clearNext() {
        this.KEYBOARD.clearNext();
        this.MOUSE.clearNext();
    }

    public void clearCurrent() {
        this.KEYBOARD.clearCurrent();
        this.MOUSE.clearCurrent();
    }

    public void preloadInput(VirtualKeyboard keyboardToPreload, VirtualMouse mouseToPreload, VirtualCameraAngle angleToPreload) {
        this.KEYBOARD.nextKeyboard.deepCopyFrom(keyboardToPreload);
        this.MOUSE.nextMouse.deepCopyFrom(mouseToPreload);
        this.CAMERA_ANGLE.nextCameraAngle.deepCopyFrom(angleToPreload);
        this.KEYBOARD.nextKeyboardTick();
        this.MOUSE.nextMouseTick();
        class_1600.method_2965().method_12145();
        class_1600.method_2965().method_12141();
        Ducks.SubtickDuck entityRenderer = (Ducks.SubtickDuck)class_1600.method_2965().field_3818;
        entityRenderer.runUpdate(0.0f);
    }

    public List<String> getCurrentMousePresses() {
        return this.MOUSE.currentMouse.getCurrentPresses();
    }

    public List<String> getNextMousePresses() {
        return this.MOUSE.nextMouse.getCurrentPresses();
    }

    public List<String> getCurrentKeyboardPresses() {
        return this.KEYBOARD.currentKeyboard.getCurrentPresses();
    }

    public List<String> getNextKeyboardPresses() {
        return this.KEYBOARD.nextKeyboard.getCurrentPresses();
    }

    public class VirtualKeyboardInput {
        private final VirtualKeyboard currentKeyboard;
        private final VirtualKeyboard nextKeyboard = new VirtualKeyboard();
        private final Queue<VirtualKeyboardEvent> keyboardEventQueue = new ConcurrentLinkedQueue<VirtualKeyboardEvent>();
        private VirtualKeyboardEvent currentKeyboardEvent = new VirtualKeyboardEvent();

        public VirtualKeyboardInput(VirtualKeyboard preloadedKeyboard) {
            this.currentKeyboard = preloadedKeyboard;
        }

        public void updateNextKeyboard(int keycode, boolean keystate, char character) {
            this.updateNextKeyboard(keycode, keystate, character, false);
        }

        public void updateNextKeyboard(int keycode, boolean keystate, char character, boolean repeatEventsEnabled) {
            VirtualInput.this.LOGGER.debug(LoggerMarkers.Keyboard, "Update: {}, {}, {}", (Object)keycode, (Object)keystate, (Object)Character.valueOf(character));
            this.nextKeyboard.updateFromEvent(keycode, keystate, character, repeatEventsEnabled);
        }

        public void nextKeyboardTick() {
            this.nextKeyboard.deepCopyFrom((VirtualKeyboard)EventListenerRegistry.fireEvent(EventVirtualInput.EventVirtualKeyboardTick.class, this.nextKeyboard));
            this.currentKeyboard.getVirtualEvents(this.nextKeyboard, this.keyboardEventQueue);
            this.currentKeyboard.moveFrom(this.nextKeyboard);
            VirtualInput.this.LOGGER.debug(LoggerMarkers.Keyboard, "KeyboardTick: {}", (Object)this.currentKeyboard);
        }

        public boolean nextKeyboardSubtick() {
            boolean isPolled;
            VirtualKeyboardEvent newKeyboardEvent = this.keyboardEventQueue.poll();
            boolean bl = isPolled = newKeyboardEvent != null;
            if (isPolled) {
                this.currentKeyboardEvent = newKeyboardEvent;
            }
            EventListenerRegistry.fireEvent(EventVirtualInput.EventVirtualKeyboardSubtick.class, this.currentKeyboardEvent);
            return isPolled;
        }

        public int getEventKeyboardKey() {
            return this.currentKeyboardEvent.getKeyCode();
        }

        public boolean getEventKeyboardState() {
            return this.currentKeyboardEvent.isState();
        }

        public char getEventKeyboardCharacter() {
            return this.currentKeyboardEvent.getCharacter();
        }

        public boolean isKeyDown(int keycode) {
            return this.currentKeyboard.isKeyDown(keycode);
        }

        public boolean willKeyBeDown(int keycode) {
            return this.nextKeyboard.isKeyDown(keycode);
        }

        public void clearNext() {
            this.nextKeyboard.clear();
        }

        public void clearCurrent() {
            this.currentKeyboard.clear();
        }
    }

    public class VirtualMouseInput {
        private final VirtualMouse currentMouse;
        private final VirtualMouse nextMouse = new VirtualMouse();
        private final Queue<VirtualMouseEvent> mouseEventQueue = new ConcurrentLinkedQueue<VirtualMouseEvent>();
        private VirtualMouseEvent currentMouseEvent = new VirtualMouseEvent();

        public VirtualMouseInput(VirtualMouse preloadedMouse) {
            this.currentMouse = preloadedMouse;
        }

        public void updateNextMouse(int keycode, boolean keystate, int scrollwheel, int cursorX, int cursorY) {
            VirtualInput.this.LOGGER.debug(LoggerMarkers.Mouse, "Update: {} ({}), {}, {}, {}, {}", (Object)keycode, (Object)VirtualKey.getName(keycode), (Object)keystate, (Object)scrollwheel, (Object)cursorX, (Object)cursorY);
            this.nextMouse.updateFromEvent(keycode, keystate, scrollwheel, cursorX, cursorY);
        }

        public void nextMouseTick() {
            this.nextMouse.deepCopyFrom((VirtualMouse)EventListenerRegistry.fireEvent(EventVirtualInput.EventVirtualMouseTick.class, this.nextMouse));
            this.currentMouse.getVirtualEvents(this.nextMouse, this.mouseEventQueue);
            this.currentMouse.moveFrom(this.nextMouse);
        }

        public boolean nextMouseSubtick() {
            boolean isPolled;
            VirtualMouseEvent newMouseEvent = this.mouseEventQueue.poll();
            boolean bl = isPolled = newMouseEvent != null;
            if (isPolled) {
                this.currentMouseEvent = newMouseEvent;
            }
            EventListenerRegistry.fireEvent(EventVirtualInput.EventVirtualMouseSubtick.class, this.currentMouseEvent);
            return isPolled;
        }

        public int getEventMouseKey() {
            return this.currentMouseEvent.getKeyCode();
        }

        public boolean getEventMouseState() {
            return this.currentMouseEvent.isState();
        }

        public int getEventMouseScrollWheel() {
            return this.currentMouseEvent.getScrollwheel();
        }

        public int getEventCursorX() {
            return PointerNormalizer.reapplyScalingX(this.getNormalizedCursorX());
        }

        public int getNormalizedCursorX() {
            return this.currentMouseEvent.getCursorX();
        }

        public int getEventCursorY() {
            return PointerNormalizer.reapplyScalingY(this.getNormalizedCursorY());
        }

        public int getNormalizedCursorY() {
            return this.currentMouseEvent.getCursorY();
        }

        public boolean isKeyDown(int keycode) {
            return this.currentMouse.isKeyDown(keycode);
        }

        public boolean willKeyBeDown(int keycode) {
            return this.nextMouse.isKeyDown(keycode);
        }

        public void clearNext() {
            this.nextMouse.clear();
        }

        public void clearCurrent() {
            this.currentMouse.clear();
        }
    }

    public class VirtualCameraAngleInput {
        private final VirtualCameraAngle currentCameraAngle;
        private final VirtualCameraAngle nextCameraAngle = new VirtualCameraAngle();

        public VirtualCameraAngleInput(VirtualCameraAngle preloadedCamera) {
            this.currentCameraAngle = preloadedCamera;
        }

        public void updateNextCameraAngle(float pitchDelta, float yawDelta) {
            this.updateNextCameraAngle(pitchDelta, yawDelta, true);
        }

        public void updateNextCameraAngle(float pitchDelta, float yawDelta, boolean updateSubtick) {
            this.nextCameraAngle.updateFromEvent(pitchDelta, yawDelta, updateSubtick);
        }

        public void nextCameraTick() {
            this.nextCameraAngle.deepCopyFrom((VirtualCameraAngle)EventListenerRegistry.fireEvent(EventVirtualInput.EventVirtualCameraAngleTick.class, this.nextCameraAngle));
            this.currentCameraAngle.moveFrom(this.nextCameraAngle);
        }

        public void setCamera(Float pitch, Float yaw) {
            this.nextCameraAngle.set(pitch.floatValue(), yaw.floatValue());
        }

        public Float getCurrentPitch() {
            return this.currentCameraAngle.getPitch();
        }

        public Float getCurrentYaw() {
            return this.currentCameraAngle.getYaw();
        }

        public Float getNextPitch() {
            return this.nextCameraAngle.getPitch();
        }

        public Float getNextYaw() {
            return this.nextCameraAngle.getYaw();
        }

        public void clearNext() {
            this.nextCameraAngle.clear();
        }

        public void clearCurrent() {
            this.currentCameraAngle.clear();
        }
    }
}

