/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.virtual;

import com.minecrafttas.tasmod.TASmodClient;
import com.minecrafttas.tasmod.events.EventVirtualInput;
import com.minecrafttas.tasmod.util.Ducks;
import com.minecrafttas.tasmod.util.PointerNormalizer;
import com.minecrafttas.tasmod.virtual.SubtickGuiScreen;
import com.minecrafttas.tasmod.virtual.VirtualCameraAngle;
import com.minecrafttas.tasmod.virtual.VirtualMouse;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1600;
import net.minecraft.class_837;

public class VirtualInterpolationHandler
implements EventVirtualInput.EventVirtualMouseTick,
EventVirtualInput.EventVirtualCameraAngleTick {
    private VirtualMouse nextMouse = new VirtualMouse();
    private VirtualCameraAngle nextCameraAngle = new VirtualCameraAngle();
    private final List<VirtualMouse> mousePointerStates = new ArrayList<VirtualMouse>();
    private final List<VirtualCameraAngle> cameraAngleStates = new ArrayList<VirtualCameraAngle>();

    @Override
    public VirtualMouse onVirtualMouseTick(VirtualMouse vmouse) {
        this.nextMouse = vmouse;
        this.mousePointerStates.clear();
        TASmodClient.controller.getNextMouse().getStates(this.mousePointerStates);
        return null;
    }

    @Override
    public VirtualCameraAngle onVirtualCameraTick(VirtualCameraAngle vcamera) {
        this.nextCameraAngle = vcamera;
        this.cameraAngleStates.clear();
        this.nextCameraAngle.getStates(this.cameraAngleStates);
        return null;
    }

    public MouseInterpolation getInterpolatedMouseCursor(float partialTick, boolean enable) {
        int interpolatedPointerX = this.nextMouse.getCursorX();
        int interpolatedPointerY = this.nextMouse.getCursorY();
        if (enable && !this.mousePointerStates.isEmpty()) {
            partialTick = this.dynamicallyRound(partialTick, TASmodClient.tickratechanger.ticksPerSecond);
            int index = (int)class_837.method_8341((double)0.0, (double)(this.mousePointerStates.size() - 1), (double)partialTick);
            VirtualMouse interpolatedCamera = this.mousePointerStates.get(index);
            interpolatedPointerX = interpolatedCamera.getCursorX();
            interpolatedPointerY = interpolatedCamera.getCursorY();
        }
        class_1600 mc = class_1600.method_2965();
        Ducks.GuiScreenDuck gui = (Ducks.GuiScreenDuck)mc.field_3816;
        if (gui != null && !(mc.field_3816 instanceof SubtickGuiScreen)) {
            interpolatedPointerX = gui.rescaleX(PointerNormalizer.reapplyScalingX(interpolatedPointerX));
            interpolatedPointerY = gui.rescaleY(PointerNormalizer.reapplyScalingY(interpolatedPointerY));
        }
        return new MouseInterpolation(interpolatedPointerX, interpolatedPointerY);
    }

    private float dynamicallyRound(float partialTick, float tps) {
        float percent = tps / 100.0f;
        if (partialTick > 1.0f - percent) {
            partialTick = 1.0f;
        }
        return partialTick;
    }

    public CameraInterpolation getInterpolatedState(float partialTick, float pitch, float yaw, boolean enable) {
        float interpolatedYaw;
        float interpolatedPitch = this.nextCameraAngle.getPitch() == null ? pitch : this.nextCameraAngle.getPitch().floatValue();
        float f = interpolatedYaw = this.nextCameraAngle.getYaw() == null ? yaw : this.nextCameraAngle.getYaw().floatValue() + 180.0f;
        if (enable && !this.cameraAngleStates.isEmpty()) {
            int index = (int)class_837.method_8341((double)0.0, (double)(this.cameraAngleStates.size() - 1), (double)partialTick);
            VirtualCameraAngle interpolatedCamera = this.cameraAngleStates.get(index);
            interpolatedPitch = interpolatedCamera.getPitch() == null ? 0.0f : interpolatedCamera.getPitch().floatValue();
            interpolatedYaw = interpolatedCamera.getYaw() == null ? 0.0f : interpolatedCamera.getYaw().floatValue() + 180.0f;
        }
        return new CameraInterpolation(Float.valueOf(interpolatedPitch), Float.valueOf(interpolatedYaw));
    }

    public static class MouseInterpolation {
        final Integer x;
        final Integer y;

        public MouseInterpolation(Integer x, Integer y) {
            this.x = x;
            this.y = y;
        }

        public Integer getX() {
            return this.x;
        }

        public Integer getY() {
            return this.y;
        }

        public boolean equals(Object obj) {
            if (obj instanceof MouseInterpolation) {
                MouseInterpolation other = (MouseInterpolation)obj;
                return this.x.equals(other.x) && this.y.equals(other.y);
            }
            return super.equals(obj);
        }
    }

    public static class CameraInterpolation {
        final Float pitch;
        final Float yaw;

        public CameraInterpolation(Float pitch, Float yaw) {
            this.pitch = pitch;
            this.yaw = yaw;
        }

        public Float getPitch() {
            return this.pitch;
        }

        public Float getYaw() {
            return this.yaw;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CameraInterpolation) {
                CameraInterpolation other = (CameraInterpolation)obj;
                return this.pitch.equals(other.pitch) && this.yaw.equals(other.yaw);
            }
            return super.equals(obj);
        }
    }
}

