/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.virtual;

import com.google.common.collect.ImmutableList;
import com.minecrafttas.tasmod.virtual.VirtualKey;
import com.minecrafttas.tasmod.virtual.VirtualPeripheral;
import com.minecrafttas.tasmod.virtual.event.VirtualKeyboardEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class VirtualKeyboard
extends VirtualPeripheral<VirtualKeyboard>
implements Serializable {
    private final List<Character> charList;
    private final ConcurrentLinkedQueue<Character> charQueue = new ConcurrentLinkedQueue();

    public VirtualKeyboard() {
        this(new LinkedHashSet<Integer>(), new ArrayList<Character>(), new ArrayList<VirtualKeyboard>(), true);
    }

    public VirtualKeyboard(Set<Integer> pressedKeys, List<Character> charList) {
        this(pressedKeys, charList, null, false);
    }

    public VirtualKeyboard(Set<Integer> pressedKeys, List<Character> charList, boolean ignoreFirstUpdate) {
        this(pressedKeys, charList, null, ignoreFirstUpdate);
    }

    public VirtualKeyboard(Set<Integer> pressedKeys, List<Character> charList, List<VirtualKeyboard> subtickList, boolean ignoreFirstUpdate) {
        super(pressedKeys, subtickList, ignoreFirstUpdate);
        this.charList = charList;
    }

    public void updateFromEvent(int keycode, boolean keystate, char keycharacter, boolean repeatEventsEnabled) {
        this.createSubtick();
        this.charList.clear();
        if (keystate) {
            this.addChar(keycharacter, repeatEventsEnabled);
        }
        this.setPressed(keycode, keystate);
    }

    public void updateFromEvent(int keycode, boolean keystate, char keycharacter) {
        this.updateFromEvent(keycode, keystate, keycharacter, false);
    }

    public void updateFromEvent(VirtualKey key, boolean keystate, char keycharacter) {
        this.updateFromEvent(key.getKeycode(), keystate, keycharacter);
    }

    public void updateFromEvent(VirtualKey key, boolean keystate, char keycharacter, boolean repeatEventsEnabled) {
        this.updateFromEvent(key.getKeycode(), keystate, keycharacter, false);
    }

    public void updateFromState(Set<Integer> keycodes, char[] chars) {
        this.createSubtick();
        this.pressedKeys.clear();
        this.pressedKeys.addAll(keycodes);
        this.charList.clear();
        for (char c : chars) {
            this.charList.add(Character.valueOf(c));
        }
    }

    @Override
    public void createSubtick() {
        if (this.isParent() && !this.ignoreFirstUpdate()) {
            this.addSubtick(this.shallowClone());
        }
    }

    @Override
    public void setPressed(int keycode, boolean keystate) {
        if (keycode >= 0) {
            super.setPressed(keycode, keystate);
        }
    }

    public void getVirtualEvents(VirtualKeyboard nextKeyboard, Queue<VirtualKeyboardEvent> reference) {
        if (this.isParent()) {
            VirtualKeyboard currentSubtick = this;
            for (VirtualKeyboard subtick : nextKeyboard.getAll()) {
                currentSubtick.getDifference(subtick, reference);
                currentSubtick = subtick;
            }
        }
    }

    public void getDifference(VirtualKeyboard nextKeyboard, Queue<VirtualKeyboardEvent> reference) {
        this.charQueue.addAll(nextKeyboard.charList);
        Iterator iterator = this.pressedKeys.iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            if (nextKeyboard.getPressedKeys().contains(key)) continue;
            reference.add(new VirtualKeyboardEvent(key, false, '\u0000'));
        }
        int lastKey = 0;
        Iterator<Integer> iterator2 = nextKeyboard.getPressedKeys().iterator();
        while (iterator2.hasNext()) {
            int key;
            lastKey = key = iterator2.next().intValue();
            if (this.pressedKeys.contains(key)) continue;
            reference.add(new VirtualKeyboardEvent(key, true, this.getOrMinChar(this.charQueue.poll())));
        }
        while (!this.charQueue.isEmpty()) {
            reference.add(new VirtualKeyboardEvent(lastKey, true, this.getOrMinChar(this.charQueue.poll())));
        }
    }

    private char getOrMinChar(Character charr) {
        if (charr == null) {
            charr = Character.valueOf('\u0000');
        }
        return charr.charValue();
    }

    public void addChar(char character, boolean repeatEventsEnabled) {
        if (character != '\u0000' || repeatEventsEnabled) {
            this.charList.add(Character.valueOf(character));
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.charList.clear();
    }

    @Override
    public String toString() {
        if (this.isParent()) {
            return this.getAll().stream().map(VirtualKeyboard::toString2).collect(Collectors.joining("\n"));
        }
        return this.toString2();
    }

    public String toString2() {
        return String.format("%s;%s", super.toString(), this.charListToString(this.charList));
    }

    private String charListToString(List<Character> charList) {
        String charString = "";
        if (!charList.isEmpty()) {
            charString = charList.stream().map(Object::toString).collect(Collectors.joining());
            charString = StringUtils.replace((String)charString, (String)"\r", (String)"\\n");
            charString = StringUtils.replace((String)charString, (String)"\n", (String)"\\n");
        }
        return charString;
    }

    public VirtualKeyboard shallowClone() {
        return new VirtualKeyboard((Set<Integer>)new HashSet<Integer>(this.pressedKeys), (List<Character>)new ArrayList<Character>(this.charList), this.isIgnoreFirstUpdate());
    }

    public VirtualKeyboard clone() {
        return new VirtualKeyboard(new HashSet<Integer>(this.pressedKeys), new ArrayList<Character>(this.charList), new ArrayList<VirtualKeyboard>(this.subtickList), this.isIgnoreFirstUpdate());
    }

    @Override
    public void moveFrom(VirtualKeyboard keyboard) {
        if (keyboard == null) {
            return;
        }
        super.moveFrom(keyboard);
        this.charList.clear();
        this.charList.addAll(keyboard.charList);
        keyboard.charList.clear();
    }

    @Override
    public void copyFrom(VirtualKeyboard keyboard) {
        if (keyboard == null) {
            return;
        }
        super.copyFrom(keyboard);
        this.charList.clear();
        this.charList.addAll(keyboard.charList);
    }

    @Override
    public void deepCopyFrom(VirtualKeyboard keyboard) {
        if (keyboard == null) {
            return;
        }
        super.deepCopyFrom(keyboard);
        this.charList.clear();
        this.charList.addAll(keyboard.charList);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof VirtualKeyboard) {
            VirtualKeyboard keyboard = (VirtualKeyboard)obj;
            if (this.charList.size() != keyboard.charList.size()) {
                return false;
            }
            for (int i = 0; i < this.charList.size(); ++i) {
                if (this.charList.get(i) == keyboard.charList.get(i)) continue;
                return false;
            }
            return super.equals(obj);
        }
        return super.equals(obj);
    }

    public List<Character> getCharList() {
        return ImmutableList.copyOf(this.charList);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.charList.isEmpty();
    }
}

