/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.virtual;

import com.minecrafttas.tasmod.virtual.VirtualKey;
import com.minecrafttas.tasmod.virtual.VirtualPeripheral;
import com.minecrafttas.tasmod.virtual.event.VirtualMouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;

public class VirtualMouse
extends VirtualPeripheral<VirtualMouse>
implements Serializable {
    private int scrollWheel;
    private int cursorX;
    private int cursorY;

    public VirtualMouse() {
        this(new LinkedHashSet<Integer>(), 0, 0, 0, new ArrayList<VirtualMouse>(), true);
    }

    public VirtualMouse(Set<Integer> pressedKeys, int scrollWheel, int cursorX, int cursorY) {
        this(pressedKeys, scrollWheel, cursorX, cursorY, null);
    }

    public VirtualMouse(Set<Integer> pressedKeys, int scrollWheel, int cursorX, int cursorY, List<VirtualMouse> subtickList) {
        this(pressedKeys, scrollWheel, cursorX, cursorY, subtickList, false);
    }

    public VirtualMouse(Set<Integer> pressedKeys, int scrollWheel, int cursorX, int cursorY, List<VirtualMouse> subtickList, boolean ignoreFirstUpdate) {
        super(pressedKeys, subtickList, ignoreFirstUpdate);
        this.scrollWheel = scrollWheel;
        this.cursorX = cursorX;
        this.cursorY = cursorY;
    }

    public void updateFromEvent(int keycode, boolean keystate, int scrollwheel, int cursorX, int cursorY) {
        this.createSubtick();
        this.setPressed(keycode, keystate);
        this.scrollWheel = scrollwheel;
        this.cursorX = cursorX;
        this.cursorY = cursorY;
    }

    public void updateFromEvent(VirtualKey key, boolean keystate, int scrollwheel, int cursorX, int cursorY) {
        this.updateFromEvent(key.getKeycode(), keystate, scrollwheel, cursorX, cursorY);
    }

    public void updateFromState(Set<Integer> keycodes, int scrollwheel, int cursorX, int cursorY) {
        this.createSubtick();
        this.pressedKeys.clear();
        this.pressedKeys.addAll(keycodes);
        this.scrollWheel = scrollwheel;
        this.cursorX = cursorX;
        this.cursorY = cursorY;
    }

    @Override
    public void createSubtick() {
        if (this.isParent() && !this.ignoreFirstUpdate()) {
            this.addSubtick(this.shallowClone());
        }
    }

    @Override
    public void setPressed(int keycode, boolean keystate) {
        if (keycode < 0) {
            super.setPressed(keycode, keystate);
        }
    }

    public void getVirtualEvents(VirtualMouse nextMouse, Queue<VirtualMouseEvent> reference) {
        if (this.isParent()) {
            VirtualMouse currentSubtick = this;
            for (VirtualMouse subtick : nextMouse.getAll()) {
                currentSubtick.getDifference(subtick, reference);
                currentSubtick = subtick;
            }
        }
    }

    public void getDifference(VirtualMouse nextMouse, Queue<VirtualMouseEvent> reference) {
        int keycode;
        if (this.pressedKeys.equals(nextMouse.pressedKeys)) {
            if (!this.equals(nextMouse) || this.scrollWheel != 0) {
                reference.add(new VirtualMouseEvent(VirtualKey.MOUSEMOVED.getKeycode(), false, nextMouse.scrollWheel, nextMouse.cursorX, nextMouse.cursorY));
            }
            return;
        }
        int scrollWheelCopy = nextMouse.scrollWheel;
        int cursorXCopy = nextMouse.cursorX;
        int cursorYCopy = nextMouse.cursorY;
        Iterator<Object> iterator = this.pressedKeys.iterator();
        while (iterator.hasNext()) {
            keycode = (Integer)iterator.next();
            if (nextMouse.getPressedKeys().contains(keycode)) continue;
            reference.add(new VirtualMouseEvent(keycode, false, scrollWheelCopy, cursorXCopy, cursorYCopy));
            scrollWheelCopy = 0;
            cursorXCopy = 0;
            cursorYCopy = 0;
        }
        iterator = nextMouse.getPressedKeys().iterator();
        while (iterator.hasNext()) {
            keycode = (Integer)iterator.next();
            if (this.pressedKeys.contains(keycode)) continue;
            reference.add(new VirtualMouseEvent(keycode, true, scrollWheelCopy, cursorXCopy, cursorYCopy));
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.clearMouseData();
    }

    private void clearMouseData() {
        this.scrollWheel = 0;
        this.cursorX = 0;
        this.cursorY = 0;
    }

    @Override
    public String toString() {
        if (this.isParent()) {
            return this.getAll().stream().map(VirtualMouse::toString2).collect(Collectors.joining("\n"));
        }
        return this.toString2();
    }

    public String toString2() {
        return String.format("%s;%s,%s,%s", super.toString(), this.scrollWheel, this.cursorX, this.cursorY);
    }

    public VirtualMouse shallowClone() {
        return new VirtualMouse(new HashSet<Integer>(this.pressedKeys), this.scrollWheel, this.cursorX, this.cursorY, null, this.ignoreFirstUpdate());
    }

    public VirtualMouse clone() {
        return new VirtualMouse(new HashSet<Integer>(this.pressedKeys), this.scrollWheel, this.cursorX, this.cursorY, new ArrayList<VirtualMouse>(this.subtickList), this.isIgnoreFirstUpdate());
    }

    @Override
    public void moveFrom(VirtualMouse mouse) {
        if (mouse == null) {
            return;
        }
        super.moveFrom(mouse);
        this.scrollWheel = mouse.scrollWheel;
        this.cursorX = mouse.cursorX;
        this.cursorY = mouse.cursorY;
        mouse.scrollWheel = 0;
    }

    @Override
    public void copyFrom(VirtualMouse mouse) {
        if (mouse == null) {
            return;
        }
        super.copyFrom(mouse);
        this.scrollWheel = mouse.scrollWheel;
        this.cursorX = mouse.cursorX;
        this.cursorY = mouse.cursorY;
    }

    @Override
    public void deepCopyFrom(VirtualMouse mouse) {
        if (mouse == null) {
            return;
        }
        super.deepCopyFrom(mouse);
        this.scrollWheel = mouse.scrollWheel;
        this.cursorX = mouse.cursorX;
        this.cursorY = mouse.cursorY;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof VirtualMouse) {
            VirtualMouse mouse = (VirtualMouse)obj;
            return super.equals(obj) && this.scrollWheel == mouse.scrollWheel && this.cursorX == mouse.cursorX && this.cursorY == mouse.cursorY;
        }
        return super.equals(obj);
    }

    public int getScrollWheel() {
        return this.scrollWheel;
    }

    public int getCursorX() {
        return this.cursorX;
    }

    public int getCursorY() {
        return this.cursorY;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.scrollWheel == 0 && this.cursorX == 0 && this.cursorY == 0;
    }

    public void getStates(List<VirtualMouse> reference) {
        if (this.isParent()) {
            reference.addAll(this.subtickList);
            reference.add(this.shallowClone());
        }
    }
}

