/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.virtual;

import com.google.common.collect.ImmutableSet;
import com.minecrafttas.tasmod.virtual.Subtickable;
import com.minecrafttas.tasmod.virtual.VirtualKey;
import com.minecrafttas.tasmod.virtual.VirtualKeybindings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class VirtualPeripheral<T extends VirtualPeripheral<T>>
extends Subtickable<T>
implements Serializable {
    protected final Set<Integer> pressedKeys;

    protected VirtualPeripheral(Set<Integer> pressedKeys, List<T> subtickList, boolean ignoreFirstUpdate) {
        super(subtickList, ignoreFirstUpdate);
        this.pressedKeys = pressedKeys;
    }

    protected void setPressed(int keycode, boolean keystate) {
        if (VirtualKeybindings.isKeyCodeAlwaysBlocked(keycode)) {
            return;
        }
        if (keystate) {
            this.pressedKeys.add(keycode);
        } else {
            this.pressedKeys.remove(keycode);
        }
    }

    public void setPressed(String keyname, boolean keystate) {
        Integer keycode = VirtualKey.getKeycode(keyname);
        if (keycode != null) {
            this.setPressed(keycode, keystate);
        }
    }

    public List<String> getCurrentPresses() {
        ArrayList<String> out = new ArrayList<String>();
        this.pressedKeys.forEach(keycode -> out.add(VirtualKey.getName(keycode)));
        return out;
    }

    public void createSubtick() {
    }

    public String toString() {
        return String.join((CharSequence)",", this.getCurrentPresses());
    }

    public Set<Integer> getPressedKeys() {
        return ImmutableSet.copyOf(this.pressedKeys);
    }

    public boolean isKeyDown(int keycode) {
        return this.pressedKeys.contains(keycode);
    }

    public boolean isKeyDown(String keyname) {
        return this.pressedKeys.contains(VirtualKey.getKeycode(keyname));
    }

    @Override
    protected void clear() {
        this.pressedKeys.clear();
        super.clear();
    }

    public boolean equals(Object obj) {
        if (obj instanceof VirtualPeripheral) {
            VirtualPeripheral peripheral = (VirtualPeripheral)obj;
            for (Integer keycode : this.pressedKeys) {
                if (peripheral.pressedKeys.contains(keycode)) continue;
                return false;
            }
            return true;
        }
        return super.equals(obj);
    }

    protected void moveFrom(T peripheral) {
        if (peripheral == null) {
            return;
        }
        this.deepCopyFrom(peripheral);
        ((VirtualPeripheral)peripheral).subtickList.clear();
        ((Subtickable)peripheral).resetFirstUpdate();
    }

    protected void copyFrom(T peripheral) {
        if (peripheral == null) {
            return;
        }
        this.pressedKeys.clear();
        this.pressedKeys.addAll(((VirtualPeripheral)peripheral).pressedKeys);
    }

    protected void deepCopyFrom(T peripheral) {
        if (peripheral == null || !((Subtickable)peripheral).isParent()) {
            return;
        }
        this.copyFrom(peripheral);
        this.subtickList.clear();
        this.subtickList.addAll(((VirtualPeripheral)peripheral).subtickList);
    }

    @Override
    public boolean isEmpty() {
        boolean flag = this.pressedKeys.isEmpty();
        if (this.pressedKeys.size() == 1) {
            flag = this.pressedKeys.contains(VirtualKey.ZERO.getKeycode()) || this.pressedKeys.contains(VirtualKey.MOUSEMOVED.getKeycode());
        }
        return super.isEmpty() && flag;
    }
}

