/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights;

import com.mojang.logging.LogUtils;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.petemc.undeadnights.client.render.DemolitionZombieRenderer;
import net.petemc.undeadnights.client.render.EliteZombieRenderer;
import net.petemc.undeadnights.client.render.HordeZombieRenderer;
import net.petemc.undeadnights.command.HordeMobsCommand;
import net.petemc.undeadnights.config.HordeConfig;
import net.petemc.undeadnights.config.MainConfig;
import net.petemc.undeadnights.config.difficulty.DifficultyConfig;
import net.petemc.undeadnights.config.difficulty.DifficultyConfigLoader;
import net.petemc.undeadnights.effect.ModEffects;
import net.petemc.undeadnights.entity.ModEntities;
import net.petemc.undeadnights.item.ModCreativeModeTabs;
import net.petemc.undeadnights.item.ModItems;
import net.petemc.undeadnights.potion.ModPotions;
import net.petemc.undeadnights.sound.UndeadNightsSounds;
import net.petemc.undeadnights.util.StateSaverAndLoader;
import net.petemc.undeadnights.world.spawner.HordeSpawner;
import org.slf4j.Logger;

@Mod(value="undeadnights")
public class UndeadNights {
    public static final String MOD_ID = "undeadnights";
    public static final String MOD_NAME = "UndeadNights";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static StateSaverAndLoader serverState = null;
    public static DifficultyConfig difficultyConfig;
    public static int globalSpawnCounter;
    public static boolean automaticDifficultyProgressionActive;

    public UndeadNights(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        UndeadNightsSounds.register(modEventBus);
        ModEntities.register(modEventBus);
        ModItems.register(modEventBus);
        ModEffects.register(modEventBus);
        ModPotions.register(modEventBus);
        ModCreativeModeTabs.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        context.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)MainConfig.SPEC_SERVER);
        HordeConfig.loadConfig();
        DifficultyConfigLoader.loadConfig();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Initializing the {} Mod", (Object)MOD_NAME);
        event.enqueueWork(() -> {
            ModEntities.initModEntities();
            PotionBrewing.m_43513_((Potion)Potions.f_43602_, (Item)((Item)ModItems.SLIMY_ROTTEN_FLESH.get()), (Potion)((Potion)ModPotions.LURE_HORDE_POTION.get()));
            PotionBrewing.m_43513_((Potion)((Potion)ModPotions.LURE_HORDE_POTION.get()), (Item)((Item)ModItems.SLIMY_ROTTEN_FLESH.get()), (Potion)((Potion)ModPotions.STRONG_LURE_HORDE_POTION.get()));
        });
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256731_) {
            event.accept(ModItems.HORDE_ZOMBIE_SPAWN_EGG);
            event.accept(ModItems.ELITE_ZOMBIE_SPAWN_EGG);
            event.accept(ModItems.DEMOLITION_ZOMBIE_SPAWN_EGG);
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("Initializing UndeadNights Mod");
        if (serverState == null) {
            serverState = StateSaverAndLoader.getServerState(event.getServer());
            difficultyConfig.setCurrentDifficultyLevel(difficultyConfig.getDifficultyLevels().get(serverState.getCurrentDifficultyLevelIndex()));
            automaticDifficultyProgressionActive = MainConfig.getEnableAutomaticDifficultyProgression();
            if (serverState.getLastMaxDaysCounter() != difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeNights().getDaysBetweenHordeNights().intValue()) {
                serverState.setDaysCounter(difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeNights().getDaysBetweenHordeNights());
                serverState.setLastMaxDaysCounter(difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeNights().getDaysBetweenHordeNights());
            }
            if (serverState.getLastMaxGracePeriod() != MainConfig.getGracePeriodBeforeFirstHordeNight()) {
                serverState.setGracePeriod(MainConfig.getGracePeriodBeforeFirstHordeNight());
                serverState.setLastMaxGracePeriod(MainConfig.getGracePeriodBeforeFirstHordeNight());
            }
            if (serverState.getLastMaxHordesCounter() != difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeNights().getMaxHordesPerHordeNight().intValue()) {
                if (difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeNights().getMaxHordesPerHordeNight() != 0) {
                    serverState.setHordesCounter(difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeNights().getMaxHordesPerHordeNight() + 1);
                } else {
                    serverState.setHordesCounter(0);
                }
                serverState.setLastMaxHordesCounter(difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeNights().getMaxHordesPerHordeNight());
            }
            if (!MainConfig.getNoNaturalSpawningBeforeFirstHordeNight()) {
                serverState.setIsNaturalSpawningOk(true);
            }
            if (MainConfig.getPrintDebugMessages()) {
                LOGGER.info("INIT DaysCounter: {} LastMaxDaysCounter: {}", (Object)serverState.getDaysCounter(), (Object)serverState.getLastMaxDaysCounter());
                LOGGER.info("INIT HordeNight: {} SpawnZombies: {} RespawnZombies: {}", new Object[]{serverState.getHordeNight(), serverState.getSpawnZombies(), serverState.getRespawnZombies()});
                LOGGER.info("INIT Difficulty level: {}", (Object)difficultyConfig.getCurrentDifficultyLevel().getDifficultyName());
            }
            HordeSpawner.hordeIdFromHordesConfig = HordeConfig.getDefaultHorde();
            HordeMobsCommand.hordeZombiesCanBreakBlocks = difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeMobs().isBlockBreaking();
            HordeMobsCommand.hordeZombiesBlockBreakingTier = difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeMobs().getBlockBreakingTier();
        }
    }

    static {
        globalSpawnCounter = 0;
        automaticDifficultyProgressionActive = false;
    }

    @Mod.EventBusSubscriber(modid="undeadnights", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.HORDE_ZOMBIE.get()), HordeZombieRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.DEMOLITION_ZOMBIE.get()), DemolitionZombieRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.ELITE_ZOMBIE.get()), EliteZombieRenderer::new);
        }
    }
}

