/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights.effect;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.petemc.undeadnights.UndeadNights;
import net.petemc.undeadnights.casts.UndeadNightsExtendedPlayer;
import net.petemc.undeadnights.effect.ModEffects;
import org.jetbrains.annotations.NotNull;

public class StrongLureHordeMobsEffect
extends MobEffect {
    private static final HashMap<UUID, CompletableFuture<Boolean>> cachedNearbyHordeMobsPerPlayer = new HashMap();

    public static CompletableFuture<Boolean> asynchronousSetPlayerAsTargetForNearbyHordeMobs(ServerLevel level, ServerPlayer player) {
        return CompletableFuture.supplyAsync(() -> StrongLureHordeMobsEffect.setPlayerAsTargetForNearbyHordeMobs(level, player), ForkJoinPool.commonPool());
    }

    private static Boolean setPlayerAsTargetForNearbyHordeMobs(ServerLevel level, ServerPlayer pPlayer) {
        Vec3 entityPosition = pPlayer.m_20182_();
        AABB entitySearchArea = new AABB(entityPosition, entityPosition).m_82400_(15.0);
        List<Entity> sortedEntityList = level.m_6443_(Entity.class, entitySearchArea, entityUUIDCheck -> UndeadNights.serverState.spawnedHordeMobs.contains(entityUUIDCheck.m_20148_())).stream().sorted(Comparator.comparingDouble(entityDistSort -> entityDistSort.m_20238_(entityPosition))).toList();
        for (Entity hordeMobIterator : sortedEntityList) {
            if (!(hordeMobIterator instanceof Mob)) continue;
            Mob mob = (Mob)hordeMobIterator;
            mob.m_6710_((LivingEntity)pPlayer);
        }
        return true;
    }

    public StrongLureHordeMobsEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
    }

    public void m_6742_(@NotNull LivingEntity pLivingEntity, int pAmplifier) {
        if (!pLivingEntity.m_9236_().m_5776_()) {
            Player player;
            boolean removeEffect = false;
            if (pLivingEntity instanceof Player && (player = (Player)pLivingEntity).m_21023_((MobEffect)ModEffects.LURE_HORDE.get())) {
                player.m_21195_((MobEffect)ModEffects.LURE_HORDE.get());
                removeEffect = true;
            }
            double chance = 0.08;
            if (pLivingEntity instanceof UndeadNightsExtendedPlayer) {
                UndeadNightsExtendedPlayer hordeLurePlayer = (UndeadNightsExtendedPlayer)pLivingEntity;
                if (removeEffect) {
                    hordeLurePlayer.undeadnights_setHordeLureEffect(false);
                }
                if (!hordeLurePlayer.undeadnights_hasHordeLureEffect()) {
                    chance = 20.0;
                }
                hordeLurePlayer.undeadnights_setHordeLureEffect(true);
            }
            if (pLivingEntity instanceof Player) {
                double randomValue;
                Player pPlayer = (Player)pLivingEntity;
                Level world = pPlayer.m_9236_();
                if (UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsLureEffect().isStrongLureHordeEffectSpawnsHorde().booleanValue() && !UndeadNights.serverState.entitiesWithReceivedHorde.contains(pPlayer.m_20148_())) {
                    UndeadNights.serverState.entitiesWithPendingHorde.add(pPlayer.m_20148_());
                }
                if ((randomValue = Math.random()) < chance / 10.0) {
                    if (!cachedNearbyHordeMobsPerPlayer.containsKey(pPlayer.m_20148_())) {
                        CompletableFuture<Boolean> future = StrongLureHordeMobsEffect.asynchronousSetPlayerAsTargetForNearbyHordeMobs((ServerLevel)world, (ServerPlayer)pPlayer);
                        cachedNearbyHordeMobsPerPlayer.put(pPlayer.m_20148_(), future);
                    } else {
                        CompletableFuture<Boolean> existingFuture = cachedNearbyHordeMobsPerPlayer.get(pPlayer.m_20148_());
                        if (existingFuture.isDone()) {
                            cachedNearbyHordeMobsPerPlayer.remove(pPlayer.m_20148_());
                        }
                    }
                }
            }
        }
        super.m_6742_(pLivingEntity, pAmplifier);
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }
}

