/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights.entity;

import java.time.LocalDate;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.ZombieAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.petemc.undeadnights.UndeadNights;
import net.petemc.undeadnights.config.HordeConfig;
import net.petemc.undeadnights.config.MainConfig;
import net.petemc.undeadnights.entity.DemolitionZombieEntity;
import net.petemc.undeadnights.entity.HordeZombieEntity;
import net.petemc.undeadnights.entity.ModEntities;
import net.petemc.undeadnights.entity.ai.goal.BreakBlockGoal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EliteZombieEntity
extends Zombie {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(EliteZombieEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);

    public EliteZombieEntity(EntityType<? extends Zombie> entityType, Level level) {
        super(entityType, level);
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        spawnGroupData = super.m_6518_(level, difficulty, mobSpawnType, spawnGroupData, compoundTag);
        float f = difficulty.m_19057_();
        this.m_21553_(this.f_19796_.m_188501_() < 0.55f * f);
        if (spawnGroupData == null) {
            spawnGroupData = new Zombie.ZombieGroupData(false, false);
        }
        if (spawnGroupData instanceof Zombie.ZombieGroupData) {
            this.m_34336_(true);
            this.m_213945_(this.f_19796_, difficulty);
            this.m_213946_(this.f_19796_, difficulty);
        }
        if (this.m_6844_(EquipmentSlot.HEAD).m_41619_()) {
            LocalDate localdate = LocalDate.now();
            int i = localdate.getDayOfMonth();
            int j = localdate.getMonth().getValue();
            if (j == 10 && i == 31 && this.f_19796_.m_188501_() < 0.25f) {
                this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)(this.f_19796_.m_188501_() < 0.1f ? Blocks.f_50144_ : Blocks.f_50143_)));
                this.f_21348_[EquipmentSlot.HEAD.m_20749_()] = 0.0f;
            }
        }
        Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22125_(new AttributeModifier("Elite zombie health bonus", MainConfig.getMaxHealthEliteZombies() - 20.0, AttributeModifier.Operation.ADDITION));
        int playerCount = 1;
        if (!this.m_9236_().f_46443_) {
            playerCount = this.m_9236_().m_6907_().size();
        }
        double healthScaleFactor = 0.0;
        double damageScaleFactor = 0.0;
        double speedScaleFactor = 0.0;
        double armorScaleFactor = 0.0;
        if (UndeadNights.difficultyConfig.getDynamicScaling().isDynamicScalingEnabled().booleanValue() && playerCount > 1) {
            healthScaleFactor = UndeadNights.difficultyConfig.getDynamicScaling().getHealthScalePerPlayer() * (double)(playerCount - 1);
            damageScaleFactor = UndeadNights.difficultyConfig.getDynamicScaling().getDamageScalePerPlayer() * (double)(playerCount - 1);
            speedScaleFactor = UndeadNights.difficultyConfig.getDynamicScaling().getSpeedScalePerPlayer() * (double)(playerCount - 1);
            armorScaleFactor = UndeadNights.difficultyConfig.getDynamicScaling().getArmorScalePerPlayer() * (double)(playerCount - 1);
            healthScaleFactor += UndeadNights.serverState.getCurrentHealthScale();
            damageScaleFactor += (double)UndeadNights.serverState.getCurrentDayScaleCounter();
            speedScaleFactor += UndeadNights.serverState.getCurrentSpeedScale();
            armorScaleFactor += UndeadNights.serverState.getCurrentArmorScale();
            if (healthScaleFactor > UndeadNights.difficultyConfig.getDynamicScaling().getMaxHealthScale()) {
                healthScaleFactor = UndeadNights.difficultyConfig.getDynamicScaling().getMaxHealthScale();
            }
            if (damageScaleFactor > UndeadNights.difficultyConfig.getDynamicScaling().getMaxDamageScale()) {
                damageScaleFactor = UndeadNights.difficultyConfig.getDynamicScaling().getMaxDamageScale();
            }
            if (speedScaleFactor > UndeadNights.difficultyConfig.getDynamicScaling().getMaxSpeedScale()) {
                speedScaleFactor = UndeadNights.difficultyConfig.getDynamicScaling().getMaxSpeedScale();
            }
            if (armorScaleFactor > UndeadNights.difficultyConfig.getDynamicScaling().getMaxArmorScale()) {
                armorScaleFactor = UndeadNights.difficultyConfig.getDynamicScaling().getMaxArmorScale();
            }
        }
        if (UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeMobs().isUpdateHordeMobAttributes().booleanValue()) {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22125_(new AttributeModifier("Elite zombie difficulty health bonus", UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeMobs().getHealthAttributeScaleFactor() - 1.0 + healthScaleFactor, AttributeModifier.Operation.MULTIPLY_BASE));
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22125_(new AttributeModifier("Elite zombie difficulty speed bonus", UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeMobs().getSpeedAttributeScaleFactor() - 1.0 + speedScaleFactor, AttributeModifier.Operation.MULTIPLY_BASE));
            Objects.requireNonNull(this.m_21051_(Attributes.f_22281_)).m_22125_(new AttributeModifier("Elite zombie difficulty attack damage bonus", UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeMobs().getDamageAttributeScaleFactor() - 1.0 + damageScaleFactor, AttributeModifier.Operation.MULTIPLY_BASE));
            Objects.requireNonNull(this.m_21051_(Attributes.f_22284_)).m_22125_(new AttributeModifier("Elite zombie difficulty armor bonus", UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeMobs().getArmorAttributeScaleFactor() - 1.0 + armorScaleFactor, AttributeModifier.Operation.MULTIPLY_BASE));
        }
        this.m_34339_(f);
        this.m_21153_(this.m_21233_());
        this.m_6863_(false);
        return spawnGroupData;
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder m_34328_() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeMobs().getHordeMobsTrackingRange().doubleValue()).m_22268_(Attributes.f_22279_, 0.32).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22287_, 0.0);
    }

    protected void m_6878_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BreakBlockGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new ZombieAttackGoal((Zombie)this, 1.0, false));
        this.f_21345_.m_25352_(4, (Goal)new ChasePlayerGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new MoveThroughVillageGoal((PathfinderMob)this, 1.0, true, 4, this::m_34330_));
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{HordeZombieEntity.class, EliteZombieEntity.class, DemolitionZombieEntity.class}).m_26044_(new Class[]{HordeZombieEntity.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true, entity -> HordeConfig.getTargetEntities().contains(entity.m_6095_().toString())));
    }

    protected void m_213945_(@NotNull RandomSource pRandom, @NotNull DifficultyInstance pDifficulty) {
        this.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42388_));
        this.initCustomEquipment(pRandom, pDifficulty);
    }

    protected void initCustomEquipment(RandomSource random, DifficultyInstance pDifficulty) {
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            Item item;
            ItemStack itemStack;
            if (equipmentSlot.m_20743_() != EquipmentSlot.Type.ARMOR || !(itemStack = this.m_6844_(equipmentSlot)).m_41619_() || (item = EliteZombieEntity.m_21412_((EquipmentSlot)equipmentSlot, (int)4)) == null) continue;
            this.m_8061_(equipmentSlot, new ItemStack((ItemLike)item));
        }
    }

    protected boolean m_7593_() {
        return false;
    }

    protected boolean m_5884_() {
        return UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeMobs().isHordeZombiesBurnInTheSun();
    }

    public boolean m_34330_() {
        return false;
    }

    public void m_34336_(boolean val) {
    }

    protected float m_6108_() {
        return UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeMobs().isHordeZombiesAreFasterOnWater() != false ? 0.94f : 0.8f;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    public boolean isBreakingBlock() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setBreakingBlock(boolean pClimbing) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        b0 = pClimbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)b0);
    }

    public void m_7572_() {
        Objects.requireNonNull(this.m_21051_(Attributes.f_22287_)).m_22100_(0.0);
    }

    public static void initSpawnConditions() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)ModEntities.ELITE_ZOMBIE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, serverLevel, reason, pos, random) -> MainConfig.getEliteZombiesSpawnNaturally() && UndeadNights.serverState.getIsNaturalSpawningOk() && !serverLevel.m_204166_(pos).m_203565_(Biomes.f_48215_) && serverLevel.m_46791_() != Difficulty.PEACEFUL && Monster.m_219009_((ServerLevelAccessor)serverLevel, (BlockPos)pos, (RandomSource)random) && Mob.m_217057_((EntityType)entityType, (LevelAccessor)serverLevel, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random));
    }

    public void m_7334_(@NotNull Entity entity) {
        super.m_7334_(entity);
    }

    static class ChasePlayerGoal
    extends Goal {
        private final EliteZombieEntity hordeZombie;
        @Nullable
        private LivingEntity target;

        public ChasePlayerGoal(EliteZombieEntity hordeZombie) {
            this.hordeZombie = hordeZombie;
        }

        public boolean m_8036_() {
            this.target = this.hordeZombie.m_5448_();
            return this.target instanceof Player;
        }

        public void m_8056_() {
            this.hordeZombie.m_21573_().m_26573_();
        }

        public void m_8037_() {
            assert (this.target != null);
            this.hordeZombie.m_21563_().m_24946_(this.target.m_20185_(), this.target.m_20188_(), this.target.m_20189_());
        }
    }
}

