/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights.mixin;

import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.petemc.undeadnights.casts.UndeadNightsExtendedPlayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public class PlayerEntityMixin
implements UndeadNightsExtendedPlayer {
    @Unique
    private boolean hasHordeLureEffect = false;
    @Unique
    private boolean isInCave = false;
    @Unique
    private boolean isInCaveStageOne = false;
    @Unique
    private boolean previousIsInCaveStageOne = false;
    @Unique
    private boolean isInCaveStageTwo = false;
    @Unique
    private boolean previousIsInCaveStageTwo = false;
    @Unique
    private int coolDown = 100;
    @Unique
    private int delay = 3;

    @Override
    public void undeadnights_setHordeLureEffect(boolean hordeLureValue) {
        this.hasHordeLureEffect = hordeLureValue;
    }

    @Override
    public boolean undeadnights_hasHordeLureEffect() {
        return this.hasHordeLureEffect;
    }

    @Override
    public void undeadnights_setIsInCave(boolean isInCaveValue) {
        this.isInCave = isInCaveValue;
    }

    @Override
    public boolean undeadnights_isInCave() {
        return this.isInCave;
    }

    @Override
    public boolean undeadnights_isInCaveDelayed() {
        return this.isInCaveStageOne;
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;updatePlayerPose()V", shift=At.Shift.AFTER)})
    public void tick(CallbackInfo ci) {
        Player player = (Player)this;
        if (!player.m_9236_().m_5776_()) {
            if (this.coolDown > 0) {
                --this.coolDown;
            } else {
                this.coolDown = 100;
                this.isInCaveStageOne = PlayerEntityMixin.caveCheckStageOne(player.m_9236_(), player.m_20183_());
                if (this.isInCaveStageOne) {
                    if (this.delay > 0) {
                        --this.delay;
                    } else {
                        this.delay = 3;
                        this.isInCaveStageTwo = PlayerEntityMixin.caveCheckStageTwo(player.m_9236_(), player.m_20183_());
                        if (this.isInCaveStageTwo) {
                            this.undeadnights_setIsInCave(true);
                        }
                    }
                } else {
                    this.isInCaveStageTwo = false;
                    this.previousIsInCaveStageTwo = false;
                    this.undeadnights_setIsInCave(false);
                    this.delay = 3;
                }
                if (this.previousIsInCaveStageOne != this.isInCaveStageOne) {
                    this.previousIsInCaveStageOne = this.isInCaveStageOne;
                }
                if (this.isInCaveStageTwo != this.previousIsInCaveStageTwo) {
                    this.previousIsInCaveStageTwo = this.isInCaveStageTwo;
                }
            }
        }
    }

    @Unique
    private static boolean caveCheckStageOne(Level level, BlockPos pos) {
        int z;
        int layersAbove = 0;
        int x = pos.m_123341_();
        int y = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z = pos.m_123343_());
        if (y == pos.m_123342_()) {
            return false;
        }
        y = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, x, z);
        if (y == pos.m_123342_()) {
            return false;
        }
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos(x, pos.m_123342_() + 1, z);
        while (checkPos.m_123342_() < y) {
            BlockState state = level.m_8055_((BlockPos)checkPos);
            if (state.m_60795_()) {
                layersAbove = 0;
                checkPos.m_122184_(0, 1, 0);
                continue;
            }
            if (state.m_60713_(Blocks.f_49990_)) {
                layersAbove = 0;
                checkPos.m_122184_(0, 1, 0);
                continue;
            }
            if (state.m_60713_(Blocks.f_152550_) && checkPos.m_123342_() > 8) {
                layersAbove = 0;
                checkPos.m_122184_(0, 1, 0);
                continue;
            }
            if (state.m_60713_(Blocks.f_50652_)) {
                layersAbove = 0;
                checkPos.m_122184_(0, 1, 0);
                continue;
            }
            if (state.m_204336_(BlockTags.f_13035_)) {
                layersAbove = 0;
                checkPos.m_122184_(0, 1, 0);
                continue;
            }
            if (++layersAbove > 3) {
                return true;
            }
            checkPos.m_122184_(0, 1, 0);
        }
        return false;
    }

    @Unique
    private static boolean caveCheckStageTwo(Level level, BlockPos pos) {
        AABB box = new AABB(pos).m_82377_(10.0, 0.0, 10.0);
        AtomicBoolean isCave = new AtomicBoolean(true);
        BlockPos.MutableBlockPos.m_121921_((AABB)box).forEach(c -> {
            int y1 = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, c.m_123341_(), c.m_123343_());
            if (c.m_123342_() + 5 >= y1) {
                isCave.set(false);
            }
        });
        return isCave.get();
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void injectToReadNbt(CompoundTag nbt, CallbackInfo ci) {
        this.isInCave = nbt.m_128471_("undeadnights_is_player_in_cave");
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void injectToWriteNbt(CompoundTag nbt, CallbackInfo ci) {
        nbt.m_128379_("undeadnights_is_player_in_cave", this.isInCave);
    }
}

