/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights.util;

import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.petemc.undeadnights.UndeadNights;
import net.petemc.undeadnights.config.MainConfig;
import net.petemc.undeadnights.entity.HordeZombieEntity;
import net.petemc.undeadnights.entity.ModEntities;

public class SpawnLocationFinder {
    public static boolean isDarkEnoughToSpawn(ServerLevelAccessor level, BlockPos pos) {
        return level.m_45517_(LightLayer.BLOCK, pos) <= MainConfig.getMaxBlockLightLevelForMonsterSpawns();
    }

    public static boolean checkSpawnLocation(ServerLevel level, double x, double y, double z) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(x, y, z);
        BlockState blockState = level.m_8055_((BlockPos)mutable);
        Block block = blockState.m_60734_();
        boolean doesNotBlockMovement = block != Blocks.f_50033_ && block != Blocks.f_50570_;
        boolean notWater = true;
        boolean darkEnough = true;
        if (!MainConfig.getHordeWavesCanSpawnInWater()) {
            notWater = !blockState.m_60819_().m_205070_(FluidTags.f_13131_);
        }
        boolean notLeaves = true;
        if (!MainConfig.getHordeWavesCanSpawnOnTrees()) {
            boolean bl = notLeaves = !(blockState.m_60734_() instanceof LeavesBlock);
        }
        if (MainConfig.getBlockLightLevelsInfluenceMonsterSpawns()) {
            darkEnough = SpawnLocationFinder.isDarkEnoughToSpawn((ServerLevelAccessor)level, (BlockPos)mutable);
        }
        return doesNotBlockMovement && notLeaves && notWater && darkEnough;
    }

    public static BlockPos getBlockPosWithDistance(BlockPos pos, Level level, int distanceMin, int distanceMax) {
        double _z;
        RandomSource random = level.f_46441_;
        double _d = random.m_216332_(distanceMin, distanceMax);
        double _x = random.m_216332_(0, (int)_d);
        if (_x == 0.0) {
            _z = _d;
        } else {
            _z = Math.sqrt(_d * _d - _x * _x);
            if (random.m_188499_()) {
                _x *= -1.0;
            }
        }
        if (random.m_188499_()) {
            _z *= -1.0;
        }
        return new BlockPos(pos.m_123341_() + (int)_x, level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.m_123341_() + (int)_x, pos.m_123343_() + (int)_z), pos.m_123343_() + (int)_z);
    }

    public static BlockPos findNearbySurfaceSpawnPosition(ServerLevel level, BlockPos pos, RandomSource randomSource, boolean playerInCave) {
        int deltaX = randomSource.m_188503_(5);
        int deltaZ = randomSource.m_188503_(5);
        if (!randomSource.m_188499_()) {
            deltaX *= -1;
        }
        if (!randomSource.m_188499_()) {
            deltaZ *= -1;
        }
        int y = MainConfig.getHordeWavesCanSpawnOnTrees() ? level.m_6924_(Heightmap.Types.MOTION_BLOCKING, pos.m_123341_() + deltaX, pos.m_123343_() + deltaZ) : level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.m_123341_() + deltaX, pos.m_123343_() + deltaZ);
        return new BlockPos(pos.m_123341_() + deltaX, y, pos.m_123343_() + deltaZ);
    }

    public static BlockPos findEndPositionUsingMinecraftPathfinding(Level level, ServerPlayer player, int distance, boolean allowEndInWater) {
        if (level == null || player == null || distance <= 0) {
            return null;
        }
        boolean debug = MainConfig.getPrintDebugMessages();
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        int attempts = 600;
        int maxYDelta = 8;
        BlockPos start = player.m_20183_();
        if (!SpawnLocationFinder.isAABBFree(level, new AABB((double)start.m_123341_() + 0.5 - 0.3, (double)start.m_123342_(), (double)start.m_123343_() + 0.5 - 0.3, (double)start.m_123341_() + 0.5 + 0.3, (double)start.m_123342_() + 1.8, (double)start.m_123343_() + 0.5 + 0.3))) {
            if (debug) {
                UndeadNights.LOGGER.info("findEndUsingMinecraftPF: start pos AABB not free: {}", (Object)start);
            }
            return null;
        }
        HordeZombieEntity probe = new HordeZombieEntity((EntityType<? extends Zombie>)((EntityType)ModEntities.HORDE_ZOMBIE.get()), level);
        probe.m_6518_((ServerLevelAccessor)level, level.m_6436_(start), MobSpawnType.MOB_SUMMONED, null, null);
        level.m_7967_((Entity)probe);
        for (int i = 0; i < 600; ++i) {
            int dx = rnd.nextInt(-distance - 3, distance + 4);
            int dz = rnd.nextInt(-distance - 3, distance + 4);
            int cheb = Math.max(Math.abs(dx), Math.abs(dz));
            if (Math.abs(cheb - distance) > 4) continue;
            int cx = start.m_123341_() + dx;
            int cz = start.m_123343_() + dz;
            int baseY = start.m_123342_();
            for (int dy = -8; dy <= 8; ++dy) {
                int cy = baseY + dy;
                BlockPos cand = new BlockPos(cx, cy, cz);
                BlockState feet = level.m_8055_(cand);
                if (feet.m_60713_(Blocks.f_49991_) || feet.m_60819_().m_205070_(FluidTags.f_13132_) || !allowEndInWater && (feet.m_60713_(Blocks.f_49990_) || feet.m_60819_().m_205070_(FluidTags.f_13131_)) || MainConfig.getBlockLightLevelsInfluenceMonsterSpawns() && !SpawnLocationFinder.isDarkEnoughToSpawn((ServerLevelAccessor)level, cand) || !SpawnLocationFinder.hasSolidBlockBelow(level, cand) || !SpawnLocationFinder.isAABBFreeForSpawn(level, new AABB((double)cand.m_123341_() + 0.5 - 0.3, (double)cand.m_123342_() + 0.001, (double)cand.m_123343_() + 0.5 - 0.3, (double)cand.m_123341_() + 0.5 + 0.3, (double)cand.m_123342_() + 1.8 - 0.001, (double)cand.m_123343_() + 0.5 + 0.3))) continue;
                try {
                    PathNavigation nav = probe.m_21573_();
                    probe.m_6034_((double)cand.m_123341_() + 0.5, cand.m_123342_(), (double)cand.m_123343_() + 0.5);
                    Path path = nav.m_6570_((Entity)player, 0);
                    if (path != null) {
                        if (debug) {
                            UndeadNights.LOGGER.info("findEndUsingMinecraftPF: candidate {} accepted by vanilla navigation (attempt {})", (Object)cand, (Object)i);
                        }
                        probe.m_142687_(Entity.RemovalReason.DISCARDED);
                        return cand;
                    }
                    if (!debug) continue;
                    UndeadNights.LOGGER.info("findEndUsingMinecraftPF: candidate {} rejected by vanilla navigation (null/empty)", (Object)cand);
                    continue;
                }
                catch (Throwable t) {
                    UndeadNights.LOGGER.warn("findEndUsingMinecraftPF: navigation threw for candidate {}: {}", (Object)cand, (Object)t.toString());
                }
            }
        }
        probe.m_142687_(Entity.RemovalReason.DISCARDED);
        if (debug) {
            UndeadNights.LOGGER.info("findEndUsingMinecraftPF: no candidate found (distance={})", (Object)distance);
        }
        return null;
    }

    private static boolean isAABBFree(Level level, AABB box) {
        int minX = (int)Math.floor(box.f_82288_);
        int minY = (int)Math.floor(box.f_82289_);
        int minZ = (int)Math.floor(box.f_82290_);
        int maxX = (int)Math.floor(box.f_82291_);
        int maxY = (int)Math.floor(box.f_82292_);
        int maxZ = (int)Math.floor(box.f_82293_);
        for (int bx = minX; bx <= maxX; ++bx) {
            for (int by = minY; by <= maxY; ++by) {
                for (int bz = minZ; bz <= maxZ; ++bz) {
                    BlockPos bpos = new BlockPos(bx, by, bz);
                    BlockState state = level.m_8055_(bpos);
                    VoxelShape shape = state.m_60812_((BlockGetter)level, bpos);
                    if (shape.m_83281_() || state.m_60734_() instanceof FenceBlock || state.m_60734_() instanceof FenceGateBlock || state.m_60734_() instanceof DoorBlock) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean hasSolidBlockBelow(Level level, BlockPos center) {
        BlockPos below = center.m_7495_();
        if (below.m_123342_() < level.m_141937_()) {
            return false;
        }
        BlockState belowState = level.m_8055_(below);
        boolean hasCollision = !belowState.m_60812_((BlockGetter)level, below).m_83281_();
        boolean isSlab = belowState.m_204336_(BlockTags.f_13031_);
        boolean isStair = belowState.m_204336_(BlockTags.f_13030_);
        boolean isFence = belowState.m_60734_() instanceof FenceBlock;
        boolean isFenceGate = belowState.m_60734_() instanceof FenceGateBlock;
        boolean isDoor = belowState.m_60734_() instanceof DoorBlock;
        return hasCollision || isSlab || isStair || isFence || isFenceGate || isDoor;
    }

    private static boolean isAABBFreeForSpawn(Level level, AABB box) {
        int minX = (int)Math.floor(box.f_82288_);
        int minY = (int)Math.floor(box.f_82289_);
        int minZ = (int)Math.floor(box.f_82290_);
        int maxX = (int)Math.floor(box.f_82291_);
        int maxY = (int)Math.floor(box.f_82292_);
        int maxZ = (int)Math.floor(box.f_82293_);
        for (int bx = minX; bx <= maxX; ++bx) {
            for (int by = minY; by <= maxY; ++by) {
                for (int bz = minZ; bz <= maxZ; ++bz) {
                    BlockPos bpos = new BlockPos(bx, by, bz);
                    BlockState state = level.m_8055_(bpos);
                    VoxelShape shape = state.m_60812_((BlockGetter)level, bpos);
                    if (shape.m_83281_()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static BlockPos findSpawnablePosition(Level level, BlockPos center, int radius, int deltaY) {
        int dx;
        if (level == null || center == null) {
            return null;
        }
        int minY = level.m_141937_();
        int maxY = level.m_151558_() - 1;
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        float mobWidth = 0.6f;
        float mobHeight = 1.8f;
        boolean allowWater = MainConfig.getHordeWavesCanSpawnInWater();
        int attempts = 200;
        for (int i = 0; i < 200; ++i) {
            BlockPos cand;
            BlockState feet;
            dx = rnd.nextInt(-radius, radius + 1);
            int dz = rnd.nextInt(-radius, radius + 1);
            int dy = deltaY > 0 ? rnd.nextInt(-deltaY, deltaY + 1) : 0;
            int x = center.m_123341_() + dx;
            int z = center.m_123343_() + dz;
            int y = center.m_123342_() + dy;
            if (y < minY || y > maxY || (feet = level.m_8055_(cand = new BlockPos(x, y, z))).m_60713_(Blocks.f_49991_) || feet.m_60819_().m_205070_(FluidTags.f_13132_) || !SpawnLocationFinder.isValidSpawnPos(level, cand, 0.6f, 1.8f, allowWater)) continue;
            return cand;
        }
        for (int r = 0; r <= radius; ++r) {
            for (dx = -r; dx <= r; ++dx) {
                int[] zs;
                int[] nArray;
                if (r == 0) {
                    int[] nArray2 = new int[1];
                    nArray = nArray2;
                    nArray2[0] = 0;
                } else {
                    int[] nArray3 = new int[2];
                    nArray3[0] = -r;
                    nArray = nArray3;
                    nArray3[1] = r;
                }
                for (int zOff : zs = nArray) {
                    int x = center.m_123341_() + dx;
                    int z = center.m_123343_() + zOff;
                    for (int dy = -deltaY; dy <= deltaY; ++dy) {
                        BlockPos cand;
                        BlockState feet;
                        int y = center.m_123342_() + dy;
                        if (y < minY || y > maxY || (feet = level.m_8055_(cand = new BlockPos(x, y, z))).m_60713_(Blocks.f_49991_) || feet.m_60819_().m_205070_(FluidTags.f_13132_) || !SpawnLocationFinder.isValidSpawnPos(level, cand, 0.6f, 1.8f, allowWater)) continue;
                        return cand;
                    }
                }
            }
        }
        return null;
    }

    private static boolean isValidSpawnPos(Level level, BlockPos pos, float mobWidth, float mobHeight, boolean allowWater) {
        boolean feetIsLava;
        if (level == null || pos == null) {
            return false;
        }
        int minY = level.m_141937_();
        int maxY = level.m_151558_();
        if (pos.m_123342_() < minY || pos.m_123342_() >= maxY) {
            return false;
        }
        BlockState feetState = level.m_8055_(pos);
        boolean feetIsWater = feetState.m_60713_(Blocks.f_49990_) || feetState.m_60819_().m_205070_(FluidTags.f_13131_);
        boolean bl = feetIsLava = feetState.m_60713_(Blocks.f_49991_) || feetState.m_60819_().m_205070_(FluidTags.f_13132_);
        if (feetIsLava) {
            return false;
        }
        if (feetIsWater && !allowWater) {
            return false;
        }
        VoxelShape feetShape = feetState.m_60812_((BlockGetter)level, pos);
        if (!feetShape.m_83281_() && !feetIsWater) {
            return false;
        }
        double cx = (double)pos.m_123341_() + 0.5;
        double cz = (double)pos.m_123343_() + 0.5;
        double bottomY = pos.m_123342_();
        double topY = bottomY + (double)mobHeight;
        double halfWidth = (double)mobWidth / 2.0;
        double eps = 0.001;
        AABB box = new AABB(cx - halfWidth + 0.001, bottomY + 0.001, cz - halfWidth + 0.001, cx + halfWidth - 0.001, topY - 0.001, cz + halfWidth - 0.001);
        if (!SpawnLocationFinder.isAABBFreeForSpawn(level, box)) {
            return false;
        }
        if (!allowWater) {
            int bottomBlock = (int)Math.floor(box.f_82289_);
            int topBlock = (int)Math.floor(box.f_82292_);
            for (int by = bottomBlock; by <= topBlock; ++by) {
                BlockState s = level.m_8055_(new BlockPos(pos.m_123341_(), by, pos.m_123343_()));
                if (!s.m_60713_(Blocks.f_49990_) && !s.m_60819_().m_205070_(FluidTags.f_13131_)) continue;
                return false;
            }
        }
        return SpawnLocationFinder.hasSolidBlockBelow(level, pos);
    }
}

