/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights.config.difficulty;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.util.RandomSource;
import net.petemc.undeadnights.UndeadNights;
import net.petemc.undeadnights.config.difficulty.DifficultyLevel;
import net.petemc.undeadnights.config.difficulty.DifficultySettingDynamicScaling;
import net.petemc.undeadnights.config.difficulty.DifficultySettingsHordeMobs;
import net.petemc.undeadnights.config.difficulty.DifficultySettingsHordeNights;
import net.petemc.undeadnights.config.difficulty.DifficultySettingsHordes;
import net.petemc.undeadnights.config.difficulty.DifficultySettingsLureEffect;
import org.jetbrains.annotations.NotNull;

public class DifficultyConfig {
    private DifficultySettingDynamicScaling dynamicScaling = new DifficultySettingDynamicScaling();
    private List<DifficultyLevel> difficultyLevels;
    private DifficultyLevel currentDifficultyLevel;
    public static final DifficultySettingDynamicScaling defaultDynamicScalingValues = new DifficultySettingDynamicScaling(false, 0.05, 0.05, 0.0, 0.0, 10.0, 0.05, 0.05, 0.0, 0.0, 2.0, 2.0, 2.0, 2.0);
    public static final DifficultyLevel defaultDifficultyLevelValues = new DifficultyLevel("Level 1", 0, 0, 100, new DifficultySettingsHordeMobs(false, false, 1.0, 1.0, 1.0, 1.0, 128.0, false, true, false, true, false, 1), new DifficultySettingsHordeNights(5, 100, true, 45, 7, false, 0, 5), new DifficultySettingsHordes(false, 15, List.of(Integer.valueOf(1)), 1.0, "sequential"), new DifficultySettingsLureEffect(true, true, 0.07, 60, true, 0.2, true));
    private int internalConfigVersion;

    public DifficultyConfig() {
    }

    public DifficultyConfig(DifficultySettingDynamicScaling dynamicScaling, List<DifficultyLevel> difficultyLevels, DifficultyLevel currentDifficultyLevel, int internalConfigVersion) {
        this.dynamicScaling = dynamicScaling;
        this.difficultyLevels = difficultyLevels;
        this.currentDifficultyLevel = currentDifficultyLevel;
        this.internalConfigVersion = internalConfigVersion;
    }

    public List<DifficultyLevel> getDifficultyLevels() {
        return this.difficultyLevels;
    }

    public void setDifficultyLevels(List<DifficultyLevel> difficultyLevels) {
        this.difficultyLevels = difficultyLevels;
    }

    public DifficultyLevel getCurrentDifficultyLevel() {
        return this.currentDifficultyLevel;
    }

    public void setCurrentDifficultyLevel(DifficultyLevel currentDifficultyLevel) {
        this.currentDifficultyLevel = currentDifficultyLevel;
    }

    public DifficultySettingDynamicScaling getDynamicScaling() {
        return this.dynamicScaling;
    }

    public void setDynamicScaling(DifficultySettingDynamicScaling dynamicScaling) {
        this.dynamicScaling = dynamicScaling;
    }

    public boolean checkForDifficultyLevelSwitch(int currentDay, RandomSource randomSource) {
        UndeadNights.serverState.setCurrentDayScaleCounter(UndeadNights.serverState.getCurrentDayScaleCounter() + 1);
        if ((double)UndeadNights.serverState.getCurrentDayScaleCounter() == UndeadNights.difficultyConfig.getDynamicScaling().getDaysBetweenScaleIncreases()) {
            UndeadNights.serverState.setCurrentDayScaleCounter(0);
            UndeadNights.serverState.setCurrentHealthScale(UndeadNights.serverState.getCurrentHealthScale() + UndeadNights.difficultyConfig.getDynamicScaling().getDaysHealthScaleIncrease());
            UndeadNights.serverState.setCurrentDamageScale(UndeadNights.serverState.getCurrentDamageScale() + UndeadNights.difficultyConfig.getDynamicScaling().getDaysDamageScaleIncrease());
            UndeadNights.serverState.setCurrentSpeedScale(UndeadNights.serverState.getCurrentSpeedScale() + UndeadNights.difficultyConfig.getDynamicScaling().getDaysSpeedScaleIncrease());
            UndeadNights.serverState.setCurrentArmorScale(UndeadNights.serverState.getCurrentArmorScale() + UndeadNights.difficultyConfig.getDynamicScaling().getDaysArmorScaleIncrease());
            if (UndeadNights.serverState.getCurrentHealthScale() > UndeadNights.difficultyConfig.getDynamicScaling().getMaxHealthScale()) {
                UndeadNights.serverState.setCurrentHealthScale(UndeadNights.difficultyConfig.getDynamicScaling().getMaxHealthScale());
            }
            if (UndeadNights.serverState.getCurrentDamageScale() > UndeadNights.difficultyConfig.getDynamicScaling().getMaxDamageScale()) {
                UndeadNights.serverState.setCurrentDamageScale(UndeadNights.difficultyConfig.getDynamicScaling().getMaxDamageScale());
            }
            if (UndeadNights.serverState.getCurrentSpeedScale() > UndeadNights.difficultyConfig.getDynamicScaling().getMaxSpeedScale()) {
                UndeadNights.serverState.setCurrentSpeedScale(UndeadNights.difficultyConfig.getDynamicScaling().getMaxSpeedScale());
            }
            if (UndeadNights.serverState.getCurrentArmorScale() > UndeadNights.difficultyConfig.getDynamicScaling().getMaxArmorScale()) {
                UndeadNights.serverState.setCurrentArmorScale(UndeadNights.difficultyConfig.getDynamicScaling().getMaxArmorScale());
            }
        }
        if (UndeadNights.serverState.getCurrentDifficultyLevelIndex() + 1 < UndeadNights.difficultyConfig.getDifficultyLevels().size()) {
            int randomValue;
            DifficultyLevel nextDifficultyLevel = UndeadNights.difficultyConfig.getDifficultyLevels().get(UndeadNights.serverState.getCurrentDifficultyLevelIndex() + 1);
            if (currentDay >= nextDifficultyLevel.getMaxStartDay()) {
                UndeadNights.difficultyConfig.setCurrentDifficultyLevel(nextDifficultyLevel);
                UndeadNights.serverState.setCurrentDifficultyLevelIndex(UndeadNights.serverState.getCurrentDifficultyLevelIndex() + 1);
                return true;
            }
            if (currentDay >= nextDifficultyLevel.getMinStartDay() && currentDay < nextDifficultyLevel.getMaxStartDay() && (randomValue = randomSource.m_216332_(1, 100)) > 100 - nextDifficultyLevel.getChanceForDifficultyLevelSwitch()) {
                UndeadNights.difficultyConfig.setCurrentDifficultyLevel(nextDifficultyLevel);
                UndeadNights.serverState.setCurrentDifficultyLevelIndex(UndeadNights.serverState.getCurrentDifficultyLevelIndex() + 1);
                UndeadNights.LOGGER.info("Switching to new difficulty level: {}", (Object)nextDifficultyLevel.getDifficultyName());
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static JsonObject createDefaultConfigJsonObject() {
        JsonArray difficultyLevelArray = new JsonArray();
        JsonArray listOfPossibleHordes = new JsonArray();
        JsonObject difficultyLevel = new JsonObject();
        difficultyLevel.addProperty("difficultyName", defaultDifficultyLevelValues.getDifficultyName());
        difficultyLevel.addProperty("minStartDay", (Number)defaultDifficultyLevelValues.getMinStartDay());
        difficultyLevel.addProperty("maxStartDay", (Number)defaultDifficultyLevelValues.getMaxStartDay());
        difficultyLevel.addProperty("chanceForDifficultyLevelSwitch", (Number)defaultDifficultyLevelValues.getChanceForDifficultyLevelSwitch());
        DifficultySettingsHordeNights hordeNightsValues = defaultDifficultyLevelValues.getDifficultySettingsHordeNights();
        JsonObject difficultySettingsHordeNights = new JsonObject();
        difficultySettingsHordeNights.addProperty("daysBetweenHordeNights", (Number)hordeNightsValues.getDaysBetweenHordeNights());
        difficultySettingsHordeNights.addProperty("chanceForHordeNight", (Number)hordeNightsValues.getChanceForHordeNight());
        difficultySettingsHordeNights.addProperty("spawnAdditionalWaves", hordeNightsValues.isSpawnAdditionalWaves());
        difficultySettingsHordeNights.addProperty("cooldownBetweenWaves", (Number)hordeNightsValues.getCooldownBetweenWaves());
        difficultySettingsHordeNights.addProperty("chanceForAdditionalWave", (Number)hordeNightsValues.getChanceForAdditionalWave());
        difficultySettingsHordeNights.addProperty("allDayLongHordeNights", hordeNightsValues.getAllDayLongHordeNights());
        difficultySettingsHordeNights.addProperty("maxHordesPerHordeNight", (Number)hordeNightsValues.getMaxHordesPerHordeNight());
        difficultySettingsHordeNights.addProperty("numberOfPlayersToGetHordePerHordeEvent", (Number)hordeNightsValues.getNumberOfPlayersToGetHordePerHordeEvent());
        difficultyLevel.add("difficultySettingsHordeNights", (JsonElement)difficultySettingsHordeNights);
        DifficultySettingsHordeMobs hordeMobsValues = defaultDifficultyLevelValues.getDifficultySettingsHordeMobs();
        JsonObject difficultySettingsHordeMobs = new JsonObject();
        difficultySettingsHordeMobs.addProperty("updateHordeMobAttributes", hordeMobsValues.isUpdateHordeMobAttributes());
        difficultySettingsHordeMobs.addProperty("updateAttributesOfThirdPartyMobs", hordeMobsValues.isUpdateAttributesOfThirdPartyMobs());
        difficultySettingsHordeMobs.addProperty("healthAttributeScaleFactor", (Number)hordeMobsValues.getHealthAttributeScaleFactor());
        difficultySettingsHordeMobs.addProperty("damageAttributeScaleFactor", (Number)hordeMobsValues.getDamageAttributeScaleFactor());
        difficultySettingsHordeMobs.addProperty("speedAttributeScaleFactor", (Number)hordeMobsValues.getSpeedAttributeScaleFactor());
        difficultySettingsHordeMobs.addProperty("armorAttributeScaleFactor", (Number)hordeMobsValues.getArmorAttributeScaleFactor());
        difficultySettingsHordeMobs.addProperty("hordeMobsTrackingRange", (Number)hordeMobsValues.getHordeMobsTrackingRange());
        difficultySettingsHordeMobs.addProperty("hordeZombiesBurnInTheSun", hordeMobsValues.isHordeZombiesBurnInTheSun());
        difficultySettingsHordeMobs.addProperty("vanillaZombiesBurnInTheSun", hordeMobsValues.isVanillaZombiesBurnInTheSun());
        difficultySettingsHordeMobs.addProperty("hordeZombiesAreFasterOnWater", hordeMobsValues.isHordeZombiesAreFasterOnWater());
        difficultySettingsHordeMobs.addProperty("hordeMobsCanClimbEachOther", hordeMobsValues.isHordeMobsCanClimbEachOther());
        difficultySettingsHordeMobs.addProperty("blockBreaking", hordeMobsValues.isBlockBreaking());
        difficultySettingsHordeMobs.addProperty("blockBreakingTier", (Number)hordeMobsValues.getBlockBreakingTier());
        difficultyLevel.add("difficultySettingsHordeMobs", (JsonElement)difficultySettingsHordeMobs);
        DifficultySettingsHordes hordesValues = defaultDifficultyLevelValues.getDifficultySettingsHordes();
        JsonObject difficultySettingsHordes = new JsonObject();
        difficultySettingsHordes.addProperty("hordeSizeScaleFactor", (Number)hordesValues.getHordeSizeScaleFactor());
        difficultySettingsHordes.addProperty("enableRandomHordes", hordesValues.isEnableRandomHordes());
        difficultySettingsHordes.addProperty("chanceForRandomHorde", (Number)hordesValues.getChanceForRandomHorde());
        difficultySettingsHordes.addProperty("hordeSelectionMode", hordesValues.getHordeSelectionMode());
        listOfPossibleHordes = new JsonArray();
        if (hordesValues.getListOfPossibleHordes() != null) {
            for (Integer hordeId : hordesValues.getListOfPossibleHordes()) {
                listOfPossibleHordes.add((Number)hordeId);
            }
        }
        difficultySettingsHordes.add("listOfPossibleHordes", (JsonElement)listOfPossibleHordes);
        difficultyLevel.add("difficultySettingsHordes", (JsonElement)difficultySettingsHordes);
        DifficultySettingsLureEffect lureEffectValues = defaultDifficultyLevelValues.getDifficultySettingsLureEffect();
        JsonObject difficultySettingsLureEffect = new JsonObject();
        difficultySettingsLureEffect.addProperty("enableLureHordeEffect", lureEffectValues.isEnableLureHordeEffect());
        difficultySettingsLureEffect.addProperty("nonHordeZombiesCanCauseLureHordeEffect", lureEffectValues.isNonHordeZombiesCanCauseLureHordeEffect());
        difficultySettingsLureEffect.addProperty("chanceForLureHordeEffect", (Number)lureEffectValues.getChanceForLureHordeEffect());
        difficultySettingsLureEffect.addProperty("durationForLureHordeEffect", (Number)lureEffectValues.getDurationForLureHordeEffect());
        difficultySettingsLureEffect.addProperty("lureHordeEffectSpawnsHorde", lureEffectValues.isLureHordeEffectSpawnsHorde());
        difficultySettingsLureEffect.addProperty("chanceForLureEffectToSpawnHorde", (Number)lureEffectValues.getChanceForLureEffectToSpawnHorde());
        difficultySettingsLureEffect.addProperty("strongLureHordeEffectSpawnsHorde", lureEffectValues.isStrongLureHordeEffectSpawnsHorde());
        difficultyLevel.add("difficultySettingsLureEffect", (JsonElement)difficultySettingsLureEffect);
        difficultyLevelArray.add((JsonElement)difficultyLevel);
        JsonObject difficultySettingsDynamicScaling = new JsonObject();
        difficultySettingsDynamicScaling.addProperty("dynamicScalingEnabled", defaultDynamicScalingValues.isDynamicScalingEnabled());
        difficultySettingsDynamicScaling.addProperty("healthScalePerPlayer", (Number)defaultDynamicScalingValues.getHealthScalePerPlayer());
        difficultySettingsDynamicScaling.addProperty("damageScalePerPlayer", (Number)defaultDynamicScalingValues.getDamageScalePerPlayer());
        difficultySettingsDynamicScaling.addProperty("speedScalePerPlayer", (Number)defaultDynamicScalingValues.getSpeedScalePerPlayer());
        difficultySettingsDynamicScaling.addProperty("armorScalePerPlayer", (Number)defaultDynamicScalingValues.getArmorScalePerPlayer());
        difficultySettingsDynamicScaling.addProperty("daysBetweenScaleIncreases", (Number)defaultDynamicScalingValues.getDaysBetweenScaleIncreases());
        difficultySettingsDynamicScaling.addProperty("daysHealthScaleIncrease", (Number)defaultDynamicScalingValues.getDaysHealthScaleIncrease());
        difficultySettingsDynamicScaling.addProperty("daysDamageScaleIncrease", (Number)defaultDynamicScalingValues.getDaysDamageScaleIncrease());
        difficultySettingsDynamicScaling.addProperty("daysSpeedScaleIncrease", (Number)defaultDynamicScalingValues.getDaysSpeedScaleIncrease());
        difficultySettingsDynamicScaling.addProperty("daysArmorScaleIncrease", (Number)defaultDynamicScalingValues.getDaysArmorScaleIncrease());
        difficultySettingsDynamicScaling.addProperty("maxHealthScale", (Number)defaultDynamicScalingValues.getMaxHealthScale());
        difficultySettingsDynamicScaling.addProperty("maxDamageScale", (Number)defaultDynamicScalingValues.getMaxDamageScale());
        difficultySettingsDynamicScaling.addProperty("maxSpeedScale", (Number)defaultDynamicScalingValues.getMaxSpeedScale());
        difficultySettingsDynamicScaling.addProperty("maxArmorScale", (Number)defaultDynamicScalingValues.getMaxArmorScale());
        JsonObject defaultConfObject = new JsonObject();
        defaultConfObject.add("dynamicScaling", (JsonElement)difficultySettingsDynamicScaling);
        defaultConfObject.add("difficultyLevels", (JsonElement)difficultyLevelArray);
        defaultConfObject.addProperty("internalConfigVersion", (Number)1);
        return defaultConfObject;
    }
}

