/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights.event;

import com.mojang.brigadier.CommandDispatcher;
import java.util.Comparator;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.ZombieEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.command.ConfigCommand;
import net.petemc.undeadnights.UndeadNights;
import net.petemc.undeadnights.casts.BlockBreakingZombie;
import net.petemc.undeadnights.command.DifficultyLevelCommand;
import net.petemc.undeadnights.command.HordeMobsCommand;
import net.petemc.undeadnights.command.SetDefaultHordeCommand;
import net.petemc.undeadnights.command.SpawnHordeCommand;
import net.petemc.undeadnights.command.StatusCommand;
import net.petemc.undeadnights.config.MainConfig;
import net.petemc.undeadnights.entity.DemolitionZombieEntity;
import net.petemc.undeadnights.entity.EliteZombieEntity;
import net.petemc.undeadnights.entity.HordeZombieEntity;
import net.petemc.undeadnights.entity.ai.goal.BreakBlockGoal;
import net.petemc.undeadnights.util.ModTags;

public class ModEvents {

    @Mod.EventBusSubscriber(modid="undeadnights")
    public static class ForgeEvents {
        @SubscribeEvent
        public static void denyReinforcementsForHordeZombies(ZombieEvent.SummonAidEvent event) {
            if (event.getEntity() instanceof DemolitionZombieEntity || event.getEntity() instanceof HordeZombieEntity || event.getEntity() instanceof EliteZombieEntity) {
                event.setResult(Event.Result.DENY);
            }
        }

        @SubscribeEvent
        public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
            if (!event.getLevel().m_5776_() && UndeadNights.serverState != null && UndeadNights.serverState.spawnedHordeMobs.contains(event.getEntity().m_20148_())) {
                if (UndeadNights.serverState.hordeMobsToRemove.contains(event.getEntity().m_20148_())) {
                    UndeadNights.serverState.hordeMobsToRemove.remove(event.getEntity().m_20148_());
                    event.getEntity().m_142687_(Entity.RemovalReason.DISCARDED);
                    event.setCanceled(true);
                    if (MainConfig.getPrintDebugMessages()) {
                        UndeadNights.LOGGER.info("LOAD canceled, Entity marked for removal: {}", (Object)event.getEntity().m_20148_());
                    }
                } else {
                    ++UndeadNights.globalSpawnCounter;
                    Entity entity = event.getEntity();
                    if (entity instanceof Zombie) {
                        Zombie zombie = (Zombie)entity;
                        if (!(zombie instanceof HordeZombieEntity || zombie instanceof DemolitionZombieEntity || zombie instanceof EliteZombieEntity)) {
                            if (MainConfig.getPrintDebugMessages()) {
                                UndeadNights.LOGGER.info("Vanilla zombie detected, adding float and block breaking goals.");
                            }
                            zombie.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)zombie));
                            zombie.f_21345_.m_25352_(1, (Goal)new BreakBlockGoal(zombie));
                        }
                        if (zombie instanceof EliteZombieEntity) {
                            UndeadNights.serverState.setFirstEliteZombieHasSpawned(true);
                        }
                        if (zombie instanceof DemolitionZombieEntity) {
                            UndeadNights.serverState.setFirstDemolitionZombieHasSpawned(true);
                        }
                    }
                }
                if (MainConfig.getPrintDebugMessages()) {
                    UndeadNights.LOGGER.info("LOAD GlobalSpawnCount: : {} {} {}", new Object[]{UndeadNights.globalSpawnCounter, event.getEntity().m_7755_().getString(), event.getEntity().m_20148_()});
                }
            }
        }

        @SubscribeEvent
        public static void onEntityLeaveWorld(EntityLeaveLevelEvent event) {
            if (!event.getLevel().m_5776_() && UndeadNights.serverState != null && UndeadNights.serverState.spawnedHordeMobs.contains(event.getEntity().m_20148_()) && event.getEntity().m_146911_() != null && (event.getEntity().m_146911_() == Entity.RemovalReason.KILLED || event.getEntity().m_146911_() == Entity.RemovalReason.DISCARDED)) {
                --UndeadNights.globalSpawnCounter;
                UndeadNights.serverState.spawnedHordeMobs.remove(event.getEntity().m_20148_());
                if (MainConfig.getPrintDebugMessages() && event.getEntity().m_146911_() != null) {
                    UndeadNights.LOGGER.info("UNLOAD GlobalSpawnCount: {} {} {}", new Object[]{UndeadNights.globalSpawnCounter, event.getEntity().m_146911_().name(), event.getEntity().m_20148_()});
                }
            }
        }

        @SubscribeEvent
        public static void onCommandsRegister(RegisterCommandsEvent event) {
            new SpawnHordeCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            new HordeMobsCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            new StatusCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            new SetDefaultHordeCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            new DifficultyLevelCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            ConfigCommand.register((CommandDispatcher)event.getDispatcher());
        }

        @SubscribeEvent
        public static void onEntityTick(LivingEvent.LivingTickEvent event) {
            Level world = event.getEntity().m_9236_();
            LivingEntity entity = event.getEntity();
            if (entity == null) {
                return;
            }
            if (entity.m_6095_().m_204039_(ModTags.EntityTypes.HORDE_MOBS)) {
                BlockBreakingZombie blockBreakingZombie;
                EliteZombieEntity eliteZombieEntity;
                HordeZombieEntity hordeZombie;
                if (entity instanceof HordeZombieEntity && (hordeZombie = (HordeZombieEntity)entity).isBreakingBlock()) {
                    return;
                }
                if (entity instanceof EliteZombieEntity && (eliteZombieEntity = (EliteZombieEntity)entity).isBreakingBlock()) {
                    return;
                }
                if (entity instanceof BlockBreakingZombie && (blockBreakingZombie = (BlockBreakingZombie)entity).isBreakingBlock()) {
                    return;
                }
                if (UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeMobs().isHordeMobsCanClimbEachOther().booleanValue()) {
                    Vec3 entityPosition = entity.m_20182_();
                    AABB entitySearchArea = new AABB(entityPosition, entityPosition).m_82400_(0.225);
                    List<Entity> sortedEntityList = world.m_6443_(Entity.class, entitySearchArea, entityTagCheck -> entityTagCheck.m_6095_().m_204039_(ModTags.EntityTypes.HORDE_MOBS)).stream().sorted(Comparator.comparingDouble(entityDistSort -> entityDistSort.m_20238_(entityPosition))).toList();
                    for (Entity hordeMobIterator : sortedEntityList) {
                        if (entity.m_20185_() == hordeMobIterator.m_20185_()) continue;
                        double randomValue = Math.random();
                        if (randomValue > 0.16) {
                            randomValue = 0.16;
                        }
                        Vec3 entityVec3 = new Vec3(entity.m_20184_().m_7096_() + randomValue / 20.0 * (double)Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)-1, (int)1), randomValue, entity.m_20184_().m_7094_() + randomValue / 20.0 * (double)Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)-1, (int)1));
                        entity.m_20256_(entityVec3);
                        if (entity instanceof LivingEntity) {
                            LivingEntity livingEntity = entity;
                            if (livingEntity.m_6162_()) {
                                entity.m_20256_(entityVec3.m_82520_(0.0, randomValue, 0.0));
                            }
                            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 5, 0, false, false));
                        }
                        entity.f_19789_ = 0.0f;
                    }
                }
            }
        }
    }
}

