/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights.config;

import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;

@Config(name="undeadnights")
public class MainConfig
implements ConfigData {
    @ConfigEntry.Gui.Excluded
    public static MainConfig INSTANCE;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, Nights of the Undead (horde nights) are enabled | default: true")
    private boolean undeadNightsEnabled = true;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="Grace period in days before the first horde night | default: 0)\nAfter the grace period the first horde night will happen and)\nafter the first horde night only the config values daysBetweenHordeNights\")\nand chanceForHordeNight will be taken into consideration.\")\nNote: if the grace period is set to 0 the first horde night will occur after\")\nthe number of days set with daysBetweenHordeNights below.\")")
    private int gracePeriodBeforeFirstHordeNight = 0;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="Days between horde nights (1 = every night is a horde night) | default: 5")
    private int daysBetweenHordeNights = 5;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="Chance in % for a horde night | default: 100")
    private int chanceForHordeNight = 100;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="Maximum number of hordes that can spawn per horde night (0 = unlimited) | default: 0")
    private int maxHordesPerHordeNight = 0;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, each night a message will be sent to the player with how many nights are left before the next Horde Night | default: false")
    private boolean sendHordeNightsCountdownMessage = false;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, the horde has spawned message and the horde sound are enabled | default: true")
    private boolean hordeSpawnedMessageAndSound = true;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="Minimum distance a horde will spawn away from the player | default: 70")
    private int distanceMin = 70;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="Maximum distance a horde will spawn away from the player | default: 75")
    private int distanceMax = 75;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="Maximum amount of horde mobs that can be loaded in the world at the same time | default: 80")
    private int hordeMobsSpawnCap = 80;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, additional waves can spawn in a horde night | default: true")
    private boolean spawnAdditionalWaves = true;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="Time in seconds between check for next possible wave in a horde night | default: 45")
    private int cooldownBetweenWaves = 45;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="Chance in % for another horde wave | default: 7")
    private int chanceForAdditionalWaves = 7;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, horde waves can spawn in water | default: false")
    private boolean hordeWavesCanSpawnInWater = false;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, horde waves can spawn on trees | default: false")
    private boolean hordeWavesCanSpawnOnTrees = false;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, the light level of the block position can prevent horde mobs from spawning | default: false")
    private boolean blockLightLevelsInfluenceMonsterSpawns = false;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="Maximum block light level so a monster can spawn | default: 0")
    private int maxBlockLightLevelForMonsterSpawns = 0;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, Players can't sleep through horde nights | default: true")
    private boolean hordeNightsDisableSleeping = true;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, the horde mobs will be persistent and not despawn | default: false")
    private boolean persistentMobs = false;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, the horde zombies will burn in daylight (only those added by this mod) | default: false")
    private boolean hordeZombiesBurnInDaylight = false;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, the vanilla zombies will burn in daylight | default: true")
    private boolean vanillaZombiesBurnInDaylight = true;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, (Horde, Elite and vanilla) zombies can push each other up (WWZ style) | default: true")
    private boolean hordeZombiesCanPushEachOtherUp = true;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, (Horde, Elite and vanilla) zombies can break blocks | default: false")
    private boolean hordeZombiesCanBreakBlocks = false;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="Horde Zombie block break tier (0-4) | default: 1")
    private int zombiesBlockBreakTier = 1;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, Horde Zombies (incl. vanilla) have increased water movement speed | default: false")
    private boolean hordeZombiesHaveIncreasedWaterMovementSpeed = false;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, a random horde can spawn on none-horde nights | default: false")
    private boolean enableRandomHordes = false;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="Chance in % for a random horde (checked once per night, on none-horde nights) | default: 15")
    private int chanceForRandomHordes = 15;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, killing a horde mob can give the player the lure horde effect (this will attract horde mobs in the area) | default: true")
    private boolean enableLureHordeEffect = true;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, killing zombies that were not spawned in a horde can also give the player the lure horde effect | default: true")
    private boolean nonHordeZombiesCanCauseLureHordeEffect = true;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="Chance to get the lure horde effect, when the player kills a horde mob (1.0 = 100%) | default: 0.07")
    private double chanceForLureHordeEffect = 0.07;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="Duration in seconds for the lure horde effect | default: 60")
    private int durationForLureHordeEffect = 60;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, getting the lure horde effect can spawn a horde | default: true")
    private boolean lureHordeEffectSpawnsHorde = true;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="Chance for the lure horde effect to spawn a horde (1.0 = 100%) | default: 0.2")
    private double chanceForLureEffectToSpawnHorde = 0.2;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, Horde Zombies will spawn naturally | default: true")
    private boolean hordeZombiesSpawnNaturally = true;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, Elite Zombies will spawn naturally | default: true")
    private boolean eliteZombiesSpawnNaturally = true;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, Demolition Zombies will spawn naturally | default: true")
    private boolean demolitionZombiesSpawnNaturally = true;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, Horde, Elite and Demolition zombies will not spawn naturally before the first horde night | default: true")
    private boolean noNaturalSpawningBeforeFirstHordeNight = true;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="Horde zombie max health | default: 40.0")
    private double maxHealthHordeZombies = 40.0;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="Elite zombie max health | default: 40.0")
    private double maxHealthEliteZombies = 40.0;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="Demolition zombie max health | default: 40.0")
    private double maxHealthDemolitionZombies = 40.0;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, debug messages will be logged out | default: false")
    private boolean printDebugMessages = false;

    public static void init() {
        AutoConfig.register(MainConfig.class, JanksonConfigSerializer::new);
        INSTANCE = (MainConfig)AutoConfig.getConfigHolder(MainConfig.class).getConfig();
    }

    public static boolean getUndeadNightsEnabled() {
        return MainConfig.INSTANCE.undeadNightsEnabled;
    }

    public static int getGracePeriodBeforeFirstHordeNight() {
        return MainConfig.INSTANCE.gracePeriodBeforeFirstHordeNight;
    }

    public static int getDaysBetweenHordeNights() {
        return MainConfig.INSTANCE.daysBetweenHordeNights;
    }

    public static int getChanceForHordeNight() {
        return MainConfig.INSTANCE.chanceForHordeNight;
    }

    public static int getMaxHordesPerHordeNight() {
        return MainConfig.INSTANCE.maxHordesPerHordeNight;
    }

    public static boolean getSendHordeNightsCountdownMessage() {
        return MainConfig.INSTANCE.sendHordeNightsCountdownMessage;
    }

    public static boolean getHordeSpawnedMessageAndSound() {
        return MainConfig.INSTANCE.hordeSpawnedMessageAndSound;
    }

    public static int getDistanceMin() {
        return MainConfig.INSTANCE.distanceMin;
    }

    public static int getDistanceMax() {
        return MainConfig.INSTANCE.distanceMax;
    }

    public static int getHordeMobsSpawnCap() {
        return MainConfig.INSTANCE.hordeMobsSpawnCap;
    }

    public static boolean getSpawnAdditionalWaves() {
        return MainConfig.INSTANCE.spawnAdditionalWaves;
    }

    public static int getCooldownBetweenWaves() {
        return MainConfig.INSTANCE.cooldownBetweenWaves;
    }

    public static int getChanceForAdditionalWaves() {
        return MainConfig.INSTANCE.chanceForAdditionalWaves;
    }

    public static boolean getHordeWavesCanSpawnInWater() {
        return MainConfig.INSTANCE.hordeWavesCanSpawnInWater;
    }

    public static boolean getHordeWavesCanSpawnOnTrees() {
        return MainConfig.INSTANCE.hordeWavesCanSpawnOnTrees;
    }

    public static boolean getBlockLightLevelsInfluenceMonsterSpawns() {
        return MainConfig.INSTANCE.blockLightLevelsInfluenceMonsterSpawns;
    }

    public static int getMaxBlockLightLevelForMonsterSpawns() {
        return MainConfig.INSTANCE.maxBlockLightLevelForMonsterSpawns;
    }

    public static boolean getHordeNightsDisableSleeping() {
        return MainConfig.INSTANCE.hordeNightsDisableSleeping;
    }

    public static boolean getPersistentMobs() {
        return MainConfig.INSTANCE.persistentMobs;
    }

    public static boolean getHordeZombiesBurnInDaylight() {
        return MainConfig.INSTANCE.hordeZombiesBurnInDaylight;
    }

    public static boolean getVanillaZombiesBurnInDaylight() {
        return MainConfig.INSTANCE.vanillaZombiesBurnInDaylight;
    }

    public static boolean getHordeZombiesCanPushEachOtherUp() {
        return MainConfig.INSTANCE.hordeZombiesCanPushEachOtherUp;
    }

    public static boolean getHordeZombiesCanBreakBlocks() {
        return MainConfig.INSTANCE.hordeZombiesCanBreakBlocks;
    }

    public static int getZombiesBlockBreakTier() {
        return MainConfig.INSTANCE.zombiesBlockBreakTier;
    }

    public static boolean getHordeZombiesHaveIncreasedWaterMovementSpeed() {
        return MainConfig.INSTANCE.hordeZombiesHaveIncreasedWaterMovementSpeed;
    }

    public static boolean getEnableRandomHordes() {
        return MainConfig.INSTANCE.enableRandomHordes;
    }

    public static int getChanceForRandomHordes() {
        return MainConfig.INSTANCE.chanceForRandomHordes;
    }

    public static boolean getEnableLureHordeEffect() {
        return MainConfig.INSTANCE.enableLureHordeEffect;
    }

    public static boolean getNonHordeZombiesCanCauseLureHordeEffect() {
        return MainConfig.INSTANCE.nonHordeZombiesCanCauseLureHordeEffect;
    }

    public static boolean getLureHordeEffectSpawnsHorde() {
        return MainConfig.INSTANCE.lureHordeEffectSpawnsHorde;
    }

    public static double getChanceForLureHordeEffect() {
        return MainConfig.INSTANCE.chanceForLureHordeEffect;
    }

    public static int getDurationForLureHordeEffect() {
        return MainConfig.INSTANCE.durationForLureHordeEffect;
    }

    public static double getChanceForLureEffectToSpawnHorde() {
        return MainConfig.INSTANCE.chanceForLureEffectToSpawnHorde;
    }

    public static boolean getHordeZombiesSpawnNaturally() {
        return MainConfig.INSTANCE.hordeZombiesSpawnNaturally;
    }

    public static boolean getEliteZombiesSpawnNaturally() {
        return MainConfig.INSTANCE.eliteZombiesSpawnNaturally;
    }

    public static boolean getDemolitionZombiesSpawnNaturally() {
        return MainConfig.INSTANCE.demolitionZombiesSpawnNaturally;
    }

    public static boolean getNoNaturalSpawningBeforeFirstHordeNight() {
        return MainConfig.INSTANCE.noNaturalSpawningBeforeFirstHordeNight;
    }

    public static double getMaxHealthHordeZombies() {
        return MainConfig.INSTANCE.maxHealthHordeZombies;
    }

    public static double getMaxHealthEliteZombies() {
        return MainConfig.INSTANCE.maxHealthEliteZombies;
    }

    public static double getMaxHealthDemolitionZombies() {
        return MainConfig.INSTANCE.maxHealthDemolitionZombies;
    }

    public static boolean getPrintDebugMessages() {
        return MainConfig.INSTANCE.printDebugMessages;
    }
}

