/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights.world.spawner;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1266;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1400;
import net.minecraft.class_1569;
import net.minecraft.class_1642;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2397;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3730;
import net.minecraft.class_5134;
import net.minecraft.class_5304;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import net.petemc.undeadnights.UndeadNights;
import net.petemc.undeadnights.command.SpawnHordeCommand;
import net.petemc.undeadnights.config.HordeConfig;
import net.petemc.undeadnights.config.MainConfig;
import net.petemc.undeadnights.effect.ModEffects;
import net.petemc.undeadnights.entity.DemolitionZombieEntity;
import net.petemc.undeadnights.entity.HordeZombieEntity;
import net.petemc.undeadnights.entity.ModEntities;
import net.petemc.undeadnights.entity.ai.goal.BreakBlockGoal;
import net.petemc.undeadnights.sound.UndeadNightsSounds;

public class UndeadSpawner
implements class_5304 {
    public static boolean invalidHordeMobEntry = false;
    public static int hordeToSpawn = 1;
    public static long prevNormalizedTimeOfDay = 0L;
    private double x = 0.0;
    private double z = 0.0;
    private double d = 0.0;

    public static boolean isDarkEnoughToSpawn(class_5425 level, class_2338 pos) {
        return level.method_8314(class_1944.field_9282, pos) <= MainConfig.getMaxBlockLightLevelForMonsterSpawns();
    }

    private boolean checkSpawnLocation(class_3218 world, double x, double y, double z) {
        class_2338.class_2339 mutable = new class_2338.class_2339(x, y, z);
        class_2680 blockState = world.method_8320((class_2338)mutable);
        class_2248 block = blockState.method_26204();
        boolean doesNotBlockMovement = block != class_2246.field_10343 && block != class_2246.field_10108;
        boolean notWater = true;
        boolean darkEnough = true;
        if (!MainConfig.getHordeWavesCanSpawnInWater()) {
            notWater = !blockState.method_26227().method_15767(class_3486.field_15517);
        }
        boolean notLeaves = true;
        if (!MainConfig.getHordeWavesCanSpawnOnTrees()) {
            boolean bl = notLeaves = !(blockState.method_26204() instanceof class_2397);
        }
        if (MainConfig.getBlockLightLevelsInfluenceMonsterSpawns()) {
            darkEnough = UndeadSpawner.isDarkEnoughToSpawn((class_5425)world, (class_2338)mutable);
        }
        return doesNotBlockMovement && notLeaves && notWater && darkEnough;
    }

    private class_2338 getBlockPosWithDistance(class_2338 pos, class_1937 world, int distanceMin, int distanceMax) {
        double _z;
        class_5819 random = world.field_9229;
        double _d = random.method_39332(distanceMin, distanceMax);
        double _x = random.method_39332(0, (int)_d);
        if (_x == 0.0) {
            _z = _d;
        } else {
            _z = Math.sqrt(_d * _d - _x * _x);
            if (random.method_43056()) {
                _x *= -1.0;
            }
        }
        if (random.method_43056()) {
            _z *= -1.0;
        }
        return new class_2338(pos.method_10263() + (int)_x, world.method_8624(class_2902.class_2903.field_13202, pos.method_10263() + (int)_x, pos.method_10260() + (int)_z), pos.method_10260() + (int)_z);
    }

    private int spawnHordeMob(class_3218 world, class_5819 randomSource, class_2338 pos, class_1657 player, HordeConfig.MobSpawnData mobSpawnData) {
        class_1299 mobType = (class_1299)class_7923.field_41177.method_63535(class_2960.method_60654((String)mobSpawnData.mobId()));
        if (!mobSpawnData.mobId().contains(mobType.method_35050())) {
            invalidHordeMobEntry = true;
            UndeadNights.LOGGER.warn("Reading entry {} from the config file failed! Spawning default horde zombie instead.", (Object)mobSpawnData.mobId());
        }
        int deltaX = randomSource.method_43048(5);
        int deltaZ = randomSource.method_43048(5);
        if (!randomSource.method_43056()) {
            deltaX *= -1;
        }
        if (!randomSource.method_43056()) {
            deltaZ *= -1;
        }
        int y = MainConfig.getHordeWavesCanSpawnOnTrees() ? world.method_8624(class_2902.class_2903.field_13197, pos.method_10263() + deltaX, pos.method_10260() + deltaZ) : world.method_8624(class_2902.class_2903.field_13203, pos.method_10263() + deltaX, pos.method_10260() + deltaZ);
        if (mobSpawnData.mobId().equals("minecraft:ghast")) {
            y = world.method_8624(class_2902.class_2903.field_13197, pos.method_10263() + deltaX, pos.method_10260() + deltaZ) + 20;
        }
        class_2487 nbtCompound = new class_2487();
        if (!Objects.equals(mobSpawnData.nbt(), "")) {
            try {
                nbtCompound = class_2522.method_67315((String)mobSpawnData.nbt());
            }
            catch (CommandSyntaxException e) {
                UndeadNights.LOGGER.error("Parsing NBT-tags for {} failed!", (Object)mobSpawnData.mobId());
            }
        }
        if (!invalidHordeMobEntry) {
            nbtCompound.method_10582("id", mobSpawnData.mobId());
        } else {
            nbtCompound.method_10582("id", "undeadnights:horde_zombie");
        }
        int finalY = y;
        int finalDeltaX = deltaX;
        int finalDeltaZ = deltaZ;
        class_1297 entity = class_1299.method_71371((class_2487)nbtCompound, (class_1937)world, (class_3730)class_3730.field_16462, entityx -> {
            entityx.method_5808((double)(pos.method_10263() + finalDeltaX), (double)finalY, (double)(pos.method_10260() + finalDeltaZ), entityx.method_36454(), entityx.method_36455());
            return entityx;
        });
        if (entity instanceof class_1569 && MainConfig.getBlockLightLevelsInfluenceMonsterSpawns() && !UndeadSpawner.isDarkEnoughToSpawn((class_5425)world, new class_2338(pos.method_10263() + deltaX, finalY, pos.method_10260() + deltaZ))) {
            UndeadNights.LOGGER.info("Horde mob {} can't spawn here, it's not dark enough!", (Object)mobSpawnData.mobId());
            return -1;
        }
        if (entity instanceof DemolitionZombieEntity) {
            DemolitionZombieEntity demolitionZombie = (DemolitionZombieEntity)entity;
            String str = mobSpawnData.extra();
            String[] strA = str.split(":");
            if (strA[0].equals("tnt")) {
                try {
                    int numberTnt = Integer.parseInt(strA[1]);
                    if (numberTnt > 64) {
                        numberTnt = 64;
                    }
                    demolitionZombie.setNumberTnt(numberTnt);
                }
                catch (Exception e) {
                    UndeadNights.LOGGER.warn("extraSpawnInfo for {} has non valid value, using default TNT stack size!", (Object)mobSpawnData.mobId());
                }
            } else {
                UndeadNights.LOGGER.warn("extraSpawnInfo for {} could be read, using default TNT stack size!", (Object)mobSpawnData.mobId());
            }
        }
        class_1266 localDifficulty = world.method_8404(player.method_24515());
        try {
            if (entity instanceof class_1308) {
                class_1308 mob = (class_1308)entity;
                mob.method_5943((class_5425)world, localDifficulty, class_3730.field_16459, null);
                mob.method_5980((class_1309)player);
                if (mobSpawnData.mobId().equals("minecraft:zombie")) {
                    mob.field_6201.method_6277(1, (class_1352)new class_1347(mob));
                    mob.field_6201.method_6277(1, (class_1352)new BreakBlockGoal((class_1642)mob));
                }
                if (!(mobSpawnData.mobId().equals("undeadnights:horde_zombie") || mobSpawnData.mobId().equals("undeadnights:elite_zombie") || mobSpawnData.mobId().equals("undeadnights:demolition_zombie"))) {
                    Objects.requireNonNull(mob.method_5996(class_5134.field_23717)).method_6192(128.0);
                    mob.field_6185.method_6277(1, (class_1352)new class_1400(mob, class_1657.class, false, false));
                }
            }
            assert (entity != null);
            UndeadNights.serverState.spawnedHordeMobs.put(entity.method_5667(), entity.method_5845());
            world.method_30736(entity);
        }
        catch (Exception e) {
            invalidHordeMobEntry = true;
            UndeadNights.LOGGER.warn("Reading entry {} from the config file failed! Spawning default horde zombie instead.", (Object)mobSpawnData.mobId());
            HordeZombieEntity hZombie = new HordeZombieEntity(ModEntities.HORDE_ZOMBIE, (class_1937)world);
            hZombie.method_23327(pos.method_10263() + deltaX, world.method_8624(class_2902.class_2903.field_13202, pos.method_10263() + deltaX, pos.method_10260() + deltaZ), pos.method_10260() + deltaZ);
            if (MainConfig.getPersistentMobs()) {
                hZombie.method_5971();
            }
            hZombie.method_5943((class_5425)world, localDifficulty, class_3730.field_16459, null);
            hZombie.method_5980((class_1309)player);
            UndeadNights.serverState.spawnedHordeMobs.put(hZombie.method_5667(), hZombie.method_5845());
            world.method_8649((class_1297)hZombie);
        }
        return 0;
    }

    public int spawnHorde(class_3218 world, class_3222 player, class_5819 randomSource) {
        int spawnCounter = 0;
        boolean foundHordeSpawnLocation = false;
        int currentHordeCounter = UndeadNights.globalSpawnCounter;
        for (int i = 0; i < 20; ++i) {
            int randomValue;
            if (this.d == 0.0) {
                this.d = randomSource.method_39332(MainConfig.getDistanceMin(), MainConfig.getDistanceMax());
                this.x = randomSource.method_39332(0, (int)this.d);
                if (this.x == 0.0) {
                    this.z = this.d;
                } else {
                    this.z = Math.sqrt(this.d * this.d - this.x * this.x);
                    if (randomSource.method_43056()) {
                        this.x *= -1.0;
                    }
                }
                if (randomSource.method_43056()) {
                    this.z *= -1.0;
                }
            }
            class_2338 pos = player.method_24515().method_10069((int)this.x, 0, (int)this.z);
            foundHordeSpawnLocation = this.checkSpawnLocation(world, (pos = new class_2338(pos.method_10263(), world.method_8624(class_2902.class_2903.field_13202, pos.method_10263(), pos.method_10260()), pos.method_10260())).method_10263(), pos.method_10264() - 1, pos.method_10260());
            if (!foundHordeSpawnLocation) {
                this.d = 0.0;
                this.x = 0.0;
                this.z = 0.0;
                continue;
            }
            if (MainConfig.getPrintDebugMessages()) {
                UndeadNights.LOGGER.info("A possible Horde spawn location for player {} was found.", (Object)player.method_5477().getString());
            }
            boolean spawnCapReached = false;
            spawnCounter = 0;
            if (HordeConfig.getConfigVariant() == 1) {
                if (MainConfig.getPrintDebugMessages()) {
                    UndeadNights.LOGGER.info("Horde config variant 1 detected.");
                }
                int waveMobCounter = 0;
                block1: while (waveMobCounter < HordeConfig.getMaxWaveSize()) {
                    if (!HordeConfig.getHordeMobs().isEmpty()) {
                        for (HordeConfig.MobSpawnData mobSpawnData : HordeConfig.getHordeMobs()) {
                            if (UndeadNights.globalSpawnCounter < MainConfig.getHordeMobsSpawnCap()) {
                                randomValue = randomSource.method_39332(1, 100);
                                if (this.spawnHordeMob(world, randomSource, pos, (class_1657)player, randomValue > 100 - mobSpawnData.chance() ? mobSpawnData : HordeConfig.getDefaultHordeMob()) == 0) {
                                    ++spawnCounter;
                                }
                                if (++waveMobCounter < HordeConfig.getMaxWaveSize()) continue;
                                this.d = 0.0;
                                continue block1;
                            }
                            waveMobCounter = HordeConfig.getMaxWaveSize();
                            spawnCapReached = true;
                            this.d = 0.0;
                            continue block1;
                        }
                        continue;
                    }
                    if (this.spawnHordeMob(world, randomSource, pos, (class_1657)player, HordeConfig.getDefaultHordeMob()) == 0) {
                        ++spawnCounter;
                    }
                    ++waveMobCounter;
                }
            }
            if (HordeConfig.getConfigVariant() == 2) {
                if (MainConfig.getPrintDebugMessages()) {
                    UndeadNights.LOGGER.info("Horde config variant 2 detected.");
                }
                List<HordeConfig.HordesData> hordes = HordeConfig.getHordes();
                int hordeIdToSpawn = hordeToSpawn - 1;
                if (hordeToSpawn == 0) {
                    hordeIdToSpawn = randomSource.method_39332(0, hordes.size() - 1);
                }
                for (HordeConfig.MobSpawnData mobSpawnData : hordes.get(hordeIdToSpawn).hordeMobs()) {
                    int mobCount;
                    if (mobSpawnData.countMin() >= mobSpawnData.countMax()) {
                        mobCount = mobSpawnData.countMin();
                    } else {
                        mobCount = randomSource.method_39332(mobSpawnData.countMin(), mobSpawnData.countMax());
                        if (MainConfig.getPrintDebugMessages()) {
                            UndeadNights.LOGGER.info("Spawning {} {}", (Object)mobCount, (Object)mobSpawnData.mobId());
                        }
                    }
                    for (int j = 0; j < mobCount; ++j) {
                        boolean spawnMob = true;
                        if (UndeadNights.globalSpawnCounter >= MainConfig.getHordeMobsSpawnCap()) {
                            spawnCapReached = true;
                            break;
                        }
                        if (mobSpawnData.chance() != 100) {
                            randomValue = randomSource.method_39332(1, 100);
                            if (MainConfig.getPrintDebugMessages()) {
                                UndeadNights.LOGGER.info("Chance value for horde config (variant 2) found, chance value: {}, randomValue: {}", (Object)mobSpawnData.chance(), (Object)randomValue);
                            }
                            if (randomValue <= 100 - mobSpawnData.chance()) {
                                spawnMob = false;
                            }
                        }
                        if (!spawnMob || this.spawnHordeMob(world, randomSource, pos, (class_1657)player, mobSpawnData) != 0) continue;
                        ++spawnCounter;
                    }
                    if (UndeadNights.globalSpawnCounter < MainConfig.getHordeMobsSpawnCap()) continue;
                    spawnCapReached = true;
                    break;
                }
            }
            this.d = 0.0;
            if (currentHordeCounter != UndeadNights.globalSpawnCounter) {
                if (spawnCounter == 0) continue;
                if (MainConfig.getHordeSpawnedMessageAndSound()) {
                    player.method_51469().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), UndeadNightsSounds.HORDE_SCREAM, class_3419.field_15251, 4.0f, 1.0f);
                    player.method_64398((class_2561)class_2561.method_43471((String)"message.undeadnights.horde_spawned").method_27692(class_124.field_1061));
                }
                if (MainConfig.getPrintDebugMessages()) {
                    UndeadNights.LOGGER.info("A Horde has spanned!");
                }
                return 0;
            }
            if (!spawnCapReached) continue;
            UndeadNights.LOGGER.info("Spawn cap reached, {} Horde Zombies are already loaded into this world.", (Object)MainConfig.getHordeMobsSpawnCap());
            return -1;
        }
        if (spawnCounter == 0) {
            UndeadNights.LOGGER.info("Failed to spawn a horde.");
            return -1;
        }
        return 0;
    }

    public void method_6445(class_3218 world, boolean spawnMonsters) {
        class_3222 serverPlayer;
        class_1297 entity;
        if (!spawnMonsters || !MainConfig.getUndeadNightsEnabled()) {
            return;
        }
        if (world.method_27983() != class_1937.field_25179) {
            return;
        }
        if (UndeadNights.serverState == null) {
            return;
        }
        long normalizedTimeOfDay = world.method_8532() - world.method_8532() / 24000L * 24000L;
        if (UndeadNights.serverState.getPrevNormalizedTimeOfDay() == normalizedTimeOfDay) {
            return;
        }
        UndeadNights.serverState.setNightIsStarting(UndeadNights.serverState.getPrevNormalizedTimeOfDay() < 12000L && normalizedTimeOfDay >= 12000L);
        UndeadNights.serverState.setPrevNormalizedTimeOfDay(normalizedTimeOfDay);
        boolean itIsNight = normalizedTimeOfDay >= 12000L && normalizedTimeOfDay < 22500L;
        class_5819 randomSource = world.field_9229;
        int randomValue = 0;
        if (!UndeadNights.serverState.entitiesWithPendingHorde.isEmpty()) {
            for (String string : UndeadNights.serverState.entitiesWithPendingHorde.values().stream().toList()) {
                if (UndeadNights.serverState.entitiesWithReceivedHorde.containsKey(UUID.fromString(string)) || !((entity = world.method_66347(UUID.fromString(string))) instanceof class_3222)) continue;
                serverPlayer = (class_3222)entity;
                if (this.spawnHorde(world, serverPlayer, randomSource) == -1) {
                    serverPlayer.method_64398((class_2561)class_2561.method_43471((String)"message.undeadnights.command_spawn_horde_failed"));
                }
                UndeadNights.serverState.entitiesWithReceivedHorde.put(UUID.fromString(string), string);
                UndeadNights.serverState.entitiesWithPendingHorde.remove(UUID.fromString(string));
            }
        }
        if (!UndeadNights.serverState.entitiesWithReceivedHorde.isEmpty()) {
            for (String string : UndeadNights.serverState.entitiesWithReceivedHorde.values().stream().toList()) {
                entity = world.method_66347(UUID.fromString(string));
                if (!(entity instanceof class_3222) || (serverPlayer = (class_3222)entity).method_6059(ModEffects.LURE_HORDE)) continue;
                UndeadNights.serverState.entitiesWithReceivedHorde.remove(UUID.fromString(string));
            }
        }
        if (SpawnHordeCommand.spawnHorde) {
            SpawnHordeCommand.spawnHorde = false;
            if (SpawnHordeCommand.entities != null) {
                for (class_1297 class_12972 : SpawnHordeCommand.entities.stream().toList()) {
                    class_3222 serverPlayer2;
                    if (!(class_12972 instanceof class_3222) || this.spawnHorde(world, serverPlayer2 = (class_3222)class_12972, randomSource) != -1) continue;
                    serverPlayer2.method_64398((class_2561)class_2561.method_43471((String)"message.undeadnights.command_spawn_horde_failed"));
                    break;
                }
                SpawnHordeCommand.entities = null;
            } else {
                for (class_3222 class_32222 : world.method_18766(class_1309::method_5805)) {
                    if (this.spawnHorde(world, class_32222, randomSource) != -1) continue;
                    class_32222.method_64398((class_2561)class_2561.method_43471((String)"message.undeadnights.command_spawn_horde_failed"));
                    break;
                }
            }
        }
        if (itIsNight) {
            Iterator<String> iterator;
            if (UndeadNights.serverState.getRespawnZombies() && UndeadNights.serverState.getHordeNight() && MainConfig.getSpawnAdditionalWaves()) {
                if (UndeadNights.serverState.getTickCounter() > 0) {
                    UndeadNights.serverState.setTickCounter(UndeadNights.serverState.getTickCounter() - 1);
                    return;
                }
                UndeadNights.serverState.setTickCounter(MainConfig.getCooldownBetweenWaves() * 20);
                randomValue = randomSource.method_39332(1, 100);
                if (randomValue > 100 - MainConfig.getChanceForAdditionalWaves()) {
                    if (MainConfig.getPrintDebugMessages()) {
                        UndeadNights.LOGGER.info("New Wave, randomValue was: {}", (Object)randomValue);
                    }
                    UndeadNights.serverState.setSpawnZombies(true);
                    UndeadNights.serverState.setRespawnZombies(false);
                } else {
                    if (MainConfig.getPrintDebugMessages()) {
                        UndeadNights.LOGGER.info("RandomValue: {}", (Object)randomValue);
                    }
                    return;
                }
            }
            if (UndeadNights.serverState.getNightIsStarting() && UndeadNights.serverState.getDaysCounter() >= 1) {
                if (UndeadNights.serverState.getGracePeriod() > 0) {
                    UndeadNights.serverState.setGracePeriod(UndeadNights.serverState.getGracePeriod() - 1);
                    if (MainConfig.getSendHordeNightsCountdownMessage()) {
                        for (class_3222 class_32223 : world.method_18766(class_1309::method_5805)) {
                            class_32223.method_64398((class_2561)class_2561.method_43469((String)"message.undeadnights.days_of_grace_remaining", (Object[])new Object[]{String.valueOf(UndeadNights.serverState.getGracePeriod())}));
                        }
                    }
                    if (UndeadNights.serverState.getGracePeriod() == 0) {
                        UndeadNights.serverState.setDaysCounter(1);
                    } else {
                        return;
                    }
                }
                UndeadNights.serverState.setDaysCounter(UndeadNights.serverState.getDaysCounter() - 1);
                if (UndeadNights.serverState.getDaysCounter() > 0 && MainConfig.getSendHordeNightsCountdownMessage()) {
                    for (class_3222 class_32224 : world.method_18766(class_1309::method_5805)) {
                        if (UndeadNights.serverState.getDaysCounter() > 1) {
                            class_32224.method_64398((class_2561)class_2561.method_43469((String)"message.undeadnights.nights_remaining", (Object[])new Object[]{String.valueOf(UndeadNights.serverState.getDaysCounter())}));
                            continue;
                        }
                        class_32224.method_64398((class_2561)class_2561.method_43471((String)"message.undeadnights.last_nights"));
                    }
                }
                if (MainConfig.getPrintDebugMessages()) {
                    UndeadNights.LOGGER.info("Night is coming, NormalizedTimeOfDay: {}, TimeOfDay: {}, DaysCounter: {}, GameTime: {}, GameTimeDays: {}", new Object[]{normalizedTimeOfDay, world.method_8532(), UndeadNights.serverState.getDaysCounter(), world.method_8510(), world.method_8510() / 24000L});
                }
            }
            if (UndeadNights.serverState.getDaysCounter() > 0 && !UndeadNights.serverState.getHordeNight()) {
                if (UndeadNights.serverState.getTryToSpawnRandomHorde()) {
                    if (MainConfig.getEnableRandomHordes() && UndeadNights.globalSpawnCounter < MainConfig.getHordeMobsSpawnCap() && (randomValue = randomSource.method_39332(1, 100)) > 100 - MainConfig.getChanceForRandomHordes()) {
                        class_3222 class_32225;
                        iterator = world.method_18766(class_1309::method_5805).iterator();
                        while (iterator.hasNext() && this.spawnHorde(world, class_32225 = (class_3222)iterator.next(), randomSource) != -1) {
                            if (!MainConfig.getPrintDebugMessages()) continue;
                            UndeadNights.LOGGER.info("A random horde has spawned!");
                        }
                    }
                    UndeadNights.serverState.setTryToSpawnRandomHorde(false);
                }
                if (MainConfig.getHordeZombiesSpawnNaturally() && UndeadNights.globalSpawnCounter < MainConfig.getHordeMobsSpawnCap()) {
                    if (UndeadNights.serverState.getTickCounter() > 0) {
                        UndeadNights.serverState.setTickCounter(UndeadNights.serverState.getTickCounter() - 1);
                        return;
                    }
                    UndeadNights.serverState.setTickCounter(100);
                    if (!(randomSource.method_43057() < 0.03f)) {
                        return;
                    }
                    for (class_3222 class_32226 : world.method_18766(class_1309::method_5805)) {
                        class_2338 pos = this.getBlockPosWithDistance(class_32226.method_24515(), (class_1937)world, MainConfig.getDistanceMin(), MainConfig.getDistanceMax());
                        if (!this.checkSpawnLocation(world, pos.method_10263(), pos.method_10264() - 1, pos.method_10260())) {
                            return;
                        }
                        this.spawnHordeMob(world, randomSource, pos, (class_1657)class_32226, new HordeConfig.MobSpawnData("undeadnights:horde_zombie", 100, 0, 0, "none", ""));
                        if (!MainConfig.getPrintDebugMessages()) continue;
                        UndeadNights.LOGGER.info("A stray horde zombie spawned!");
                    }
                }
                return;
            }
            if (UndeadNights.serverState.getNightIsStarting()) {
                randomValue = randomSource.method_39332(1, 100);
                if (randomValue <= 100 - MainConfig.getChanceForHordeNight()) {
                    return;
                }
                UndeadNights.serverState.setIsNaturalSpawningOk(true);
                UndeadNights.serverState.setHordeNight(true);
                UndeadNights.serverState.setSpawnZombies(true);
                UndeadNights.serverState.setFirstWaveHasSpawned(false);
                for (class_3222 class_32227 : world.method_18766(class_1309::method_5805)) {
                    class_32227.method_64398((class_2561)class_2561.method_43471((String)"message.undeadnights.horde_night").method_27692(class_124.field_1061));
                }
                if (MainConfig.getPrintDebugMessages()) {
                    UndeadNights.LOGGER.info("The coming night is a Horde Night, HordeNight: {}", (Object)UndeadNights.serverState.getHordeNight());
                }
            }
            if (UndeadNights.serverState.getSpawnZombies() && UndeadNights.serverState.getHordeNight() && normalizedTimeOfDay >= 12542L) {
                class_3222 class_32228;
                if (UndeadNights.serverState.getHordesCounter() != 0 && UndeadNights.serverState.getHordesCounter() - 1 == 0) {
                    return;
                }
                iterator = world.method_18766(class_1309::method_5805).iterator();
                while (iterator.hasNext() && this.spawnHorde(world, class_32228 = (class_3222)iterator.next(), randomSource) != -1) {
                    UndeadNights.serverState.setFirstWaveHasSpawned(true);
                    UndeadNights.serverState.setHordesCounter(UndeadNights.serverState.getHordesCounter() - 1);
                }
                if (!UndeadNights.serverState.getFirstWaveHasSpawned()) {
                    UndeadNights.serverState.setTickCounter(200);
                } else {
                    UndeadNights.serverState.setTickCounter(MainConfig.getCooldownBetweenWaves() * 20);
                    UndeadNights.serverState.setSpawnZombies(false);
                    UndeadNights.serverState.setRespawnZombies(true);
                    if (MainConfig.getPrintDebugMessages()) {
                        UndeadNights.LOGGER.info("Spawned waves for every player: DaysCounter: {} GlobalSpawnCounter: {} Spawn: {}, respawn: {}", new Object[]{UndeadNights.serverState.getDaysCounter(), UndeadNights.globalSpawnCounter, UndeadNights.serverState.getSpawnZombies(), UndeadNights.serverState.getRespawnZombies()});
                    }
                }
                UndeadNights.serverState.setDaysCounter(MainConfig.getDaysBetweenHordeNights());
                this.d = 0.0;
                this.x = 0.0;
                this.z = 0.0;
            }
        } else {
            if (UndeadNights.serverState.getHordeNight()) {
                for (class_3222 class_32229 : world.method_18766(class_1309::method_5805)) {
                    class_32229.method_64398((class_2561)class_2561.method_43471((String)"message.undeadnights.horde_night_over"));
                }
                UndeadNights.serverState.setDaysCounter(MainConfig.getDaysBetweenHordeNights());
                if (MainConfig.getMaxHordesPerHordeNight() != 0) {
                    UndeadNights.serverState.setHordesCounter(MainConfig.getMaxHordesPerHordeNight() + 1);
                } else {
                    UndeadNights.serverState.setHordesCounter(0);
                }
                if (MainConfig.getPrintDebugMessages()) {
                    UndeadNights.LOGGER.info("The Night of the Undead is over, TimeOfDay: {} DaysCounter: {} GlobalSpawnCounter: {}", new Object[]{world.method_8532(), UndeadNights.serverState.getDaysCounter(), UndeadNights.globalSpawnCounter});
                }
            }
            UndeadNights.serverState.setHordeNight(false);
            UndeadNights.serverState.setSpawnZombies(true);
            UndeadNights.serverState.setRespawnZombies(false);
            UndeadNights.serverState.setTryToSpawnRandomHorde(true);
        }
    }
}

