/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights.entity;

import java.time.LocalDate;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.ZombieAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.petemc.undeadnights.UndeadNights;
import net.petemc.undeadnights.config.MainConfig;
import net.petemc.undeadnights.entity.DemolitionZombieEntity;
import net.petemc.undeadnights.entity.EliteZombieEntity;
import net.petemc.undeadnights.entity.ai.goal.BreakBlockGoal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HordeZombieEntity
extends Zombie {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.defineId(HordeZombieEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);

    public HordeZombieEntity(EntityType<? extends Zombie> entityType, Level level) {
        super(entityType, level);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, EntitySpawnReason spawnReason, @Nullable SpawnGroupData spawnGroupData) {
        RandomSource randomsource = level.getRandom();
        spawnGroupData = super.finalizeSpawn(level, difficulty, spawnReason, spawnGroupData);
        float f = difficulty.getSpecialMultiplier();
        this.setCanPickUpLoot(randomsource.nextFloat() < 0.55f * f);
        if (spawnGroupData == null) {
            spawnGroupData = new Zombie.ZombieGroupData(false, false);
        }
        if (spawnGroupData instanceof Zombie.ZombieGroupData) {
            this.setCanBreakDoors(true);
            this.populateDefaultEquipmentSlots(randomsource, difficulty);
            this.populateDefaultEquipmentEnchantments(level, randomsource, difficulty);
        }
        if (this.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
            LocalDate localdate = LocalDate.now();
            int i = localdate.getDayOfMonth();
            int j = localdate.getMonth().getValue();
            if (j == 10 && i == 31 && randomsource.nextFloat() < 0.25f) {
                this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)(randomsource.nextFloat() < 0.1f ? Blocks.JACK_O_LANTERN : Blocks.CARVED_PUMPKIN)));
                this.setDropChance(EquipmentSlot.HEAD, 0.0f);
            }
        }
        Objects.requireNonNull(this.getAttribute(Attributes.MAX_HEALTH)).addPermanentModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"undeadnights", (String)"horde_zombie_health_bonus"), MainConfig.getMaxHealthDemolitionZombies() - 20.0, AttributeModifier.Operation.ADD_VALUE));
        this.handleAttributes(f);
        this.setHealth(this.getMaxHealth());
        this.setBaby(false);
        return spawnGroupData;
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.FOLLOW_RANGE, 128.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.ARMOR, 4.0).add(Attributes.SPAWN_REINFORCEMENTS_CHANCE, 0.0);
    }

    protected void addBehaviourGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new BreakBlockGoal(this));
        this.goalSelector.addGoal(2, (Goal)new ZombieAttackGoal((Zombie)this, 1.0, false));
        this.goalSelector.addGoal(4, (Goal)new ChasePlayerGoal(this));
        this.goalSelector.addGoal(6, (Goal)new MoveThroughVillageGoal((PathfinderMob)this, 1.0, true, 4, this::canBreakDoors));
        this.goalSelector.addGoal(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{HordeZombieEntity.class, EliteZombieEntity.class, DemolitionZombieEntity.class}).setAlertOthers(new Class[]{HordeZombieEntity.class}));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_FLAGS_ID, (Object)0);
    }

    protected boolean convertsInWater() {
        return false;
    }

    protected boolean isSunSensitive() {
        return MainConfig.getHordeZombiesBurnInDaylight();
    }

    public boolean canBreakDoors() {
        return false;
    }

    public void setCanBreakDoors(boolean val) {
    }

    protected float getWaterSlowDown() {
        return MainConfig.getHordeZombiesHaveIncreasedWaterMovementSpeed() ? 0.94f : 0.8f;
    }

    public boolean isBreakingBlock() {
        return ((Byte)this.entityData.get(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setBreakingBlock(boolean isBreaking) {
        byte b0 = (Byte)this.entityData.get(DATA_FLAGS_ID);
        b0 = isBreaking ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.entityData.set(DATA_FLAGS_ID, (Object)b0);
    }

    public void randomizeReinforcementsChance() {
        Objects.requireNonNull(this.getAttribute(Attributes.SPAWN_REINFORCEMENTS_CHANCE)).setBaseValue(0.0);
    }

    protected void populateDefaultEquipmentSlots(@NotNull RandomSource pRandom, @NotNull DifficultyInstance pDifficulty) {
        this.initCustomEquipment(pRandom, pDifficulty);
        float f = pRandom.nextFloat();
        float f2 = this.level().getDifficulty() == Difficulty.HARD ? 0.07f : 0.03f;
        if (f < f2) {
            int i = this.random.nextInt(3);
            if (i == 0) {
                this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.IRON_SWORD));
            }
            if (i == 1) {
                this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.IRON_AXE));
            }
        }
    }

    protected void initCustomEquipment(RandomSource random, DifficultyInstance localDifficulty) {
        if (random.nextFloat() < 0.2f * localDifficulty.getSpecialMultiplier()) {
            float f;
            int i = random.nextInt(2);
            float f2 = f = this.level().getDifficulty() == Difficulty.HARD ? 0.2f : 0.45f;
            if (random.nextFloat() < 0.095f) {
                ++i;
            }
            if (random.nextFloat() < 0.095f) {
                ++i;
            }
            if (random.nextFloat() < 0.095f) {
                ++i;
            }
            boolean flag = true;
            for (EquipmentSlot equipmentslot : EquipmentSlot.values()) {
                Item item;
                if (equipmentslot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR) continue;
                ItemStack itemstack = this.getItemBySlot(equipmentslot);
                if (!flag && random.nextFloat() < f) break;
                flag = false;
                if (!itemstack.isEmpty() || (item = HordeZombieEntity.getEquipmentForSlot((EquipmentSlot)equipmentslot, (int)i)) == null) continue;
                this.setItemSlot(equipmentslot, new ItemStack((ItemLike)item));
            }
        }
    }

    public static boolean checkHordeZombieSpawnRules(EntityType<HordeZombieEntity> hordeZombieEntityType, ServerLevelAccessor serverLevel, EntitySpawnReason spawnType, BlockPos pos, RandomSource random) {
        return MainConfig.getHordeZombiesSpawnNaturally() && UndeadNights.serverState.getIsNaturalSpawningOk() && !serverLevel.getBiome(pos).is(Biomes.MUSHROOM_FIELDS) && serverLevel.getDifficulty() != Difficulty.PEACEFUL && Monster.isDarkEnoughToSpawn((ServerLevelAccessor)serverLevel, (BlockPos)pos, (RandomSource)random) && Mob.checkMobSpawnRules(hordeZombieEntityType, (LevelAccessor)serverLevel, (EntitySpawnReason)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    public void push(@NotNull Entity entity) {
        super.push(entity);
    }

    static class ChasePlayerGoal
    extends Goal {
        private final HordeZombieEntity hordeZombie;
        @Nullable
        private LivingEntity target;

        public ChasePlayerGoal(HordeZombieEntity hordeZombie) {
            this.hordeZombie = hordeZombie;
        }

        public boolean canUse() {
            this.target = this.hordeZombie.getTarget();
            return this.target instanceof Player;
        }

        public void start() {
            this.hordeZombie.getNavigation().stop();
        }

        public void tick() {
            assert (this.target != null);
            this.hordeZombie.getLookControl().setLookAt(this.target.getX(), this.target.getEyeY(), this.target.getZ());
        }
    }
}

