/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights.entity.ai.goal;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.petemc.undeadnights.entity.DemolitionZombieEntity;
import org.jetbrains.annotations.Nullable;

public class DemolitionZombieIgniteGoal
extends Goal {
    private final DemolitionZombieEntity demolitionZombie;
    private int tntCoolDown = 0;
    @Nullable
    private LivingEntity target;

    public DemolitionZombieIgniteGoal(DemolitionZombieEntity demolitionZombie) {
        this.demolitionZombie = demolitionZombie;
    }

    public boolean canUse() {
        LivingEntity target = this.demolitionZombie.getTarget();
        if (!(target instanceof Player)) {
            return false;
        }
        return this.demolitionZombie.distanceToSqr((Entity)target) < 12.0;
    }

    public void start() {
        this.target = this.demolitionZombie.getTarget();
    }

    public void stop() {
        this.target = null;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        BlockPos pos = this.demolitionZombie.blockPosition();
        if (this.tntCoolDown <= 0) {
            if (this.target != null && this.demolitionZombie.distanceToSqr((Entity)this.target) < 12.0 && this.demolitionZombie.getSensing().hasLineOfSight((Entity)this.target) && this.demolitionZombie.getMainHandItem().getCount() > 0) {
                PrimedTnt tntEntity = new PrimedTnt(this.demolitionZombie.level(), (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, (LivingEntity)this.demolitionZombie);
                this.demolitionZombie.level().addFreshEntity((Entity)tntEntity);
                this.demolitionZombie.level().playSound(null, tntEntity.getX(), tntEntity.getY(), tntEntity.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (this.demolitionZombie.getNumberTnt() != 0) {
                    this.demolitionZombie.getMainHandItem().shrink(1);
                }
                this.tntCoolDown = 100;
            }
        } else {
            --this.tntCoolDown;
        }
        super.tick();
    }
}

