/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights.mixin;

import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.petemc.undeadnights.UndeadNights;
import net.petemc.undeadnights.config.MainConfig;
import net.petemc.undeadnights.effect.ModEffects;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    @Inject(method={"getWaterSlowDown"}, at={@At(value="HEAD")}, cancellable=true)
    protected void getWaterSlowDown(CallbackInfoReturnable<Float> cir) {
        if ((Entity)this instanceof Zombie && MainConfig.getHordeZombiesHaveIncreasedWaterMovementSpeed()) {
            cir.setReturnValue((Object)Float.valueOf(0.94f));
        }
    }

    @Inject(method={"die"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/damagesource/DamageSource;getEntity()Lnet/minecraft/world/entity/Entity;", shift=At.Shift.AFTER)})
    public void die_lureEffect(DamageSource pDamageSource, CallbackInfo ci) {
        Entity entity;
        if (pDamageSource != null && MainConfig.getEnableLureHordeEffect() && (entity = pDamageSource.getEntity()) instanceof ServerPlayer) {
            RandomSource randomSource;
            double rand;
            boolean flag;
            ServerPlayer player = (ServerPlayer)entity;
            boolean isZombie = (Entity)this instanceof Zombie;
            boolean bl = flag = MainConfig.getNonHordeZombiesCanCauseLureHordeEffect() && isZombie;
            if ((UndeadNights.serverState.spawnedHordeMobs.containsKey(((Entity)this).getUUID()) || flag) && (rand = (randomSource = player.level().random).nextDouble()) <= MainConfig.getChanceForLureHordeEffect() && !player.hasEffect((Holder)ModEffects.LURE_HORDE.getHolder().get())) {
                player.addEffect(new MobEffectInstance((Holder)ModEffects.LURE_HORDE.getHolder().get(), MainConfig.getDurationForLureHordeEffect() * 20, 0));
            }
        }
    }
}

