/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights;

import com.mojang.logging.LogUtils;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.petemc.undeadnights.client.render.DemolitionZombieRenderer;
import net.petemc.undeadnights.client.render.EliteZombieRenderer;
import net.petemc.undeadnights.client.render.HordeZombieRenderer;
import net.petemc.undeadnights.command.HordeMobsCommand;
import net.petemc.undeadnights.config.HordeConfig;
import net.petemc.undeadnights.config.MainConfig;
import net.petemc.undeadnights.effect.ModEffects;
import net.petemc.undeadnights.entity.ModEntities;
import net.petemc.undeadnights.item.ModCreativeModeTabs;
import net.petemc.undeadnights.item.ModItems;
import net.petemc.undeadnights.potion.ModPotions;
import net.petemc.undeadnights.sound.UndeadNightsSounds;
import net.petemc.undeadnights.util.StateSaverAndLoader;
import net.petemc.undeadnights.world.spawner.UndeadSpawner;
import org.slf4j.Logger;

@Mod(value="undeadnights")
public class UndeadNights {
    public static final String MOD_ID = "undeadnights";
    public static final String MOD_NAME = "UndeadNights";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"undeadnights");
    public static StateSaverAndLoader serverState = null;
    public static int globalSpawnCounter = 0;

    public UndeadNights(FMLJavaModLoadingContext context) {
        BusGroup modBusGroup = context.getModBusGroup();
        FMLCommonSetupEvent.getBus((BusGroup)modBusGroup).addListener(this::commonSetup);
        FMLClientSetupEvent.getBus((BusGroup)modBusGroup).addListener(ClientModEvents::onClientSetup);
        ServerStartingEvent.BUS.addListener(this::onServerStarting);
        CREATIVE_MODE_TABS.register(modBusGroup);
        BuildCreativeModeTabContentsEvent.BUS.addListener(UndeadNights::addCreative);
        UndeadNightsSounds.register(modBusGroup);
        ModEntities.register(modBusGroup);
        ModItems.register(modBusGroup);
        ModEffects.register(modBusGroup);
        ModPotions.register(modBusGroup);
        ModCreativeModeTabs.register(modBusGroup);
        context.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)MainConfig.SPEC_SERVER);
        HordeConfig.loadConfig();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Initializing the {} Mod", (Object)MOD_NAME);
        event.enqueueWork(() -> {});
    }

    private static void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.SPAWN_EGGS) {
            event.accept(ModItems.HORDE_ZOMBIE_SPAWN_EGG);
            event.accept(ModItems.ELITE_ZOMBIE_SPAWN_EGG);
            event.accept(ModItems.DEMOLITION_ZOMBIE_SPAWN_EGG);
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("Initializing UndeadNights Mod");
        if (serverState == null) {
            serverState = (StateSaverAndLoader)event.getServer().overworld().getDataStorage().computeIfAbsent(StateSaverAndLoader.createStateType());
            if (serverState.getLastMaxDaysCounter() != MainConfig.getDaysBetweenHordeNights()) {
                serverState.setDaysCounter(MainConfig.getDaysBetweenHordeNights());
                serverState.setLastMaxDaysCounter(MainConfig.getDaysBetweenHordeNights());
            }
            if (serverState.getLastMaxGracePeriod() != MainConfig.getGracePeriodBeforeFirstHordeNight()) {
                serverState.setGracePeriod(MainConfig.getGracePeriodBeforeFirstHordeNight());
                serverState.setLastMaxGracePeriod(MainConfig.getGracePeriodBeforeFirstHordeNight());
            }
            if (serverState.getLastMaxHordesCounter() != MainConfig.getMaxHordesPerHordeNight()) {
                if (MainConfig.getMaxHordesPerHordeNight() != 0) {
                    serverState.setHordesCounter(MainConfig.getMaxHordesPerHordeNight() + 1);
                } else {
                    serverState.setHordesCounter(0);
                }
                serverState.setLastMaxHordesCounter(MainConfig.getMaxHordesPerHordeNight());
            }
            if (!MainConfig.getNoNaturalSpawningBeforeFirstHordeNight()) {
                serverState.setIsNaturalSpawningOk(true);
            }
            if (MainConfig.getPrintDebugMessages()) {
                LOGGER.info("INIT DaysCounter: {} LastMaxDaysCounter: {}", (Object)serverState.getDaysCounter(), (Object)serverState.getLastMaxDaysCounter());
                LOGGER.info("INIT HordeNight: {} SpawnZombies: {} RespawnZombies: {}", new Object[]{serverState.getHordeNight(), serverState.getSpawnZombies(), serverState.getRespawnZombies()});
            }
            UndeadSpawner.hordeToSpawn = HordeConfig.getDefaultHorde();
            HordeMobsCommand.hordeZombiesCanBreakBlocks = MainConfig.getHordeZombiesCanBreakBlocks();
            HordeMobsCommand.hordeZombiesBlockBreakingTier = MainConfig.getZombiesBlockBreakTier();
        }
    }

    @Mod.EventBusSubscriber(modid="undeadnights", value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            EntityRenderers.register(ModEntities.HORDE_ZOMBIE.get(), HordeZombieRenderer::new);
            EntityRenderers.register(ModEntities.DEMOLITION_ZOMBIE.get(), DemolitionZombieRenderer::new);
            EntityRenderers.register(ModEntities.ELITE_ZOMBIE.get(), EliteZombieRenderer::new);
        }
    }
}

