/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights.world.spawner;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.registries.ForgeRegistries;
import net.petemc.undeadnights.UndeadNights;
import net.petemc.undeadnights.command.SpawnHordeCommand;
import net.petemc.undeadnights.config.HordeConfig;
import net.petemc.undeadnights.config.MainConfig;
import net.petemc.undeadnights.effect.ModEffects;
import net.petemc.undeadnights.entity.DemolitionZombieEntity;
import net.petemc.undeadnights.entity.HordeZombieEntity;
import net.petemc.undeadnights.entity.ModEntities;
import net.petemc.undeadnights.entity.ai.goal.BreakBlockGoal;
import net.petemc.undeadnights.sound.UndeadNightsSounds;
import org.jetbrains.annotations.NotNull;

public class UndeadSpawner
implements CustomSpawner {
    public static boolean invalidHordeMobEntry = false;
    public static int hordeToSpawn = 1;
    private double x = 0.0;
    private double z = 0.0;
    private double d = 0.0;

    public static boolean isDarkEnoughToSpawn(ServerLevelAccessor level, BlockPos pos) {
        return level.getBrightness(LightLayer.BLOCK, pos) <= MainConfig.getMaxBlockLightLevelForMonsterSpawns();
    }

    private boolean checkSpawnLocation(ServerLevel level, double x, double y, double z) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(x, y, z);
        BlockState blockState = level.getBlockState((BlockPos)mutable);
        Block block = blockState.getBlock();
        boolean doesNotBlockMovement = block != Blocks.COBWEB && block != Blocks.BAMBOO_SAPLING;
        boolean notWater = true;
        boolean darkEnough = true;
        if (!MainConfig.getHordeWavesCanSpawnInWater()) {
            notWater = !blockState.getFluidState().is(FluidTags.WATER);
        }
        boolean notLeaves = true;
        if (!MainConfig.getHordeWavesCanSpawnOnTrees()) {
            boolean bl = notLeaves = !(blockState.getBlock() instanceof LeavesBlock);
        }
        if (MainConfig.getBlockLightLevelsInfluenceMonsterSpawns()) {
            darkEnough = UndeadSpawner.isDarkEnoughToSpawn((ServerLevelAccessor)level, (BlockPos)mutable);
        }
        return doesNotBlockMovement && notLeaves && notWater && darkEnough;
    }

    private BlockPos getBlockPosWithDistance(BlockPos pos, Level level, int distanceMin, int distanceMax) {
        double _z;
        RandomSource random = level.random;
        double _d = random.nextIntBetweenInclusive(distanceMin, distanceMax);
        double _x = random.nextIntBetweenInclusive(0, (int)_d);
        if (_x == 0.0) {
            _z = _d;
        } else {
            _z = Math.sqrt(_d * _d - _x * _x);
            if (random.nextBoolean()) {
                _x *= -1.0;
            }
        }
        if (random.nextBoolean()) {
            _z *= -1.0;
        }
        return new BlockPos(pos.getX() + (int)_x, level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.getX() + (int)_x, pos.getZ() + (int)_z), pos.getZ() + (int)_z);
    }

    private int spawnHordeMob(ServerLevel level, RandomSource randomSource, BlockPos pos, Player player, HordeConfig.MobSpawnData mobSpawnData) {
        EntityType mobType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(ResourceLocation.parse((String)mobSpawnData.mobId()));
        if (mobType == null) {
            invalidHordeMobEntry = true;
            UndeadNights.LOGGER.warn("Spawning entry {} from the config file failed! Spawning default horde zombie instead.", (Object)mobSpawnData.mobId());
        }
        int deltaX = randomSource.nextInt(5);
        int deltaZ = randomSource.nextInt(5);
        if (!randomSource.nextBoolean()) {
            deltaX *= -1;
        }
        if (!randomSource.nextBoolean()) {
            deltaZ *= -1;
        }
        int y = MainConfig.getHordeWavesCanSpawnOnTrees() ? level.getHeight(Heightmap.Types.MOTION_BLOCKING, pos.getX() + deltaX, pos.getZ() + deltaZ) : level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.getX() + deltaX, pos.getZ() + deltaZ);
        if (mobSpawnData.mobId().equals("minecraft:ghast")) {
            y = level.getHeight(Heightmap.Types.MOTION_BLOCKING, pos.getX() + deltaX, pos.getZ() + deltaZ) + 20;
        }
        CompoundTag nbtCompound = new CompoundTag();
        if (!Objects.equals(mobSpawnData.nbt(), "")) {
            try {
                nbtCompound = TagParser.parseCompoundFully((String)mobSpawnData.nbt());
            }
            catch (CommandSyntaxException e) {
                UndeadNights.LOGGER.error("Parsing NBT-tags for {} failed!", (Object)mobSpawnData.mobId());
            }
        }
        if (!invalidHordeMobEntry) {
            nbtCompound.putString("id", mobSpawnData.mobId());
        } else {
            nbtCompound.putString("id", "undeadnights:horde_zombie");
        }
        int finalY = y;
        int finalDeltaX = deltaX;
        int finalDeltaZ = deltaZ;
        Entity entity = EntityType.loadEntityRecursive((CompoundTag)nbtCompound, (Level)level, (EntitySpawnReason)EntitySpawnReason.COMMAND, entityx -> {
            entityx.snapTo((double)(pos.getX() + finalDeltaX), (double)finalY, (double)(pos.getZ() + finalDeltaZ), entityx.getYRot(), entityx.getXRot());
            return entityx;
        });
        if (entity instanceof Monster && MainConfig.getBlockLightLevelsInfluenceMonsterSpawns() && !UndeadSpawner.isDarkEnoughToSpawn((ServerLevelAccessor)level, new BlockPos(pos.getX() + deltaX, finalY, pos.getZ() + deltaZ))) {
            UndeadNights.LOGGER.info("Horde mob {} can't spawn here, it's not dark enough!", (Object)mobSpawnData.mobId());
            return -1;
        }
        if (entity instanceof DemolitionZombieEntity) {
            DemolitionZombieEntity demolitionZombie = (DemolitionZombieEntity)entity;
            String str = mobSpawnData.extra();
            String[] strA = str.split(":");
            if (strA[0].equals("tnt")) {
                try {
                    int numberTnt = Integer.parseInt(strA[1]);
                    if (numberTnt > 64) {
                        numberTnt = 64;
                    }
                    demolitionZombie.setNumberTnt(numberTnt);
                }
                catch (Exception e) {
                    UndeadNights.LOGGER.warn("extraSpawnInfo for {} has non valid value, using default TNT stack size!", (Object)mobSpawnData.mobId());
                }
            } else {
                UndeadNights.LOGGER.warn("extraSpawnInfo for {} could be read, using default TNT stack size!", (Object)mobSpawnData.mobId());
            }
        }
        DifficultyInstance localDifficulty = level.getCurrentDifficultyAt(player.blockPosition());
        try {
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                mob.finalizeSpawn((ServerLevelAccessor)level, localDifficulty, EntitySpawnReason.NATURAL, (SpawnGroupData)new Zombie.ZombieGroupData(false, false));
                mob.setTarget((LivingEntity)player);
                if (mobSpawnData.mobId().equals("minecraft:zombie")) {
                    mob.goalSelector.addGoal(1, (Goal)new FloatGoal(mob));
                    mob.goalSelector.addGoal(1, (Goal)new BreakBlockGoal((Zombie)mob));
                }
                if (!(mobSpawnData.mobId().equals("undeadnights:horde_zombie") || mobSpawnData.mobId().equals("undeadnights:elite_zombie") || mobSpawnData.mobId().equals("undeadnights:demolition_zombie"))) {
                    Objects.requireNonNull(mob.getAttribute(Attributes.FOLLOW_RANGE)).setBaseValue(128.0);
                    mob.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal(mob, Player.class, false, false));
                }
            }
            assert (entity != null);
            UndeadNights.serverState.spawnedHordeMobs.put(entity.getUUID(), entity.getStringUUID());
            level.tryAddFreshEntityWithPassengers(entity);
        }
        catch (Exception e) {
            invalidHordeMobEntry = true;
            UndeadNights.LOGGER.warn("Spawning entry {} from the config file failed! Spawning default horde zombie instead.", (Object)mobSpawnData.mobId());
            HordeZombieEntity hZombie = new HordeZombieEntity(ModEntities.HORDE_ZOMBIE.get(), (Level)level);
            hZombie.setPos(pos.getX() + deltaX, level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.getX() + deltaX, pos.getZ() + deltaZ), pos.getZ() + deltaZ);
            if (MainConfig.getPersistentMobs()) {
                hZombie.setPersistenceRequired();
            }
            hZombie.finalizeSpawn((ServerLevelAccessor)level, localDifficulty, EntitySpawnReason.NATURAL, (SpawnGroupData)new Zombie.ZombieGroupData(false, false));
            hZombie.setTarget((LivingEntity)player);
            UndeadNights.serverState.spawnedHordeMobs.put(hZombie.getUUID(), hZombie.getStringUUID());
            level.addFreshEntity((Entity)hZombie);
        }
        return 0;
    }

    public int spawnHorde(ServerLevel level, ServerPlayer player, RandomSource randomSource) {
        int spawnCounter = 0;
        boolean foundHordeSpawnLocation = false;
        int currentHordeCounter = UndeadNights.globalSpawnCounter;
        for (int i = 0; i < 20; ++i) {
            int randomValue;
            if (this.d == 0.0) {
                this.d = randomSource.nextIntBetweenInclusive(MainConfig.getDistanceMin(), MainConfig.getDistanceMax());
                this.x = randomSource.nextIntBetweenInclusive(0, (int)this.d);
                if (this.x == 0.0) {
                    this.z = this.d;
                } else {
                    this.z = Math.sqrt(this.d * this.d - this.x * this.x);
                    if (randomSource.nextBoolean()) {
                        this.x *= -1.0;
                    }
                }
                if (randomSource.nextBoolean()) {
                    this.z *= -1.0;
                }
            }
            BlockPos pos = player.blockPosition().offset((int)this.x, 0, (int)this.z);
            foundHordeSpawnLocation = this.checkSpawnLocation(level, (pos = new BlockPos(pos.getX(), level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.getX(), pos.getZ()), pos.getZ())).getX(), pos.getY() - 1, pos.getZ());
            if (!foundHordeSpawnLocation) {
                this.d = 0.0;
                this.x = 0.0;
                this.z = 0.0;
                continue;
            }
            if (MainConfig.getPrintDebugMessages()) {
                UndeadNights.LOGGER.info("A possible Horde spawn location for player {} was found.", (Object)player.getName().getString());
            }
            boolean spawnCapReached = false;
            spawnCounter = 0;
            if (HordeConfig.getConfigVariant() == 1) {
                if (MainConfig.getPrintDebugMessages()) {
                    UndeadNights.LOGGER.info("Horde config variant 1 detected.");
                }
                int waveMobCounter = 0;
                block1: while (waveMobCounter < HordeConfig.getMaxWaveSize()) {
                    if (!HordeConfig.getHordeMobs().isEmpty()) {
                        for (HordeConfig.MobSpawnData mobSpawnData : HordeConfig.getHordeMobs()) {
                            if (UndeadNights.globalSpawnCounter < MainConfig.getHordeMobsSpawnCap()) {
                                randomValue = randomSource.nextIntBetweenInclusive(1, 100);
                                if (this.spawnHordeMob(level, randomSource, pos, (Player)player, randomValue > 100 - mobSpawnData.chance() ? mobSpawnData : HordeConfig.getDefaultHordeMob()) == 0) {
                                    ++spawnCounter;
                                }
                                if (++waveMobCounter < HordeConfig.getMaxWaveSize()) continue;
                                this.d = 0.0;
                                continue block1;
                            }
                            waveMobCounter = HordeConfig.getMaxWaveSize();
                            spawnCapReached = true;
                            this.d = 0.0;
                            continue block1;
                        }
                        continue;
                    }
                    if (this.spawnHordeMob(level, randomSource, pos, (Player)player, HordeConfig.getDefaultHordeMob()) == 0) {
                        ++spawnCounter;
                    }
                    ++waveMobCounter;
                }
            }
            if (HordeConfig.getConfigVariant() == 2) {
                if (MainConfig.getPrintDebugMessages()) {
                    UndeadNights.LOGGER.info("Horde config variant 2 detected.");
                }
                List<HordeConfig.HordesData> hordes = HordeConfig.getHordes();
                int hordeIdToSpawn = hordeToSpawn - 1;
                if (hordeToSpawn == 0) {
                    hordeIdToSpawn = randomSource.nextIntBetweenInclusive(0, hordes.size() - 1);
                }
                for (HordeConfig.MobSpawnData mobSpawnData : hordes.get(hordeIdToSpawn).hordeMobs()) {
                    int mobCount;
                    if (mobSpawnData.countMin() >= mobSpawnData.countMax()) {
                        mobCount = mobSpawnData.countMin();
                    } else {
                        mobCount = randomSource.nextInt(mobSpawnData.countMin(), mobSpawnData.countMax());
                        if (MainConfig.getPrintDebugMessages()) {
                            UndeadNights.LOGGER.info("Spawning {} {}", (Object)mobCount, (Object)mobSpawnData.mobId());
                        }
                    }
                    for (int j = 0; j < mobCount; ++j) {
                        boolean spawnMob = true;
                        if (UndeadNights.globalSpawnCounter >= MainConfig.getHordeMobsSpawnCap()) {
                            spawnCapReached = true;
                            break;
                        }
                        if (mobSpawnData.chance() != 100) {
                            randomValue = randomSource.nextIntBetweenInclusive(1, 100);
                            if (MainConfig.getPrintDebugMessages()) {
                                UndeadNights.LOGGER.info("Chance value for horde config (variant 2) found, chance value: {}, randomValue: {}", (Object)mobSpawnData.chance(), (Object)randomValue);
                            }
                            if (randomValue <= 100 - mobSpawnData.chance()) {
                                spawnMob = false;
                            }
                        }
                        if (!spawnMob || this.spawnHordeMob(level, randomSource, pos, (Player)player, mobSpawnData) != 0) continue;
                        ++spawnCounter;
                    }
                    if (UndeadNights.globalSpawnCounter < MainConfig.getHordeMobsSpawnCap()) continue;
                    spawnCapReached = true;
                    break;
                }
            }
            this.d = 0.0;
            if (currentHordeCounter != UndeadNights.globalSpawnCounter) {
                if (spawnCounter == 0) continue;
                if (MainConfig.getHordeSpawnedMessageAndSound()) {
                    player.level().playSound(null, player.getX(), player.getY(), player.getZ(), UndeadNightsSounds.HORDE_SCREAM.get(), SoundSource.HOSTILE, 4.0f, 1.0f);
                    player.sendSystemMessage((Component)Component.translatable((String)"message.undeadnights.horde_spawned").withStyle(ChatFormatting.RED));
                }
                if (MainConfig.getPrintDebugMessages()) {
                    UndeadNights.LOGGER.info("A Horde has spanned!");
                }
                return 0;
            }
            if (!spawnCapReached) continue;
            UndeadNights.LOGGER.info("Spawn cap reached, {} Horde Zombies are already loaded into this world.", (Object)MainConfig.getHordeMobsSpawnCap());
            return -1;
        }
        if (spawnCounter == 0) {
            UndeadNights.LOGGER.info("Failed to spawn a horde.");
            return -1;
        }
        return 0;
    }

    public void tick(@NotNull ServerLevel level, boolean spawnMonsters) {
        ServerPlayer serverPlayer;
        Entity entity;
        if (!spawnMonsters || !MainConfig.getUndeadNightsEnabled()) {
            return;
        }
        if (level.dimension() != Level.OVERWORLD) {
            return;
        }
        if (UndeadNights.serverState == null) {
            return;
        }
        long normalizedTimeOfDay = level.getDayTime() - level.getDayTime() / 24000L * 24000L;
        if (UndeadNights.serverState.getPrevNormalizedTimeOfDay() == normalizedTimeOfDay) {
            return;
        }
        UndeadNights.serverState.setNightIsStarting(UndeadNights.serverState.getPrevNormalizedTimeOfDay() < 12000L && normalizedTimeOfDay >= 12000L);
        UndeadNights.serverState.setPrevNormalizedTimeOfDay(normalizedTimeOfDay);
        boolean itIsNight = normalizedTimeOfDay >= 12000L && normalizedTimeOfDay < 22500L;
        RandomSource randomSource = level.random;
        int randomValue = 0;
        if (!UndeadNights.serverState.entitiesWithPendingHorde.isEmpty()) {
            for (String string : UndeadNights.serverState.entitiesWithPendingHorde.values().stream().toList()) {
                if (UndeadNights.serverState.entitiesWithReceivedHorde.containsKey(UUID.fromString(string)) || !((entity = level.getEntity(UUID.fromString(string))) instanceof ServerPlayer)) continue;
                serverPlayer = (ServerPlayer)entity;
                if (this.spawnHorde(level, serverPlayer, randomSource) == -1) {
                    serverPlayer.sendSystemMessage((Component)Component.translatable((String)"message.undeadnights.command_spawn_horde_failed"));
                }
                UndeadNights.serverState.entitiesWithReceivedHorde.put(UUID.fromString(string), string);
                UndeadNights.serverState.entitiesWithPendingHorde.remove(UUID.fromString(string));
            }
        }
        if (!UndeadNights.serverState.entitiesWithReceivedHorde.isEmpty()) {
            for (String string : UndeadNights.serverState.entitiesWithReceivedHorde.values().stream().toList()) {
                entity = level.getEntity(UUID.fromString(string));
                if (!(entity instanceof ServerPlayer) || (serverPlayer = (ServerPlayer)entity).hasEffect((Holder)ModEffects.LURE_HORDE.getHolder().get())) continue;
                UndeadNights.serverState.entitiesWithReceivedHorde.remove(UUID.fromString(string));
            }
        }
        if (SpawnHordeCommand.spawnHorde) {
            SpawnHordeCommand.spawnHorde = false;
            if (SpawnHordeCommand.entities != null) {
                for (Entity entity2 : SpawnHordeCommand.entities.stream().toList()) {
                    ServerPlayer serverPlayer2;
                    if (!(entity2 instanceof ServerPlayer) || this.spawnHorde(level, serverPlayer2 = (ServerPlayer)entity2, randomSource) != -1) continue;
                    serverPlayer2.sendSystemMessage((Component)Component.translatable((String)"message.undeadnights.command_spawn_horde_failed"));
                    break;
                }
                SpawnHordeCommand.entities = null;
            } else {
                for (ServerPlayer serverPlayer2 : level.getPlayers(LivingEntity::isAlive)) {
                    if (this.spawnHorde(level, serverPlayer2, randomSource) != -1) continue;
                    serverPlayer2.sendSystemMessage((Component)Component.translatable((String)"message.undeadnights.command_spawn_horde_failed"));
                    break;
                }
            }
        }
        if (itIsNight) {
            Iterator<String> iterator;
            if (UndeadNights.serverState.getRespawnZombies() && UndeadNights.serverState.getHordeNight() && MainConfig.getSpawnAdditionalWaves()) {
                if (UndeadNights.serverState.getTickCounter() > 0) {
                    UndeadNights.serverState.setTickCounter(UndeadNights.serverState.getTickCounter() - 1);
                    return;
                }
                UndeadNights.serverState.setTickCounter(MainConfig.getCooldownBetweenWaves() * 20);
                randomValue = randomSource.nextIntBetweenInclusive(1, 100);
                if (randomValue > 100 - MainConfig.getChanceForAdditionalWaves()) {
                    if (MainConfig.getPrintDebugMessages()) {
                        UndeadNights.LOGGER.info("New Wave, randomValue was: {}", (Object)randomValue);
                    }
                    UndeadNights.serverState.setSpawnZombies(true);
                    UndeadNights.serverState.setRespawnZombies(false);
                } else {
                    if (MainConfig.getPrintDebugMessages()) {
                        UndeadNights.LOGGER.info("RandomValue: {}", (Object)randomValue);
                    }
                    return;
                }
            }
            if (UndeadNights.serverState.getNightIsStarting() && UndeadNights.serverState.getDaysCounter() >= 1) {
                if (UndeadNights.serverState.getGracePeriod() > 0) {
                    UndeadNights.serverState.setGracePeriod(UndeadNights.serverState.getGracePeriod() - 1);
                    if (MainConfig.getSendHordeNightsCountdownMessage()) {
                        for (ServerPlayer serverPlayer3 : level.getPlayers(LivingEntity::isAlive)) {
                            serverPlayer3.sendSystemMessage((Component)Component.translatable((String)"message.undeadnights.days_of_grace_remaining", (Object[])new Object[]{String.valueOf(UndeadNights.serverState.getGracePeriod())}));
                        }
                    }
                    if (UndeadNights.serverState.getGracePeriod() == 0) {
                        UndeadNights.serverState.setDaysCounter(1);
                    } else {
                        return;
                    }
                }
                UndeadNights.serverState.setDaysCounter(UndeadNights.serverState.getDaysCounter() - 1);
                if (UndeadNights.serverState.getDaysCounter() > 0 && MainConfig.getSendHordeNightsCountdownMessage()) {
                    for (ServerPlayer serverPlayer4 : level.getPlayers(LivingEntity::isAlive)) {
                        if (UndeadNights.serverState.getDaysCounter() > 1) {
                            serverPlayer4.sendSystemMessage((Component)Component.translatable((String)"message.undeadnights.nights_remaining", (Object[])new Object[]{String.valueOf(UndeadNights.serverState.getDaysCounter())}));
                            continue;
                        }
                        serverPlayer4.sendSystemMessage((Component)Component.translatable((String)"message.undeadnights.last_nights"));
                    }
                }
                if (MainConfig.getPrintDebugMessages()) {
                    UndeadNights.LOGGER.info("Night is coming, NormalizedTimeOfDay: {}, TimeOfDay: {}, DaysCounter: {}, GameTime: {}, GameTimeDays: {}", new Object[]{normalizedTimeOfDay, level.getDayTime(), UndeadNights.serverState.getDaysCounter(), level.getGameTime(), level.getGameTime() / 24000L});
                }
            }
            if (UndeadNights.serverState.getDaysCounter() > 0 && !UndeadNights.serverState.getHordeNight()) {
                if (UndeadNights.serverState.getTryToSpawnRandomHorde()) {
                    if (MainConfig.getEnableRandomHordes() && UndeadNights.globalSpawnCounter < MainConfig.getHordeMobsSpawnCap() && (randomValue = randomSource.nextIntBetweenInclusive(1, 100)) > 100 - MainConfig.getChanceForRandomHordes()) {
                        ServerPlayer serverPlayer5;
                        iterator = level.getPlayers(LivingEntity::isAlive).iterator();
                        while (iterator.hasNext() && this.spawnHorde(level, serverPlayer5 = (ServerPlayer)iterator.next(), randomSource) != -1) {
                            if (!MainConfig.getPrintDebugMessages()) continue;
                            UndeadNights.LOGGER.info("A random horde has spawned!");
                        }
                    }
                    UndeadNights.serverState.setTryToSpawnRandomHorde(false);
                }
                if (MainConfig.getHordeZombiesSpawnNaturally() && UndeadNights.globalSpawnCounter < MainConfig.getHordeMobsSpawnCap()) {
                    if (UndeadNights.serverState.getTickCounter() > 0) {
                        UndeadNights.serverState.setTickCounter(UndeadNights.serverState.getTickCounter() - 1);
                        return;
                    }
                    UndeadNights.serverState.setTickCounter(100);
                    if (!(randomSource.nextFloat() < 0.03f)) {
                        return;
                    }
                    for (ServerPlayer serverPlayer6 : level.getPlayers(LivingEntity::isAlive)) {
                        BlockPos pos = this.getBlockPosWithDistance(serverPlayer6.blockPosition(), (Level)level, MainConfig.getDistanceMin(), MainConfig.getDistanceMax());
                        if (!this.checkSpawnLocation(level, pos.getX(), pos.getY() - 1, pos.getZ())) {
                            return;
                        }
                        this.spawnHordeMob(level, randomSource, pos, (Player)serverPlayer6, new HordeConfig.MobSpawnData("undeadnights:horde_zombie", 100, 0, 0, "none", ""));
                        if (!MainConfig.getPrintDebugMessages()) continue;
                        UndeadNights.LOGGER.info("A stray horde zombie spawned!");
                    }
                }
                return;
            }
            if (UndeadNights.serverState.getNightIsStarting()) {
                randomValue = randomSource.nextIntBetweenInclusive(1, 100);
                if (randomValue <= 100 - MainConfig.getChanceForHordeNight()) {
                    return;
                }
                UndeadNights.serverState.setIsNaturalSpawningOk(true);
                UndeadNights.serverState.setHordeNight(true);
                UndeadNights.serverState.setSpawnZombies(true);
                UndeadNights.serverState.setFirstWaveHasSpawned(false);
                for (ServerPlayer serverPlayer7 : level.getPlayers(LivingEntity::isAlive)) {
                    serverPlayer7.sendSystemMessage((Component)Component.translatable((String)"message.undeadnights.horde_night").withStyle(ChatFormatting.RED));
                }
                if (MainConfig.getPrintDebugMessages()) {
                    UndeadNights.LOGGER.info("The coming night is a Horde Night, HordeNight: {}", (Object)UndeadNights.serverState.getHordeNight());
                }
            }
            if (UndeadNights.serverState.getSpawnZombies() && UndeadNights.serverState.getHordeNight() && normalizedTimeOfDay >= 12542L) {
                ServerPlayer serverPlayer8;
                if (UndeadNights.serverState.getHordesCounter() != 0 && UndeadNights.serverState.getHordesCounter() - 1 == 0) {
                    return;
                }
                iterator = level.getPlayers(LivingEntity::isAlive).iterator();
                while (iterator.hasNext() && this.spawnHorde(level, serverPlayer8 = (ServerPlayer)iterator.next(), randomSource) != -1) {
                    UndeadNights.serverState.setFirstWaveHasSpawned(true);
                    UndeadNights.serverState.setHordesCounter(UndeadNights.serverState.getHordesCounter() - 1);
                }
                if (!UndeadNights.serverState.getFirstWaveHasSpawned()) {
                    UndeadNights.serverState.setTickCounter(200);
                } else {
                    UndeadNights.serverState.setTickCounter(MainConfig.getCooldownBetweenWaves() * 20);
                    UndeadNights.serverState.setSpawnZombies(false);
                    UndeadNights.serverState.setRespawnZombies(true);
                    if (MainConfig.getPrintDebugMessages()) {
                        UndeadNights.LOGGER.info("Spawned waves for every player: DaysCounter: {} GlobalSpawnCounter: {} Spawn: {}, respawn: {}", new Object[]{UndeadNights.serverState.getDaysCounter(), UndeadNights.globalSpawnCounter, UndeadNights.serverState.getSpawnZombies(), UndeadNights.serverState.getRespawnZombies()});
                    }
                }
                UndeadNights.serverState.setDaysCounter(MainConfig.getDaysBetweenHordeNights());
                this.d = 0.0;
                this.x = 0.0;
                this.z = 0.0;
            }
        } else {
            if (UndeadNights.serverState.getHordeNight()) {
                for (ServerPlayer serverPlayer9 : level.getPlayers(LivingEntity::isAlive)) {
                    serverPlayer9.sendSystemMessage((Component)Component.translatable((String)"message.undeadnights.horde_night_over"));
                }
                UndeadNights.serverState.setDaysCounter(MainConfig.getDaysBetweenHordeNights());
                if (MainConfig.getMaxHordesPerHordeNight() != 0) {
                    UndeadNights.serverState.setHordesCounter(MainConfig.getMaxHordesPerHordeNight() + 1);
                } else {
                    UndeadNights.serverState.setHordesCounter(0);
                }
                if (MainConfig.getPrintDebugMessages()) {
                    UndeadNights.LOGGER.info("The Night of the Undead is over, TimeOfDay: {} DaysCounter: {} GlobalSpawnCounter: {}", new Object[]{level.getDayTime(), UndeadNights.serverState.getDaysCounter(), UndeadNights.globalSpawnCounter});
                }
            }
            UndeadNights.serverState.setHordeNight(false);
            UndeadNights.serverState.setSpawnZombies(true);
            UndeadNights.serverState.setRespawnZombies(false);
            UndeadNights.serverState.setTryToSpawnRandomHorde(true);
        }
    }
}

