/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights.world.spawner;

import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.Level;
import net.petemc.undeadnights.UndeadNights;
import net.petemc.undeadnights.command.SpawnHordeCommand;
import net.petemc.undeadnights.config.HordeConfig;
import net.petemc.undeadnights.config.MainConfig;
import net.petemc.undeadnights.effect.ModEffects;
import net.petemc.undeadnights.util.SpawnLocationFinder;
import net.petemc.undeadnights.util.SpawnProcess;
import org.jetbrains.annotations.NotNull;

public class HordeSpawner
implements CustomSpawner {
    public static boolean invalidHordeMobEntry = false;
    public static int hordeIdFromHordesConfig = 1;
    public HashMap<UUID, HordeSpawnTask> hordeSpawningPerPlayer = new HashMap();

    public SpawnHordeResult spawnHorde(ServerLevel level, ServerPlayer player, RandomSource randomSource) {
        if (!this.hordeSpawningPerPlayer.containsKey(player.m_20148_())) {
            this.hordeSpawningPerPlayer.put(player.m_20148_(), new HordeSpawnTask(SpawnProcess.asynchronousHordeSpawner(level, player, randomSource), 10));
            if (MainConfig.getPrintDebugMessages()) {
                player.m_213846_((Component)Component.m_237113_((String)"[DEBUG] Finding horde spawn location (async)...").m_130940_(ChatFormatting.DARK_AQUA));
            }
            if (MainConfig.getPrintDebugMessages()) {
                UndeadNights.LOGGER.info("Async horde spawning location calculation for player {} at {}", (Object)player.m_7755_().getString(), (Object)player.m_20183_());
            }
        }
        HordeSpawnTask existingHordeSpawnTask = this.hordeSpawningPerPlayer.get(player.m_20148_());
        CompletableFuture<SpawnHordeResult> existingFutureSpawnHorde = existingHordeSpawnTask.futureResult;
        if (existingFutureSpawnHorde != null && existingFutureSpawnHorde.isDone()) {
            SpawnHordeResult result = SpawnHordeResult.FAILED;
            try {
                result = existingFutureSpawnHorde.get();
            }
            catch (Exception e) {
                UndeadNights.LOGGER.warn("Spawning horde for player {} failed!", (Object)player.m_7755_().getString());
            }
            if (result == SpawnHordeResult.DONE) {
                this.hordeSpawningPerPlayer.remove(player.m_20148_());
                return result;
            }
            if (existingHordeSpawnTask.tries > 0) {
                --existingHordeSpawnTask.tries;
                return SpawnHordeResult.NOT_DONE_YET;
            }
            this.hordeSpawningPerPlayer.remove(player.m_20148_());
            return SpawnHordeResult.FAILED;
        }
        return SpawnHordeResult.NOT_DONE_YET;
    }

    public int m_7995_(@NotNull ServerLevel level, boolean spawnMonsters, boolean spawnAnimals) {
        ServerPlayer serverPlayer;
        Entity entity;
        if (!MainConfig.getUndeadNightsEnabled()) {
            return 0;
        }
        if (!spawnMonsters && !MainConfig.getIgnoreDoMobSpawningGamerule()) {
            return 0;
        }
        if (level.m_46472_() != Level.f_46428_) {
            return 0;
        }
        if (UndeadNights.serverState == null) {
            return 0;
        }
        long normalizedTimeOfDay = level.m_46468_() - level.m_46468_() / 24000L * 24000L;
        if (UndeadNights.serverState.getPrevNormalizedTimeOfDay() == normalizedTimeOfDay) {
            return 0;
        }
        UndeadNights.serverState.setNightIsStarting(UndeadNights.serverState.getPrevNormalizedTimeOfDay() < 12000L && normalizedTimeOfDay >= 12000L);
        UndeadNights.serverState.setPrevNormalizedTimeOfDay(normalizedTimeOfDay);
        boolean itIsNight = normalizedTimeOfDay >= 12000L && normalizedTimeOfDay < 22500L;
        boolean allDayLong = UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeNights().getAllDayLongHordeNights() != false && UndeadNights.serverState.getHordeNight() && (normalizedTimeOfDay >= 22500L || normalizedTimeOfDay < 11000L);
        RandomSource randomSource = level.f_46441_;
        int randomValue = 0;
        if (!UndeadNights.serverState.entitiesWithPendingHorde.isEmpty()) {
            for (UUID playerUUID : UndeadNights.serverState.entitiesWithPendingHorde.stream().toList()) {
                SpawnHordeResult result;
                if (UndeadNights.serverState.entitiesWithReceivedHorde.contains(playerUUID) || !((entity = level.m_8791_(playerUUID)) instanceof ServerPlayer)) continue;
                serverPlayer = (ServerPlayer)entity;
                if (MainConfig.getPrintDebugMessages()) {
                    UndeadNights.LOGGER.info("Processing pending horde spawn for player {}.", (Object)serverPlayer.m_7755_().getString());
                }
                if ((result = this.spawnHorde(level, serverPlayer, randomSource)) != SpawnHordeResult.FAILED && result != SpawnHordeResult.DONE) continue;
                if (result == SpawnHordeResult.DONE && MainConfig.getPrintDebugMessages()) {
                    UndeadNights.LOGGER.info("Spawning horde for player {} succeeded.", (Object)serverPlayer.m_7755_().getString());
                }
                UndeadNights.serverState.entitiesWithPendingHorde.remove(playerUUID);
                UndeadNights.serverState.entitiesWithReceivedHorde.add(playerUUID);
                if (result != SpawnHordeResult.FAILED) continue;
                UndeadNights.LOGGER.info("Spawning horde for player {} failed.", (Object)serverPlayer.m_7755_().getString());
                if (!SpawnHordeCommand.spawnHordeByCommand) continue;
                serverPlayer.m_213846_((Component)Component.m_237115_((String)"message.undeadnights.command_spawn_horde_failed"));
                SpawnHordeCommand.spawnHordeByCommand = false;
            }
        }
        if (!UndeadNights.serverState.entitiesWithReceivedHorde.isEmpty()) {
            for (UUID playerUUID : UndeadNights.serverState.entitiesWithReceivedHorde.stream().toList()) {
                entity = level.m_8791_(playerUUID);
                if (!(entity instanceof ServerPlayer) || (serverPlayer = (ServerPlayer)entity).m_21023_((MobEffect)ModEffects.LURE_HORDE.get()) || serverPlayer.m_21023_((MobEffect)ModEffects.STRONG_LURE_HORDE.get())) continue;
                UndeadNights.serverState.entitiesWithReceivedHorde.remove(playerUUID);
            }
        }
        if (itIsNight || allDayLong) {
            UndeadNights.serverState.setPerformDifficultySwitchCheck(true);
            if (UndeadNights.serverState.getRespawnZombies() && UndeadNights.serverState.getHordeNight() && UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeNights().isSpawnAdditionalWaves().booleanValue()) {
                if (UndeadNights.serverState.getTickCounter() > 0) {
                    UndeadNights.serverState.setTickCounter(UndeadNights.serverState.getTickCounter() - 1);
                    return 0;
                }
                UndeadNights.serverState.setTickCounter(UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeNights().getCooldownBetweenWaves() * 20);
                randomValue = randomSource.m_216332_(1, 100);
                if (randomValue > 100 - UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeNights().getChanceForAdditionalWave()) {
                    if (MainConfig.getPrintDebugMessages()) {
                        UndeadNights.LOGGER.info("New Wave, randomValue was: {}", (Object)randomValue);
                    }
                    UndeadNights.serverState.setSpawnZombies(true);
                    UndeadNights.serverState.setRespawnZombies(false);
                } else {
                    if (MainConfig.getPrintDebugMessages()) {
                        UndeadNights.LOGGER.info("RandomValue: {}", (Object)randomValue);
                    }
                    return 0;
                }
            }
            if (UndeadNights.serverState.getNightIsStarting() && UndeadNights.serverState.getDaysCounter() >= 1) {
                if (UndeadNights.serverState.getGracePeriod() > 0) {
                    UndeadNights.serverState.setGracePeriod(UndeadNights.serverState.getGracePeriod() - 1);
                    if (MainConfig.getSendHordeNightsCountdownMessage()) {
                        for (ServerPlayer player : level.m_8795_(LivingEntity::m_6084_)) {
                            player.m_213846_((Component)Component.m_237110_((String)"message.undeadnights.days_of_grace_remaining", (Object[])new Object[]{String.valueOf(UndeadNights.serverState.getGracePeriod())}));
                        }
                    }
                    if (UndeadNights.serverState.getGracePeriod() == 0) {
                        UndeadNights.serverState.setDaysCounter(1);
                    } else {
                        return 0;
                    }
                }
                UndeadNights.serverState.setDaysCounter(UndeadNights.serverState.getDaysCounter() - 1);
                if (UndeadNights.serverState.getDaysCounter() > 0 && MainConfig.getSendHordeNightsCountdownMessage()) {
                    for (ServerPlayer player : level.m_8795_(LivingEntity::m_6084_)) {
                        if (UndeadNights.serverState.getDaysCounter() > 1) {
                            player.m_213846_((Component)Component.m_237110_((String)"message.undeadnights.nights_remaining", (Object[])new Object[]{String.valueOf(UndeadNights.serverState.getDaysCounter())}));
                            continue;
                        }
                        player.m_213846_((Component)Component.m_237115_((String)"message.undeadnights.last_nights"));
                    }
                }
                if (MainConfig.getPrintDebugMessages()) {
                    UndeadNights.LOGGER.info("Night is coming, NormalizedTimeOfDay: {}, TimeOfDay: {}, DaysCounter: {}, GameTime: {}, GameTimeDays: {}", new Object[]{normalizedTimeOfDay, level.m_46468_(), UndeadNights.serverState.getDaysCounter(), level.m_46467_(), level.m_46467_() / 24000L});
                }
            }
            if (UndeadNights.serverState.getDaysCounter() > 0 && !UndeadNights.serverState.getHordeNight()) {
                if (UndeadNights.serverState.getTryToSpawnRandomHorde()) {
                    if (UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordes().isEnableRandomHordes().booleanValue() && UndeadNights.globalSpawnCounter < MainConfig.getHordeMobsSpawnCap() && (randomValue = randomSource.m_216332_(1, 100)) > 100 - UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordes().getChanceForRandomHorde()) {
                        ServerPlayer player;
                        Iterator iterator = level.m_8795_(LivingEntity::m_6084_).iterator();
                        while (iterator.hasNext() && this.spawnHorde(level, player = (ServerPlayer)iterator.next(), randomSource) != SpawnHordeResult.FAILED) {
                            if (!MainConfig.getPrintDebugMessages()) continue;
                            UndeadNights.LOGGER.info("A random horde has spawned!");
                        }
                    }
                    UndeadNights.serverState.setTryToSpawnRandomHorde(false);
                }
                if (MainConfig.getHordeZombiesSpawnNaturally() && UndeadNights.globalSpawnCounter < MainConfig.getHordeMobsSpawnCap()) {
                    if (UndeadNights.serverState.getTickCounter() > 0) {
                        UndeadNights.serverState.setTickCounter(UndeadNights.serverState.getTickCounter() - 1);
                        return 0;
                    }
                    UndeadNights.serverState.setTickCounter(100);
                    if (!(randomSource.m_188501_() < 0.03f)) {
                        return 0;
                    }
                    for (ServerPlayer player : level.m_8795_(LivingEntity::m_6084_)) {
                        BlockPos pos = SpawnLocationFinder.getBlockPosWithDistance(player.m_20183_(), (Level)level, MainConfig.getDistanceMin(), MainConfig.getDistanceMax());
                        if (!SpawnLocationFinder.checkSpawnLocation(level, pos.m_123341_(), pos.m_123342_() - 1, pos.m_123343_())) {
                            return 0;
                        }
                        SpawnProcess.spawnHordeMob(level, randomSource, pos, (Player)player, new HordeConfig.MobSpawnData("undeadnights:horde_zombie", 100, 0, 0, "none", ""));
                        if (!MainConfig.getPrintDebugMessages()) continue;
                        UndeadNights.LOGGER.info("A stray horde zombie spawned!");
                    }
                }
                return 0;
            }
            if (UndeadNights.serverState.getNightIsStarting()) {
                randomValue = randomSource.m_216332_(1, 100);
                if (randomValue <= 100 - UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeNights().getChanceForHordeNight()) {
                    return 0;
                }
                UndeadNights.serverState.setIsNaturalSpawningOk(true);
                UndeadNights.serverState.setHordeNight(true);
                UndeadNights.serverState.setSpawnZombies(true);
                UndeadNights.serverState.setFirstWaveHasSpawned(false);
                for (ServerPlayer player : level.m_8795_(LivingEntity::m_6084_)) {
                    player.m_213846_((Component)Component.m_237115_((String)"message.undeadnights.horde_night").m_130940_(ChatFormatting.RED));
                }
                if (MainConfig.getPrintDebugMessages()) {
                    UndeadNights.LOGGER.info("The coming night is a Horde Night, HordeNight: {}", (Object)UndeadNights.serverState.getHordeNight());
                }
            }
            if (UndeadNights.serverState.getSpawnZombies() && UndeadNights.serverState.getHordeNight() && (normalizedTimeOfDay >= 12542L || allDayLong)) {
                if (UndeadNights.serverState.getHordesCounter() != 0 && UndeadNights.serverState.getHordesCounter() - 1 == 0) {
                    return 0;
                }
                for (ServerPlayer player : level.m_8795_(LivingEntity::m_6084_)) {
                    UndeadNights.serverState.entitiesWithPendingHorde.add(player.m_20148_());
                    UndeadNights.serverState.entitiesWithPendingWave.add(player.m_20148_());
                    UndeadNights.serverState.entitiesWithReceivedHorde.remove(player.m_20148_());
                    UndeadNights.serverState.setFirstWaveHasSpawned(true);
                }
                UndeadNights.serverState.setHordesCounter(UndeadNights.serverState.getHordesCounter() - 1);
                if (!UndeadNights.serverState.getFirstWaveHasSpawned()) {
                    UndeadNights.serverState.setTickCounter(200);
                } else {
                    UndeadNights.serverState.setTickCounter(UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeNights().getCooldownBetweenWaves() * 20);
                    UndeadNights.serverState.setSpawnZombies(false);
                    UndeadNights.serverState.setRespawnZombies(true);
                    if (MainConfig.getPrintDebugMessages()) {
                        UndeadNights.LOGGER.info("Spawned waves for every player: DaysCounter: {} GlobalSpawnCounter: {} Spawn: {}, respawn: {}", new Object[]{UndeadNights.serverState.getDaysCounter(), UndeadNights.globalSpawnCounter, UndeadNights.serverState.getSpawnZombies(), UndeadNights.serverState.getRespawnZombies()});
                    }
                }
                UndeadNights.serverState.setDaysCounter(UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeNights().getDaysBetweenHordeNights());
            }
        } else {
            if (UndeadNights.serverState.getHordeNight()) {
                for (ServerPlayer player : level.m_8795_(LivingEntity::m_6084_)) {
                    if (!UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeNights().getAllDayLongHordeNights().booleanValue()) {
                        player.m_213846_((Component)Component.m_237115_((String)"message.undeadnights.horde_night_over"));
                    } else {
                        player.m_213846_((Component)Component.m_237115_((String)"message.undeadnights.horde_time_over"));
                    }
                    if (!UndeadNights.serverState.entitiesWithPendingWave.contains(player.m_20148_())) continue;
                    UndeadNights.serverState.entitiesWithPendingWave.remove(player.m_20148_());
                    UndeadNights.serverState.entitiesWithPendingHorde.remove(player.m_20148_());
                }
                UndeadNights.serverState.setDaysCounter(UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeNights().getDaysBetweenHordeNights());
                if (UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeNights().getMaxHordesPerHordeNight() != 0) {
                    UndeadNights.serverState.setHordesCounter(UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeNights().getMaxHordesPerHordeNight() + 1);
                } else {
                    UndeadNights.serverState.setHordesCounter(0);
                }
                if (MainConfig.getPrintDebugMessages()) {
                    UndeadNights.LOGGER.info("The Night of the Undead is over, TimeOfDay: {} DaysCounter: {} GlobalSpawnCounter: {}", new Object[]{level.m_46468_(), UndeadNights.serverState.getDaysCounter(), UndeadNights.globalSpawnCounter});
                }
            }
            if (normalizedTimeOfDay >= 11500L && !level.m_8795_(LivingEntity::m_6084_).isEmpty() && UndeadNights.automaticDifficultyProgressionActive) {
                boolean flag = false;
                if (UndeadNights.serverState.isPerformDifficultySwitchCheck()) {
                    flag = UndeadNights.difficultyConfig.checkForDifficultyLevelSwitch((int)(level.m_46468_() / 24000L) + 1, level.f_46441_);
                    UndeadNights.serverState.setPerformDifficultySwitchCheck(false);
                }
                if ((flag || !UndeadNights.serverState.isFirstDifficultyLevelPrinted()) && UndeadNights.difficultyConfig.getDifficultyLevels().size() > 1) {
                    for (ServerPlayer player : level.m_8795_(LivingEntity::m_6084_)) {
                        player.m_213846_((Component)Component.m_237113_((String)UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultyName()).m_130940_(ChatFormatting.YELLOW));
                    }
                    if (MainConfig.getPrintDebugMessages()) {
                        UndeadNights.LOGGER.info("Difficulty level set to {}", (Object)UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultyName());
                    }
                    UndeadNights.serverState.setPossibleHordesIndex(-1);
                    UndeadNights.serverState.setFirstDifficultyLevelPrinted(true);
                }
            }
            UndeadNights.serverState.setHordeNight(false);
            UndeadNights.serverState.setSpawnZombies(true);
            UndeadNights.serverState.setRespawnZombies(false);
            UndeadNights.serverState.setTryToSpawnRandomHorde(true);
        }
        return 0;
    }

    public static class HordeSpawnTask {
        public CompletableFuture<SpawnHordeResult> futureResult;
        public int tries = 0;

        public HordeSpawnTask(CompletableFuture<SpawnHordeResult> futureResult, int tries) {
            this.futureResult = futureResult;
            this.tries = tries;
        }
    }

    public static enum SpawnHordeResult {
        DONE,
        NOT_DONE_YET,
        FAILED;

    }
}

