/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights.util;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.petemc.undeadnights.UndeadNights;
import net.petemc.undeadnights.config.MainConfig;
import net.petemc.undeadnights.entity.HordeZombieEntity;
import net.petemc.undeadnights.entity.ModEntities;

public class Helpers {
    public static boolean caveCheckStageOne(Level level, BlockPos pos) {
        int z;
        int layersAbove = 0;
        int x = pos.m_123341_();
        int y = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z = pos.m_123343_());
        if (y == pos.m_123342_()) {
            return false;
        }
        y = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, x, z);
        if (y == pos.m_123342_()) {
            return false;
        }
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos(x, pos.m_123342_() + 1, z);
        while (checkPos.m_123342_() < y) {
            BlockState state = level.m_8055_((BlockPos)checkPos);
            if (state.m_60795_()) {
                layersAbove = 0;
                checkPos.m_122184_(0, 1, 0);
                continue;
            }
            if (state.m_60713_(Blocks.f_49990_)) {
                layersAbove = 0;
                checkPos.m_122184_(0, 1, 0);
                continue;
            }
            if (state.m_60713_(Blocks.f_152550_) && checkPos.m_123342_() > 8) {
                layersAbove = 0;
                checkPos.m_122184_(0, 1, 0);
                continue;
            }
            if (state.m_60713_(Blocks.f_50652_)) {
                layersAbove = 0;
                checkPos.m_122184_(0, 1, 0);
                continue;
            }
            if (state.m_204336_(BlockTags.f_13035_)) {
                layersAbove = 0;
                checkPos.m_122184_(0, 1, 0);
                continue;
            }
            if (++layersAbove > 3) {
                return true;
            }
            checkPos.m_122184_(0, 1, 0);
        }
        return false;
    }

    public static boolean caveCheckStageTwo(Level level, BlockPos pos) {
        AABB box = new AABB(pos).m_82377_(10.0, 0.0, 10.0);
        AtomicBoolean isCave = new AtomicBoolean(true);
        BlockPos.MutableBlockPos.m_121921_((AABB)box).forEach(c -> {
            int y1 = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, c.m_123341_(), c.m_123343_());
            if (c.m_123342_() + 5 >= y1) {
                isCave.set(false);
            }
        });
        return isCave.get();
    }

    public static boolean hasDirectPath(Level level, BlockPos start, BlockPos end) {
        Vec3 startVec = Vec3.m_82512_((Vec3i)start);
        Vec3 endVec = Vec3.m_82512_((Vec3i)end);
        Vec3 dir = endVec.m_82546_(startVec);
        double dist = dir.m_82553_();
        if (dist == 0.0) {
            return true;
        }
        double samplesPerBlock = 4.0;
        int steps = (int)Math.ceil(dist * samplesPerBlock);
        Vec3 step = dir.m_82490_(1.0 / (double)steps);
        Vec3 cur = startVec;
        for (int i = 0; i <= steps; ++i) {
            BlockPos samplePos = BlockPos.m_274561_((double)cur.m_7096_(), (double)cur.m_7098_(), (double)cur.m_7094_());
            BlockState state = level.m_8055_(samplePos);
            if (!state.m_60812_((BlockGetter)level, samplePos).m_83281_()) {
                return false;
            }
            cur = cur.m_82549_(step);
        }
        return true;
    }

    public static boolean canPathfind(Level level, BlockPos start, BlockPos end, float mobWidth, float mobHeight) {
        Vec3 startVec = Vec3.m_82512_((Vec3i)start);
        Vec3 endVec = Vec3.m_82512_((Vec3i)end);
        Vec3 dir = endVec.m_82546_(startVec);
        double dist = dir.m_82553_();
        if (dist == 0.0) {
            return true;
        }
        double samplesPerBlock = 3.0;
        int steps = (int)Math.ceil(dist * samplesPerBlock);
        Vec3 step = dir.m_82490_(1.0 / (double)steps);
        Vec3 cur = startVec;
        double halfWidth = (double)mobWidth / 2.0;
        for (int i = 0; i <= steps; ++i) {
            AABB entityBox = new AABB(cur.f_82479_ - halfWidth, cur.f_82480_, cur.f_82481_ - halfWidth, cur.f_82479_ + halfWidth, cur.f_82480_ + (double)mobHeight, cur.f_82481_ + halfWidth);
            int minX = (int)Math.floor(entityBox.f_82288_);
            int minY = (int)Math.floor(entityBox.f_82289_);
            int minZ = (int)Math.floor(entityBox.f_82290_);
            int maxX = (int)Math.floor(entityBox.f_82291_);
            int maxY = (int)Math.floor(entityBox.f_82292_);
            int maxZ = (int)Math.floor(entityBox.f_82293_);
            for (int bx = minX; bx <= maxX; ++bx) {
                for (int by = minY; by <= maxY; ++by) {
                    for (int bz = minZ; bz <= maxZ; ++bz) {
                        BlockPos bpos = new BlockPos(bx, by, bz);
                        BlockState state = level.m_8055_(bpos);
                        if (state.m_60812_((BlockGetter)level, bpos).m_83281_()) continue;
                        return false;
                    }
                }
            }
            cur = cur.m_82549_(step);
        }
        return true;
    }

    public static boolean canMobPathfind(Level level, BlockPos start, BlockPos end, float mobWidth, float mobHeight) {
        Vec3 startVec = Vec3.m_82512_((Vec3i)start);
        Vec3 endVec = Vec3.m_82512_((Vec3i)end);
        Vec3 dir = endVec.m_82546_(startVec);
        double dist = dir.m_82553_();
        if (dist == 0.0) {
            return true;
        }
        double samplesPerBlock = 3.0;
        int steps = (int)Math.ceil(dist * samplesPerBlock);
        Vec3 step = dir.m_82490_(1.0 / (double)steps);
        Vec3 cur = startVec;
        double halfWidth = (double)mobWidth / 2.0;
        for (int i = 0; i <= steps; ++i) {
            AABB entityBox = new AABB(cur.m_7096_() - halfWidth, cur.m_7098_(), cur.m_7094_() - halfWidth, cur.m_7096_() + halfWidth, cur.m_7098_() + (double)mobHeight, cur.m_7094_() + halfWidth);
            if (Helpers.isAABBFree(level, entityBox)) {
                cur = cur.m_82549_(step);
                continue;
            }
            Vec3 upVec = new Vec3(cur.m_7096_(), cur.m_7098_() + 1.0, cur.m_7094_());
            AABB upBox = new AABB(upVec.m_7096_() - halfWidth, upVec.m_7098_(), upVec.m_7094_() - halfWidth, upVec.m_7096_() + halfWidth, upVec.m_7098_() + (double)mobHeight, upVec.m_7094_() + halfWidth);
            BlockPos upCenter = BlockPos.m_274561_((double)upVec.m_7096_(), (double)upVec.m_7098_(), (double)upVec.m_7094_());
            if (upVec.m_7098_() + (double)mobHeight <= (double)level.m_151558_() && Helpers.isAABBFree(level, upBox) && Helpers.hasSolidBlockBelow(level, upCenter)) {
                cur = upVec.m_82549_(step);
                continue;
            }
            Vec3 downVec = new Vec3(cur.m_7096_(), cur.m_7098_() - 1.0, cur.m_7094_());
            AABB downBox = new AABB(downVec.m_7096_() - halfWidth, downVec.m_7098_(), downVec.m_7094_() - halfWidth, downVec.m_7096_() + halfWidth, downVec.m_7098_() + (double)mobHeight, downVec.m_7094_() + halfWidth);
            BlockPos downCenter = BlockPos.m_274561_((double)downVec.m_7096_(), (double)downVec.m_7098_(), (double)downVec.m_7094_());
            if (downVec.m_7098_() >= (double)level.m_141937_() && Helpers.isAABBFree(level, downBox) && Helpers.hasSolidBlockBelow(level, downCenter)) {
                cur = downVec.m_82549_(step);
                continue;
            }
            return false;
        }
        return true;
    }

    public static List<BlockPos> findPathAStar(Level level, BlockPos start, BlockPos end, float mobWidth, float mobHeight, int maxNodes) {
        return Helpers.findPathAStarWithLimits(level, start, end, mobWidth, mobHeight, maxNodes, 4, 1, 0);
    }

    public static List<BlockPos> findPathAStar(Level level, BlockPos start, BlockPos end, float mobWidth, float mobHeight, int maxNodes, int maxDown) {
        return Helpers.findPathAStarWithLimits(level, start, end, mobWidth, mobHeight, maxNodes, maxDown, 1, 0);
    }

    public static List<BlockPos> findPathAStar(Level level, BlockPos start, BlockPos end, float mobWidth, float mobHeight, int maxNodes, int maxDown, int maxUp, int endRadius) {
        return Helpers.findPathAStarWithLimits(level, start, end, mobWidth, mobHeight, maxNodes, maxDown, maxUp, Math.max(0, endRadius));
    }

    public static boolean canMobPathfindAStar(Level level, BlockPos start, BlockPos end, float mobWidth, float mobHeight, int maxNodes, int maxDown, int maxUp) {
        return Helpers.canMobPathfindAStar(level, start, end, mobWidth, mobHeight, maxNodes, maxDown, maxUp, 10);
    }

    public static boolean canMobPathfindAStar(Level level, BlockPos start, BlockPos end, float mobWidth, float mobHeight, int maxNodes, int maxDown, int maxUp, int endRadius) {
        List<BlockPos> path = Helpers.findPathAStar(level, start, end, mobWidth, mobHeight, maxNodes, maxDown, maxUp, Math.max(0, endRadius));
        return !path.isEmpty();
    }

    private static List<BlockPos> findPathAStarWithLimits(Level level, BlockPos start, BlockPos end, float mobWidth, float mobHeight, int maxNodes, int maxDown, int maxUp, int endRadius) {
        PathNode current;
        BlockPos fixedEnd;
        BlockPos fixedStart = start == null ? null : start.m_7949_();
        BlockPos blockPos = fixedEnd = end == null ? null : end.m_7949_();
        if (fixedStart == null || fixedEnd == null) {
            return Collections.emptyList();
        }
        if (level.m_8055_(fixedStart).m_60713_(Blocks.f_49990_)) {
            BlockPos alt = Helpers.findNearbyStandable(level, start, mobWidth, mobHeight, 5);
            if (alt == null || level.m_8055_(alt).m_60713_(Blocks.f_49990_)) {
                return Collections.emptyList();
            }
            fixedStart = alt.m_7949_();
        }
        PriorityQueue<PathNode> open = new PriorityQueue<PathNode>(Comparator.comparingDouble(n -> n.f));
        HashMap<BlockPos, Double> gScore = new HashMap<BlockPos, Double>();
        HashSet<BlockPos> closed = new HashSet<BlockPos>();
        class PathNode {
            final BlockPos pos;
            final double g;
            final double f;
            final PathNode parent;

            PathNode(BlockPos pos, double g, double f, PathNode parent) {
                this.pos = pos;
                this.g = g;
                this.f = f;
                this.parent = parent;
            }
        }
        PathNode startNode = new PathNode(fixedStart, 0.0, Helpers.heuristic(fixedStart, fixedEnd), null);
        open.add(startNode);
        gScore.put(fixedStart, 0.0);
        int expanded = 0;
        int[][] dirs = new int[][]{{1, 0}, {-1, 0}, {0, 1}, {0, -1}, {1, 1}, {1, -1}, {-1, 1}, {-1, -1}};
        int minY = level.m_141937_();
        int maxY = level.m_151558_();
        while (!open.isEmpty() && expanded < maxNodes && (current = open.poll()) != null) {
            double distToGoal = Helpers.heuristic(current.pos, fixedEnd);
            if (distToGoal <= (double)endRadius) {
                LinkedList<BlockPos> path = new LinkedList<BlockPos>();
                PathNode it = current;
                while (it != null) {
                    path.addFirst(it.pos);
                    it = it.parent;
                }
                return path;
            }
            Double bestG = (Double)gScore.get(current.pos);
            if (bestG != null && current.g > bestG + 1.0E-6) continue;
            closed.add(current.pos);
            ++expanded;
            block2: for (int[] d : dirs) {
                int nx = current.pos.m_123341_() + d[0];
                int nz = current.pos.m_123343_() + d[1];
                int scanTop = Math.min(current.pos.m_123342_() + maxUp, maxY);
                int scanBottom = Math.max(current.pos.m_123342_() - maxDown, minY);
                for (int ny = scanTop; ny >= scanBottom; --ny) {
                    double horizontalCost;
                    BlockState neighborState;
                    BlockPos neighbor;
                    int vertDiff = ny - current.pos.m_123342_();
                    if (vertDiff > maxUp || vertDiff < -maxDown || closed.contains(neighbor = new BlockPos(nx, ny, nz)) || (neighborState = level.m_8055_(neighbor)).m_60713_(Blocks.f_49990_) || neighborState.m_60819_().m_205070_(FluidTags.f_13131_) || !Helpers.canStandAt(level, neighbor, mobWidth, mobHeight)) continue;
                    boolean isDiagonal = Math.abs(d[0]) == 1 && Math.abs(d[1]) == 1;
                    double d2 = horizontalCost = isDiagonal ? 1.41421356237 : 1.0;
                    if (vertDiff == 0) {
                        horizontalCost *= 0.9;
                    }
                    double verticalPenalty = (double)Math.abs(vertDiff) * (vertDiff < 0 ? 1.0 : 0.5);
                    double tentativeG = current.g + horizontalCost + verticalPenalty;
                    Double existingG = (Double)gScore.get(neighbor);
                    if (existingG == null || tentativeG < existingG - 1.0E-9) {
                        gScore.put(neighbor, tentativeG);
                        double f = tentativeG + Helpers.heuristic(neighbor, fixedEnd);
                        PathNode node = new PathNode(neighbor, tentativeG, f, current);
                        open.add(node);
                    }
                    if (Helpers.canStandAt(level, neighbor, mobWidth, mobHeight)) continue block2;
                }
            }
        }
        return Collections.emptyList();
    }

    private static BlockPos findNearbyStandable(Level level, BlockPos center, float mobWidth, float mobHeight, int radius) {
        BlockPos best = null;
        int bestDist = Integer.MAX_VALUE;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                for (int dy = -1; dy <= 1; ++dy) {
                    int dist;
                    BlockPos candidate = center.m_7918_(dx, dy, dz);
                    if (!Helpers.canStandAt(level, candidate, mobWidth, mobHeight) || (dist = Math.abs(dx) + Math.abs(dy) + Math.abs(dz)) >= bestDist) continue;
                    bestDist = dist;
                    best = candidate.m_7949_();
                }
            }
        }
        return best;
    }

    private static double heuristic(BlockPos a, BlockPos b) {
        double dx = (double)a.m_123341_() - (double)b.m_123341_();
        double dy = (double)a.m_123342_() - (double)b.m_123342_();
        double dz = (double)a.m_123343_() - (double)b.m_123343_();
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    private static boolean checkSpawnLocation(ServerLevel level, double x, double y, double z) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(x, y, z);
        BlockState blockState = level.m_8055_((BlockPos)mutable);
        Block block = blockState.m_60734_();
        boolean doesNotBlockMovement = block != Blocks.f_50033_ && block != Blocks.f_50570_;
        boolean notWater = true;
        if (!MainConfig.getHordeWavesCanSpawnInWater()) {
            notWater = !blockState.m_60819_().m_205070_(FluidTags.f_13131_);
        }
        boolean notLeaves = true;
        if (!MainConfig.getHordeWavesCanSpawnOnTrees()) {
            notLeaves = !(blockState.m_60734_() instanceof LeavesBlock);
        }
        return doesNotBlockMovement && notLeaves && notWater;
    }

    private static boolean canStandAt(Level level, BlockPos pos, float mobWidth, float mobHeight) {
        double topY;
        double cx = (double)pos.m_123341_() + 0.5;
        double cz = (double)pos.m_123343_() + 0.5;
        double halfWidth = (double)mobWidth / 2.0;
        double bottomY = pos.m_123342_();
        AABB box = new AABB(cx - halfWidth, bottomY, cz - halfWidth, cx + halfWidth, topY = bottomY + (double)mobHeight, cz + halfWidth);
        if (!Helpers.isAABBFree(level, box)) {
            return false;
        }
        return Helpers.hasSolidBlockBelow(level, pos);
    }

    private static boolean isAABBFree(Level level, AABB box) {
        int minX = (int)Math.floor(box.f_82288_);
        int minY = (int)Math.floor(box.f_82289_);
        int minZ = (int)Math.floor(box.f_82290_);
        int maxX = (int)Math.floor(box.f_82291_);
        int maxY = (int)Math.floor(box.f_82292_);
        int maxZ = (int)Math.floor(box.f_82293_);
        for (int bx = minX; bx <= maxX; ++bx) {
            for (int by = minY; by <= maxY; ++by) {
                for (int bz = minZ; bz <= maxZ; ++bz) {
                    BlockPos bpos = new BlockPos(bx, by, bz);
                    BlockState state = level.m_8055_(bpos);
                    VoxelShape shape = state.m_60812_((BlockGetter)level, bpos);
                    if (shape.m_83281_() || state.m_60734_() instanceof FenceBlock || state.m_60734_() instanceof FenceGateBlock || state.m_60734_() instanceof DoorBlock) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean isAABBFreeForSpawn(Level level, AABB box) {
        int minX = (int)Math.floor(box.f_82288_);
        int minY = (int)Math.floor(box.f_82289_);
        int minZ = (int)Math.floor(box.f_82290_);
        int maxX = (int)Math.floor(box.f_82291_);
        int maxY = (int)Math.floor(box.f_82292_);
        int maxZ = (int)Math.floor(box.f_82293_);
        for (int bx = minX; bx <= maxX; ++bx) {
            for (int by = minY; by <= maxY; ++by) {
                for (int bz = minZ; bz <= maxZ; ++bz) {
                    BlockPos bpos = new BlockPos(bx, by, bz);
                    BlockState state = level.m_8055_(bpos);
                    VoxelShape shape = state.m_60812_((BlockGetter)level, bpos);
                    if (shape.m_83281_()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean hasSolidBlockBelow(Level level, BlockPos center) {
        BlockPos below = center.m_7495_();
        if (below.m_123342_() < level.m_141937_()) {
            return false;
        }
        BlockState belowState = level.m_8055_(below);
        boolean hasCollision = !belowState.m_60812_((BlockGetter)level, below).m_83281_();
        boolean isSlab = belowState.m_204336_(BlockTags.f_13031_);
        boolean isStair = belowState.m_204336_(BlockTags.f_13030_);
        boolean isFence = belowState.m_60734_() instanceof FenceBlock;
        boolean isFenceGate = belowState.m_60734_() instanceof FenceGateBlock;
        boolean isDoor = belowState.m_60734_() instanceof DoorBlock;
        return hasCollision || isSlab || isStair || isFence || isFenceGate || isDoor;
    }

    public static BlockPos findEndPositionForPathAStar(Level level, BlockPos end, int distance) {
        return Helpers.findEndPositionForPathAStar(level, end, distance, false, 0.6f, 1.8f, 10000, 4, 1, 0);
    }

    public static BlockPos findEndPositionForPathAStar(Level level, BlockPos start, int distance, boolean canEndInWater, float mobWidth, float mobHeight, int maxNodes, int maxDown, int maxUp) {
        return Helpers.findEndPositionForPathAStar(level, start, distance, canEndInWater, mobWidth, mobHeight, maxNodes, maxDown, maxUp, 10);
    }

    public static BlockPos findEndPositionForPathAStar(Level level, BlockPos start, int distance, boolean canEndInWater, float mobWidth, float mobHeight, int maxNodes, int maxDown, int maxUp, int radius) {
        Node cur;
        double topY;
        if (start == null || level == null) {
            return null;
        }
        int minWorldY = level.m_141937_();
        int maxWorldY = level.m_151558_();
        double sx = (double)start.m_123341_() + 0.5;
        double sz = (double)start.m_123343_() + 0.5;
        double halfWidth = (double)mobWidth / 2.0;
        double bottomY = start.m_123342_();
        AABB startBox = new AABB(sx - halfWidth, bottomY, sz - halfWidth, sx + halfWidth, topY = bottomY + (double)mobHeight, sz + halfWidth);
        if (!Helpers.isAABBFree(level, startBox)) {
            return null;
        }
        if (!Helpers.hasSolidBlockBelow(level, start)) {
            BlockPos found = null;
            int sxInt = start.m_123341_();
            int szInt = start.m_123343_();
            for (int y = start.m_123342_() - 1; y >= minWorldY; --y) {
                BlockPos candidate = new BlockPos(sxInt, y, szInt);
                double cbottomY = candidate.m_123342_();
                double ctopY = cbottomY + (double)mobHeight;
                AABB centered = new AABB((double)candidate.m_123341_() + 0.5 - halfWidth, cbottomY, (double)candidate.m_123343_() + 0.5 - halfWidth, (double)candidate.m_123341_() + 0.5 + halfWidth, ctopY, (double)candidate.m_123343_() + 0.5 + halfWidth);
                if (!Helpers.isAABBFree(level, centered) || !Helpers.hasSolidBlockBelow(level, candidate)) continue;
                found = candidate;
                break;
            }
            if (found == null) {
                return null;
            }
            start = found;
        }
        int[][] dirs = new int[][]{{1, 0}, {-1, 0}, {0, 1}, {0, -1}, {1, 1}, {1, -1}, {-1, 1}, {-1, -1}};
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        HashMap<Long, BlockState> blockStateCache = new HashMap<Long, BlockState>();
        HashMap<Long, Integer> bestDepth = new HashMap<Long, Integer>();
        ArrayList<BlockPos> exactDepthCandidates = new ArrayList<BlockPos>();
        PriorityQueue<Node> open = new PriorityQueue<Node>(Comparator.comparingDouble(n -> n.score));
        int startX = start.m_123341_();
        int startY = start.m_123342_();
        int startZ = start.m_123343_();
        class Node {
            final int x;
            final int y;
            final int z;
            final long key;
            final int depth;
            final double score;

            Node(int x, int y, int z, long key, int depth, double score) {
                this.x = x;
                this.y = y;
                this.z = z;
                this.key = key;
                this.depth = depth;
                this.score = score;
            }
        }
        open.add(new Node(startX, startY, startZ, start.m_121878_(), 0, -0.0));
        bestDepth.put(start.m_121878_(), 0);
        int expanded = 0;
        while (!open.isEmpty() && expanded < Math.max(1, maxNodes) && (cur = open.poll()) != null) {
            if (cur.depth == distance) {
                boolean isWater;
                mutable.m_122178_(cur.x, cur.y, cur.z);
                long cKey = mutable.m_121878_();
                BlockState endState = blockStateCache.computeIfAbsent(cKey, k -> level.m_8055_((BlockPos)mutable));
                int isLava = endState.m_60713_(Blocks.f_49991_) || endState.m_60819_().m_205070_(FluidTags.f_13132_) ? 1 : 0;
                if (isLava != 0) continue;
                boolean bl = isWater = endState.m_60713_(Blocks.f_49990_) || endState.m_60819_().m_205070_(FluidTags.f_13131_);
                if (isWater && !canEndInWater) continue;
                exactDepthCandidates.add(new BlockPos(cur.x, cur.y, cur.z));
                continue;
            }
            Integer recorded = (Integer)bestDepth.get(cur.key);
            if (recorded != null && cur.depth > recorded) continue;
            ++expanded;
            block2: for (int[] d : dirs) {
                int nx = cur.x + d[0];
                int nz = cur.z + d[1];
                int scanTop = Math.min(cur.y + maxUp, maxWorldY);
                int scanBottom = Math.max(cur.y - maxDown, minWorldY);
                for (int ny = scanTop; ny >= scanBottom; --ny) {
                    boolean neighborIsWater;
                    int vert = ny - cur.y;
                    if (vert > maxUp || vert < -maxDown) continue;
                    mutable.m_122178_(nx, ny, nz);
                    long nKey = mutable.m_121878_();
                    int nextDepth = cur.depth + 1;
                    Integer prev = (Integer)bestDepth.get(nKey);
                    if (prev != null && nextDepth >= prev) continue;
                    BlockState neighborState = blockStateCache.computeIfAbsent(nKey, k -> level.m_8055_((BlockPos)mutable));
                    boolean bl = neighborIsWater = neighborState.m_60713_(Blocks.f_49990_) || neighborState.m_60819_().m_205070_(FluidTags.f_13131_);
                    if (nextDepth < distance && neighborIsWater || !Helpers.canStandAt(level, (BlockPos)mutable, mobWidth, mobHeight)) continue;
                    double dx = (double)nx - (double)startX;
                    double dz = (double)nz - (double)startZ;
                    double horiz = Math.sqrt(dx * dx + dz * dz);
                    double vertFromStart = Math.abs((double)ny - (double)startY);
                    double score = -horiz + (double)nextDepth * 0.001 + vertFromStart;
                    bestDepth.put(nKey, nextDepth);
                    open.add(new Node(nx, ny, nz, nKey, nextDepth, score));
                    if (Helpers.canStandAt(level, (BlockPos)mutable, mobWidth, mobHeight)) continue block2;
                }
            }
        }
        if (!exactDepthCandidates.isEmpty()) {
            exactDepthCandidates.sort((a, b) -> {
                double adx = a.m_123341_() - startX;
                double adz = a.m_123343_() - startZ;
                double ad = Math.sqrt(adx * adx + adz * adz);
                double bdx = b.m_123341_() - startX;
                double bdz = b.m_123343_() - startZ;
                double bd = Math.sqrt(bdx * bdx + bdz * bdz);
                return Double.compare(bd, ad);
            });
            double minStraightFactor = 0.8;
            double minStrictHoriz = Math.max((double)radius, (double)distance * minStraightFactor);
            boolean requireStrict = distance >= 50;
            for (BlockPos c : exactDepthCandidates) {
                double ddz;
                double ddx = c.m_123341_() - startX;
                double h = Math.sqrt(ddx * ddx + (ddz = (double)(c.m_123343_() - startZ)) * ddz);
                if (h < minStrictHoriz || Math.abs(c.m_123342_() - startY) > 20) continue;
                return c;
            }
            if (!requireStrict) {
                for (BlockPos c : exactDepthCandidates) {
                    double ddz;
                    double ddx = c.m_123341_() - startX;
                    double h = Math.sqrt(ddx * ddx + (ddz = (double)(c.m_123343_() - startZ)) * ddz);
                    if (h < (double)radius || Math.abs(c.m_123342_() - startY) > 20) continue;
                    return c;
                }
            }
        }
        return null;
    }

    public static BlockPos findEndPositionForPathFast(Level level, BlockPos start, int distance) {
        return Helpers.findEndPositionForPathFast(level, start, distance, false, 0.6f, 1.8f, 250, 4, 1, 0, 3);
    }

    public static BlockPos findEndPositionForPathFast(Level level, BlockPos start, int distance, boolean canEndInWater, float mobWidth, float mobHeight, int maxAttempts, int maxDown, int maxUp, int radius, int tries) {
        double topY;
        if (level == null || start == null || distance <= 0 || maxAttempts <= 0 || tries <= 0) {
            return null;
        }
        boolean debug = MainConfig.getPrintDebugMessages();
        int minWorldY = level.m_141937_();
        int maxWorldY = level.m_151558_();
        double sx = (double)start.m_123341_() + 0.5;
        double sz = (double)start.m_123343_() + 0.5;
        double halfWidth = (double)mobWidth / 2.0;
        double bottomY = start.m_123342_();
        AABB startBox = new AABB(sx - halfWidth, bottomY, sz - halfWidth, sx + halfWidth, topY = bottomY + (double)mobHeight, sz + halfWidth);
        if (!Helpers.isAABBFree(level, startBox)) {
            return null;
        }
        if (!Helpers.hasSolidBlockBelow(level, start)) {
            BlockPos found = null;
            int sxInt = start.m_123341_();
            int szInt = start.m_123343_();
            for (int y = start.m_123342_() - 1; y >= minWorldY; --y) {
                BlockPos candidate = new BlockPos(sxInt, y, szInt);
                double cbottomY = candidate.m_123342_();
                double ctopY = cbottomY + (double)mobHeight;
                AABB centered = new AABB((double)candidate.m_123341_() + 0.5 - halfWidth, cbottomY, (double)candidate.m_123343_() + 0.5 - halfWidth, (double)candidate.m_123341_() + 0.5 + halfWidth, ctopY, (double)candidate.m_123343_() + 0.5 + halfWidth);
                if (!Helpers.isAABBFree(level, centered) || !Helpers.hasSolidBlockBelow(level, candidate)) continue;
                found = candidate;
                break;
            }
            if (found == null) {
                return null;
            }
            start = found;
        }
        int[][] dirs = new int[][]{{1, 0}, {-1, 0}, {0, 1}, {0, -1}, {1, 1}, {1, -1}, {-1, 1}, {-1, -1}};
        BlockPos.MutableBlockPos cur = new BlockPos.MutableBlockPos(start.m_123341_(), start.m_123342_(), start.m_123343_());
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        int astarChecks = 0;
        int MAX_ASTAR_CHECKS = 5;
        double bestOverallScore = Double.NEGATIVE_INFINITY;
        BlockPos bestOverallCandidate = null;
        for (int attempt = 0; attempt < maxAttempts; ++attempt) {
            double candidateScore;
            BlockPos candidate;
            block28: {
                cur.m_122178_(start.m_123341_(), start.m_123342_(), start.m_123343_());
                int curY = cur.m_123342_();
                boolean failed = false;
                for (int stepIdx = 0; stepIdx < distance; ++stepIdx) {
                    int baseX = cur.m_123341_();
                    int baseZ = cur.m_123343_();
                    int baseY = curY;
                    Integer[] order = new Integer[dirs.length];
                    for (int i = 0; i < dirs.length; ++i) {
                        order[i] = i;
                    }
                    Collections.shuffle(Arrays.asList(order), new Random(rnd.nextLong()));
                    int localTries = Math.min(tries, dirs.length);
                    int tried = 0;
                    double bestScore = Double.NEGATIVE_INFINITY;
                    int chosenX = Integer.MIN_VALUE;
                    int chosenY = Integer.MIN_VALUE;
                    int chosenZ = Integer.MIN_VALUE;
                    for (int oi = 0; oi < order.length && tried < localTries; ++oi) {
                        double verticalPenalty;
                        double dz;
                        double dx;
                        double horiz;
                        double score;
                        int cheb;
                        int[] d = dirs[order[oi]];
                        ++tried;
                        int nx = baseX + d[0];
                        int nz = baseZ + d[1];
                        int scanTop = Math.min(baseY + maxUp, maxWorldY);
                        int scanBottom = Math.max(baseY - maxDown, minWorldY);
                        int foundNy = Integer.MIN_VALUE;
                        for (int ny = scanTop; ny >= scanBottom; --ny) {
                            boolean isWater;
                            BlockPos cand = new BlockPos(nx, ny, nz);
                            BlockState st = level.m_8055_(cand);
                            boolean bl = isWater = st.m_60713_(Blocks.f_49990_) || st.m_60819_().m_205070_(FluidTags.f_13131_);
                            if (stepIdx < distance - 1 && isWater || st.m_60713_(Blocks.f_49991_) || st.m_60819_().m_205070_(FluidTags.f_13132_) || !Helpers.quickStandable(level, cand, mobWidth, mobHeight) || !Helpers.canStandAt(level, cand, mobWidth, mobHeight)) continue;
                            foundNy = ny;
                            break;
                        }
                        if (foundNy == Integer.MIN_VALUE || (cheb = Math.max(Math.abs(nx - start.m_123341_()), Math.abs(nz - start.m_123343_()))) > distance + 3 || !((score = (horiz = Math.sqrt((dx = (double)nx - (double)start.m_123341_()) * dx + (dz = (double)nz - (double)start.m_123343_()) * dz)) - (verticalPenalty = (double)Math.abs(foundNy - start.m_123342_()) * 0.2) + rnd.nextDouble() * 0.15) > bestScore)) continue;
                        bestScore = score;
                        chosenX = nx;
                        chosenY = foundNy;
                        chosenZ = nz;
                    }
                    if (chosenX == Integer.MIN_VALUE) {
                        if (debug) {
                            UndeadNights.LOGGER.info("findEndFast: attempt {} step {} - no valid direction found from {} {} {}", new Object[]{attempt, stepIdx, baseX, baseY, baseZ});
                        }
                        failed = true;
                        break;
                    }
                    cur.m_122178_(chosenX, chosenY, chosenZ);
                    curY = chosenY;
                }
                if (failed) continue;
                candidate = cur.m_7949_();
                BlockState finalState = level.m_8055_(candidate);
                if (finalState.m_60713_(Blocks.f_49991_) || finalState.m_60819_().m_205070_(FluidTags.f_13132_)) {
                    if (!debug) continue;
                    UndeadNights.LOGGER.info("findEndFast: candidate {} rejected: lava", (Object)candidate);
                    continue;
                }
                if (!canEndInWater && (finalState.m_60713_(Blocks.f_49990_) || finalState.m_60819_().m_205070_(FluidTags.f_13131_))) {
                    if (!debug) continue;
                    UndeadNights.LOGGER.info("findEndFast: candidate {} rejected: water (end not allowed)", (Object)candidate);
                    continue;
                }
                int cheb = Math.max(Math.abs(candidate.m_123341_() - start.m_123341_()), Math.abs(candidate.m_123343_() - start.m_123343_()));
                if (cheb > distance + 3) {
                    if (!debug) continue;
                    UndeadNights.LOGGER.info("findEndFast: candidate {} rejected: chebyshev {} > allowed {}", new Object[]{candidate, cheb, distance + 3});
                    continue;
                }
                candidateScore = (double)(-Math.abs(cheb - distance)) - (double)Math.abs(candidate.m_123342_() - start.m_123342_()) * 0.1 + rnd.nextDouble() * 0.01;
                if (Math.abs(cheb - distance) <= 4) {
                    try {
                        boolean cheapOk = Helpers.canMobPathfind(level, start, candidate, mobWidth, mobHeight);
                        if (cheapOk) {
                            if (debug) {
                                UndeadNights.LOGGER.info("findEndFast: candidate {} accepted by cheap path check", (Object)candidate);
                            }
                            return candidate;
                        }
                        if (debug) {
                            UndeadNights.LOGGER.info("findEndFast: candidate {} failed cheap path check", (Object)candidate);
                        }
                    }
                    catch (Throwable t) {
                        if (!debug) break block28;
                        UndeadNights.LOGGER.info("findEndFast: candidate {} cheap path check threw: {}", (Object)candidate, (Object)t.toString());
                    }
                }
            }
            if (astarChecks < 5) {
                ++astarChecks;
                int aStarMaxNodes = Math.max(300, Math.min(2000, distance * 8));
                List<BlockPos> realPath = Helpers.findPathAStar(level, start, candidate, mobWidth, mobHeight, aStarMaxNodes, Math.max(1, maxDown), Math.max(1, maxUp), 0);
                if (realPath == null || realPath.isEmpty()) {
                    double penalized;
                    if (debug) {
                        UndeadNights.LOGGER.info("findEndFast: candidate {} A* returned empty path", (Object)candidate);
                    }
                    if (!((penalized = candidateScore - 5.0) > bestOverallScore)) continue;
                    bestOverallScore = penalized;
                    bestOverallCandidate = candidate;
                    continue;
                }
                int pathSteps = Math.max(0, realPath.size() - 1);
                if (Math.abs(pathSteps - distance) > 3) {
                    double penalized;
                    if (debug) {
                        UndeadNights.LOGGER.info("findEndFast: candidate {} A* pathSteps {} deviates from required {}", new Object[]{candidate, pathSteps, distance});
                    }
                    if (!((penalized = candidateScore - 2.0) > bestOverallScore)) continue;
                    bestOverallScore = penalized;
                    bestOverallCandidate = candidate;
                    continue;
                }
                if (debug) {
                    UndeadNights.LOGGER.info("findEndFast: candidate {} accepted by A* (steps={})", (Object)candidate, (Object)pathSteps);
                }
                return candidate;
            }
            if (!(candidateScore > bestOverallScore)) continue;
            bestOverallScore = candidateScore;
            bestOverallCandidate = candidate;
            if (!debug) continue;
            UndeadNights.LOGGER.info("findEndFast: candidate {} recorded as fallback (score={})", (Object)candidate, (Object)candidateScore);
        }
        if (debug) {
            UndeadNights.LOGGER.info("findEndFast: returning fallback candidate {} (score={})", bestOverallCandidate, (Object)bestOverallScore);
        }
        return bestOverallCandidate;
    }

    private static boolean tryComputePath(Level level, BlockPos start, BlockPos end, long pTime) {
        HordeZombieEntity pMob = new HordeZombieEntity((EntityType<? extends Zombie>)((EntityType)ModEntities.HORDE_ZOMBIE.get()), level);
        pMob.m_6034_((double)start.m_123341_() + 0.5, start.m_123342_(), (double)start.m_123343_() + 0.5);
        Path path = pMob.m_21573_().m_7864_(end, 0);
        float speedModifier = 1.2f;
        Brain brain = pMob.m_6274_();
        if (Helpers.reachedTarget((Mob)pMob, end, 0.0f)) {
            brain.m_21936_(MemoryModuleType.f_26326_);
        } else {
            boolean flag;
            boolean bl = flag = path != null && path.m_77403_();
            if (flag) {
                brain.m_21936_(MemoryModuleType.f_26326_);
            } else if (!brain.m_21874_(MemoryModuleType.f_26326_)) {
                brain.m_21879_(MemoryModuleType.f_26326_, (Object)pTime);
            }
            if (path != null) {
                return true;
            }
            Vec3 vec3 = DefaultRandomPos.m_148412_((PathfinderMob)pMob, (int)10, (int)7, (Vec3)Vec3.m_82539_((Vec3i)end), (double)1.5707963705062866);
            if (vec3 != null) {
                path = pMob.m_21573_().m_26524_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0);
                return path != null;
            }
        }
        return false;
    }

    private static boolean reachedTarget(Mob pMob, BlockPos pTarget, float closeEnoughDist) {
        return (float)pTarget.m_123333_((Vec3i)pMob.m_20183_()) <= closeEnoughDist;
    }

    private static boolean quickStandable(Level level, BlockPos pos, float mobWidth, float mobHeight) {
        boolean belowSolid;
        if (level == null || pos == null) {
            return false;
        }
        BlockPos below = pos.m_7495_();
        if (below.m_123342_() < level.m_141937_()) {
            return false;
        }
        BlockState belowState = level.m_8055_(below);
        boolean bl = belowSolid = !belowState.m_60812_((BlockGetter)level, below).m_83281_() || belowState.m_204336_(BlockTags.f_13031_) || belowState.m_204336_(BlockTags.f_13030_) || belowState.m_60734_() instanceof FenceBlock || belowState.m_60734_() instanceof FenceGateBlock || belowState.m_60734_() instanceof DoorBlock;
        if (!belowSolid) {
            return false;
        }
        int checks = Math.min(2, Math.max(1, (int)Math.ceil(mobHeight)));
        for (int dy = 0; dy < checks; ++dy) {
            BlockPos p = pos.m_6630_(dy);
            BlockState s = level.m_8055_(p);
            if (!s.m_60812_((BlockGetter)level, p).m_83281_()) {
                return false;
            }
            if (!s.m_60713_(Blocks.f_49991_) && !s.m_60819_().m_205070_(FluidTags.f_13132_)) continue;
            return false;
        }
        return true;
    }

    public static BlockPos findSpawnablePosition(Level level, BlockPos center, int radius) {
        return Helpers.findSpawnablePosition(level, center, radius, 5);
    }

    public static BlockPos findSpawnablePosition(Level level, BlockPos center, int radius, boolean allowWater, float mobWidth, float mobHeight) {
        return Helpers.findSpawnablePosition(level, center, radius, 5);
    }

    public static BlockPos findSpawnablePosition(Level level, BlockPos center, int radius, int deltaY) {
        int dx;
        if (level == null || center == null) {
            return null;
        }
        int minY = level.m_141937_();
        int maxY = level.m_151558_() - 1;
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        float mobWidth = 0.6f;
        float mobHeight = 1.8f;
        boolean allowWater = MainConfig.getHordeWavesCanSpawnInWater();
        int attempts = 200;
        for (int i = 0; i < 200; ++i) {
            BlockPos cand;
            BlockState feet;
            dx = rnd.nextInt(-radius, radius + 1);
            int dz = rnd.nextInt(-radius, radius + 1);
            int dy = deltaY > 0 ? rnd.nextInt(-deltaY, deltaY + 1) : 0;
            int x = center.m_123341_() + dx;
            int z = center.m_123343_() + dz;
            int y = center.m_123342_() + dy;
            if (y < minY || y > maxY || (feet = level.m_8055_(cand = new BlockPos(x, y, z))).m_60713_(Blocks.f_49991_) || feet.m_60819_().m_205070_(FluidTags.f_13132_) || !Helpers.isValidSpawnPos(level, cand, 0.6f, 1.8f, allowWater)) continue;
            return cand;
        }
        for (int r = 0; r <= radius; ++r) {
            for (dx = -r; dx <= r; ++dx) {
                int[] zs;
                int[] nArray;
                if (r == 0) {
                    int[] nArray2 = new int[1];
                    nArray = nArray2;
                    nArray2[0] = 0;
                } else {
                    int[] nArray3 = new int[2];
                    nArray3[0] = -r;
                    nArray = nArray3;
                    nArray3[1] = r;
                }
                for (int zOff : zs = nArray) {
                    int x = center.m_123341_() + dx;
                    int z = center.m_123343_() + zOff;
                    for (int dy = -deltaY; dy <= deltaY; ++dy) {
                        BlockPos cand;
                        BlockState feet;
                        int y = center.m_123342_() + dy;
                        if (y < minY || y > maxY || (feet = level.m_8055_(cand = new BlockPos(x, y, z))).m_60713_(Blocks.f_49991_) || feet.m_60819_().m_205070_(FluidTags.f_13132_) || !Helpers.isValidSpawnPos(level, cand, 0.6f, 1.8f, allowWater)) continue;
                        return cand;
                    }
                }
            }
        }
        return null;
    }

    private static boolean isValidSpawnPos(Level level, BlockPos pos, float mobWidth, float mobHeight, boolean allowWater) {
        boolean feetIsLava;
        if (level == null || pos == null) {
            return false;
        }
        int minY = level.m_141937_();
        int maxY = level.m_151558_();
        if (pos.m_123342_() < minY || pos.m_123342_() >= maxY) {
            return false;
        }
        BlockState feetState = level.m_8055_(pos);
        boolean feetIsWater = feetState.m_60713_(Blocks.f_49990_) || feetState.m_60819_().m_205070_(FluidTags.f_13131_);
        boolean bl = feetIsLava = feetState.m_60713_(Blocks.f_49991_) || feetState.m_60819_().m_205070_(FluidTags.f_13132_);
        if (feetIsLava) {
            return false;
        }
        if (feetIsWater && !allowWater) {
            return false;
        }
        VoxelShape feetShape = feetState.m_60812_((BlockGetter)level, pos);
        if (!feetShape.m_83281_() && !feetIsWater) {
            return false;
        }
        double cx = (double)pos.m_123341_() + 0.5;
        double cz = (double)pos.m_123343_() + 0.5;
        double bottomY = pos.m_123342_();
        double topY = bottomY + (double)mobHeight;
        double halfWidth = (double)mobWidth / 2.0;
        double eps = 0.001;
        AABB box = new AABB(cx - halfWidth + 0.001, bottomY + 0.001, cz - halfWidth + 0.001, cx + halfWidth - 0.001, topY - 0.001, cz + halfWidth - 0.001);
        if (!Helpers.isAABBFreeForSpawn(level, box)) {
            return false;
        }
        if (!allowWater) {
            int bottomBlock = (int)Math.floor(box.f_82289_);
            int topBlock = (int)Math.floor(box.f_82292_);
            for (int by = bottomBlock; by <= topBlock; ++by) {
                BlockState s = level.m_8055_(new BlockPos(pos.m_123341_(), by, pos.m_123343_()));
                if (!s.m_60713_(Blocks.f_49990_) && !s.m_60819_().m_205070_(FluidTags.f_13131_)) continue;
                return false;
            }
        }
        return Helpers.hasSolidBlockBelow(level, pos);
    }

    public static boolean isPlayerInCave(Level level, BlockPos pos) {
        if (level == null || pos == null) {
            return false;
        }
        int surfaceY = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.m_123341_(), pos.m_123343_());
        if (pos.m_123342_() >= surfaceY - 2) {
            return false;
        }
        if (!Helpers.caveCheckStageOne(level, pos)) {
            return false;
        }
        if (!Helpers.caveCheckStageTwo(level, pos)) {
            return false;
        }
        int hx = 6;
        int hy = 3;
        ImmutableSet buildingMaterials = ImmutableSet.of((Object)Blocks.f_50705_, (Object)Blocks.f_50741_, (Object)Blocks.f_50742_, (Object)Blocks.f_50743_, (Object)Blocks.f_50744_, (Object)Blocks.f_50745_, (Object[])new Block[]{Blocks.f_50655_, Blocks.f_50656_, Blocks.f_50058_, Blocks.f_50185_, Blocks.f_50076_, Blocks.f_50222_, Blocks.f_50223_, Blocks.f_50224_, Blocks.f_50352_, Blocks.f_50287_, Blocks.f_50193_, Blocks.f_50194_});
        int buildCount = 0;
        int lightCount = 0;
        int doorOrEntranceCount = 0;
        for (int dx = -6; dx <= 6; ++dx) {
            for (int dz = -6; dz <= 6; ++dz) {
                for (int dy = -3; dy <= 3; ++dy) {
                    BlockPos p = pos.m_7918_(dx, dy, dz);
                    BlockState s = level.m_8055_(p);
                    Block b = s.m_60734_();
                    if (b == Blocks.f_49990_ || b == Blocks.f_49991_) continue;
                    if (buildingMaterials.contains((Object)b)) {
                        ++buildCount;
                    }
                    if (b == Blocks.f_50081_ || b == Blocks.f_50082_ || b == Blocks.f_50681_ || b == Blocks.f_50682_ || b == Blocks.f_50141_ || b == Blocks.f_50386_ || b == Blocks.f_50261_) {
                        ++lightCount;
                    }
                    if (b instanceof DoorBlock || b instanceof FenceGateBlock || b instanceof FenceBlock) {
                        ++doorOrEntranceCount;
                    }
                    if (buildCount < 8 || lightCount < 1 && doorOrEntranceCount < 1) continue;
                    return false;
                }
            }
        }
        return buildCount < 6 || lightCount < 1 && doorOrEntranceCount < true;
    }

    public static boolean isPlayerInCave(Level level, ServerPlayer player) {
        if (player == null) {
            return false;
        }
        return Helpers.isPlayerInCave(level, player.m_20183_());
    }
}

