/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights.util;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.registries.ForgeRegistries;
import net.petemc.undeadnights.UndeadNights;
import net.petemc.undeadnights.casts.UndeadNightsExtendedPlayer;
import net.petemc.undeadnights.config.HordeConfig;
import net.petemc.undeadnights.config.MainConfig;
import net.petemc.undeadnights.entity.DemolitionZombieEntity;
import net.petemc.undeadnights.entity.HordeZombieEntity;
import net.petemc.undeadnights.entity.ModEntities;
import net.petemc.undeadnights.entity.ai.goal.BreakBlockGoal;
import net.petemc.undeadnights.sound.UndeadNightsSounds;
import net.petemc.undeadnights.util.Helpers;
import net.petemc.undeadnights.util.SpawnLocationFinder;
import net.petemc.undeadnights.world.spawner.HordeSpawner;

public class SpawnProcess {
    public static boolean invalidHordeMobEntry = false;
    public static int hordeIdFromHordesConfig = 1;
    private static double x = 0.0;
    private static double z = 0.0;
    private static double d = 0.0;

    public static CompletableFuture<HordeSpawner.SpawnHordeResult> asynchronousHordeSpawner(ServerLevel level, ServerPlayer player, RandomSource randomSource) {
        return CompletableFuture.supplyAsync(() -> SpawnProcess.spawnHordeImplementation(level, player, randomSource), ForkJoinPool.commonPool());
    }

    public static HordeSpawner.SpawnHordeResult spawnHordeImplementation(ServerLevel level, ServerPlayer player, RandomSource randomSource) {
        int spawnCounter = 0;
        boolean foundHordeSpawnLocation = false;
        int currentHordeCounter = UndeadNights.globalSpawnCounter;
        int maxChecks = 30;
        for (int i = 0; i < maxChecks; ++i) {
            int randomValue;
            if (d == 0.0) {
                d = randomSource.m_216332_(MainConfig.getDistanceMin(), MainConfig.getDistanceMax());
                x = randomSource.m_216332_(0, (int)d);
                if (x == 0.0) {
                    z = d;
                } else {
                    z = Math.sqrt(d * d - x * x);
                    if (randomSource.m_188499_()) {
                        x *= -1.0;
                    }
                }
                if (randomSource.m_188499_()) {
                    z *= -1.0;
                }
            }
            boolean playerInCave = false;
            if (player instanceof UndeadNightsExtendedPlayer) {
                UndeadNightsExtendedPlayer undeadNightsExtendedPlayer = (UndeadNightsExtendedPlayer)player;
                playerInCave = undeadNightsExtendedPlayer.undeadnights_isInCave();
            }
            BlockPos possibleSpawnLocation = player.m_20183_().m_7918_((int)x, 0, (int)z);
            if (MainConfig.getHordeWavesCanSpawnInCaves() && playerInCave) {
                possibleSpawnLocation = SpawnLocationFinder.findEndPositionUsingMinecraftPathfinding((Level)level, player, MainConfig.getCaveSpawnDistance(), MainConfig.getHordeWavesCanSpawnInWater());
                if (possibleSpawnLocation == null) {
                    if (MainConfig.getPrintDebugMessages()) {
                        UndeadNights.LOGGER.info("Cave horde spawn location calculation for player {} failed, trying again.", (Object)player.m_7755_().getString());
                    }
                    d = 0.0;
                    continue;
                }
                if (MainConfig.getPrintDebugMessages()) {
                    player.m_213846_((Component)Component.m_237113_((String)"[DEBUG] Cave horde spawn location calculated.").m_130940_(ChatFormatting.DARK_AQUA));
                }
                if (MainConfig.getPrintDebugMessages()) {
                    UndeadNights.LOGGER.info("Cave horde spawn location calculation for player {} is done, result: {}", (Object)player.m_7755_().getString(), (Object)possibleSpawnLocation);
                }
                foundHordeSpawnLocation = true;
            } else {
                possibleSpawnLocation = new BlockPos(possibleSpawnLocation.m_123341_(), level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, possibleSpawnLocation.m_123341_(), possibleSpawnLocation.m_123343_()) - 1, possibleSpawnLocation.m_123343_());
                if (MainConfig.getPrintDebugMessages()) {
                    UndeadNights.LOGGER.info("Surface horde spawning check for player {} at position {}", (Object)player.m_7755_().getString(), (Object)possibleSpawnLocation);
                }
                foundHordeSpawnLocation = SpawnLocationFinder.checkSpawnLocation(level, possibleSpawnLocation.m_123341_(), possibleSpawnLocation.m_123342_() - 1, possibleSpawnLocation.m_123343_());
            }
            if (!foundHordeSpawnLocation) {
                if (MainConfig.getPrintDebugMessages()) {
                    UndeadNights.LOGGER.info("Horde spawn location check for player {} at position {} failed, trying again.", (Object)player.m_7755_().getString(), (Object)possibleSpawnLocation);
                }
                d = 0.0;
                continue;
            }
            if (MainConfig.getPrintDebugMessages()) {
                UndeadNights.LOGGER.info("A possible Horde spawn location for player {} was found.", (Object)player.m_7755_().getString());
            }
            boolean spawnCapReached = false;
            spawnCounter = 0;
            if (HordeConfig.getConfigVariant() == 1) {
                if (MainConfig.getPrintDebugMessages()) {
                    UndeadNights.LOGGER.info("Horde config variant 1 detected.");
                }
                int waveMobCounter = 0;
                int scaledHordeSize = (int)Math.round((double)HordeConfig.getMaxWaveSize() * UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordes().getHordeSizeScaleFactor());
                if (MainConfig.getPrintDebugMessages()) {
                    UndeadNights.LOGGER.info("Scaled horde size: {}", (Object)scaledHordeSize);
                }
                block1: while (waveMobCounter < scaledHordeSize) {
                    if (!HordeConfig.getHordeMobs().isEmpty()) {
                        for (HordeConfig.MobSpawnData mobSpawnData : HordeConfig.getHordeMobs()) {
                            if (UndeadNights.globalSpawnCounter < MainConfig.getHordeMobsSpawnCap()) {
                                randomValue = randomSource.m_216332_(1, 100);
                                if (SpawnProcess.spawnHordeMob(level, randomSource, possibleSpawnLocation, (Player)player, randomValue > 100 - mobSpawnData.chance() ? mobSpawnData : HordeConfig.getDefaultHordeMob()) == 0) {
                                    ++spawnCounter;
                                }
                                if (++waveMobCounter < scaledHordeSize) continue;
                                d = 0.0;
                                continue block1;
                            }
                            waveMobCounter = scaledHordeSize;
                            spawnCapReached = true;
                            d = 0.0;
                            continue block1;
                        }
                        continue;
                    }
                    if (SpawnProcess.spawnHordeMob(level, randomSource, possibleSpawnLocation, (Player)player, HordeConfig.getDefaultHordeMob()) == 0) {
                        ++spawnCounter;
                    }
                    ++waveMobCounter;
                }
            }
            if (HordeConfig.getConfigVariant() == 2) {
                if (MainConfig.getPrintDebugMessages()) {
                    UndeadNights.LOGGER.info("Horde config variant 2 detected.");
                }
                if (hordeIdFromHordesConfig == 0) {
                    UndeadNights.LOGGER.warn("Horde to spawn was set to 0, setting it to 1.");
                    hordeIdFromHordesConfig = 1;
                }
                int hordeIdToSpawn = hordeIdFromHordesConfig - 1;
                if (!UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordes().getListOfPossibleHordes().isEmpty()) {
                    if (UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordes().getHordeSelectionMode().equalsIgnoreCase("sequential")) {
                        UndeadNights.serverState.setPossibleHordesIndex(UndeadNights.serverState.getPossibleHordesIndex() + 1);
                        if (UndeadNights.serverState.getPossibleHordesIndex() >= UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordes().getListOfPossibleHordes().size()) {
                            UndeadNights.serverState.setPossibleHordesIndex(0);
                        }
                        hordeIdToSpawn = UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordes().getListOfPossibleHordes().get(UndeadNights.serverState.getPossibleHordesIndex()) - 1;
                        if (MainConfig.getPrintDebugMessages()) {
                            UndeadNights.LOGGER.info("Horde selection mode: sequential, listOfPossibleHordes({}) = {} will be spawned", (Object)UndeadNights.serverState.getPossibleHordesIndex(), (Object)UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordes().getListOfPossibleHordes().get(UndeadNights.serverState.getPossibleHordesIndex()));
                        }
                    } else if (UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordes().getHordeSelectionMode().equalsIgnoreCase("random")) {
                        int index = randomSource.m_216332_(0, UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordes().getListOfPossibleHordes().size() - 1);
                        hordeIdToSpawn = UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordes().getListOfPossibleHordes().get(index) - 1;
                        if (MainConfig.getPrintDebugMessages()) {
                            UndeadNights.LOGGER.info("Horde selection mode: random, listOfPossibleHordes({}) = {} will be spawned", (Object)index, (Object)UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordes().getListOfPossibleHordes().get(index));
                        }
                    }
                }
                if (hordeIdToSpawn >= HordeConfig.getHordes().size()) {
                    if (MainConfig.getPrintDebugMessages()) {
                        UndeadNights.LOGGER.error("Horde index {} from config is out of range, using default horde instead.", (Object)hordeIdToSpawn);
                    }
                    hordeIdToSpawn = hordeIdFromHordesConfig - 1;
                }
                if (MainConfig.getPrintDebugMessages()) {
                    UndeadNights.LOGGER.info("Spawning Horde \"{}\"", (Object)HordeConfig.getHordes().get(hordeIdToSpawn).hordeName());
                }
                List<HordeConfig.HordesData> hordes = HordeConfig.getHordes();
                for (HordeConfig.MobSpawnData mobSpawnData : hordes.get(hordeIdToSpawn).hordeMobs()) {
                    int mobCount;
                    if (mobSpawnData.countMin() >= mobSpawnData.countMax()) {
                        mobCount = mobSpawnData.countMin();
                    } else {
                        mobCount = randomSource.m_216339_(mobSpawnData.countMin(), mobSpawnData.countMax());
                        if (MainConfig.getPrintDebugMessages()) {
                            UndeadNights.LOGGER.info("Spawning {} {}", (Object)mobCount, (Object)mobSpawnData.mobId());
                        }
                    }
                    int scaledMobCount = (int)Math.round((double)mobCount * UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordes().getHordeSizeScaleFactor());
                    if (MainConfig.getPrintDebugMessages()) {
                        UndeadNights.LOGGER.info("Scaled mob count: {}", (Object)scaledMobCount);
                    }
                    for (int j = 0; j < scaledMobCount; ++j) {
                        boolean spawnMob = true;
                        if (UndeadNights.globalSpawnCounter >= MainConfig.getHordeMobsSpawnCap()) {
                            spawnCapReached = true;
                            break;
                        }
                        if (mobSpawnData.chance() != 100) {
                            randomValue = randomSource.m_216332_(1, 100);
                            if (MainConfig.getPrintDebugMessages()) {
                                UndeadNights.LOGGER.info("Chance value for horde config (variant 2) found, chance value: {}, randomValue: {}", (Object)mobSpawnData.chance(), (Object)randomValue);
                            }
                            if (randomValue <= 100 - mobSpawnData.chance()) {
                                spawnMob = false;
                            }
                        }
                        if (!spawnMob || SpawnProcess.spawnHordeMob(level, randomSource, possibleSpawnLocation, (Player)player, mobSpawnData) != 0) continue;
                        ++spawnCounter;
                    }
                    if (UndeadNights.globalSpawnCounter < MainConfig.getHordeMobsSpawnCap()) continue;
                    spawnCapReached = true;
                    break;
                }
            }
            d = 0.0;
            if (currentHordeCounter != UndeadNights.globalSpawnCounter) {
                if (spawnCounter == 0) continue;
                if (MainConfig.getHordeSpawnedMessageAndSound()) {
                    player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), UndeadNightsSounds.HORDE_SCREAM.get(), SoundSource.HOSTILE, 4.0f, 1.0f);
                    player.m_213846_((Component)Component.m_237115_((String)"message.undeadnights.horde_spawned").m_130940_(ChatFormatting.RED));
                }
                if (MainConfig.getPrintDebugMessages()) {
                    UndeadNights.LOGGER.info("Horde was spawned for player {} (removing from horde lists)", (Object)player.m_7755_().getString());
                }
                return HordeSpawner.SpawnHordeResult.DONE;
            }
            if (!spawnCapReached) continue;
            UndeadNights.LOGGER.info("Spawn cap reached, {} Horde Zombies are already loaded into this world.", (Object)MainConfig.getHordeMobsSpawnCap());
            return HordeSpawner.SpawnHordeResult.FAILED;
        }
        if (spawnCounter == 0) {
            UndeadNights.LOGGER.info("Failed to spawn a horde.");
            return HordeSpawner.SpawnHordeResult.FAILED;
        }
        return HordeSpawner.SpawnHordeResult.DONE;
    }

    public static int spawnHordeMob(ServerLevel level, RandomSource randomSource, BlockPos pos, Player player, HordeConfig.MobSpawnData mobSpawnData) {
        Entity entity;
        EntityType mobType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(ResourceLocation.parse((String)mobSpawnData.mobId()));
        if (mobType == null) {
            invalidHordeMobEntry = true;
            UndeadNights.LOGGER.warn("Spawning entry {} from the config file failed! Spawning default horde zombie instead.", (Object)mobSpawnData.mobId());
        }
        CompoundTag nbtCompound = new CompoundTag();
        if (!Objects.equals(mobSpawnData.nbt(), "")) {
            try {
                nbtCompound = TagParser.m_129359_((String)mobSpawnData.nbt());
            }
            catch (CommandSyntaxException e) {
                UndeadNights.LOGGER.error("Parsing NBT-tags for {} failed!", (Object)mobSpawnData.mobId());
            }
        }
        if (!invalidHordeMobEntry) {
            nbtCompound.m_128359_("id", mobSpawnData.mobId());
        } else {
            nbtCompound.m_128359_("id", "undeadnights:horde_zombie");
        }
        boolean playerInCave = false;
        if (player instanceof UndeadNightsExtendedPlayer) {
            UndeadNightsExtendedPlayer undeadNightsExtendedPlayer = (UndeadNightsExtendedPlayer)player;
            playerInCave = undeadNightsExtendedPlayer.undeadnights_isInCave();
        }
        if (MainConfig.getHordeWavesCanSpawnInCaves() && playerInCave) {
            if (MainConfig.getPrintDebugMessages()) {
                UndeadNights.LOGGER.info("Player {} is in cave, attempting to spawn horde mob in cave.", (Object)player.m_7755_().getString());
            }
            pos = Helpers.findSpawnablePosition((Level)level, pos, 8, 5);
        } else {
            if (MainConfig.getPrintDebugMessages()) {
                UndeadNights.LOGGER.info("Player {} is not in cave, attempting to spawn horde mob on surface.", (Object)player.m_7755_().getString());
            }
            pos = SpawnLocationFinder.findNearbySurfaceSpawnPosition(level, pos, randomSource, playerInCave);
        }
        BlockPos finalPos = pos;
        if (MainConfig.getPrintDebugMessages()) {
            UndeadNights.LOGGER.info("Spawning horde mob {} at position {}, {}, {}", new Object[]{mobSpawnData.mobId(), finalPos.m_123341_(), finalPos.m_123342_(), finalPos.m_123343_()});
        }
        if ((entity = EntityType.m_20645_((CompoundTag)nbtCompound, (Level)level, entityX -> {
            entityX.m_7678_((double)finalPos.m_123341_(), (double)finalPos.m_123342_(), (double)finalPos.m_123343_(), entityX.m_146908_(), entityX.m_146909_());
            return entityX;
        })) instanceof Monster && MainConfig.getBlockLightLevelsInfluenceMonsterSpawns() && !SpawnLocationFinder.isDarkEnoughToSpawn((ServerLevelAccessor)level, new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()))) {
            UndeadNights.LOGGER.info("Horde mob {} can't spawn here, it's not dark enough!", (Object)mobSpawnData.mobId());
            return -1;
        }
        if (entity instanceof DemolitionZombieEntity) {
            DemolitionZombieEntity demolitionZombie = (DemolitionZombieEntity)entity;
            String str = mobSpawnData.extra();
            String[] strA = str.split(":");
            if (strA[0].equals("tnt")) {
                try {
                    int numberTnt = Integer.parseInt(strA[1]);
                    if (numberTnt > 64) {
                        numberTnt = 64;
                    }
                    demolitionZombie.setNumberTnt(numberTnt);
                }
                catch (Exception e) {
                    UndeadNights.LOGGER.warn("extraSpawnInfo for {} has non valid value, using default TNT stack size!", (Object)mobSpawnData.mobId());
                }
            } else {
                UndeadNights.LOGGER.warn("extraSpawnInfo for {} could be read, using default TNT stack size!", (Object)mobSpawnData.mobId());
            }
        }
        DifficultyInstance localDifficulty = level.m_6436_(player.m_20183_());
        try {
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                mob.m_6518_((ServerLevelAccessor)level, localDifficulty, MobSpawnType.NATURAL, null, null);
                mob.m_6710_((LivingEntity)player);
                if (mobSpawnData.mobId().equals("minecraft:zombie")) {
                    mob.f_21345_.m_25352_(1, (Goal)new FloatGoal(mob));
                    mob.f_21345_.m_25352_(1, (Goal)new BreakBlockGoal((Zombie)mob));
                }
                if (!(mobSpawnData.mobId().equals("undeadnights:horde_zombie") || mobSpawnData.mobId().equals("undeadnights:elite_zombie") || mobSpawnData.mobId().equals("undeadnights:demolition_zombie"))) {
                    mob.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal(mob, Player.class, false, false));
                    Objects.requireNonNull(mob.m_21051_(Attributes.f_22277_)).m_22100_(128.0);
                    int playerCount = 1;
                    if (!mob.m_9236_().f_46443_) {
                        playerCount = mob.m_9236_().m_6907_().size();
                    }
                    double healthScaleFactor = 0.0;
                    double damageScaleFactor = 0.0;
                    double speedScaleFactor = 0.0;
                    double armorScaleFactor = 0.0;
                    if (UndeadNights.difficultyConfig.getDynamicScaling().isDynamicScalingEnabled().booleanValue() && playerCount > 1) {
                        healthScaleFactor = UndeadNights.difficultyConfig.getDynamicScaling().getHealthScalePerPlayer() * (double)(playerCount - 1);
                        damageScaleFactor = UndeadNights.difficultyConfig.getDynamicScaling().getDamageScalePerPlayer() * (double)(playerCount - 1);
                        speedScaleFactor = UndeadNights.difficultyConfig.getDynamicScaling().getSpeedScalePerPlayer() * (double)(playerCount - 1);
                        armorScaleFactor = UndeadNights.difficultyConfig.getDynamicScaling().getArmorScalePerPlayer() * (double)(playerCount - 1);
                        healthScaleFactor += UndeadNights.serverState.getCurrentHealthScale();
                        damageScaleFactor += (double)UndeadNights.serverState.getCurrentDayScaleCounter();
                        speedScaleFactor += UndeadNights.serverState.getCurrentSpeedScale();
                        armorScaleFactor += UndeadNights.serverState.getCurrentArmorScale();
                        if (healthScaleFactor > UndeadNights.difficultyConfig.getDynamicScaling().getMaxHealthScale()) {
                            healthScaleFactor = UndeadNights.difficultyConfig.getDynamicScaling().getMaxHealthScale();
                        }
                        if (damageScaleFactor > UndeadNights.difficultyConfig.getDynamicScaling().getMaxDamageScale()) {
                            damageScaleFactor = UndeadNights.difficultyConfig.getDynamicScaling().getMaxDamageScale();
                        }
                        if (speedScaleFactor > UndeadNights.difficultyConfig.getDynamicScaling().getMaxSpeedScale()) {
                            speedScaleFactor = UndeadNights.difficultyConfig.getDynamicScaling().getMaxSpeedScale();
                        }
                        if (armorScaleFactor > UndeadNights.difficultyConfig.getDynamicScaling().getMaxArmorScale()) {
                            armorScaleFactor = UndeadNights.difficultyConfig.getDynamicScaling().getMaxArmorScale();
                        }
                    }
                    if (UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeMobs().isUpdateAttributesOfThirdPartyMobs().booleanValue() || mobSpawnData.mobId().equals("minecraft:zombie")) {
                        Objects.requireNonNull(mob.m_21051_(Attributes.f_22276_)).m_22125_(new AttributeModifier("Monster difficulty health bonus", UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeMobs().getHealthAttributeScaleFactor() - 1.0 + healthScaleFactor, AttributeModifier.Operation.MULTIPLY_BASE));
                        Objects.requireNonNull(mob.m_21051_(Attributes.f_22279_)).m_22125_(new AttributeModifier("Monster difficulty speed bonus", UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeMobs().getSpeedAttributeScaleFactor() - 1.0 + speedScaleFactor, AttributeModifier.Operation.MULTIPLY_BASE));
                        Objects.requireNonNull(mob.m_21051_(Attributes.f_22281_)).m_22125_(new AttributeModifier("Monster difficulty attack damage bonus", UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeMobs().getDamageAttributeScaleFactor() - 1.0 + damageScaleFactor, AttributeModifier.Operation.MULTIPLY_BASE));
                        Objects.requireNonNull(mob.m_21051_(Attributes.f_22284_)).m_22125_(new AttributeModifier("Monster difficulty armor bonus", UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeMobs().getArmorAttributeScaleFactor() - 1.0 + armorScaleFactor, AttributeModifier.Operation.MULTIPLY_BASE));
                        mob.m_21153_(mob.m_21233_());
                    }
                }
            }
            assert (entity != null);
            UndeadNights.serverState.spawnedHordeMobs.add(entity.m_20148_());
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (MainConfig.getHordeWavesCanSpawnInCaves()) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 40, 1));
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 40, 1));
                }
                if (MainConfig.getDebugMakeHordeMobsGlow()) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 4000, 1));
                }
            }
            level.m_8860_(entity);
        }
        catch (Exception e) {
            invalidHordeMobEntry = true;
            UndeadNights.LOGGER.warn("Spawning entry {} from the config file failed! Spawning default horde zombie instead.", (Object)mobSpawnData.mobId());
            HordeZombieEntity hZombie = new HordeZombieEntity((EntityType<? extends Zombie>)((EntityType)ModEntities.HORDE_ZOMBIE.get()), (Level)level);
            hZombie.m_6034_(pos.m_123341_(), level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.m_123341_(), pos.m_123343_()), pos.m_123343_());
            if (MainConfig.getPersistentMobs()) {
                hZombie.m_21530_();
            }
            hZombie.m_6518_((ServerLevelAccessor)level, localDifficulty, MobSpawnType.NATURAL, null, null);
            hZombie.m_6710_((LivingEntity)player);
            UndeadNights.serverState.spawnedHordeMobs.add(hZombie.m_20148_());
            level.m_7967_((Entity)hZombie);
        }
        return 0;
    }
}

