/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.petemc.undeadnights.UndeadNights;
import net.petemc.undeadnights.config.difficulty.DifficultyLevel;

public class DifficultyLevelCommand {
    public DifficultyLevelCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"undeadnights").requires(source -> source.m_6761_(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"difficulty").then(Commands.m_82127_((String)"query").executes(ctx -> this.queryDifficulty((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"levelIndex", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> this.setDifficulty((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"levelIndex")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"auto_progression").then(Commands.m_82127_((String)"enable").executes(ctx -> this.setAutoProgression((CommandSourceStack)ctx.getSource(), true)))).then(Commands.m_82127_((String)"disable").executes(ctx -> this.setAutoProgression((CommandSourceStack)ctx.getSource(), false))))));
    }

    private int queryDifficulty(CommandSourceStack source) throws CommandSyntaxException {
        DifficultyLevel currentDifficultyLevel = UndeadNights.difficultyConfig.getCurrentDifficultyLevel();
        Objects.requireNonNull(source.m_81373_()).m_213846_((Component)Component.m_237113_((String)("Current difficulty level: " + currentDifficultyLevel.getDifficultyName() + "\nAutomatic difficulty progression: " + (UndeadNights.automaticDifficultyProgressionActive ? "enabled" : "disabled") + "\n")));
        return 1;
    }

    private int setDifficulty(CommandSourceStack source, int levelIndex) throws CommandSyntaxException {
        List<DifficultyLevel> difficultyLevels = UndeadNights.difficultyConfig.getDifficultyLevels();
        if (levelIndex <= 0 || levelIndex > difficultyLevels.size()) {
            Objects.requireNonNull(source.m_81373_()).m_213846_((Component)Component.m_237113_((String)"Invalid difficulty level index!"));
            return 0;
        }
        UndeadNights.difficultyConfig.setCurrentDifficultyLevel(difficultyLevels.get(--levelIndex));
        UndeadNights.serverState.setCurrentDifficultyLevelIndex(levelIndex);
        UndeadNights.serverState.setPossibleHordesIndex(-1);
        Objects.requireNonNull(source.m_81373_()).m_213846_((Component)Component.m_237113_((String)("Difficulty level set to: " + difficultyLevels.get(levelIndex).getDifficultyName())));
        return 1;
    }

    private int setAutoProgression(CommandSourceStack source, boolean value) {
        UndeadNights.automaticDifficultyProgressionActive = value;
        Objects.requireNonNull(source.m_81373_()).m_213846_((Component)Component.m_237113_((String)("Automatic difficulty progression has been " + (value ? "enabled" : "disabled") + ".")));
        return 1;
    }
}

